/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.jem.internal.instantiation.base.IJavaDataTypeInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.JavaBeanCustomizeLayoutPage;
import org.eclipse.ve.internal.java.core.Spinner;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.propertysheet.common.commands.AbstractCommand;
import org.eclipse.ve.internal.swt.SWTConstants;
import org.eclipse.ve.internal.swt.SWTMessages;

public class GridLayoutLayoutPage
extends JavaBeanCustomizeLayoutPage {
    EditPart fEditPart = null;
    Spinner numColumnsSpinner;
    Button equalWidthCheck;
    Spinner horizontalSpinner;
    Spinner verticalSpinner;
    Spinner heightSpinner;
    Spinner widthSpinner;
    ResourceSet rset;
    protected EReference sfCompositeLayout;
    EStructuralFeature sfNumColumns;
    EStructuralFeature sfMakeColumnsEqualWidth;
    EStructuralFeature sfHorizontalSpacing;
    EStructuralFeature sfVerticalSpacing;
    EStructuralFeature sfMarginHeight;
    EStructuralFeature sfMarginWidth;
    boolean initialized = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    protected void handleSelectionProviderInitialization(ISelectionProvider selectionProvider) {
    }

    public Control getControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout g1 = new GridLayout();
        g1.numColumns = 2;
        c.setLayout((Layout)g1);
        Listener spinnerModify = new Listener(){

            public void handleEvent(Event event) {
                GridLayoutLayoutPage.this.spinnerModified((Spinner)event.widget);
            }
        };
        Group colGroup = new Group(c, 0);
        GridData gd0 = new GridData();
        gd0.verticalAlignment = 1;
        colGroup.setLayoutData((Object)gd0);
        GridLayout g2 = new GridLayout();
        g2.numColumns = 2;
        colGroup.setLayout((Layout)g2);
        colGroup.setText(SWTMessages.getString("GridLayoutLayoutPage.columnsTitle"));
        Label l1 = new Label((Composite)colGroup, 0);
        l1.setText(SWTMessages.getString("GridLayoutLayoutPage.numColumns"));
        GridData gd4 = new GridData();
        gd4.grabExcessHorizontalSpace = true;
        l1.setLayoutData((Object)gd4);
        this.numColumnsSpinner = new Spinner((Composite)colGroup, 0, 1);
        this.numColumnsSpinner.setMinimum(1);
        this.numColumnsSpinner.addModifyListener(spinnerModify);
        this.equalWidthCheck = new Button((Composite)colGroup, 32);
        this.equalWidthCheck.setText(SWTMessages.getString("GridLayoutLayoutPage.columnsEqualWidth"));
        GridData gd1 = new GridData();
        gd1.horizontalSpan = 2;
        this.equalWidthCheck.setLayoutData((Object)gd1);
        this.equalWidthCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridLayoutLayoutPage.this.checkModified();
            }
        });
        Group spaceGroup = new Group(c, 0);
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 4;
        spaceGroup.setLayoutData((Object)gd2);
        GridLayout g3 = new GridLayout();
        g3.numColumns = 2;
        spaceGroup.setLayout((Layout)g3);
        spaceGroup.setText(SWTMessages.getString("GridLayoutLayoutPage.spacingTitle"));
        Label l2 = new Label((Composite)spaceGroup, 0);
        l2.setText(SWTMessages.getString("GridLayoutLayoutPage.horizontalSpacing"));
        this.horizontalSpinner = new Spinner((Composite)spaceGroup, 0, 5);
        this.horizontalSpinner.addModifyListener(spinnerModify);
        GridData gd3 = new GridData();
        gd3.grabExcessHorizontalSpace = true;
        l2.setLayoutData((Object)gd3);
        Label l3 = new Label((Composite)spaceGroup, 0);
        l3.setText(SWTMessages.getString("GridLayoutLayoutPage.verticalSpacing"));
        this.verticalSpinner = new Spinner((Composite)spaceGroup, 0, 5);
        this.verticalSpinner.addModifyListener(spinnerModify);
        Label l4 = new Label((Composite)spaceGroup, 0);
        l4.setText(SWTMessages.getString("GridLayoutLayoutPage.marginWidth"));
        this.widthSpinner = new Spinner((Composite)spaceGroup, 0, 5);
        this.widthSpinner.addModifyListener(spinnerModify);
        Label l5 = new Label((Composite)spaceGroup, 0);
        l5.setText(SWTMessages.getString("GridLayoutLayoutPage.marginHeight"));
        this.heightSpinner = new Spinner((Composite)spaceGroup, 0, 5);
        this.heightSpinner.addModifyListener(spinnerModify);
        if (this.fEditPart != null) {
            this.initialized = false;
            this.initializeValues();
        }
        return c;
    }

    protected boolean handleSelectionChanged(ISelection oldSelection) {
        ISelection newSelection = this.getSelection();
        if (newSelection != null && newSelection instanceof IStructuredSelection && !((IStructuredSelection)newSelection).isEmpty()) {
            EditPart firstParent;
            List editparts = ((IStructuredSelection)newSelection).toList();
            boolean enableAll = true;
            if (editparts.size() == 1 && editparts.get(0) instanceof EditPart && this.isValidTarget(firstParent = (EditPart)editparts.get(0))) {
                this.fEditPart = firstParent;
                this.initialized = false;
                this.initializeValues();
                return true;
            }
            if (editparts.get(0) instanceof EditPart && ((EditPart)editparts.get(0)).getParent() != null && this.isValidTarget(firstParent = ((EditPart)editparts.get(0)).getParent())) {
                EditPart ep = (EditPart)editparts.get(0);
                int i = 1;
                while (i < editparts.size()) {
                    if (editparts.get(i) instanceof EditPart) {
                        ep = (EditPart)editparts.get(i);
                        if (ep.getParent() == null || ep.getParent() != firstParent) {
                            enableAll = false;
                            break;
                        }
                    } else {
                        enableAll = false;
                        break;
                    }
                    ++i;
                }
                if (enableAll) {
                    this.fEditPart = firstParent;
                    this.initialized = false;
                    this.initializeValues();
                    return true;
                }
            }
        }
        this.fEditPart = null;
        return false;
    }

    public boolean isValidTarget(EditPart target) {
        IActionFilter af;
        Class<?> clazz;
        if (target instanceof TreeEditPart) {
            EditPart ep;
            EditPartViewer viewer;
            EditDomain ed = EditDomain.getEditDomain((EditPart)target);
            IEditorPart iEditorPart = ed.getEditorPart();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.gef.EditPartViewer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((viewer = (EditPartViewer)iEditorPart.getAdapter((Class)clazz2)) != null && (ep = (EditPart)viewer.getEditPartRegistry().get(target.getModel())) != null) {
                target = ep;
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.IActionFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (af = (IActionFilter)target.getAdapter((Class)clazz)) != null && af.testAttribute((Object)target, "EDITPOLICY#LAYOUTPOLICY", "org.eclipse.swt.layout.GridLayout");
    }

    protected boolean selectionIsContainer(ISelection oldSelection) {
        EditPart firstParent;
        List editparts;
        ISelection newSelection = this.getSelection();
        return newSelection != null && newSelection instanceof IStructuredSelection && !((IStructuredSelection)newSelection).isEmpty() && (editparts = ((IStructuredSelection)newSelection).toList()).size() == 1 && editparts.get(0) instanceof EditPart && this.isValidTarget(firstParent = (EditPart)editparts.get(0));
    }

    protected void handleEditorPartChanged(IEditorPart oldEditorPart) {
        this.resetVariables();
    }

    private void initializeValues() {
        if (!this.initialized) {
            this.getResourceSet(this.fEditPart);
            if (this.numColumnsSpinner == null) {
                return;
            }
            this.numColumnsSpinner.setValue(this.getIntValue(this.fEditPart, this.sfNumColumns));
            this.numColumnsSpinner.setEnabled(true);
            this.horizontalSpinner.setValue(this.getIntValue(this.fEditPart, this.sfHorizontalSpacing));
            this.horizontalSpinner.setEnabled(true);
            this.verticalSpinner.setValue(this.getIntValue(this.fEditPart, this.sfVerticalSpacing));
            this.verticalSpinner.setEnabled(true);
            this.heightSpinner.setValue(this.getIntValue(this.fEditPart, this.sfMarginHeight));
            this.heightSpinner.setEnabled(true);
            this.widthSpinner.setValue(this.getIntValue(this.fEditPart, this.sfMarginWidth));
            this.widthSpinner.setEnabled(true);
            this.equalWidthCheck.setSelection(this.getBooleanValue(this.fEditPart, this.sfMakeColumnsEqualWidth));
            this.initialized = true;
        }
    }

    private EStructuralFeature getSFForSpinner(Spinner s) {
        if (s == this.numColumnsSpinner) {
            return this.sfNumColumns;
        }
        if (s == this.horizontalSpinner) {
            return this.sfHorizontalSpacing;
        }
        if (s == this.verticalSpinner) {
            return this.sfVerticalSpacing;
        }
        if (s == this.heightSpinner) {
            return this.sfMarginHeight;
        }
        if (s == this.widthSpinner) {
            return this.sfMarginWidth;
        }
        return null;
    }

    private void checkModified() {
        if (this.initialized) {
            this.execute(this.createBooleanCommand(this.fEditPart, this.sfMakeColumnsEqualWidth, this.equalWidthCheck.getSelection()));
        }
    }

    private void spinnerModified(Spinner s) {
        if (this.initialized) {
            this.execute(this.createSpinnerCommand(this.fEditPart, this.getSFForSpinner(s), s));
        }
    }

    protected Command createSpinnerCommand(EditPart editpart, EStructuralFeature sf, Spinner spinner) {
        CommandBuilder cb = new CommandBuilder();
        EObject control = (EObject)editpart.getModel();
        if (control != null) {
            IJavaInstance gridLayout = (IJavaInstance)control.eGet((EStructuralFeature)this.sfCompositeLayout);
            if (gridLayout == null) {
                return UnexecutableCommand.INSTANCE;
            }
            RuledCommandBuilder componentCB = new RuledCommandBuilder(EditDomain.getEditDomain((EditPart)editpart), null, false);
            String init = String.valueOf(spinner.getValue());
            IJavaInstance intObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)init);
            componentCB.applyAttributeSetting((EObject)gridLayout, sf, (Object)intObject);
            componentCB.applyAttributeSetting(control, (EStructuralFeature)this.sfCompositeLayout, (Object)gridLayout);
            cb.append(componentCB.getCommand());
            cb.append((Command)new EnableSpinnerCommand(spinner));
            return cb.getCommand();
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected int getIntValue(EditPart ep, EStructuralFeature sf) {
        if (this.getResourceSet(ep) != null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((IPropertySource)ep.getAdapter((Class)clazz) instanceof IPropertySource) {
                Object intPV;
                IPropertySource ps;
                IPropertySource gridLayout;
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((gridLayout = (IPropertySource)(ps = (IPropertySource)ep.getAdapter((Class)clazz2)).getPropertyValue((Object)this.sfCompositeLayout)) != null && (intPV = gridLayout.getPropertyValue((Object)sf)) != null && intPV instanceof IJavaDataTypeInstance) {
                    IIntegerBeanProxy intProxy = (IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaDataTypeInstance)intPV), (ResourceSet)this.rset);
                    return intProxy.intValue();
                }
            }
        }
        return 0;
    }

    protected Command createBooleanCommand(EditPart editpart, EStructuralFeature sf, boolean value) {
        CommandBuilder cb = new CommandBuilder();
        EObject control = (EObject)editpart.getModel();
        if (control != null) {
            IJavaInstance gridLayout = (IJavaInstance)control.eGet((EStructuralFeature)this.sfCompositeLayout);
            if (gridLayout == null) {
                return UnexecutableCommand.INSTANCE;
            }
            RuledCommandBuilder componentCB = new RuledCommandBuilder(EditDomain.getEditDomain((EditPart)editpart), null, false);
            String init = String.valueOf(value);
            IJavaInstance booleanObject = BeanUtilities.createJavaObject((String)"boolean", (ResourceSet)this.rset, (String)init);
            componentCB.applyAttributeSetting((EObject)gridLayout, sf, (Object)booleanObject);
            componentCB.applyAttributeSetting(control, (EStructuralFeature)this.sfCompositeLayout, (Object)gridLayout);
            cb.append(componentCB.getCommand());
            return cb.getCommand();
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean getBooleanValue(EditPart ep, EStructuralFeature sf) {
        if (this.getResourceSet(ep) != null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((IPropertySource)ep.getAdapter((Class)clazz) instanceof IPropertySource) {
                Object booleanPV;
                IPropertySource ps;
                IPropertySource gridLayout;
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((gridLayout = (IPropertySource)(ps = (IPropertySource)ep.getAdapter((Class)clazz2)).getPropertyValue((Object)this.sfCompositeLayout)) != null && (booleanPV = gridLayout.getPropertyValue((Object)sf)) != null && booleanPV instanceof IJavaDataTypeInstance) {
                    IBooleanBeanProxy booleanProxy = (IBooleanBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaDataTypeInstance)booleanPV), (ResourceSet)this.rset);
                    return booleanProxy.booleanValue();
                }
            }
        }
        return false;
    }

    protected void execute(Command command) {
        CommandStack cmdStack;
        if (command == null || !command.canExecute()) {
            return;
        }
        IEditorPart iEditorPart = this.getEditorPart();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.gef.commands.CommandStack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((cmdStack = (CommandStack)iEditorPart.getAdapter((Class)clazz)) != null) {
            cmdStack.execute(command);
        }
    }

    private void resetVariables() {
        this.rset = null;
        this.sfCompositeLayout = null;
        this.sfNumColumns = null;
        this.sfMakeColumnsEqualWidth = null;
        this.sfHorizontalSpacing = null;
        this.sfVerticalSpacing = null;
        this.sfMarginHeight = null;
        this.sfMarginWidth = null;
        this.initialized = false;
    }

    protected ResourceSet getResourceSet(EditPart editpart) {
        if (this.rset == null) {
            this.rset = EMFEditDomainHelper.getResourceSet((EditDomain)EditDomain.getEditDomain((EditPart)editpart));
            this.sfCompositeLayout = JavaInstantiation.getReference((ResourceSet)this.rset, (URI)SWTConstants.SF_COMPOSITE_LAYOUT);
            this.sfNumColumns = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_LAYOUT_NUM_COLUMNS);
            this.sfMakeColumnsEqualWidth = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_LAYOUT_MAKE_COLUMNS_EQUAL_WIDTH);
            this.sfHorizontalSpacing = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_LAYOUT_HORIZONTAL_SPACING);
            this.sfVerticalSpacing = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_LAYOUT_VERTICAL_SPACING);
            this.sfMarginHeight = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_LAYOUT_MARGIN_HEIGHT);
            this.sfMarginWidth = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_LAYOUT_MARGIN_WIDTH);
        }
        return this.rset;
    }

    protected class EnableSpinnerCommand
    extends AbstractCommand {
        protected Spinner spinner;

        public EnableSpinnerCommand(Spinner spinner) {
            this.spinner = spinner;
        }

        public void execute() {
            if (this.spinner != null) {
                this.spinner.setEnabled(true);
            }
        }

        public boolean canExecute() {
            return true;
        }
    }
}

