/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.awt.IRectangleBeanProxy;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.swt.DisplayManager;
import org.eclipse.jem.internal.proxy.swt.IStandardSWTBeanProxyFactory;
import org.eclipse.jem.internal.proxy.swt.JavaStandardSWTBeanConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.swt.BeanSWTUtilities;
import org.eclipse.ve.internal.swt.LayoutPolicyHelper;
import org.eclipse.ve.internal.swt.SWTConstants;

public class GridLayoutPolicyHelper
extends LayoutPolicyHelper
implements IActionFilter {
    protected ResourceSet rset;
    protected EReference sfLayoutData;
    protected EReference sfCompositeControls;
    protected EStructuralFeature sfHorizontalSpan;
    protected EStructuralFeature sfVerticalSpan;
    protected int defaultHorizontalSpan;
    protected int defaultVerticalSpan;
    protected EObject[][] layoutTable = null;
    protected Rectangle[] childrenDimensions = null;
    protected int numColumns = -1;
    private IBeanProxy fContainerBeanProxy = null;
    private IBeanProxy fLayoutManagerBeanProxy = null;
    static /* synthetic */ Class class$0;

    protected IBeanProxy getContainerBeanProxy() {
        if (this.fContainerBeanProxy == null) {
            this.fContainerBeanProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)this.getContainer());
        }
        return this.fContainerBeanProxy;
    }

    protected IBeanProxy getLayoutManagerBeanProxy() {
        if (this.fLayoutManagerBeanProxy == null && this.getContainerBeanProxy() != null) {
            this.fLayoutManagerBeanProxy = BeanSWTUtilities.invoke_getLayout(this.getContainerBeanProxy());
        }
        return this.fLayoutManagerBeanProxy;
    }

    public GridLayoutPolicyHelper(VisualContainerPolicy ep) {
        super(ep);
        this.initializeDefaults();
    }

    public GridLayoutPolicyHelper() {
        this.initializeDefaults();
    }

    protected void initializeDefaults() {
        GridData gd = new GridData();
        this.defaultHorizontalSpan = gd.horizontalSpan;
        this.defaultVerticalSpan = gd.verticalSpan;
    }

    protected void cancelConstraints(CommandBuilder commandBuilder, List children) {
    }

    public List getDefaultConstraint(List children) {
        return Collections.nCopies(children.size(), null);
    }

    public EObject[][] getLayoutTable() {
        if (this.layoutTable == null) {
            int[][] dimensions = this.getContainerLayoutDimensions();
            this.layoutTable = new EObject[dimensions[0].length][dimensions[1].length];
            this.numColumns = dimensions[0].length;
            int row = 0;
            int col = 0;
            List children = (List)this.getContainer().eGet((EStructuralFeature)this.sfCompositeControls);
            this.childrenDimensions = new Rectangle[children.size()];
            int childNum = 0;
            Iterator itr = children.iterator();
            while (itr.hasNext()) {
                int verticalSpan;
                int horizontalSpan;
                IJavaObjectInstance child = (IJavaObjectInstance)itr.next();
                IJavaObjectInstance childData = (IJavaObjectInstance)child.eGet((EStructuralFeature)this.sfLayoutData);
                if (childData != null) {
                    horizontalSpan = this.getIntValue(this.sfHorizontalSpan, childData);
                    verticalSpan = this.getIntValue(this.sfVerticalSpan, childData);
                } else {
                    horizontalSpan = this.defaultHorizontalSpan;
                    verticalSpan = this.defaultVerticalSpan;
                }
                Rectangle r = new Rectangle();
                while (this.layoutTable[col][row] != null) {
                    if (++col < this.numColumns) continue;
                    ++row;
                    col = 0;
                }
                if (col != 0 && col + horizontalSpan - 1 >= this.numColumns) {
                    ++row;
                    col = 0;
                }
                int i = 0;
                while (i < horizontalSpan) {
                    int j = 0;
                    while (j < verticalSpan) {
                        this.layoutTable[col + i][row + j] = child;
                        ++j;
                    }
                    ++i;
                }
                r.x = col;
                r.y = row;
                r.width = horizontalSpan;
                r.height = verticalSpan;
                this.childrenDimensions[childNum] = r;
                ++childNum;
                col += horizontalSpan - 1;
            }
        }
        return this.layoutTable;
    }

    private int getIntValue(EStructuralFeature sf, IJavaObjectInstance object) {
        IIntegerBeanProxy intProxy;
        int value = 1;
        IJavaInstance valueObject = (IJavaInstance)object.eGet(sf);
        if (valueObject != null && (intProxy = (IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)valueObject, (ResourceSet)this.rset)) != null) {
            value = intProxy.intValue();
        }
        return value;
    }

    public Rectangle[] getChildrenDimensions() {
        if (this.childrenDimensions == null) {
            this.getLayoutTable();
        }
        return this.childrenDimensions;
    }

    public int getNumColumns() {
        if (this.numColumns == -1) {
            this.getLayoutTable();
        }
        return this.numColumns;
    }

    public int getChildIndexAtCell(Point cell) {
        int value = -1;
        EObject[][] table = this.getLayoutTable();
        if (cell.x < 0 || cell.x >= this.getNumColumns() || cell.y < 0 || cell.y >= table[0].length) {
            return -1;
        }
        EObject childAtCell = table[cell.x][cell.y];
        if (childAtCell == null) {
            int x = cell.x;
            int y = cell.y;
            while (childAtCell == null && (x != 0 || y != 0)) {
                if (x == 0) {
                    --y;
                    x = this.getNumColumns();
                }
                childAtCell = table[--x][y];
            }
        }
        List children = (List)this.getContainer().eGet((EStructuralFeature)this.sfCompositeControls);
        int i = 0;
        while (i < children.size()) {
            if (children.get(i).equals(childAtCell)) {
                value = i;
                break;
            }
            ++i;
        }
        return value;
    }

    public int[][] getContainerLayoutDimensions() {
        int[] columnWidths = null;
        int[] rowHeights = null;
        int[][] result = new int[][]{new int[0], new int[0]};
        IFieldProxy getColumnWidthsFieldProxy = this.getLayoutManagerBeanProxy().getTypeProxy().getDeclaredFieldProxy("pixelColumnWidths");
        IFieldProxy getRowHeightsFieldProxy = this.getLayoutManagerBeanProxy().getTypeProxy().getDeclaredFieldProxy("pixelRowHeights");
        try {
            getColumnWidthsFieldProxy.setAccessible(true);
            IArrayBeanProxy arrayProxyColumnWidths = (IArrayBeanProxy)getColumnWidthsFieldProxy.get(this.getLayoutManagerBeanProxy());
            if (arrayProxyColumnWidths != null) {
                columnWidths = new int[arrayProxyColumnWidths.getLength()];
                int i = 0;
                while (i < arrayProxyColumnWidths.getLength()) {
                    columnWidths[i] = ((IIntegerBeanProxy)arrayProxyColumnWidths.get(i)).intValue();
                    ++i;
                }
                result[0] = columnWidths;
            }
            getRowHeightsFieldProxy.setAccessible(true);
            IArrayBeanProxy arrayProxyRowHeights = (IArrayBeanProxy)getRowHeightsFieldProxy.get(this.getLayoutManagerBeanProxy());
            if (arrayProxyRowHeights != null) {
                rowHeights = new int[arrayProxyRowHeights.getLength()];
                int i = 0;
                while (i < arrayProxyRowHeights.getLength()) {
                    rowHeights[i] = ((IIntegerBeanProxy)arrayProxyRowHeights.get(i)).intValue();
                    ++i;
                }
                result[1] = rowHeights;
            }
        }
        catch (ThrowableProxy throwableProxy) {
            return null;
        }
        return result;
    }

    public boolean isContainerColumnsEqualWidth() {
        boolean result = false;
        IFieldProxy getColumnsEqualWidthsFieldProxy = this.getLayoutManagerBeanProxy().getTypeProxy().getDeclaredFieldProxy("makeColumnsEqualWidth");
        try {
            IBooleanBeanProxy booleanProxyEqualWidths = (IBooleanBeanProxy)getColumnsEqualWidthsFieldProxy.get(this.getLayoutManagerBeanProxy());
            result = booleanProxyEqualWidths.booleanValue();
        }
        catch (ThrowableProxy throwableProxy) {}
        return result;
    }

    public int[][] getContainerExpandableDimensions() {
        int[] expandableColumns = null;
        int[] expandableRows = null;
        int[][] result = new int[][]{new int[0], new int[0]};
        IFieldProxy getExpandableColumnsFieldProxy = this.getLayoutManagerBeanProxy().getTypeProxy().getDeclaredFieldProxy("expandableColumns");
        IFieldProxy getExpandableRowsFieldProxy = this.getLayoutManagerBeanProxy().getTypeProxy().getDeclaredFieldProxy("expandableRows");
        try {
            getExpandableColumnsFieldProxy.setAccessible(true);
            IArrayBeanProxy arrayProxyExpandableColumns = (IArrayBeanProxy)getExpandableColumnsFieldProxy.get(this.getLayoutManagerBeanProxy());
            if (arrayProxyExpandableColumns != null) {
                expandableColumns = new int[arrayProxyExpandableColumns.getLength()];
                int i = 0;
                while (i < arrayProxyExpandableColumns.getLength()) {
                    expandableColumns[i] = ((IIntegerBeanProxy)arrayProxyExpandableColumns.get(i)).intValue();
                    ++i;
                }
                result[0] = expandableColumns;
            }
            getExpandableRowsFieldProxy.setAccessible(true);
            IArrayBeanProxy arrayProxyExpandableRows = (IArrayBeanProxy)getExpandableRowsFieldProxy.get(this.getLayoutManagerBeanProxy());
            if (arrayProxyExpandableRows != null) {
                expandableRows = new int[arrayProxyExpandableRows.getLength()];
                int i = 0;
                while (i < arrayProxyExpandableRows.getLength()) {
                    expandableRows[i] = ((IIntegerBeanProxy)arrayProxyExpandableRows.get(i)).intValue();
                    ++i;
                }
                result[1] = expandableRows;
            }
        }
        catch (ThrowableProxy throwableProxy) {
            return null;
        }
        return result;
    }

    public Rectangle getContainerLayoutSpacing() {
        Rectangle result = null;
        IFieldProxy getMarginHeightFieldProxy = this.getLayoutManagerBeanProxy().getTypeProxy().getDeclaredFieldProxy("marginHeight");
        IFieldProxy getMarginWidthFieldProxy = this.getLayoutManagerBeanProxy().getTypeProxy().getDeclaredFieldProxy("marginWidth");
        IFieldProxy getHorizontalSpacingFieldProxy = this.getLayoutManagerBeanProxy().getTypeProxy().getDeclaredFieldProxy("horizontalSpacing");
        IFieldProxy getVerticalSpacingFieldProxy = this.getLayoutManagerBeanProxy().getTypeProxy().getDeclaredFieldProxy("verticalSpacing");
        try {
            IIntegerBeanProxy intProxyVerticalSpacing;
            IIntegerBeanProxy intProxyHorizontalSpacing;
            IIntegerBeanProxy intProxyMarginWidth;
            result = new Rectangle();
            IIntegerBeanProxy intProxyMarginHeight = (IIntegerBeanProxy)getMarginHeightFieldProxy.get(this.getLayoutManagerBeanProxy());
            if (intProxyMarginHeight != null) {
                result.y = intProxyMarginHeight.intValue();
            }
            if ((intProxyMarginWidth = (IIntegerBeanProxy)getMarginWidthFieldProxy.get(this.getLayoutManagerBeanProxy())) != null) {
                result.x = intProxyMarginWidth.intValue();
            }
            if ((intProxyHorizontalSpacing = (IIntegerBeanProxy)getHorizontalSpacingFieldProxy.get(this.getLayoutManagerBeanProxy())) != null) {
                result.width = intProxyHorizontalSpacing.intValue();
            }
            if ((intProxyVerticalSpacing = (IIntegerBeanProxy)getVerticalSpacingFieldProxy.get(this.getLayoutManagerBeanProxy())) != null) {
                result.height = intProxyVerticalSpacing.intValue();
            }
        }
        catch (ThrowableProxy throwableProxy) {
            return null;
        }
        return result;
    }

    public Rectangle getContainerClientArea() {
        if (this.getContainerBeanProxy() != null) {
            try {
                IRectangleBeanProxy result = (IRectangleBeanProxy)JavaStandardSWTBeanConstants.invokeSyncExec(this.getContainerBeanProxy().getProxyFactoryRegistry(), new DisplayManager.DisplayRunnable(){

                    public Object run(IBeanProxy displayProxy) throws ThrowableProxy, DisplayManager.DisplayRunnable.RunnableException {
                        IBeanProxy aContainerBeanProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)GridLayoutPolicyHelper.this.getContainer());
                        IMethodProxy getContainerClientArea = aContainerBeanProxy.getProxyFactoryRegistry().getMethodProxyFactory().getMethodProxy(aContainerBeanProxy.getTypeProxy().getTypeName(), "getClientArea", null);
                        if (getContainerClientArea != null) {
                            IIntegerBeanProxy heightProxy;
                            IIntegerBeanProxy widthProxy;
                            IIntegerBeanProxy yProxy;
                            IStandardBeanProxyFactory fac;
                            IIntegerBeanProxy xProxy;
                            IRectangleBeanProxy trimProxy;
                            IMethodProxy getDecorationsComputeTrim;
                            IRectangleBeanProxy rectangleProxy = (IRectangleBeanProxy)getContainerClientArea.invokeCatchThrowableExceptions(aContainerBeanProxy);
                            IBeanTypeProxy decorationsType = displayProxy.getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy("org.eclipse.swt.widgets.Decorations");
                            if (aContainerBeanProxy.getTypeProxy().isKindOf(decorationsType) && (getDecorationsComputeTrim = aContainerBeanProxy.getProxyFactoryRegistry().getMethodProxyFactory().getMethodProxy(aContainerBeanProxy.getTypeProxy().getTypeName(), "computeTrim", new String[]{"int", "int", "int", "int"})) != null && (trimProxy = (IRectangleBeanProxy)getDecorationsComputeTrim.invoke(aContainerBeanProxy, new IBeanProxy[]{xProxy = (fac = aContainerBeanProxy.getProxyFactoryRegistry().getBeanProxyFactory()).createBeanProxyWith(rectangleProxy.getX()), yProxy = fac.createBeanProxyWith(rectangleProxy.getY()), widthProxy = fac.createBeanProxyWith(rectangleProxy.getWidth()), heightProxy = fac.createBeanProxyWith(rectangleProxy.getHeight())})) != null) {
                                IStandardSWTBeanProxyFactory fac2 = (IStandardSWTBeanProxyFactory)aContainerBeanProxy.getProxyFactoryRegistry().getBeanProxyFactoryExtension("standard-java.SWT");
                                IRectangleBeanProxy newRectProxy = fac2.createBeanProxyWith(trimProxy.getX() * -1, trimProxy.getY() * -1, rectangleProxy.getWidth(), rectangleProxy.getHeight());
                                return newRectProxy;
                            }
                            return rectangleProxy;
                        }
                        return null;
                    }
                });
                if (result != null) {
                    return new Rectangle(result.getX(), result.getY(), result.getWidth(), result.getHeight());
                }
            }
            catch (ThrowableProxy throwableProxy) {
            }
            catch (DisplayManager.DisplayRunnable.RunnableException runnableException) {}
        }
        return null;
    }

    public boolean isContainerEmpty() {
        if (this.getContainerBeanProxy() != null) {
            try {
                IArrayBeanProxy result = (IArrayBeanProxy)JavaStandardSWTBeanConstants.invokeSyncExec(this.getContainerBeanProxy().getProxyFactoryRegistry(), new DisplayManager.DisplayRunnable(){

                    public Object run(IBeanProxy displayProxy) throws ThrowableProxy, DisplayManager.DisplayRunnable.RunnableException {
                        IMethodProxy getChildrenMethodProxy;
                        IBeanProxy aContainerBeanProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)GridLayoutPolicyHelper.this.getContainer());
                        if (aContainerBeanProxy != null && (getChildrenMethodProxy = aContainerBeanProxy.getProxyFactoryRegistry().getMethodProxyFactory().getMethodProxy(aContainerBeanProxy.getTypeProxy().getTypeName(), "getChildren", null)) != null) {
                            IArrayBeanProxy childrenProxy = (IArrayBeanProxy)getChildrenMethodProxy.invokeCatchThrowableExceptions(aContainerBeanProxy);
                            return childrenProxy;
                        }
                        return null;
                    }
                });
                if (result != null) {
                    return result.getLength() <= 0;
                }
            }
            catch (ThrowableProxy throwableProxy) {
            }
            catch (DisplayManager.DisplayRunnable.RunnableException runnableException) {}
        }
        return true;
    }

    public boolean isOnSameRow(int child1, int child2) {
        Rectangle[] children = this.getChildrenDimensions();
        Rectangle r1 = children[child1];
        Rectangle r2 = children[child2];
        return r1.y == r2.y;
    }

    public boolean isCellEmptyBefore(int index) {
        if (index == 0) {
            return false;
        }
        Rectangle r = this.getChildrenDimensions()[index];
        if (r.y == 0) {
            return false;
        }
        EObject cell = r.x != 0 ? this.getLayoutTable()[r.x - 1][r.y] : this.getLayoutTable()[this.getNumColumns() - 1][r.y - 1];
        return cell == null;
    }

    public Command getSpanChildrenCommand(EditPart childEditPart, Point childCellLocation, Point endCellLocation, int spanDirection) {
        CommandBuilder cb = new CommandBuilder();
        EObject control = (EObject)childEditPart.getModel();
        if (control != null) {
            IJavaObjectInstance gridData = (IJavaObjectInstance)control.eGet((EStructuralFeature)this.sfLayoutData);
            if (gridData == null) {
                gridData = (IJavaObjectInstance)BeanUtilities.createJavaObject((String)"org.eclipse.swt.layout.GridData", (ResourceSet)this.rset, (String)"new org.eclipse.swt.layout.GridData()");
            }
            if (gridData != null) {
                RuledCommandBuilder componentCB = new RuledCommandBuilder(EditDomain.getEditDomain((EditPart)childEditPart), null, false);
                if (spanDirection == 16) {
                    int gridWidth = endCellLocation.x - childCellLocation.x + 1;
                    IJavaInstance widthObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)String.valueOf(gridWidth));
                    componentCB.applyAttributeSetting((EObject)gridData, this.sfHorizontalSpan, (Object)widthObject);
                }
                if (spanDirection == 4) {
                    int gridHeight = endCellLocation.y - childCellLocation.y + 1;
                    IJavaInstance heightObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)String.valueOf(gridHeight));
                    componentCB.applyAttributeSetting((EObject)gridData, this.sfVerticalSpan, (Object)heightObject);
                }
                componentCB.applyAttributeSetting(control, (EStructuralFeature)this.sfLayoutData, (Object)gridData);
                cb.append(componentCB.getCommand());
            }
        }
        if (cb.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        return cb.getCommand();
    }

    public void refresh() {
        this.layoutTable = null;
        this.childrenDimensions = null;
        this.numColumns = -1;
    }

    public void setContainerPolicy(VisualContainerPolicy policy) {
        super.setContainerPolicy(policy);
        if (policy != null) {
            this.rset = JavaEditDomainHelper.getResourceSet((EditDomain)policy.getEditDomain());
            this.sfCompositeControls = JavaInstantiation.getReference((ResourceSet)this.rset, (URI)SWTConstants.SF_COMPOSITE_CONTROLS);
            this.sfLayoutData = JavaInstantiation.getReference((ResourceSet)this.rset, (URI)SWTConstants.SF_CONTROL_LAYOUTDATA);
            this.sfHorizontalSpan = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_DATA_HORIZONTAL_SPAN);
            this.sfVerticalSpan = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_DATA_VERTICAL_SPAN);
        }
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof EditPart) {
            EditPart ep;
            EditPartViewer viewer;
            EditDomain ed = EditDomain.getEditDomain((EditPart)((EditPart)target));
            IEditorPart iEditorPart = ed.getEditorPart();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gef.EditPartViewer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((viewer = (EditPartViewer)iEditorPart.getAdapter((Class)clazz)) != null && (ep = (EditPart)viewer.getEditPartRegistry().get(((EditPart)target).getModel())) != null && ep.getEditPolicy((Object)"LayoutEditPolicy") instanceof IActionFilter) {
                return ((IActionFilter)ep.getEditPolicy((Object)"LayoutEditPolicy")).testAttribute(target, name, value);
            }
        }
        return false;
    }
}

