/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.commands.NoOpCommand;
import org.eclipse.ve.internal.cde.core.ContainerPolicy;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.java.visual.ILayoutPolicyHelper;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;
import org.eclipse.ve.internal.swt.SWTConstants;

public abstract class LayoutPolicyHelper
implements ILayoutPolicyHelper {
    protected ContainerPolicy policy;

    public LayoutPolicyHelper(VisualContainerPolicy ep) {
        this.setContainerPolicy(ep);
    }

    public LayoutPolicyHelper() {
    }

    protected IJavaObjectInstance getContainer() {
        return (IJavaObjectInstance)this.policy.getContainer();
    }

    public Command getCreateChildCommand(Object childComponent, Object constraint, Object position) {
        Command createContributionCmd = this.policy.getCreateCommand(childComponent, position);
        if (createContributionCmd == null || !createContributionCmd.canExecute()) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand command = new CompoundCommand("");
        command.append(createContributionCmd);
        return command.unwrap();
    }

    public Command getAddChildrenCommand(List childrenComponents, List constraints, Object position) {
        Command addContributionCmd = this.policy.getAddCommand(childrenComponents, position);
        if (addContributionCmd == null || !addContributionCmd.canExecute()) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand command = new CompoundCommand("");
        command.append(this.getChangeConstraintCommand(childrenComponents, constraints));
        command.append(addContributionCmd);
        return command.unwrap();
    }

    public Command getOrphanChildrenCommand(List children) {
        Command orphanContributionCmd = this.policy.getOrphanChildrenCommand(children);
        if (orphanContributionCmd == null || !orphanContributionCmd.canExecute()) {
            return UnexecutableCommand.INSTANCE;
        }
        RuledCommandBuilder cb = new RuledCommandBuilder(this.policy.getEditDomain());
        cb.append(orphanContributionCmd);
        this.cancelConstraints((CommandBuilder)cb, children);
        return cb.getCommand();
    }

    protected abstract void cancelConstraints(CommandBuilder var1, List var2);

    public Command getOrphanConstraintsCommand(List children) {
        RuledCommandBuilder cb = new RuledCommandBuilder(this.policy.getEditDomain());
        this.cancelConstraints((CommandBuilder)cb, children);
        IJavaObjectInstance parent = (IJavaObjectInstance)this.policy.getContainer();
        EStructuralFeature sf_layoutData = JavaInstantiation.getSFeature((IJavaObjectInstance)parent, (URI)SWTConstants.SF_CONTROL_LAYOUTDATA);
        cb.cancelGroupAttributeSetting(children, sf_layoutData);
        return cb.getCommand();
    }

    public void setContainerPolicy(VisualContainerPolicy policy) {
        this.policy = policy;
    }

    public Command getChangeConstraintCommand(List children, List constraints) {
        return NoOpCommand.INSTANCE;
    }
}

