/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.beaninfo;

import java.awt.Component;
import java.beans.PropertyEditorSupport;
import java.util.Locale;
import org.eclipse.ve.internal.jfc.beaninfo.LocalePropertyEditor;

public class LocaleEditor
extends PropertyEditorSupport {
    protected Object fLocale = null;
    protected LocalePropertyEditor fCustomEditor = null;

    public String getAsText() {
        if (this.fLocale != null) {
            return ((Locale)this.fLocale).getDisplayName();
        }
        return null;
    }

    public Component getCustomEditor() {
        if (this.fCustomEditor == null) {
            Locale aLocale = (Locale)this.getValue();
            this.fCustomEditor = aLocale == null ? new LocalePropertyEditor() : new LocalePropertyEditor(aLocale);
        }
        return this.fCustomEditor;
    }

    public String getJavaInitializationString() {
        Locale locale = (Locale)this.fLocale;
        if (this.fCustomEditor != null) {
            return this.fCustomEditor.getLocaleInitializationString();
        }
        return "new java.util.Locale(\" " + locale.getLanguage() + "\", \"" + locale.getCountry() + "\", \"" + locale.getVariant() + "\")";
    }

    public Object getValue() {
        if (this.fCustomEditor != null) {
            return this.fCustomEditor.getLocaleValue();
        }
        return super.getValue();
    }

    public void setValue(Object newValue) {
        this.fLocale = newValue;
        if (this.fCustomEditor != null) {
            this.fCustomEditor.setLocaleValue((Locale)newValue);
        }
        super.setValue(newValue);
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

