/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.beaninfo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.ve.internal.jfc.beaninfo.VisualBeanInfoMessages;

public class MnemonicPropertyEditor
extends JPanel {
    private JList constantsList = null;
    private JTextField constantField = null;
    private JTextField descriptionField = null;
    private static TreeMap constantsToValue = null;
    private static HashMap valueToConstants = null;
    private boolean initialized = false;
    private Integer value = new Integer(0);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MnemonicPropertyEditor() {
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent e) {
                Container topParent;
                Container parent = e.getAncestorParent();
                if (parent instanceof JComponent && (topParent = ((JComponent)parent).getTopLevelAncestor()) instanceof Window) {
                    ((Window)topParent).addWindowListener(new WindowAdapter(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void windowOpened(WindowEvent e) {
                            MnemonicPropertyEditor.access$0(1.access$0(this.this$1)).requestFocus();
                        }

                        public void windowActivated(WindowEvent e) {
                            MnemonicPropertyEditor.access$0(1.access$0(this.this$1)).requestFocus();
                        }
                    });
                }
            }

            public void ancestorMoved(AncestorEvent e) {
            }

            public void ancestorRemoved(AncestorEvent e) {
            }

            static /* synthetic */ MnemonicPropertyEditor access$0(1 var0) {
                return var0.MnemonicPropertyEditor.this;
            }
        });
    }

    private TreeMap getConstantsToValue() {
        if (constantsToValue == null) {
            this.initializeMaps();
        }
        return constantsToValue;
    }

    private HashMap getValueToConstants() {
        if (valueToConstants == null) {
            this.initializeMaps();
        }
        return valueToConstants;
    }

    private void initializeMaps() {
        constantsToValue = new TreeMap();
        valueToConstants = new HashMap();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.KeyEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> cClass = clazz;
        Field[] fields = cClass.getFields();
        int i = 0;
        while (i < fields.length) {
            String name = fields[i].getName();
            if (name.startsWith("VK_")) {
                name = name.substring(3);
                try {
                    Integer value = new Integer(fields[i].getInt(fields[i]));
                    constantsToValue.put(name, value);
                    valueToConstants.put(value, name);
                }
                catch (Exception exception) {}
            }
            ++i;
        }
    }

    public void initialize() {
        if (!this.initialized) {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gb);
            c.insets = new Insets(5, 5, 5, 5);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            c.anchor = 17;
            this.add((Component)new JLabel(VisualBeanInfoMessages.getString("MnemonicPropertyEditor.PressKey")), c);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            JScrollPane listScroll = new JScrollPane(this.getConstantsList());
            this.removeKeyboardActions(listScroll);
            this.removeKeyboardActions(listScroll.getVerticalScrollBar());
            this.removeKeyboardActions(listScroll.getHorizontalScrollBar());
            this.add((Component)listScroll, c);
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 1;
            c.fill = 2;
            c.anchor = 17;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.add((Component)new JLabel(VisualBeanInfoMessages.getString("MnemonicPropertyEditor.Constant")), c);
            c.gridx = 1;
            c.gridy = 2;
            c.gridwidth = 1;
            c.weightx = 1.0;
            this.add((Component)this.getConstantField(), c);
            c.gridx = 0;
            c.gridy = 3;
            c.gridwidth = 1;
            c.fill = 2;
            c.anchor = 17;
            c.weightx = 0.0;
            this.add((Component)new JLabel(VisualBeanInfoMessages.getString("MnemonicPropertyEditor.Description")), c);
            c.gridx = 1;
            c.gridy = 3;
            c.gridwidth = 1;
            c.weightx = 1.0;
            this.add((Component)this.getDescriptionField(), c);
            this.recursiveSetBackground(this, SystemColor.control);
            this.initialized = true;
        }
        this.updateSelection();
        this.getConstantsList().requestFocus();
    }

    private JList getConstantsList() {
        if (this.constantsList == null) {
            this.constantsList = new JList();
            this.constantsList.setSelectionMode(0);
            this.constantsList.setListData(this.getConstantsToValue().keySet().toArray());
            this.constantsList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    String constant = (String)MnemonicPropertyEditor.this.getConstantsList().getSelectedValue();
                    if (constant != null) {
                        MnemonicPropertyEditor.this.value = (Integer)MnemonicPropertyEditor.this.getConstantsToValue().get(constant);
                        MnemonicPropertyEditor.this.updateFields();
                    } else {
                        MnemonicPropertyEditor.this.getConstantField().setText("");
                        MnemonicPropertyEditor.this.getDescriptionField().setText("");
                    }
                }
            });
            this.removeKeyboardActions(this.constantsList);
            this.constantsList.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() != 10) {
                        MnemonicPropertyEditor.this.value = new Integer(e.getKeyCode());
                        MnemonicPropertyEditor.this.updateSelection();
                    }
                }
            });
        }
        return this.constantsList;
    }

    public void updateSelection() {
        this.getConstantsList().setSelectedValue(this.getValueToConstants().get(this.value), true);
    }

    public void updateFields() {
        this.getConstantField().setText("VK_" + this.getValueToConstants().get(this.value));
        this.getDescriptionField().setText(KeyEvent.getKeyText(this.value));
    }

    private JTextField getConstantField() {
        if (this.constantField == null) {
            this.constantField = new JTextField();
            this.constantField.setText("");
            this.constantField.setEditable(false);
        }
        return this.constantField;
    }

    private JTextField getDescriptionField() {
        if (this.descriptionField == null) {
            this.descriptionField = new JTextField();
            this.descriptionField.setText("");
            this.descriptionField.setEditable(false);
        }
        return this.descriptionField;
    }

    private void removeKeyboardActions(JComponent c) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.awt.event.KeyListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        KeyListener[] existing = (KeyListener[])c.getListeners(clazz);
        int i = 0;
        while (i < existing.length) {
            c.removeKeyListener(existing[i]);
            ++i;
        }
        c.resetKeyboardActions();
        c.setInputMap(0, null);
        c.setInputMap(1, null);
    }

    private void recursiveSetBackground(Container parent, Color bgColor) {
        if (parent instanceof JList) {
            return;
        }
        parent.setBackground(bgColor);
        Component[] children = parent.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Container) {
                this.recursiveSetBackground((Container)children[i], bgColor);
            } else {
                children[i].setBackground(bgColor);
            }
            ++i;
        }
    }

    public String getAsText() {
        if (this.value == 0) {
            return "";
        }
        return KeyEvent.getKeyText(this.value);
    }

    public String getJavaInitializationString() {
        return "java.awt.event.KeyEvent.VK_" + this.getValueToConstants().get(this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object o) {
        if (o instanceof Integer) {
            this.value = (Integer)o;
        }
    }
}

