/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.beaninfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.eclipse.ve.internal.jfc.beaninfo.VisualBeanInfoMessages;

public class SubEditorJDialog
extends JDialog
implements ActionListener {
    public static final int OK = 0;
    public static final int CANCELLED = 1;
    private int closedState = 1;
    JPanel mainPanel = null;
    JButton okButton = null;
    JButton cancelButton = null;

    public SubEditorJDialog(Frame owner) {
        super(owner, VisualBeanInfoMessages.getString("SubEditorJDialog.title"), true);
        this.initialize();
    }

    public SubEditorJDialog(Dialog owner) {
        super(owner, VisualBeanInfoMessages.getString("SubEditorJDialog.title"), true);
        this.initialize();
    }

    public static int showSubEditorJDialog(Container owner, Component customEditor) {
        SubEditorJDialog subEditor = owner instanceof Dialog ? new SubEditorJDialog((Dialog)owner) : (owner instanceof Frame ? new SubEditorJDialog((Frame)owner) : new SubEditorJDialog(null));
        subEditor.setCustomEditor(customEditor);
        return subEditor.showEditor();
    }

    public JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setBackground(SystemColor.control);
            this.okButton.setText(VisualBeanInfoMessages.getString("SubEditorJDialog.ok"));
            this.okButton.addActionListener(this);
        }
        return this.okButton;
    }

    public JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setBackground(SystemColor.control);
            this.cancelButton.setText(VisualBeanInfoMessages.getString("SubEditorJDialog.cancel"));
            this.cancelButton.addActionListener(this);
        }
        return this.cancelButton;
    }

    public void initialize() {
        this.mainPanel = new JPanel();
        this.mainPanel.setBackground(SystemColor.control);
        this.mainPanel.setLayout(new BorderLayout());
        JPanel buttonRow = new JPanel();
        buttonRow.setBackground(SystemColor.control);
        buttonRow.setLayout(new FlowLayout(2));
        JPanel buttonGrid = new JPanel();
        buttonGrid.setBackground(SystemColor.control);
        buttonGrid.setLayout(new GridLayout(1, 0, 5, 0));
        buttonGrid.add(this.getOkButton());
        buttonGrid.add(this.getCancelButton());
        buttonRow.add(buttonGrid);
        this.mainPanel.add((Component)buttonRow, "South");
        this.getContentPane().add(this.mainPanel);
        this.getRootPane().setDefaultButton(this.getOkButton());
    }

    public void setCustomEditor(Component customEditor) {
        this.mainPanel.add(customEditor, "Center");
        this.pack();
    }

    public int showEditor() {
        this.setVisible(true);
        return this.closedState;
    }

    public int getState() {
        return this.closedState;
    }

    public void actionPerformed(ActionEvent e) {
        this.closedState = e.getSource() == this.getOkButton() ? 0 : 1;
        this.setVisible(false);
    }
}

