/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.awt.IRectangleBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.jfc.core.BeanAwtUtilities;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.jfc.core.LayoutPolicyHelper;
import org.eclipse.ve.internal.jfc.core.VisualMessages;

public class BorderLayoutPolicyHelper
extends LayoutPolicyHelper {
    protected VisualContainerPolicy policy;
    public static final int LEFT_TO_RIGHT = 0;
    public static final int RIGHT_TO_LEFT = 1;
    public static final List REAL_INTERNAL_TAGS;
    public static final List DISPLAY_TAGS;
    public static final String[] CODEGEN_TAGS;
    public static final int NORTH_INDEX = 0;
    public static final int EAST_INDEX = 1;
    public static final int WEST_INDEX = 2;
    public static final int CENTER_INDEX = 3;
    public static final int SOUTH_INDEX = 4;
    public static final int BEFORE_INDEX = 5;
    public static final int AFTER_INDEX = 6;

    static {
        CODEGEN_TAGS = new String[]{"java.awt.BorderLayout.NORTH", "java.awt.BorderLayout.EAST", "java.awt.BorderLayout.WEST", "java.awt.BorderLayout.CENTER", "java.awt.BorderLayout.SOUTH", "java.awt.BorderLayout.BEFORE_LINE_BEGINS", "java.awt.BorderLayout.AFTER_LINE_ENDS"};
        REAL_INTERNAL_TAGS = new ArrayList(7);
        REAL_INTERNAL_TAGS.add("North");
        REAL_INTERNAL_TAGS.add("East");
        REAL_INTERNAL_TAGS.add("West");
        REAL_INTERNAL_TAGS.add("Center");
        REAL_INTERNAL_TAGS.add("South");
        REAL_INTERNAL_TAGS.add("Before");
        REAL_INTERNAL_TAGS.add("After");
        DISPLAY_TAGS = new ArrayList(7);
        DISPLAY_TAGS.add(VisualMessages.getString("BorderLayout.North"));
        DISPLAY_TAGS.add(VisualMessages.getString("BorderLayout.East"));
        DISPLAY_TAGS.add(VisualMessages.getString("BorderLayout.West"));
        DISPLAY_TAGS.add(VisualMessages.getString("BorderLayout.Center"));
        DISPLAY_TAGS.add(VisualMessages.getString("BorderLayout.South"));
        DISPLAY_TAGS.add(VisualMessages.getString("BorderLayout.BEFORE_LINE_BEGINS"));
        DISPLAY_TAGS.add(VisualMessages.getString("BorderLayout.AFTER_LINE_ENDS"));
    }

    protected static HashMap getDisplayTagMap(int componentOrientation) {
        HashMap displayTagMap = new HashMap(DISPLAY_TAGS.size());
        List displayTags = DISPLAY_TAGS;
        displayTagMap.put(displayTags.get(3), displayTags.get(3));
        displayTagMap.put(displayTags.get(0), displayTags.get(0));
        displayTagMap.put(displayTags.get(4), displayTags.get(4));
        if (componentOrientation == 0) {
            displayTagMap.put(displayTags.get(1), displayTags.get(6));
            displayTagMap.put(displayTags.get(2), displayTags.get(5));
            displayTagMap.put(displayTags.get(5), displayTags.get(2));
            displayTagMap.put(displayTags.get(6), displayTags.get(1));
        } else if (componentOrientation == 1) {
            displayTagMap.put(displayTags.get(1), displayTags.get(5));
            displayTagMap.put(displayTags.get(2), displayTags.get(6));
            displayTagMap.put(displayTags.get(5), displayTags.get(1));
            displayTagMap.put(displayTags.get(6), displayTags.get(2));
        }
        return displayTagMap;
    }

    public static HashMap getInternalTagMap(int componentOrientation) {
        HashMap internalTagMap = new HashMap(REAL_INTERNAL_TAGS.size());
        List realInternalTags = REAL_INTERNAL_TAGS;
        internalTagMap.put(realInternalTags.get(3), realInternalTags.get(3));
        internalTagMap.put(realInternalTags.get(0), realInternalTags.get(0));
        internalTagMap.put(realInternalTags.get(4), realInternalTags.get(4));
        if (componentOrientation == 0) {
            internalTagMap.put(realInternalTags.get(1), realInternalTags.get(6));
            internalTagMap.put(realInternalTags.get(2), realInternalTags.get(5));
            internalTagMap.put(realInternalTags.get(5), realInternalTags.get(2));
            internalTagMap.put(realInternalTags.get(6), realInternalTags.get(1));
        } else if (componentOrientation == 1) {
            internalTagMap.put(realInternalTags.get(1), realInternalTags.get(5));
            internalTagMap.put(realInternalTags.get(2), realInternalTags.get(6));
            internalTagMap.put(realInternalTags.get(5), realInternalTags.get(1));
            internalTagMap.put(realInternalTags.get(6), realInternalTags.get(2));
        }
        return internalTagMap;
    }

    protected static int getComponentOrientation(IJavaObjectInstance aComponent) {
        int result = 0;
        IBeanProxyHost componentProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)aComponent);
        IBeanProxy aBeanProxy = componentProxyHost.getBeanProxy();
        IBooleanBeanProxy booleanProxy = BeanAwtUtilities.invoke_getComponentOrientation_isLeftToRight(aBeanProxy);
        if (booleanProxy != null) {
            result = booleanProxy.booleanValue() ? 0 : 1;
        }
        return result;
    }

    public BorderLayoutPolicyHelper(VisualContainerPolicy ep) {
        super(ep);
    }

    public BorderLayoutPolicyHelper() {
    }

    protected IJavaObjectInstance convertConstraint(Object constraint) {
        if (constraint instanceof String) {
            int ndx = REAL_INTERNAL_TAGS.indexOf((String)constraint);
            return ndx > -1 ? BeanUtilities.createJavaObject((String)"java.lang.String", (ResourceSet)this.getContainer().eResource().getResourceSet(), (String)CODEGEN_TAGS[ndx]) : BeanUtilities.createString((ResourceSet)this.getContainer().eResource().getResourceSet(), (String)((String)constraint));
        }
        return null;
    }

    private Rectangle boundingRectangle() {
        if (this.getContainer() != null) {
            IBeanProxy containerProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)this.getContainer());
            IRectangleBeanProxy rectangleProxy = BeanAwtUtilities.invoke_getBounds(containerProxy);
            Rectangle r = new Rectangle(rectangleProxy.getX(), rectangleProxy.getY(), rectangleProxy.getWidth(), rectangleProxy.getHeight());
            return r;
        }
        return null;
    }

    public Point convertLocation(Point p) {
        if (p == null) {
            return null;
        }
        Rectangle r = this.boundingRectangle();
        return new Point(p.x + r.x, p.y + r.y);
    }

    public List getAllRegions() {
        return REAL_INTERNAL_TAGS;
    }

    public String[] getAvailableRegions() {
        EStructuralFeature sfConstraintConstraint = JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)JFCConstants.SF_CONSTRAINT_CONSTRAINT);
        EStructuralFeature sfComponents = JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)JFCConstants.SF_CONTAINER_COMPONENTS);
        ArrayList result = new ArrayList(this.getAllRegions().size());
        result.addAll(this.getAllRegions());
        Iterator containerComponents = ((List)this.getContainer().eGet(sfComponents)).iterator();
        HashMap tagMap = BorderLayoutPolicyHelper.getInternalTagMap(BorderLayoutPolicyHelper.getComponentOrientation(this.getContainer()));
        while (containerComponents.hasNext()) {
            EObject constraintsValue = (EObject)containerComponents.next();
            IJavaObjectInstance constraintString = (IJavaObjectInstance)constraintsValue.eGet(sfConstraintConstraint);
            IBeanProxy cp = BeanProxyUtilities.getBeanProxy((IJavaInstance)constraintString, (boolean)true);
            String constraint = cp != null ? cp.toBeanString() : "";
            result.remove(constraint);
            if (!result.contains(tagMap.get(constraint))) continue;
            result.remove(tagMap.get(constraint));
        }
        if (result.size() <= 0) {
            return null;
        }
        String[] tags = new String[result.size()];
        int i = 0;
        while (i < result.size()) {
            tags[i] = (String)result.get(i);
            ++i;
        }
        return tags;
    }

    public Command getAddChildrenCommand(List childrenComponents, List constraints, Object position) {
        Iterator itr = constraints.iterator();
        while (itr.hasNext()) {
            if (itr.next() != null) continue;
            return UnexecutableCommand.INSTANCE;
        }
        return super.getAddChildrenCommand(childrenComponents, constraints, position);
    }

    public Command getCreateChildCommand(Object childComponent, Object constraint, Object position) {
        if (constraint == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getCreateChildCommand(childComponent, constraint, position);
    }

    public String getCurrentConstraint(Point p) {
        if (p == null) {
            return null;
        }
        Rectangle r = this.boundingRectangle();
        Rectangle nRect = new Rectangle(r.x, r.y, r.width, r.height / 3);
        Rectangle wRect = new Rectangle(r.x, r.y + r.height / 3, r.width / 3, r.height / 3);
        Rectangle cRect = new Rectangle(r.x + r.width / 3, r.y + r.height / 3, r.width / 3, r.height / 3);
        Rectangle sRect = new Rectangle(r.x, r.y + 2 * r.height / 3, r.width, r.height / 3);
        Rectangle eRect = new Rectangle(r.x + 2 * r.width / 3, r.y + r.height / 3, r.width / 3, r.height / 3);
        if (nRect.contains(p)) {
            return (String)REAL_INTERNAL_TAGS.get(0);
        }
        if (wRect.contains(p)) {
            return (String)REAL_INTERNAL_TAGS.get(2);
        }
        if (cRect.contains(p)) {
            return (String)REAL_INTERNAL_TAGS.get(3);
        }
        if (eRect.contains(p)) {
            return (String)REAL_INTERNAL_TAGS.get(1);
        }
        if (sRect.contains(p)) {
            return (String)REAL_INTERNAL_TAGS.get(4);
        }
        return null;
    }

    public Rectangle getCurrentRectangle(Point p) {
        if (p == null) {
            return null;
        }
        Rectangle r = this.boundingRectangle();
        Rectangle nRect = new Rectangle(r.x, r.y, r.width, r.height / 3);
        Rectangle wRect = new Rectangle(r.x, r.y + r.height / 3, r.width / 3, r.height / 3);
        Rectangle cRect = new Rectangle(r.x + r.width / 3, r.y + r.height / 3, r.width / 3, r.height / 3);
        Rectangle sRect = new Rectangle(r.x, r.y + 2 * r.height / 3, r.width, r.height / 3);
        Rectangle eRect = new Rectangle(r.x + 2 * r.width / 3, r.y + r.height / 3, r.width / 3, r.height / 3);
        if (nRect.contains(p)) {
            return nRect;
        }
        if (wRect.contains(p)) {
            return wRect;
        }
        if (cRect.contains(p)) {
            return cRect;
        }
        if (eRect.contains(p)) {
            return eRect;
        }
        if (sRect.contains(p)) {
            return sRect;
        }
        return null;
    }

    public List getDefaultConstraint(List children) {
        ArrayList<String> constraints = new ArrayList<String>(children.size());
        String[] regions = this.getAvailableRegions();
        if (regions == null || regions.length < children.size()) {
            return Collections.nCopies(children.size(), null);
        }
        int i = 0;
        while (i < children.size()) {
            constraints.add(regions[i]);
            ++i;
        }
        return constraints;
    }

    public String[] getFilledRegions() {
        EStructuralFeature sfConstraintComponent = JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)JFCConstants.SF_CONSTRAINT_CONSTRAINT);
        ArrayList<String> result = new ArrayList<String>();
        if (this.getContainer() != null) {
            Iterator containerComponents = ((List)this.getContainer().eGet(JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)JFCConstants.SF_CONTAINER_COMPONENTS))).iterator();
            while (containerComponents.hasNext()) {
                IBeanProxy cProxy;
                EObject borderComponent = (EObject)containerComponents.next();
                IJavaObjectInstance constraintsValue = (IJavaObjectInstance)borderComponent.eGet(sfConstraintComponent);
                if (constraintsValue == null || !((cProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)constraintsValue, (boolean)true)) instanceof IStringBeanProxy)) continue;
                result.add(((IStringBeanProxy)cProxy).stringValue());
            }
        }
        HashMap tagMap = BorderLayoutPolicyHelper.getInternalTagMap(BorderLayoutPolicyHelper.getComponentOrientation(this.getContainer()));
        int i = 0;
        while (i < result.size()) {
            String constraint = (String)result.get(i);
            String equalConstraint = (String)tagMap.get(constraint);
            if (!result.contains(equalConstraint)) {
                result.add(equalConstraint);
            }
            ++i;
        }
        if (result.size() <= 0) {
            return null;
        }
        String[] tags = new String[result.size()];
        int i2 = 0;
        while (i2 < result.size()) {
            tags[i2] = (String)result.get(i2);
            ++i2;
        }
        return tags;
    }

    public boolean isRegionAvailable(String constraint) {
        String[] tags = this.getAvailableRegions();
        if (tags != null) {
            int i = 0;
            while (i < tags.length) {
                if (tags[i].equals(constraint)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

