/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.jem.internal.instantiation.base.IJavaDataTypeInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.cde.emf.InverseMaintenanceAdapter;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.InsetsJavaClassCellEditor;
import org.eclipse.ve.internal.java.core.JavaBeanCustomizeLayoutPage;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.core.Spinner;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.jfc.core.JFCMessages;
import org.eclipse.ve.internal.propertysheet.common.commands.AbstractCommand;

public class GridBagComponentPage
extends JavaBeanCustomizeLayoutPage {
    protected IEditorPart fEditorPart;
    private static final String[] resAnchorPrefix = new String[]{"AnchorAction.northwest.", "AnchorAction.north.", "AnchorAction.northeast.", "AnchorAction.west.", "AnchorAction.center.", "AnchorAction.east.", "AnchorAction.southwest.", "AnchorAction.south.", "AnchorAction.southeast."};
    protected static String[] anchorInitStrings = new String[]{"java.awt.GridBagConstraints.NORTHWEST", "java.awt.GridBagConstraints.NORTH", "java.awt.GridBagConstraints.NORTHEAST", "java.awt.GridBagConstraints.WEST", "java.awt.GridBagConstraints.CENTER", "java.awt.GridBagConstraints.EAST", "java.awt.GridBagConstraints.SOUTHWEST", "java.awt.GridBagConstraints.SOUTH", "java.awt.GridBagConstraints.SOUTHEAST"};
    protected AnchorAction[] anchorActions = new AnchorAction[]{new AnchorAction(0), new AnchorAction(1), new AnchorAction(2), new AnchorAction(3), new AnchorAction(4), new AnchorAction(5), new AnchorAction(6), new AnchorAction(7), new AnchorAction(8)};
    public static final int NW = 0;
    public static final int NORTH = 1;
    public static final int NE = 2;
    public static final int WEST = 3;
    public static final int CENTER = 4;
    public static final int EAST = 5;
    public static final int SW = 6;
    public static final int SOUTH = 7;
    public static final int SE = 8;
    protected static final int[] anchorAWTValue = new int[]{18, 11, 12, 17, 10, 13, 16, 15, 14};
    private static final String[] resFillPrefix = new String[]{"FillAction.horizontal.", "FillAction.vertical."};
    protected static String[] fillInitStrings = new String[]{"java.awt.GridBagConstraints.HORIZONTAL", "java.awt.GridBagConstraints.VERTICAL", "java.awt.GridBagConstraints.NONE", "java.awt.GridBagConstraints.BOTH"};
    private FillAction[] fillActions = new FillAction[]{new FillAction(0), new FillAction(1)};
    public static final int FILL_HORIZONTAL = 0;
    public static final int FILL_VERTICAL = 1;
    public static final int FILL_NONE = 2;
    public static final int FILL_BOTH = 3;
    protected static final int[] fillAWTValue;
    protected EReference sfComponents;
    protected EReference sfConstraintComponent;
    protected EReference sfConstraintConstraint;
    protected EStructuralFeature sfAnchor;
    protected EStructuralFeature sfFill;
    protected EStructuralFeature sfInsets;
    protected ResourceSet rset;
    protected AnchorAction selectedAnchorAction;
    protected int currentFillValue;
    protected Spinner topSpinner;
    protected Spinner leftSpinner;
    protected Spinner bottomSpinner;
    protected Spinner rightSpinner;
    protected Insets componentInsets = null;
    public static final int INSETS_TOP = 0;
    public static final int INSETS_LEFT = 1;
    public static final int INSETS_BOTTOM = 2;
    public static final int INSETS_RIGHT = 3;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[1] = 3;
        nArray[3] = 1;
        fillAWTValue = nArray;
    }

    protected List getSelectedObjects() {
        if (!(this.getSelection() instanceof IStructuredSelection)) {
            return Collections.EMPTY_LIST;
        }
        return ((IStructuredSelection)this.getSelection()).toList();
    }

    protected Command createAnchorCommand(List editparts, int anchorType) {
        if (!editparts.isEmpty()) {
            CommandBuilder cb = new CommandBuilder();
            int i = 0;
            while (i < editparts.size()) {
                IJavaObjectInstance gridbagconstraint;
                EditPart editpart = (EditPart)editparts.get(i);
                EObject constraintComponent = InverseMaintenanceAdapter.getIntermediateReference((EObject)((EObject)editpart.getParent().getModel()), (EReference)this.sfComponents, (EReference)this.sfConstraintComponent, (Notifier)((IJavaObjectInstance)editpart.getModel()));
                if (constraintComponent != null && (gridbagconstraint = (IJavaObjectInstance)constraintComponent.eGet((EStructuralFeature)this.sfConstraintConstraint)) != null) {
                    RuledCommandBuilder componentCB = new RuledCommandBuilder(EditDomain.getEditDomain((EditPart)editpart), null, false);
                    IJavaInstance anchorObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)anchorInitStrings[anchorType]);
                    componentCB.applyAttributeSetting((EObject)gridbagconstraint, this.sfAnchor, (Object)anchorObject);
                    componentCB.applyAttributeSetting(constraintComponent, (EStructuralFeature)this.sfConstraintConstraint, (Object)gridbagconstraint);
                    cb.append(componentCB.getCommand());
                }
                ++i;
            }
            return cb.getCommand();
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command createFillCommand(List editparts, int fillType) {
        if (!editparts.isEmpty()) {
            CommandBuilder cb = new CommandBuilder();
            int i = 0;
            while (i < editparts.size()) {
                IJavaObjectInstance gridbagconstraint;
                EditPart editpart = (EditPart)editparts.get(i);
                EObject constraintComponent = InverseMaintenanceAdapter.getIntermediateReference((EObject)((EObject)editpart.getParent().getModel()), (EReference)this.sfComponents, (EReference)this.sfConstraintComponent, (Notifier)((IJavaObjectInstance)editpart.getModel()));
                if (constraintComponent != null && (gridbagconstraint = (IJavaObjectInstance)constraintComponent.eGet((EStructuralFeature)this.sfConstraintConstraint)) != null) {
                    RuledCommandBuilder componentCB = new RuledCommandBuilder(EditDomain.getEditDomain((EditPart)editpart), null, false);
                    IJavaInstance fillObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)fillInitStrings[fillType]);
                    componentCB.applyAttributeSetting((EObject)gridbagconstraint, this.sfFill, (Object)fillObject);
                    componentCB.applyAttributeSetting(constraintComponent, (EStructuralFeature)this.sfConstraintConstraint, (Object)gridbagconstraint);
                    cb.append(componentCB.getCommand());
                }
                ++i;
            }
            return cb.getCommand();
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command createInsetsCommand(List editparts, Insets changedInsets, int insetsPosition, Spinner spinner) {
        if (!editparts.isEmpty()) {
            CommandBuilder cb = new CommandBuilder();
            int i = 0;
            while (i < editparts.size()) {
                EditPart editpart = (EditPart)editparts.get(i);
                Insets insets = this.getInsetsValue(editpart);
                if (insets != null) {
                    IJavaObjectInstance gridbagconstraint;
                    if (insetsPosition == 0) {
                        insets.top = changedInsets.top;
                    } else if (insetsPosition == 1) {
                        insets.left = changedInsets.left;
                    } else if (insetsPosition == 3) {
                        insets.right = changedInsets.right;
                    } else if (insetsPosition == 2) {
                        insets.bottom = changedInsets.bottom;
                    }
                    EObject constraintComponent = InverseMaintenanceAdapter.getIntermediateReference((EObject)((EObject)editpart.getParent().getModel()), (EReference)this.sfComponents, (EReference)this.sfConstraintComponent, (Notifier)((IJavaObjectInstance)editpart.getModel()));
                    if (constraintComponent != null && (gridbagconstraint = (IJavaObjectInstance)constraintComponent.eGet((EStructuralFeature)this.sfConstraintConstraint)) != null) {
                        RuledCommandBuilder componentCB = new RuledCommandBuilder(EditDomain.getEditDomain((EditPart)editpart), null, false);
                        IJavaInstance insetsObject = BeanUtilities.createJavaObject((String)"java.awt.Insets", (ResourceSet)this.rset, (String)InsetsJavaClassCellEditor.getJavaInitializationString((Insets)insets));
                        componentCB.applyAttributeSetting((EObject)gridbagconstraint, this.sfInsets, (Object)insetsObject);
                        componentCB.applyAttributeSetting(constraintComponent, (EStructuralFeature)this.sfConstraintConstraint, (Object)gridbagconstraint);
                        cb.append(componentCB.getCommand());
                    }
                }
                ++i;
            }
            cb.append((Command)new EnableSpinnerCommand(spinner));
            return cb.getCommand();
        }
        spinner.setEnabled(true);
        return UnexecutableCommand.INSTANCE;
    }

    public Control getControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)new GridLayout(3, false));
        Group anchorGroup = this.createGroup(mainComposite, JFCMessages.getString("GridBagComponentPage.Anchor"), 3, 0, 0);
        int i = 0;
        while (i < this.anchorActions.length) {
            ActionContributionItem ac = new ActionContributionItem((IAction)this.anchorActions[i]);
            ac.fill((Composite)anchorGroup);
            ++i;
        }
        Group fillGroup = this.createGroup(mainComposite, JFCMessages.getString("GridBagComponentPage.Fill"), 1, 0, 0);
        int i2 = 0;
        while (i2 < this.fillActions.length) {
            ActionContributionItem ac = new ActionContributionItem((IAction)this.fillActions[i2]);
            ac.fill((Composite)fillGroup);
            ++i2;
        }
        Group insetsGroup = this.createGroup(mainComposite, JFCMessages.getString("GridBagComponentPage.Insets"), 2, 5, 4);
        this.createInsetsControl(insetsGroup);
        return mainComposite;
    }

    protected void createInsetsControl(Group insetsGroup) {
        Label lbl = new Label((Composite)insetsGroup, 0);
        lbl.setText(JFCMessages.getString("GridBagComponentPage.InsetsGroup.Top"));
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;
        if (this.componentInsets != null) {
            top = this.componentInsets.top;
            left = this.componentInsets.left;
            bottom = this.componentInsets.bottom;
            right = this.componentInsets.right;
        }
        this.topSpinner = new Spinner((Composite)insetsGroup, 0, top);
        this.topSpinner.setEnabled(this.componentInsets != null);
        this.topSpinner.addModifyListener(new Listener(){

            public void handleEvent(Event e) {
                int top = GridBagComponentPage.this.topSpinner.getValue();
                if (GridBagComponentPage.this.componentInsets != null && top != GridBagComponentPage.this.componentInsets.top) {
                    GridBagComponentPage.this.componentInsets.top = top;
                    GridBagComponentPage.this.execute(GridBagComponentPage.this.createInsetsCommand(GridBagComponentPage.this.getSelectedObjects(), GridBagComponentPage.this.componentInsets, 0, GridBagComponentPage.this.topSpinner));
                } else {
                    GridBagComponentPage.this.topSpinner.setEnabled(true);
                }
            }
        });
        lbl = new Label((Composite)insetsGroup, 0);
        lbl.setText(JFCMessages.getString("GridBagComponentPage.InsetsGroup.Left"));
        this.leftSpinner = new Spinner((Composite)insetsGroup, 0, left);
        this.leftSpinner.setEnabled(this.componentInsets != null);
        this.leftSpinner.addModifyListener(new Listener(){

            public void handleEvent(Event e) {
                int left = GridBagComponentPage.this.leftSpinner.getValue();
                if (GridBagComponentPage.this.componentInsets != null && left != GridBagComponentPage.this.componentInsets.left) {
                    GridBagComponentPage.this.componentInsets.left = left;
                    GridBagComponentPage.this.execute(GridBagComponentPage.this.createInsetsCommand(GridBagComponentPage.this.getSelectedObjects(), GridBagComponentPage.this.componentInsets, 1, GridBagComponentPage.this.leftSpinner));
                } else {
                    GridBagComponentPage.this.leftSpinner.setEnabled(true);
                }
            }
        });
        lbl = new Label((Composite)insetsGroup, 0);
        lbl.setText(JFCMessages.getString("GridBagComponentPage.InsetsGroup.Bottom"));
        this.bottomSpinner = new Spinner((Composite)insetsGroup, 0, bottom);
        this.bottomSpinner.setEnabled(this.componentInsets != null);
        this.bottomSpinner.addModifyListener(new Listener(){

            public void handleEvent(Event e) {
                int bottom = GridBagComponentPage.this.bottomSpinner.getValue();
                if (GridBagComponentPage.this.componentInsets != null && bottom != GridBagComponentPage.this.componentInsets.bottom) {
                    GridBagComponentPage.this.componentInsets.bottom = bottom;
                    GridBagComponentPage.this.execute(GridBagComponentPage.this.createInsetsCommand(GridBagComponentPage.this.getSelectedObjects(), GridBagComponentPage.this.componentInsets, 2, GridBagComponentPage.this.bottomSpinner));
                } else {
                    GridBagComponentPage.this.bottomSpinner.setEnabled(true);
                }
            }
        });
        lbl = new Label((Composite)insetsGroup, 0);
        lbl.setText(JFCMessages.getString("GridBagComponentPage.InsetsGroup.Right"));
        this.rightSpinner = new Spinner((Composite)insetsGroup, 0, right);
        this.rightSpinner.setEnabled(this.componentInsets != null);
        this.rightSpinner.addModifyListener(new Listener(){

            public void handleEvent(Event e) {
                int right = GridBagComponentPage.this.rightSpinner.getValue();
                if (GridBagComponentPage.this.componentInsets != null && right != GridBagComponentPage.this.componentInsets.right) {
                    GridBagComponentPage.this.componentInsets.right = right;
                    GridBagComponentPage.this.execute(GridBagComponentPage.this.createInsetsCommand(GridBagComponentPage.this.getSelectedObjects(), GridBagComponentPage.this.componentInsets, 3, GridBagComponentPage.this.rightSpinner));
                } else {
                    GridBagComponentPage.this.rightSpinner.setEnabled(true);
                }
            }
        });
    }

    protected Group createGroup(Composite aParent, String title, int numColumns, int verticalSpacing, int horizontalSpacing) {
        Group group = new Group(aParent, 0);
        group.setText(title);
        GridLayout gridLayout = new GridLayout(numColumns, false);
        gridLayout.verticalSpacing = verticalSpacing;
        gridLayout.horizontalSpacing = horizontalSpacing;
        group.setLayout((Layout)gridLayout);
        GridData data = new GridData(768);
        data.verticalAlignment = 1040;
        group.setLayoutData((Object)data);
        return group;
    }

    protected void enableAnchorActions(boolean enable) {
        int i = 0;
        while (i < this.anchorActions.length) {
            this.anchorActions[i].setEnabled(enable);
            if (!enable) {
                this.anchorActions[i].setChecked(false);
            }
            ++i;
        }
    }

    protected void enableFillActions(boolean enable) {
        int i = 0;
        while (i < this.fillActions.length) {
            this.fillActions[i].setEnabled(enable);
            if (!enable) {
                this.fillActions[i].setChecked(false);
            }
            ++i;
        }
    }

    protected void enableInsets(boolean enable) {
        if (this.topSpinner != null) {
            this.topSpinner.setEnabled(enable);
        }
        if (this.leftSpinner != null) {
            this.leftSpinner.setEnabled(enable);
        }
        if (this.bottomSpinner != null) {
            this.bottomSpinner.setEnabled(enable);
        }
        if (this.rightSpinner != null) {
            this.rightSpinner.setEnabled(enable);
        }
    }

    protected void execute(Command command) {
        CommandStack cmdStack;
        if (command == null || !command.canExecute()) {
            return;
        }
        IEditorPart iEditorPart = this.getEditorPart();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.commands.CommandStack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((cmdStack = (CommandStack)iEditorPart.getAdapter((Class)clazz)) != null) {
            cmdStack.execute(command);
        }
    }

    public Image getImage() {
        return null;
    }

    public String getText() {
        return JFCMessages.getString("GridBagComponentPage.Gridbag");
    }

    public String getToolTipText() {
        return JFCMessages.getString("GridBagComponentPage.ToolTipText");
    }

    protected void handleEditorPartChanged(IEditorPart oldEditorPart) {
        IEditorPart newEditorPart = this.getEditorPart();
        int i = 0;
        while (i < this.anchorActions.length) {
            this.anchorActions[i].setEditorPart(newEditorPart);
            ++i;
        }
        i = 0;
        while (i < this.fillActions.length) {
            this.fillActions[i].setEditorPart(newEditorPart);
            ++i;
        }
        this.resetVariables();
    }

    protected boolean handleSelectionChanged(ISelection oldSelection) {
        ISelection newSelection = this.getSelection();
        if (newSelection != null && newSelection instanceof IStructuredSelection && !((IStructuredSelection)newSelection).isEmpty()) {
            EditPart firstParent;
            List editparts = ((IStructuredSelection)newSelection).toList();
            boolean enableAll = true;
            if (editparts.get(0) instanceof EditPart && ((EditPart)editparts.get(0)).getParent() != null && this.isValidParent(firstParent = ((EditPart)editparts.get(0)).getParent())) {
                EditPart ep = (EditPart)editparts.get(0);
                int i = 1;
                while (i < editparts.size()) {
                    if (editparts.get(i) instanceof EditPart) {
                        ep = (EditPart)editparts.get(i);
                        if (ep.getParent() == null || ep.getParent() != firstParent) {
                            enableAll = false;
                            break;
                        }
                    } else {
                        enableAll = false;
                        break;
                    }
                    ++i;
                }
                if (enableAll) {
                    this.enableAnchorActions(true);
                    this.enableFillActions(true);
                    this.enableInsets(true);
                    this.handleSelectionChangedForAnchorActions(editparts);
                    this.handleSelectionChangedForFillActions(editparts);
                    this.handleSelectionChangedForInsets(editparts);
                    return true;
                }
            }
        }
        this.enableAnchorActions(false);
        this.enableFillActions(false);
        this.enableInsets(false);
        return false;
    }

    protected void handleSelectionChangedForAnchorActions(List editparts) {
        boolean setChecked = true;
        int firstAnchorValue = this.getAnchorValue((EditPart)editparts.get(0));
        int i = 1;
        while (i < editparts.size()) {
            if (firstAnchorValue != this.getAnchorValue((EditPart)editparts.get(i))) {
                setChecked = false;
                break;
            }
            ++i;
        }
        if (setChecked) {
            i = 0;
            while (i < this.anchorActions.length) {
                if (anchorAWTValue[i] == firstAnchorValue) {
                    this.anchorActions[i].setChecked(true);
                    this.selectedAnchorAction = this.anchorActions[i];
                } else {
                    this.anchorActions[i].setChecked(false);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.anchorActions.length) {
                this.anchorActions[i].setChecked(false);
                ++i;
            }
            this.selectedAnchorAction = null;
        }
    }

    protected void handleSelectionChangedForFillActions(List editparts) {
        block5: {
            int i;
            block3: {
                int firstFillValue;
                block7: {
                    block6: {
                        block4: {
                            boolean setChecked = true;
                            firstFillValue = this.getFillValue((EditPart)editparts.get(0));
                            i = 1;
                            while (i < editparts.size()) {
                                if (firstFillValue != this.getFillValue((EditPart)editparts.get(i))) {
                                    setChecked = false;
                                    break;
                                }
                                ++i;
                            }
                            if (!setChecked) break block3;
                            if (fillAWTValue[2] != firstFillValue) break block4;
                            this.fillActions[0].setChecked(false);
                            this.fillActions[1].setChecked(false);
                            this.currentFillValue = 2;
                            break block5;
                        }
                        if (fillAWTValue[0] != firstFillValue) break block6;
                        this.fillActions[0].setChecked(true);
                        this.fillActions[1].setChecked(false);
                        this.currentFillValue = 0;
                        break block5;
                    }
                    if (fillAWTValue[1] != firstFillValue) break block7;
                    this.fillActions[1].setChecked(true);
                    this.fillActions[0].setChecked(false);
                    this.currentFillValue = 1;
                    break block5;
                }
                if (fillAWTValue[3] != firstFillValue) break block5;
                this.fillActions[0].setChecked(true);
                this.fillActions[1].setChecked(true);
                this.currentFillValue = 3;
                break block5;
            }
            i = 0;
            while (i < this.fillActions.length) {
                this.fillActions[i].setChecked(false);
                ++i;
            }
        }
    }

    protected void handleSelectionChangedForInsets(List editparts) {
        int i = 0;
        while (i < editparts.size()) {
            EditPart ep = (EditPart)editparts.get(i);
            if (ep.getSelected() == 2 && ep.getModel() instanceof IJavaObjectInstance) {
                this.componentInsets = this.getInsetsValue(ep);
                break;
            }
            ++i;
        }
        this.setInsetsValues(this.componentInsets);
    }

    protected void setInsetsValues(Insets componentInsets) {
        if (componentInsets == null) {
            this.enableInsets(false);
            return;
        }
        this.enableInsets(true);
        if (this.topSpinner != null) {
            this.topSpinner.setValue(componentInsets.top);
        }
        if (this.leftSpinner != null) {
            this.leftSpinner.setValue(componentInsets.left);
        }
        if (this.bottomSpinner != null) {
            this.bottomSpinner.setValue(componentInsets.bottom);
        }
        if (this.rightSpinner != null) {
            this.rightSpinner.setValue(componentInsets.right);
        }
    }

    protected int getAnchorValue(EditPart ep) {
        if (this.getResourceSet(ep) != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((IPropertySource)ep.getAdapter((Class)clazz) instanceof IPropertySource) {
                Object anchorPV;
                IPropertySource ps;
                IPropertySource gridbagconstraint;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((gridbagconstraint = (IPropertySource)(ps = (IPropertySource)ep.getAdapter((Class)clazz2)).getPropertyValue((Object)this.sfConstraintConstraint)) != null && (anchorPV = gridbagconstraint.getPropertyValue((Object)this.sfAnchor)) != null && anchorPV instanceof IJavaDataTypeInstance) {
                    IIntegerBeanProxy intProxy = (IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaDataTypeInstance)anchorPV), (ResourceSet)this.rset);
                    return intProxy.intValue();
                }
            }
        }
        return anchorAWTValue[4];
    }

    protected int getFillValue(EditPart ep) {
        if (this.getResourceSet(ep) != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((IPropertySource)ep.getAdapter((Class)clazz) instanceof IPropertySource) {
                Object fillPV;
                IPropertySource ps;
                IPropertySource gridbagconstraint;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((gridbagconstraint = (IPropertySource)(ps = (IPropertySource)ep.getAdapter((Class)clazz2)).getPropertyValue((Object)this.sfConstraintConstraint)) != null && (fillPV = gridbagconstraint.getPropertyValue((Object)this.sfFill)) != null && fillPV instanceof IJavaDataTypeInstance) {
                    IIntegerBeanProxy intProxy = (IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaDataTypeInstance)fillPV), (ResourceSet)this.rset);
                    return intProxy.intValue();
                }
            }
        }
        return fillAWTValue[2];
    }

    protected Insets getInsetsValue(EditPart ep) {
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;
        if (this.getResourceSet(ep) != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((IPropertySource)ep.getAdapter((Class)clazz) instanceof IPropertySource) {
                IBeanProxy insetsProxy;
                IPropertySource insetsPS;
                Object insetsPV;
                IPropertySource ps;
                IPropertySource gridbagconstraint;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((gridbagconstraint = (IPropertySource)(ps = (IPropertySource)ep.getAdapter((Class)clazz2)).getPropertyValue((Object)this.sfConstraintConstraint)) != null && (insetsPV = (insetsPS = (IPropertySource)gridbagconstraint.getPropertyValue((Object)this.sfInsets)).getEditableValue()) != null && insetsPV instanceof IJavaObjectInstance && (insetsProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaObjectInstance)insetsPV), (ResourceSet)this.rset)) != null) {
                    IIntegerBeanProxy intProxy = null;
                    try {
                        IFieldProxy fieldProxy = insetsProxy.getTypeProxy().getFieldProxy("top");
                        intProxy = (IIntegerBeanProxy)fieldProxy.get(insetsProxy);
                        if (intProxy != null) {
                            top = intProxy.intValue();
                        }
                        if ((intProxy = (IIntegerBeanProxy)(fieldProxy = insetsProxy.getTypeProxy().getFieldProxy("left")).get(insetsProxy)) != null) {
                            left = intProxy.intValue();
                        }
                        if ((intProxy = (IIntegerBeanProxy)(fieldProxy = insetsProxy.getTypeProxy().getFieldProxy("bottom")).get(insetsProxy)) != null) {
                            bottom = intProxy.intValue();
                        }
                        if ((intProxy = (IIntegerBeanProxy)(fieldProxy = insetsProxy.getTypeProxy().getFieldProxy("right")).get(insetsProxy)) != null) {
                            right = intProxy.intValue();
                        }
                    }
                    catch (ThrowableProxy throwableProxy) {}
                    return new Insets(top, left, bottom, right);
                }
            }
        }
        return null;
    }

    private void resetVariables() {
        this.rset = null;
        this.sfConstraintConstraint = null;
        this.sfAnchor = null;
    }

    protected ResourceSet getResourceSet(EditPart editpart) {
        if (this.rset == null) {
            this.rset = EMFEditDomainHelper.getResourceSet((EditDomain)EditDomain.getEditDomain((EditPart)editpart));
            this.sfConstraintConstraint = JavaInstantiation.getReference((ResourceSet)this.rset, (URI)JFCConstants.SF_CONSTRAINT_CONSTRAINT);
            this.sfComponents = JavaInstantiation.getReference((ResourceSet)this.rset, (URI)JFCConstants.SF_CONTAINER_COMPONENTS);
            this.sfConstraintComponent = JavaInstantiation.getReference((ResourceSet)this.rset, (URI)JFCConstants.SF_CONSTRAINT_COMPONENT);
            this.sfAnchor = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)JFCConstants.SF_GRIDBAGCONSTRAINTS_ANCHOR);
            this.sfFill = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)JFCConstants.SF_GRIDBAGCONSTRAINTS_FILL);
            this.sfInsets = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)JFCConstants.SF_GRIDBAGCONSTRAINTS_INSETS);
        }
        return this.rset;
    }

    protected void handleSelectionProviderInitialization(ISelectionProvider selectionProvider) {
    }

    public boolean isValidParent(EditPart parent) {
        IActionFilter af;
        Class<?> clazz;
        if (parent instanceof TreeEditPart) {
            EditPart ep;
            EditPartViewer viewer;
            EditDomain ed = EditDomain.getEditDomain((EditPart)parent);
            IEditorPart iEditorPart = ed.getEditorPart();
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.gef.EditPartViewer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((viewer = (EditPartViewer)iEditorPart.getAdapter((Class)clazz2)) != null && (ep = (EditPart)viewer.getEditPartRegistry().get(parent.getModel())) != null) {
                parent = ep;
            }
        }
        if ((clazz = class$3) == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.ui.IActionFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (af = (IActionFilter)parent.getAdapter((Class)clazz)) != null && af.testAttribute((Object)parent, "EDITPOLICY#LAYOUTPOLICY", "java.awt.GridBagLayout");
    }

    public class AnchorAction
    extends Action {
        protected int fAnchorType;

        public AnchorAction(int anchorType) {
            super(null, 2);
            this.fAnchorType = anchorType < 0 || anchorType >= resAnchorPrefix.length ? 4 : anchorType;
            String sAnchorType = resAnchorPrefix[this.fAnchorType];
            this.setText(JFCMessages.getString(String.valueOf(sAnchorType) + "label"));
            this.setToolTipText(JFCMessages.getString(String.valueOf(sAnchorType) + "tooltip"));
            String graphicName = JFCMessages.getString(String.valueOf(sAnchorType) + "image");
            this.setImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)("icons/full/elcl16/" + graphicName)));
            this.setHoverImageDescriptor(this.getImageDescriptor());
            this.setDisabledImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)("icons/full/dlcl16/" + graphicName)));
            this.setEnabled(true);
            this.setId(this.getActionId(this.fAnchorType));
        }

        public String getActionId(int anchorType) {
            return anchorType >= 0 && anchorType < resAnchorPrefix.length ? resAnchorPrefix[anchorType] : resAnchorPrefix[4];
        }

        protected boolean calculateEnabled() {
            return true;
        }

        protected void setEditorPart(IEditorPart part) {
            GridBagComponentPage.this.fEditorPart = part;
        }

        public void run() {
            super.run();
            if (GridBagComponentPage.this.selectedAnchorAction != this) {
                GridBagComponentPage.this.execute(GridBagComponentPage.this.createAnchorCommand(GridBagComponentPage.this.getSelectedObjects(), this.fAnchorType));
                GridBagComponentPage.this.selectedAnchorAction = this;
            }
            int i = 0;
            while (i < GridBagComponentPage.this.anchorActions.length) {
                if (GridBagComponentPage.this.anchorActions[i] != this) {
                    GridBagComponentPage.this.anchorActions[i].setChecked(false);
                } else if (!this.isChecked()) {
                    this.setChecked(true);
                }
                ++i;
            }
        }
    }

    public class FillAction
    extends Action {
        protected int fFillType;

        public FillAction(int fillType) {
            super(null, 2);
            this.fFillType = fillType < 0 || fillType >= resAnchorPrefix.length ? 0 : fillType;
            String sFillType = resFillPrefix[this.fFillType];
            this.setText(JFCMessages.getString(String.valueOf(sFillType) + "label"));
            this.setToolTipText(JFCMessages.getString(String.valueOf(sFillType) + "tooltip"));
            String graphicName = JFCMessages.getString(String.valueOf(sFillType) + "image");
            this.setImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)("icons/full/elcl16/" + graphicName)));
            this.setHoverImageDescriptor(this.getImageDescriptor());
            this.setDisabledImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)("icons/full/dlcl16/" + graphicName)));
            this.setEnabled(true);
            this.setId(this.getActionId(this.fFillType));
        }

        public String getActionId(int fillType) {
            return fillType >= 0 && fillType < resFillPrefix.length ? resFillPrefix[fillType] : resFillPrefix[0];
        }

        protected boolean calculateEnabled() {
            return true;
        }

        protected void setEditorPart(IEditorPart part) {
            GridBagComponentPage.this.fEditorPart = part;
        }

        public void run() {
            super.run();
            int fillValue = 2;
            if (GridBagComponentPage.this.fillActions[0].isChecked() && GridBagComponentPage.this.fillActions[1].isChecked()) {
                fillValue = 3;
                GridBagComponentPage.this.currentFillValue = 3;
            } else if (GridBagComponentPage.this.fillActions[0].isChecked()) {
                fillValue = 0;
                GridBagComponentPage.this.currentFillValue = 0;
            } else if (GridBagComponentPage.this.fillActions[1].isChecked()) {
                fillValue = 1;
                GridBagComponentPage.this.currentFillValue = 1;
            }
            GridBagComponentPage.this.execute(GridBagComponentPage.this.createFillCommand(GridBagComponentPage.this.getSelectedObjects(), fillValue));
        }
    }

    public class LabelAction
    extends Action {
        Text fText;
        int fActionType;
        public static final int INSETS_MINUS = 0;
        public static final int INSETS_PLUS = 1;

        public LabelAction(String text, int actionType) {
            super(null, 1);
            this.fActionType = actionType != 0 && actionType != 1 ? 1 : actionType;
            this.setText(text);
            this.setEnabled(true);
            this.setId("labelaction" + text);
        }

        public void setTextControl(Text text) {
            this.fText = text;
        }

        public void run() {
            if (this.fText != null) {
                String textValue = this.fText.getText();
                try {
                    int value = Integer.parseInt(textValue);
                    if (this.fActionType == 1) {
                        this.fText.setText(String.valueOf(++value));
                    } else if (value > 0) {
                        this.fText.setText(String.valueOf(--value));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.fText.setText(textValue);
                }
            }
        }
    }

    protected class EnableSpinnerCommand
    extends AbstractCommand {
        protected Spinner spinner;

        public EnableSpinnerCommand(Spinner spinner) {
            this.spinner = spinner;
        }

        public void execute() {
            if (this.spinner != null) {
                this.spinner.setEnabled(true);
            }
        }

        public boolean canExecute() {
            return true;
        }
    }
}

