/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.awt.IDimensionBeanProxy;
import org.eclipse.jem.internal.proxy.awt.IPointBeanProxy;
import org.eclipse.jem.internal.proxy.awt.IRectangleBeanProxy;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.ClassDecoratorFeatureAccess;
import org.eclipse.ve.internal.cde.emf.InverseMaintenanceAdapter;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.InsetsJavaClassCellEditor;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.jcm.BeanDecorator;
import org.eclipse.ve.internal.jfc.core.BeanAwtUtilities;
import org.eclipse.ve.internal.jfc.core.GridBagConstraint;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.jfc.core.LayoutPolicyHelper;

public class GridBagLayoutPolicyHelper
extends LayoutPolicyHelper
implements IActionFilter {
    static Integer ZERO_INTEGER = new Integer(0);
    protected ResourceSet rset;
    List fComponents = null;
    ArrayList childrenXYBounds;
    ArrayList columnDividerPositions;
    ArrayList rowDividerPositions;
    ArrayList sortedLeftEdges;
    ArrayList sortedRightEdges;
    ArrayList sortedTopEdges;
    ArrayList sortedBottomEdges = null;
    private EStructuralFeature sfGridX;
    private EStructuralFeature sfGridY;
    private EStructuralFeature sfGridWidth;
    private EStructuralFeature sfGridHeight;
    private EStructuralFeature sfWeightX;
    private EStructuralFeature sfWeightY;
    private EStructuralFeature sfFill;
    private EStructuralFeature sfInsets;
    private EStructuralFeature sfIPadX;
    private EStructuralFeature sfIPadY;
    private JavaHelpers primInt;
    private JavaHelpers primDouble;
    private JavaHelpers gridBagConstraints;
    private EObject[][] layoutTable;
    protected static String[] fillInitStrings = new String[]{"java.awt.GridBagConstraints.NONE", "java.awt.GridBagConstraints.BOTH", "java.awt.GridBagConstraints.HORIZONTAL", "java.awt.GridBagConstraints.VERTICAL"};
    public static final String GRIDBAG_FILL_PREFERENCE_KEY = "org.eclipse.ve.internal.jfc.core.gridbagfilepreferencekey";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public GridBagLayoutPolicyHelper(VisualContainerPolicy ep) {
        super(ep);
    }

    public GridBagLayoutPolicyHelper() {
    }

    protected void adjustForFillPreferences(IJavaObjectInstance component, GridBagConstraint constraint) {
        int fillPref = this.getGridBagConstraintsFillPreference(component);
        if (fillPref == 0) {
            return;
        }
        constraint.fill = fillPref;
        if (fillPref == 2) {
            constraint.weightx = 1.0;
        } else if (fillPref == 3) {
            constraint.weighty = 1.0;
        } else if (fillPref == 1) {
            constraint.weightx = 1.0;
            constraint.weighty = 1.0;
        }
    }

    protected IJavaObjectInstance convertConstraint(Object constraint) {
        GridBagConstraint gridBagConstraint = (GridBagConstraint)constraint;
        GridBagConstraint defaultConstraint = new GridBagConstraint();
        IJavaObjectInstance javaGridBagConstraint = (IJavaObjectInstance)BeanUtilities.createJavaObject((String)"java.awt.GridBagConstraints", (ResourceSet)this.rset, null);
        if (gridBagConstraint.gridx != defaultConstraint.gridx) {
            IJavaInstance gridx = BeanUtilities.createJavaObject((JavaHelpers)this.primInt, (ResourceSet)this.rset, (String)String.valueOf(gridBagConstraint.gridx));
            javaGridBagConstraint.eSet(this.sfGridX, (Object)gridx);
        }
        if (gridBagConstraint.gridy != defaultConstraint.gridy) {
            IJavaInstance gridy = BeanUtilities.createJavaObject((JavaHelpers)this.primInt, (ResourceSet)this.rset, (String)String.valueOf(gridBagConstraint.gridy));
            javaGridBagConstraint.eSet(this.sfGridY, (Object)gridy);
        }
        if (gridBagConstraint.gridwidth != defaultConstraint.gridwidth) {
            IJavaInstance gridwidth = BeanUtilities.createJavaObject((JavaHelpers)this.primInt, (ResourceSet)this.rset, (String)String.valueOf(gridBagConstraint.gridwidth));
            javaGridBagConstraint.eSet(this.sfGridWidth, (Object)gridwidth);
        }
        if (gridBagConstraint.gridheight != defaultConstraint.gridheight) {
            IJavaInstance gridheight = BeanUtilities.createJavaObject((JavaHelpers)this.primInt, (ResourceSet)this.rset, (String)String.valueOf(gridBagConstraint.gridheight));
            javaGridBagConstraint.eSet(this.sfGridHeight, (Object)gridheight);
        }
        if (gridBagConstraint.weightx != defaultConstraint.weightx) {
            IJavaInstance weightx = BeanUtilities.createJavaObject((JavaHelpers)this.primDouble, (ResourceSet)this.rset, (String)String.valueOf(gridBagConstraint.weightx));
            javaGridBagConstraint.eSet(this.sfWeightX, (Object)weightx);
        }
        if (gridBagConstraint.weighty != defaultConstraint.weighty) {
            IJavaInstance weighty = BeanUtilities.createJavaObject((JavaHelpers)this.primDouble, (ResourceSet)this.rset, (String)String.valueOf(gridBagConstraint.weighty));
            javaGridBagConstraint.eSet(this.sfWeightY, (Object)weighty);
        }
        if (gridBagConstraint.fill != defaultConstraint.fill) {
            IJavaInstance fill = BeanUtilities.createJavaObject((JavaHelpers)this.primInt, (ResourceSet)this.rset, (String)fillInitStrings[gridBagConstraint.fill]);
            javaGridBagConstraint.eSet(this.sfFill, (Object)fill);
        }
        if (!gridBagConstraint.insets.equals((Object)defaultConstraint.insets)) {
            Insets insets = gridBagConstraint.insets;
            IJavaObjectInstance insetsBean = (IJavaObjectInstance)BeanUtilities.createJavaObject((String)"java.awt.Insets", (ResourceSet)this.rset, (String)InsetsJavaClassCellEditor.getJavaInitializationString((Insets)insets));
            javaGridBagConstraint.eSet(this.sfInsets, (Object)insetsBean);
        }
        if (gridBagConstraint.ipadx != defaultConstraint.ipadx) {
            IJavaInstance ipadx = BeanUtilities.createJavaObject((JavaHelpers)this.primInt, (ResourceSet)this.rset, (String)String.valueOf(gridBagConstraint.ipadx));
            javaGridBagConstraint.eSet(this.sfIPadX, (Object)ipadx);
        }
        if (gridBagConstraint.ipady != defaultConstraint.ipady) {
            IJavaInstance ipady = BeanUtilities.createJavaObject((JavaHelpers)this.primInt, (ResourceSet)this.rset, (String)String.valueOf(gridBagConstraint.ipady));
            javaGridBagConstraint.eSet(this.sfIPadY, (Object)ipady);
        }
        return javaGridBagConstraint;
    }

    public List getDefaultConstraint(List children) {
        ArrayList<GridBagConstraint> constraints = new ArrayList<GridBagConstraint>(children.size());
        int i = 0;
        while (i < children.size()) {
            Object child = children.get(i);
            if (child instanceof IJavaObjectInstance) {
                constraints.add(this.getDefaultConstraint((IJavaObjectInstance)child));
            }
            ++i;
        }
        return constraints;
    }

    public GridBagConstraint getDefaultConstraint(IJavaObjectInstance component) {
        GridBagConstraint constraint = new GridBagConstraint();
        this.adjustForFillPreferences(component, constraint);
        return constraint;
    }

    public GridBagConstraint getConstraint(IJavaObjectInstance component, int gridx, int gridy) {
        GridBagConstraint constraint = new GridBagConstraint();
        constraint.gridx = gridx;
        constraint.gridy = gridy;
        this.adjustForFillPreferences(component, constraint);
        return constraint;
    }

    protected List getGridBagConstraints(List components) {
        this.resetLists();
        this.fComponents = components;
        ArrayList<GridBagConstraint> constraints = new ArrayList<GridBagConstraint>(components.size());
        int i = 0;
        while (i < components.size()) {
            int nearestLeftColumnDivider = 0;
            int nearestRightColumnDivider = 0;
            int nearestAboveRowDivider = 0;
            int nearestBelowRowDivider = 0;
            int position = 0;
            Rectangle childBounds = this.getBounds((IJavaObjectInstance)components.get(i));
            int j = 0;
            while (j < this.getColumnDividerPositions().size()) {
                position = (Integer)this.getColumnDividerPositions().get(j);
                if (position <= childBounds.x) {
                    nearestLeftColumnDivider = j;
                }
                ++j;
            }
            j = 0;
            while (j < this.getColumnDividerPositions().size()) {
                position = (Integer)this.getColumnDividerPositions().get(j);
                if (position >= childBounds.x + childBounds.width) {
                    nearestRightColumnDivider = j;
                    break;
                }
                ++j;
            }
            j = 0;
            while (j < this.getRowDividerPositions().size()) {
                position = (Integer)this.getRowDividerPositions().get(j);
                if (position <= childBounds.y) {
                    nearestAboveRowDivider = j;
                }
                ++j;
            }
            j = 0;
            while (j < this.getRowDividerPositions().size()) {
                position = (Integer)this.getRowDividerPositions().get(j);
                if (position >= childBounds.y + childBounds.height) {
                    nearestBelowRowDivider = j;
                    break;
                }
                ++j;
            }
            Insets insets = new Insets(childBounds.y - (Integer)this.getRowDividerPositions().get(nearestAboveRowDivider), childBounds.x - (Integer)this.getColumnDividerPositions().get(nearestLeftColumnDivider), (Integer)this.getRowDividerPositions().get(nearestBelowRowDivider) - (childBounds.y + childBounds.height), (Integer)this.getColumnDividerPositions().get(nearestRightColumnDivider) - (childBounds.x + childBounds.width));
            Dimension dim = this.getPreferredSize((IJavaObjectInstance)components.get(i));
            int ipadx = childBounds.width - dim.width;
            int ipady = childBounds.height - dim.height;
            GridBagConstraint constraint = new GridBagConstraint();
            constraint.gridx = nearestLeftColumnDivider;
            constraint.gridy = nearestAboveRowDivider;
            constraint.gridwidth = nearestRightColumnDivider - nearestLeftColumnDivider;
            constraint.gridheight = nearestBelowRowDivider - nearestAboveRowDivider;
            constraint.insets = insets;
            constraint.ipadx = ipadx;
            constraint.ipady = ipady;
            this.adjustForFillPreferences((IJavaObjectInstance)components.get(i), constraint);
            constraints.add(constraint);
            ++i;
        }
        return constraints;
    }

    protected void addInternalDividerPositionsTo(List dividerPositions, List near, List far) {
        int farIndex = 0;
        int nearIndex = 0;
        int thisEdge = 0;
        int prevEdge = (Integer)near.get(0);
        List prevEdgeSource = near;
        List thisEdgeSource = null;
        while (nearIndex < near.size() && farIndex < far.size()) {
            if ((Integer)near.get(nearIndex) < (Integer)far.get(farIndex)) {
                thisEdge = (Integer)near.get(nearIndex);
                ++nearIndex;
                thisEdgeSource = near;
            } else {
                thisEdge = (Integer)far.get(farIndex);
                ++farIndex;
                thisEdgeSource = far;
            }
            if (prevEdgeSource.equals(far) && thisEdgeSource.equals(near)) {
                dividerPositions.add(new Integer((thisEdge + prevEdge) / 2));
            }
            prevEdge = thisEdge;
            prevEdgeSource = thisEdgeSource;
        }
    }

    protected List getChildrenXYBounds() {
        if (this.childrenXYBounds == null) {
            this.childrenXYBounds = new ArrayList(this.fComponents.size());
            int i = 0;
            while (i < this.fComponents.size()) {
                IJavaObjectInstance comp = (IJavaObjectInstance)this.fComponents.get(i);
                IBeanProxy compProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)comp);
                IRectangleBeanProxy rectangleProxy = BeanAwtUtilities.invoke_getBounds(compProxy);
                Rectangle r = new Rectangle(rectangleProxy.getX(), rectangleProxy.getY(), rectangleProxy.getWidth(), rectangleProxy.getHeight());
                this.childrenXYBounds.add(i, r);
                ++i;
            }
        }
        return this.childrenXYBounds;
    }

    protected List getColumnDividerPositions() {
        if (this.columnDividerPositions == null) {
            Insets containerInsets = this.getContainerInsets();
            this.columnDividerPositions = new ArrayList();
            Integer leftOfContainer = new Integer(containerInsets.left);
            Integer leftMostEdge = (Integer)this.getSortedLeftEdges().get(0);
            if (leftOfContainer.compareTo(leftMostEdge) <= 0) {
                this.columnDividerPositions.add(leftOfContainer);
            } else {
                this.columnDividerPositions.add(leftMostEdge);
            }
            this.addInternalDividerPositionsTo(this.columnDividerPositions, this.getSortedLeftEdges(), this.getSortedRightEdges());
            Integer rightMostEdge = (Integer)this.getSortedRightEdges().get(this.getSortedRightEdges().size() - 1);
            Rectangle containerBounds = this.getBounds(this.getContainer());
            Integer containerWidth = new Integer(containerBounds.width - containerInsets.right);
            if (containerWidth.compareTo(rightMostEdge) >= 0) {
                this.columnDividerPositions.add(containerWidth);
            } else {
                this.columnDividerPositions.add(rightMostEdge);
            }
            Collections.sort(this.columnDividerPositions);
        }
        return this.columnDividerPositions;
    }

    protected Rectangle getBounds(IJavaObjectInstance aBean) {
        IBeanProxy beanProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)aBean);
        IRectangleBeanProxy rectangleProxy = BeanAwtUtilities.invoke_getBounds(beanProxy);
        Rectangle r = new Rectangle(rectangleProxy.getX(), rectangleProxy.getY(), rectangleProxy.getWidth(), rectangleProxy.getHeight());
        return r;
    }

    public Point getContainerLayoutOrigin() {
        IBeanProxy aContainerBeanProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)this.getContainer());
        IBeanProxy aLayoutManagerBeanProxy = BeanAwtUtilities.invoke_getLayout(aContainerBeanProxy);
        IMethodProxy getLayoutOrigin = aLayoutManagerBeanProxy.getProxyFactoryRegistry().getMethodProxyFactory().getMethodProxy(aLayoutManagerBeanProxy.getTypeProxy().getTypeName(), "getLayoutOrigin", null);
        IPointBeanProxy pointProxy = (IPointBeanProxy)getLayoutOrigin.invokeCatchThrowableExceptions(aLayoutManagerBeanProxy);
        return new Point(pointProxy.getX(), pointProxy.getY());
    }

    public boolean isContainerEmpty() {
        IIntegerBeanProxy countProxy;
        IMethodProxy getComponentCountMethodProxy;
        IBeanProxy aContainerBeanProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)this.getContainer());
        return aContainerBeanProxy == null || (getComponentCountMethodProxy = aContainerBeanProxy.getProxyFactoryRegistry().getMethodProxyFactory().getMethodProxy(aContainerBeanProxy.getTypeProxy().getTypeName(), "getComponentCount", null)) == null || (countProxy = (IIntegerBeanProxy)getComponentCountMethodProxy.invokeCatchThrowableExceptions(aContainerBeanProxy)) == null || countProxy.intValue() <= 0;
    }

    public int[][] getContainerLayoutDimensions() {
        int[] columnWidths = null;
        int[] rowHeights = null;
        int[][] result = new int[][]{new int[0], new int[0]};
        IBeanProxy aContainerBeanProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)this.getContainer());
        IBeanProxy aLayoutManagerBeanProxy = BeanAwtUtilities.invoke_getLayout(aContainerBeanProxy);
        IMethodProxy getLayoutDimensions = aLayoutManagerBeanProxy.getProxyFactoryRegistry().getMethodProxyFactory().getMethodProxy(aLayoutManagerBeanProxy.getTypeProxy().getTypeName(), "getLayoutDimensions", null);
        IArrayBeanProxy arrayProxy = (IArrayBeanProxy)getLayoutDimensions.invokeCatchThrowableExceptions(aLayoutManagerBeanProxy);
        if (arrayProxy != null) {
            try {
                IArrayBeanProxy arrayProxyRowHeights;
                IArrayBeanProxy arrayProxyColumnWidths = (IArrayBeanProxy)arrayProxy.get(0);
                if (arrayProxyColumnWidths != null) {
                    columnWidths = new int[arrayProxyColumnWidths.getLength()];
                    int i = 0;
                    while (i < arrayProxyColumnWidths.getLength()) {
                        columnWidths[i] = ((IIntegerBeanProxy)arrayProxyColumnWidths.get(i)).intValue();
                        ++i;
                    }
                    result[0] = columnWidths;
                }
                if ((arrayProxyRowHeights = (IArrayBeanProxy)arrayProxy.get(1)) != null) {
                    rowHeights = new int[arrayProxyRowHeights.getLength()];
                    int i = 0;
                    while (i < arrayProxyRowHeights.getLength()) {
                        rowHeights[i] = ((IIntegerBeanProxy)arrayProxyRowHeights.get(i)).intValue();
                        ++i;
                    }
                    result[1] = rowHeights;
                }
            }
            catch (ThrowableProxy throwableProxy) {
                return null;
            }
        }
        return result;
    }

    protected int getGridBagConstraintsFillPreference(IJavaObjectInstance component) {
        BeanDecorator bd;
        JavaHelpers javaHelpers = component.getJavaType();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ve.internal.jcm.BeanDecorator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((bd = (BeanDecorator)ClassDecoratorFeatureAccess.getDecoratorWithKeyedFeature((EClassifier)javaHelpers, (Class)clazz, (String)GRIDBAG_FILL_PREFERENCE_KEY)) != null) {
            return ((EEnumLiteral)bd.getKeyedValues().get((Object)GRIDBAG_FILL_PREFERENCE_KEY)).getValue();
        }
        return 0;
    }

    protected Insets getContainerInsets() {
        IBeanProxy aBeanProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)this.getContainer());
        IMethodProxy getInsetsMethodProxy = aBeanProxy.getProxyFactoryRegistry().getMethodProxyFactory().getMethodProxy(aBeanProxy.getTypeProxy().getTypeName(), "getInsets", null);
        IBeanProxy insetsProxy = getInsetsMethodProxy.invokeCatchThrowableExceptions(aBeanProxy);
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;
        if (insetsProxy != null) {
            IIntegerBeanProxy intProxy = null;
            try {
                IFieldProxy fieldProxy = insetsProxy.getTypeProxy().getFieldProxy("top");
                intProxy = (IIntegerBeanProxy)fieldProxy.get(insetsProxy);
                if (intProxy != null) {
                    top = intProxy.intValue();
                }
                if ((intProxy = (IIntegerBeanProxy)(fieldProxy = insetsProxy.getTypeProxy().getFieldProxy("left")).get(insetsProxy)) != null) {
                    left = intProxy.intValue();
                }
                if ((intProxy = (IIntegerBeanProxy)(fieldProxy = insetsProxy.getTypeProxy().getFieldProxy("bottom")).get(insetsProxy)) != null) {
                    bottom = intProxy.intValue();
                }
                if ((intProxy = (IIntegerBeanProxy)(fieldProxy = insetsProxy.getTypeProxy().getFieldProxy("right")).get(insetsProxy)) != null) {
                    right = intProxy.intValue();
                }
            }
            catch (ThrowableProxy throwableProxy) {}
        }
        return new Insets(top, left, bottom, right);
    }

    protected EObject[][] getLayoutTable() {
        if (this.layoutTable == null) {
            int[][] dimensions = this.getContainerLayoutDimensions();
            this.layoutTable = new EObject[dimensions[0].length][dimensions[1].length];
            if (this.getContainer() != null) {
                IJavaInstance intValue = null;
                Iterator containerComponents = ((List)this.getContainer().eGet((EStructuralFeature)this.sfComponents)).iterator();
                while (containerComponents.hasNext()) {
                    int gridHeight;
                    int i;
                    int gridWidth;
                    EObject gridbagComponent = (EObject)containerComponents.next();
                    IJavaObjectInstance gridbagconstraint = (IJavaObjectInstance)gridbagComponent.eGet((EStructuralFeature)this.sfConstraintConstraint);
                    if (gridbagconstraint == null || (intValue = (IJavaInstance)gridbagconstraint.eGet(this.sfGridX)) == null) continue;
                    int x = ((IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)intValue)).intValue();
                    intValue = (IJavaInstance)gridbagconstraint.eGet(this.sfGridY);
                    if (intValue == null) continue;
                    int y = ((IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)intValue)).intValue();
                    if (x < this.layoutTable.length && y < this.layoutTable[0].length) {
                        this.layoutTable[x][y] = gridbagComponent;
                    }
                    if ((intValue = (IJavaInstance)gridbagconstraint.eGet(this.sfGridWidth)) != null && (gridWidth = ((IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)intValue)).intValue()) > 1) {
                        i = 1;
                        while (i < gridWidth && x + i < this.layoutTable.length) {
                            this.layoutTable[x + i][y] = gridbagComponent;
                            ++i;
                        }
                    }
                    if ((intValue = (IJavaInstance)gridbagconstraint.eGet(this.sfGridHeight)) == null || (gridHeight = ((IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)intValue)).intValue()) <= 1) continue;
                    i = 1;
                    while (i < gridHeight && y + i < this.layoutTable[0].length) {
                        this.layoutTable[x][y + i] = gridbagComponent;
                        ++i;
                    }
                }
            }
        }
        return this.layoutTable;
    }

    public Command adjustConstraintsCommand(IJavaObjectInstance child, Point cellLocation, boolean insertNewColumn, boolean insertNewRow) {
        CommandBuilder cb = new CommandBuilder();
        EObject[][] table = this.getLayoutTable();
        if (table.length != 0 && table[0].length != 0) {
            int i = 0;
            while (i < table.length) {
                int j = 0;
                while (j < table[0].length) {
                    if (table[i][j] != null) {
                        IJavaObjectInstance gridbagconstraint;
                        IJavaObjectInstance gridbagcomponent;
                        EObject gridbagConstraintComponent = table[i][j];
                        if (!(i - 1 >= 0 && gridbagConstraintComponent == table[i - 1][j] || j - 1 >= 0 && gridbagConstraintComponent == table[i][j - 1] || (gridbagcomponent = (IJavaObjectInstance)gridbagConstraintComponent.eGet((EStructuralFeature)this.sfConstraintComponent)) != null && gridbagcomponent == child || (gridbagconstraint = (IJavaObjectInstance)gridbagConstraintComponent.eGet((EStructuralFeature)this.sfConstraintConstraint)) == null)) {
                            RuledCommandBuilder componentCB = new RuledCommandBuilder(this.policy.getEditDomain(), null, false);
                            boolean constraintChanged = false;
                            if (insertNewColumn && i >= cellLocation.x) {
                                constraintChanged = true;
                                IJavaInstance gridx = BeanUtilities.createJavaObject((JavaHelpers)this.primInt, (ResourceSet)this.rset, (String)String.valueOf(i + 1));
                                componentCB.applyAttributeSetting((EObject)gridbagconstraint, this.sfGridX, (Object)gridx);
                            }
                            if (insertNewRow && j >= cellLocation.y) {
                                constraintChanged = true;
                                IJavaInstance gridy = BeanUtilities.createJavaObject((JavaHelpers)this.primInt, (ResourceSet)this.rset, (String)String.valueOf(j + 1));
                                componentCB.applyAttributeSetting((EObject)gridbagconstraint, this.sfGridY, (Object)gridy);
                            }
                            if (constraintChanged) {
                                componentCB.applyAttributeSetting(gridbagConstraintComponent, (EStructuralFeature)this.sfConstraintConstraint, (Object)gridbagconstraint);
                                cb.append(componentCB.getCommand());
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return cb.getCommand();
    }

    protected Dimension getPreferredSize(IJavaObjectInstance aBean) {
        IBeanProxy aBeanProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)aBean);
        IMethodProxy getPreferredSizeMethodProxy = aBeanProxy.getProxyFactoryRegistry().getMethodProxyFactory().getMethodProxy(aBeanProxy.getTypeProxy().getTypeName(), "getPreferredSize", null);
        IDimensionBeanProxy dimensionProxy = (IDimensionBeanProxy)getPreferredSizeMethodProxy.invokeCatchThrowableExceptions(aBeanProxy);
        Dimension dim = new Dimension(dimensionProxy.getWidth(), dimensionProxy.getHeight());
        return dim;
    }

    protected List getRowDividerPositions() {
        Insets containerInsets = this.getContainerInsets();
        if (this.rowDividerPositions == null) {
            this.rowDividerPositions = new ArrayList();
            Integer topOfContainer = new Integer(containerInsets.top);
            Integer topMostEdge = (Integer)this.getSortedTopEdges().get(0);
            if (topOfContainer.compareTo(topMostEdge) <= 0) {
                this.rowDividerPositions.add(topOfContainer);
            } else {
                this.rowDividerPositions.add(topMostEdge);
            }
            this.addInternalDividerPositionsTo(this.rowDividerPositions, this.getSortedTopEdges(), this.getSortedBottomEdges());
            Integer bottomMostEdge = (Integer)this.getSortedBottomEdges().get(this.getSortedBottomEdges().size() - 1);
            Rectangle containerBounds = this.getBounds(this.getContainer());
            Integer containerHeight = new Integer(containerBounds.height - containerInsets.bottom);
            if (containerHeight.compareTo(bottomMostEdge) >= 0) {
                this.rowDividerPositions.add(containerHeight);
            } else {
                this.rowDividerPositions.add(bottomMostEdge);
            }
            Collections.sort(this.rowDividerPositions);
        }
        return this.rowDividerPositions;
    }

    protected List getSortedBottomEdges() {
        if (this.sortedBottomEdges == null) {
            this.sortedBottomEdges = new ArrayList(this.getChildrenXYBounds().size());
            int i = 0;
            while (i < this.getChildrenXYBounds().size()) {
                Rectangle rect = (Rectangle)this.getChildrenXYBounds().get(i);
                this.sortedBottomEdges.add(new Integer(rect.y + rect.height));
                ++i;
            }
            Collections.sort(this.sortedBottomEdges);
        }
        return this.sortedBottomEdges;
    }

    protected List getSortedLeftEdges() {
        if (this.sortedLeftEdges == null) {
            this.sortedLeftEdges = new ArrayList(this.getChildrenXYBounds().size());
            int i = 0;
            while (i < this.getChildrenXYBounds().size()) {
                Rectangle rect = (Rectangle)this.getChildrenXYBounds().get(i);
                this.sortedLeftEdges.add(new Integer(rect.x));
                ++i;
            }
            Collections.sort(this.sortedLeftEdges);
        }
        return this.sortedLeftEdges;
    }

    protected List getSortedRightEdges() {
        if (this.sortedRightEdges == null) {
            this.sortedRightEdges = new ArrayList(this.getChildrenXYBounds().size());
            int i = 0;
            while (i < this.getChildrenXYBounds().size()) {
                Rectangle rect = (Rectangle)this.getChildrenXYBounds().get(i);
                this.sortedRightEdges.add(new Integer(rect.x + rect.width));
                ++i;
            }
            Collections.sort(this.sortedRightEdges);
        }
        return this.sortedRightEdges;
    }

    protected List getSortedTopEdges() {
        if (this.sortedTopEdges == null) {
            this.sortedTopEdges = new ArrayList(this.getChildrenXYBounds().size());
            int i = 0;
            while (i < this.getChildrenXYBounds().size()) {
                Rectangle rect = (Rectangle)this.getChildrenXYBounds().get(i);
                this.sortedTopEdges.add(new Integer(rect.y));
                ++i;
            }
            Collections.sort(this.sortedTopEdges);
        }
        return this.sortedTopEdges;
    }

    public boolean isCellEmpty(int x, int y) {
        EObject[][] table = this.getLayoutTable();
        if (table.length != 0 && table[0].length != 0 && x < table.length && y < table[0].length) {
            return table[x][y] == null;
        }
        return true;
    }

    public boolean isCellValidForMove(Point targetCellLocation, EObject constraintComponent) {
        int x = targetCellLocation.x;
        int y = targetCellLocation.y;
        Dimension dim = this.getComponentGridDimensions(constraintComponent);
        if (dim != null) {
            int i = 0;
            while (i < dim.width) {
                if (!this.isCellEmpty(x + i, y) && this.getCellOccupant(x + i, y) != constraintComponent) {
                    return false;
                }
                ++i;
            }
            i = 0;
            while (i < dim.height) {
                if (!this.isCellEmpty(x, y + i) && this.getCellOccupant(x, y + i) != constraintComponent) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected Dimension getComponentGridDimensions(EObject component) {
        EObject[][] table = this.getLayoutTable();
        int startx = 0;
        int starty = 0;
        if (table.length != 0 && table[0].length != 0) {
            int i = 0;
            int j = 0;
            boolean foundit = false;
            i = 0;
            while (i < table.length && !foundit) {
                j = 0;
                while (j < table[0].length && !foundit) {
                    if (table[i][j] != null && table[i][j] == component) {
                        foundit = true;
                        startx = i;
                        starty = j;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            if (foundit) {
                int gridWidth = 1;
                int gridHeight = 1;
                i = startx + 1;
                while (i < table.length) {
                    if (table[i][j] != null && table[i][j] == component) {
                        ++gridWidth;
                    }
                    ++i;
                }
                i = startx;
                j = starty + 1;
                while (j < table[0].length) {
                    if (table[i][j] != null && table[i][j] == component) {
                        ++gridHeight;
                    }
                    ++j;
                }
                return new Dimension(gridWidth, gridHeight);
            }
        }
        return null;
    }

    protected EObject getCellOccupant(int x, int y) {
        EObject[][] table = this.getLayoutTable();
        if (table.length != 0 && table[0].length != 0 && x >= 0 && x < table.length && y >= 0 && y < table[0].length) {
            return table[x][y];
        }
        return null;
    }

    private void resetLists() {
        this.childrenXYBounds = null;
        this.columnDividerPositions = null;
        this.rowDividerPositions = null;
        this.sortedLeftEdges = null;
        this.sortedRightEdges = null;
        this.sortedTopEdges = null;
        this.sortedBottomEdges = null;
        this.layoutTable = null;
    }

    public void refresh() {
        this.resetLists();
    }

    public void setContainerPolicy(VisualContainerPolicy policy) {
        super.setContainerPolicy(policy);
        if (policy != null) {
            this.rset = JavaEditDomainHelper.getResourceSet((EditDomain)policy.getEditDomain());
            this.sfGridX = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)JFCConstants.SF_GRIDBAGCONSTRAINTS_GRIDX);
            this.sfGridY = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)JFCConstants.SF_GRIDBAGCONSTRAINTS_GRIDY);
            this.sfGridWidth = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)JFCConstants.SF_GRIDBAGCONSTRAINTS_GRIDWIDTH);
            this.sfGridHeight = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)JFCConstants.SF_GRIDBAGCONSTRAINTS_GRIDHEIGHT);
            this.sfWeightX = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)JFCConstants.SF_GRIDBAGCONSTRAINTS_WEIGHTX);
            this.sfWeightY = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)JFCConstants.SF_GRIDBAGCONSTRAINTS_WEIGHTY);
            this.sfFill = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)JFCConstants.SF_GRIDBAGCONSTRAINTS_FILL);
            this.sfInsets = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)JFCConstants.SF_GRIDBAGCONSTRAINTS_INSETS);
            this.sfIPadX = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)JFCConstants.SF_GRIDBAGCONSTRAINTS_IPADX);
            this.sfIPadY = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)JFCConstants.SF_GRIDBAGCONSTRAINTS_IPADY);
            this.primInt = Utilities.getJavaClass((String)"int", (ResourceSet)this.rset);
            this.primDouble = Utilities.getJavaClass((String)"double", (ResourceSet)this.rset);
            this.gridBagConstraints = Utilities.getJavaClass((String)"java.awt.GridBagConstraints", (ResourceSet)this.rset);
        }
        this.resetLists();
    }

    public Command getAddChildrenCommand(List childrenComponents, List constraints, Object position) {
        IJavaObjectInstance constraintObject;
        if (childrenComponents.isEmpty() || constraints.isEmpty() || childrenComponents.size() > 1) {
            return UnexecutableCommand.INSTANCE;
        }
        EObject constraintComponent = this.visualFact.create(this.classConstraintComponent);
        List<EObject> componentConstraints = Collections.singletonList(constraintComponent);
        GridBagConstraint gridBagConstraint = (GridBagConstraint)constraints.get(0);
        IJavaObjectInstance component = (IJavaObjectInstance)childrenComponents.get(0);
        CommandBuilder cb = new CommandBuilder();
        EObject cc = InverseMaintenanceAdapter.getIntermediateReference((EObject)component, (EReference)this.sfComponents, (EReference)this.sfConstraintComponent, (Notifier)component);
        if (cc != null && (constraintObject = (IJavaObjectInstance)cc.eGet((EStructuralFeature)this.sfConstraintConstraint)) != null && this.gridBagConstraints.isInstance((Object)constraintObject)) {
            RuledCommandBuilder componentCB = new RuledCommandBuilder(this.policy.getEditDomain(), null, false);
            IJavaInstance intObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)String.valueOf(gridBagConstraint.gridx));
            componentCB.applyAttributeSetting((EObject)constraintObject, this.sfGridX, (Object)intObject);
            intObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)String.valueOf(gridBagConstraint.gridy));
            componentCB.applyAttributeSetting((EObject)constraintObject, this.sfGridY, (Object)intObject);
            componentCB.applyAttributeSetting(constraintComponent, (EStructuralFeature)this.sfConstraintConstraint, (Object)constraintObject);
            cb.append(componentCB.getCommand());
        }
        if (cb.isEmpty()) {
            constraintComponent.eSet((EStructuralFeature)this.sfConstraintConstraint, gridBagConstraint != null ? this.convertConstraint(gridBagConstraint) : null);
        }
        cb.append(this.policy.getAddCommand(componentConstraints, childrenComponents, position));
        return cb.getCommand();
    }

    public Command getSpanChildrenCommand(EditPart childEditPart, Point childCellLocation, Point endCellLocation, int spanDirection) {
        IJavaObjectInstance gridbagconstraint;
        CommandBuilder cb = new CommandBuilder();
        EObject constraintComponent = InverseMaintenanceAdapter.getIntermediateReference((EObject)((EObject)childEditPart.getParent().getModel()), (EReference)this.sfComponents, (EReference)this.sfConstraintComponent, (Notifier)((IJavaObjectInstance)childEditPart.getModel()));
        if (constraintComponent != null && this.checkIntermediateCellsOccupied(constraintComponent, childCellLocation, endCellLocation) && (gridbagconstraint = (IJavaObjectInstance)constraintComponent.eGet((EStructuralFeature)this.sfConstraintConstraint)) != null) {
            RuledCommandBuilder componentCB = new RuledCommandBuilder(EditDomain.getEditDomain((EditPart)childEditPart), null, false);
            if (spanDirection == 16) {
                int gridWidth = endCellLocation.x - childCellLocation.x + 1;
                IJavaInstance widthObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)String.valueOf(gridWidth));
                componentCB.applyAttributeSetting((EObject)gridbagconstraint, this.sfGridWidth, (Object)widthObject);
            }
            if (spanDirection == 4) {
                int gridHeight = endCellLocation.y - childCellLocation.y + 1;
                IJavaInstance heightObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)String.valueOf(gridHeight));
                componentCB.applyAttributeSetting((EObject)gridbagconstraint, this.sfGridHeight, (Object)heightObject);
            }
            componentCB.applyAttributeSetting(constraintComponent, (EStructuralFeature)this.sfConstraintConstraint, (Object)gridbagconstraint);
            cb.append(componentCB.getCommand());
        }
        if (cb.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        return cb.getCommand();
    }

    protected boolean checkIntermediateCellsOccupied(EObject constraintComponent, Point childCellLocation, Point endCellLocation) {
        boolean valid = true;
        int i = childCellLocation.x;
        while (valid && i <= endCellLocation.x) {
            valid = this.isCellEmpty(i, endCellLocation.y) || constraintComponent == this.getCellOccupant(i, endCellLocation.y);
            ++i;
        }
        i = childCellLocation.y;
        while (valid && i <= endCellLocation.y) {
            valid = this.isCellEmpty(endCellLocation.x, i) || constraintComponent == this.getCellOccupant(endCellLocation.x, i);
            ++i;
        }
        return valid;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof EditPart) {
            EditPart ep;
            EditPartViewer viewer;
            EditDomain ed = EditDomain.getEditDomain((EditPart)((EditPart)target));
            IEditorPart iEditorPart = ed.getEditorPart();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.gef.EditPartViewer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((viewer = (EditPartViewer)iEditorPart.getAdapter((Class)clazz)) != null && (ep = (EditPart)viewer.getEditPartRegistry().get(((EditPart)target).getModel())) != null && ep.getEditPolicy((Object)"LayoutEditPolicy") instanceof IActionFilter) {
                return ((IActionFilter)ep.getEditPolicy((Object)"LayoutEditPolicy")).testAttribute(target, name, value);
            }
        }
        return false;
    }
}

