/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.instantiation.base.IJavaDataTypeInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.jfc.core.JFCMessages;
import org.eclipse.ve.internal.propertysheet.INeedData;
import org.eclipse.ve.internal.propertysheet.ISourced;

public class GridLayoutRowColumnValidator
implements ICellEditorValidator,
ISourced,
INeedData {
    protected static final String sRowColumnEqualZeroError = JFCMessages.getString("GridLayout_rowcolumn_not_valid_WARN");
    protected EditDomain domain;
    protected EReference sfRows;
    protected EReference sfColumns;
    IPropertySource[] pSources;
    IPropertyDescriptor[] fDescriptors;

    public String isValid(Object value) {
        if (value instanceof IJavaDataTypeInstance) {
            EReference propertyId;
            int new_value = -1;
            IIntegerBeanProxy intBeanProxy = (IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaInstance)value));
            if (intBeanProxy != null) {
                new_value = intBeanProxy.intValue();
            }
            if (new_value != 0) {
                return null;
            }
            int row_value = 1;
            int col_value = 0;
            Object rowsValue = this.pSources[0].getPropertyValue((Object)this.sfRows);
            Object colsValue = this.pSources[0].getPropertyValue((Object)this.sfColumns);
            if (rowsValue instanceof IJavaDataTypeInstance) {
                row_value = ((IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaInstance)rowsValue))).intValue();
            }
            if (colsValue instanceof IJavaDataTypeInstance) {
                col_value = ((IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaInstance)colsValue))).intValue();
            }
            if ((propertyId = (EReference)this.fDescriptors[0].getId()) == this.sfRows) {
                return col_value == 0 ? sRowColumnEqualZeroError : null;
            }
            if (propertyId == this.sfColumns) {
                return row_value == 0 ? sRowColumnEqualZeroError : null;
            }
        }
        return null;
    }

    public void setSources(Object[] sources, IPropertySource[] propertySources, IPropertyDescriptor[] descriptors) {
        this.pSources = propertySources;
        this.fDescriptors = descriptors;
    }

    public void setData(Object data) {
        if (data != null && data instanceof EditDomain) {
            this.domain = (EditDomain)data;
            ResourceSet rset = JavaEditDomainHelper.getResourceSet((EditDomain)this.domain);
            this.sfRows = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_GRIDLAYOUT_ROWS);
            this.sfColumns = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_GRIDLAYOUT_COLUMNS);
        }
    }
}

