/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.StringTokenizer;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jem.internal.instantiation.InstantiationFactory;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.PTClassInstanceCreation;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.ParseTreeAllocation;
import org.eclipse.jem.internal.instantiation.ParseVisitor;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.impl.NaiveExpressionFlattener;
import org.eclipse.jem.workbench.utility.NoASTResolver;
import org.eclipse.jem.workbench.utility.ParseTreeCreationFromAST;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.IJavaCellEditor;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.jfc.core.IconDialog;
import org.eclipse.ve.internal.propertysheet.INeedData;

public class ImageIconCellEditor
extends DialogCellEditor
implements IJavaCellEditor,
INeedData {
    protected EditDomain fEditDomain;
    private String path = "";
    private static final String IMAGE_ICON_CLASSNAME = "javax.swing.ImageIcon";

    public ImageIconCellEditor(Composite parent) {
        super(parent);
    }

    private Object createValue(String path) {
        if (path == null || path.equals("")) {
            return null;
        }
        this.path = path;
        return BeanUtilities.createJavaObject((String)IMAGE_ICON_CLASSNAME, (ResourceSet)JavaEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain), (JavaAllocation)this.getJavaAllocation());
    }

    public JavaAllocation getJavaAllocation() {
        ASTParser parser = ASTParser.newParser((int)2);
        String initString = this.getJavaInitializationString();
        parser.setSource(initString.toCharArray());
        parser.setSourceRange(0, initString.length());
        parser.setKind(1);
        ASTNode ast = parser.createAST(null);
        if (ast == null) {
            return null;
        }
        ParseTreeAllocation alloc = InstantiationFactory.eINSTANCE.createParseTreeAllocation();
        alloc.setExpression(new ParseTreeCreationFromAST((ParseTreeCreationFromAST.Resolver)new NoASTResolver()).createExpression((Expression)ast));
        return alloc;
    }

    public static String getPathFromInitializationAllocation(JavaAllocation allocation) {
        PTExpression exp;
        if (allocation instanceof ParseTreeAllocation && (exp = ((ParseTreeAllocation)allocation).getExpression()) instanceof PTClassInstanceCreation && ((PTClassInstanceCreation)exp).getType().equals(IMAGE_ICON_CLASSNAME) && ((PTClassInstanceCreation)exp).getArguments().size() == 1) {
            NaiveExpressionFlattener flattener = new NaiveExpressionFlattener();
            ((PTExpression)((PTClassInstanceCreation)exp).getArguments().get(0)).accept((ParseVisitor)flattener);
            return flattener.getResult();
        }
        return "";
    }

    public String getJavaInitializationString() {
        return "new javax.swing.ImageIcon(" + this.path + ")";
    }

    protected void updateContents(Object aValue) {
        Label lbl = this.getDefaultLabel();
        if (lbl == null) {
            return;
        }
        if (aValue != null) {
            String initStr = ImageIconCellEditor.getPathFromInitializationAllocation(((IJavaObjectInstance)aValue).getAllocation());
            int ind_first = initStr.indexOf("\"");
            int ind_last = initStr.lastIndexOf("\"");
            if (ind_first != -1 && ind_last != -1) {
                initStr = initStr.substring(ind_first + 1, ind_last);
                StringTokenizer tokenizer = new StringTokenizer(initStr, "\"\\/");
                String fname = "";
                while (tokenizer.hasMoreTokens()) {
                    fname = tokenizer.nextToken();
                }
                lbl.setText(fname);
                return;
            }
        }
        lbl.setText("");
    }

    public Object openDialogBox(Control cellEditorWindow) {
        int returnCode;
        IconDialog iconDialog = new IconDialog(cellEditorWindow.getShell(), ((IFileEditorInput)this.fEditDomain.getEditorPart().getEditorInput()).getFile().getProject());
        IJavaObjectInstance aValue = (IJavaObjectInstance)this.getValue();
        if (aValue != null) {
            iconDialog.setValue(ImageIconCellEditor.getPathFromInitializationAllocation(aValue.getAllocation()));
        }
        if ((returnCode = iconDialog.open()) == 0) {
            return this.createValue(iconDialog.getValue());
        }
        return null;
    }

    public void setData(Object data) {
        this.fEditDomain = (EditDomain)data;
    }
}

