/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.Iterator;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.jfc.core.JDesktopPaneProxyAdapter;
import org.eclipse.ve.internal.jfc.core.JLayeredPaneGraphicalEditPart;

public class JDesktopPaneGraphicalEditPart
extends JLayeredPaneGraphicalEditPart {
    protected EditPart fSelectedFrame;
    private EditPartListener frameListener;
    protected JDesktopPaneProxyAdapter desktopPaneAdapter;

    public JDesktopPaneGraphicalEditPart(Object model) {
        super(model);
    }

    public void activate() {
        super.activate();
        this.setListener(this.createFrameListener());
    }

    protected void addFrameListenerToChildren(EditPart ep) {
        ep.addEditPartListener(this.frameListener);
        Iterator childen = ep.getChildren().iterator();
        while (childen.hasNext()) {
            this.addFrameListenerToChildren((EditPart)childen.next());
        }
    }

    public void deactivate() {
        this.setListener(null);
        super.deactivate();
    }

    protected void removeFrameListenerFromChildren(EditPart ep) {
        ep.removeEditPartListener(this.frameListener);
        Iterator childen = ep.getChildren().iterator();
        while (childen.hasNext()) {
            this.removeFrameListenerFromChildren((EditPart)childen.next());
        }
    }

    protected EditPartListener createFrameListener() {
        return new EditPartListener.Stub(){

            public void childAdded(EditPart editpart, int index) {
                JDesktopPaneGraphicalEditPart.this.addFrameListenerToChildren(editpart);
            }

            public void removingChild(EditPart editpart, int index) {
                JDesktopPaneGraphicalEditPart.this.removeFrameListenerFromChildren(editpart);
            }

            public void selectedStateChanged(EditPart editpart) {
                EditPart frame;
                if (editpart == null || editpart == JDesktopPaneGraphicalEditPart.this) {
                    return;
                }
                if (editpart != null && (editpart.getSelected() == 1 || editpart.getSelected() == 2) && (frame = JDesktopPaneGraphicalEditPart.this.getFrameOfSelectedEditpart(editpart)) != null && frame != JDesktopPaneGraphicalEditPart.this.fSelectedFrame) {
                    JDesktopPaneGraphicalEditPart.this.selectFrame(frame);
                }
            }
        };
    }

    protected EditPart getFrameOfSelectedEditpart(EditPart ep) {
        if (ep == null || ep.getParent() == this) {
            return ep;
        }
        return this.getFrameOfSelectedEditpart(ep.getParent());
    }

    protected JDesktopPaneProxyAdapter getJDesktopPaneProxyAdapter() {
        if (this.desktopPaneAdapter == null) {
            IBeanProxyHost desktopPaneProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaObjectInstance)this.getModel()));
            this.desktopPaneAdapter = (JDesktopPaneProxyAdapter)desktopPaneProxyHost;
        }
        return this.desktopPaneAdapter;
    }

    protected void selectFrame(EditPart frame) {
        if (frame != this.fSelectedFrame) {
            this.fSelectedFrame = frame;
            this.getJDesktopPaneProxyAdapter().activateFrame((IJavaObjectInstance)frame.getModel());
            this.refreshChildren();
        }
    }

    protected void setListener(EditPartListener listener) {
        if (this.frameListener != null) {
            this.removeFrameListenerFromChildren((EditPart)this);
        }
        this.frameListener = listener;
        if (this.frameListener != null) {
            this.addFrameListenerToChildren((EditPart)this);
        }
    }
}

