/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.jfc.core.BeanAwtUtilities;
import org.eclipse.ve.internal.jfc.core.ComponentProxyAdapter;
import org.eclipse.ve.internal.jfc.core.IComponentProxyHost;
import org.eclipse.ve.internal.jfc.core.JFCConstants;

public class JMenuBarProxyAdapter
extends ComponentProxyAdapter {
    protected EStructuralFeature sfMenus;

    public JMenuBarProxyAdapter(IBeanProxyDomain domain) {
        super(domain);
        ResourceSet rset = JavaEditDomainHelper.getResourceSet((EditDomain)domain.getEditDomain());
        this.sfMenus = JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_JMENUBAR_MENUS);
    }

    protected void applied(EStructuralFeature as, Object newValue, int position) {
        if (as == this.sfMenus) {
            this.addComponent((EObject)newValue, position);
        } else {
            super.applied(as, newValue, position);
        }
    }

    protected void canceled(EStructuralFeature sf, Object oldValue, int position) {
        if (sf == this.sfMenus) {
            this.removeComponent((EObject)oldValue);
        } else {
            super.canceled(sf, oldValue, position);
        }
    }

    private void addComponent(EObject aComponent, int position) {
        IBeanProxyHost componentProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaInstance)aComponent));
        IComponentProxyHost componentAdapter = (IComponentProxyHost)componentProxyHost;
        componentProxyHost.instantiateBeanProxy();
        if (componentProxyHost.getErrorStatus() == 3 || this.getErrorStatus() == 3) {
            return;
        }
        IBeanProxy componentBeanProxy = componentProxyHost.getBeanProxy();
        IBeanProxy beforeBeanProxy = null;
        if (position != -1) {
            beforeBeanProxy = this.getBeanProxyAt(position + 1);
        }
        try {
            if (beforeBeanProxy != null) {
                BeanAwtUtilities.invoke_add_Component_before(this.getBeanProxy(), componentBeanProxy, beforeBeanProxy);
            } else {
                BeanAwtUtilities.invoke_add_Component(this.getBeanProxy(), componentBeanProxy);
            }
        }
        catch (ThrowableProxy e) {
            this.processError(this.sfMenus, e, aComponent);
        }
        componentAdapter.setParentComponentProxyHost(this);
        this.revalidateBeanProxy();
        this.clearError(this.sfMenus, aComponent);
    }

    protected IBeanProxy getBeanProxyAt(int position) {
        List menus = (List)((EObject)this.getTarget()).eGet(this.sfMenus);
        int i = position;
        while (i < menus.size()) {
            EObject menu = (EObject)menus.get(i);
            IBeanProxyHost componentProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaInstance)menu));
            if (componentProxyHost.isBeanProxyInstantiated()) {
                return componentProxyHost.getBeanProxy();
            }
            ++i;
        }
        return null;
    }

    protected void removeComponent(EObject aComponent) {
        this.clearError(this.sfMenus, aComponent);
        IBeanProxyHost aComponentBeanProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaInstance)aComponent));
        if (aComponentBeanProxyHost.getErrorStatus() != 3 && this.getErrorStatus() != 3) {
            BeanAwtUtilities.invoke_remove_Component(this.getBeanProxy(), aComponentBeanProxyHost.getBeanProxy());
            aComponentBeanProxyHost.releaseBeanProxy();
            this.revalidateBeanProxy();
        }
    }

    public void reinstantiateChild(IBeanProxyHost aChildProxyHost) {
        IJavaObjectInstance component = (IJavaObjectInstance)aChildProxyHost.getTarget();
        this.removeComponent((EObject)component);
        super.reinstantiateChild(aChildProxyHost);
    }
}

