/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ve.internal.cde.emf.InverseMaintenanceAdapter;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.jfc.core.VisualMessages;

public class JSplitPaneChildTreeLabelDecorator
implements ILabelDecorator {
    protected EReference sfLeftComponent;
    protected EReference sfRightComponent;
    protected EReference sfTopComponent;
    protected EReference sfBottomComponent;
    protected EReference sf_constraintComponent;
    protected EReference sf_constraintConstraint;

    public void initializeSFs(EObject component) {
        ResourceSet rset = component.eResource().getResourceSet();
        if (this.sfLeftComponent == null) {
            this.sfLeftComponent = (EReference)JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_LEFTCOMPONENT);
        }
        if (this.sfRightComponent == null) {
            this.sfRightComponent = (EReference)JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_RIGHTCOMPONENT);
        }
        if (this.sfBottomComponent == null) {
            this.sfBottomComponent = (EReference)JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_BOTTOMCOMPONENT);
        }
        if (this.sfTopComponent == null) {
            this.sfTopComponent = (EReference)JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_TOPCOMPONENT);
        }
        if (this.sf_constraintComponent == null) {
            this.sf_constraintComponent = (EReference)JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_CONSTRAINT_COMPONENT);
        }
        if (this.sf_constraintConstraint == null) {
            this.sf_constraintConstraint = (EReference)JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_CONSTRAINT_CONSTRAINT);
        }
    }

    public Image decorateImage(Image image, Object anObject) {
        return image;
    }

    public String decorateText(String text, Object anObject) {
        if (anObject == null) {
            return "";
        }
        if (!(anObject instanceof IJavaObjectInstance)) {
            return anObject.toString();
        }
        this.initializeSFs((EObject)anObject);
        IJavaObjectInstance component = (IJavaObjectInstance)anObject;
        InverseMaintenanceAdapter ai = (InverseMaintenanceAdapter)EcoreUtil.getExistingAdapter((Notifier)component, (Object)InverseMaintenanceAdapter.ADAPTER_KEY);
        if (ai != null) {
            List<EReference> backrefs = Arrays.asList(ai.getFeatures());
            if (backrefs.contains(this.sfLeftComponent)) {
                text = String.valueOf(VisualMessages.getString("Decorator.JSplitPane.Left")) + " - " + text;
            } else if (backrefs.contains(this.sfRightComponent)) {
                text = String.valueOf(VisualMessages.getString("Decorator.JSplitPane.Right")) + " - " + text;
            } else if (backrefs.contains(this.sfTopComponent)) {
                text = String.valueOf(VisualMessages.getString("Decorator.JSplitPane.Top")) + " - " + text;
            } else if (backrefs.contains(this.sfBottomComponent)) {
                text = String.valueOf(VisualMessages.getString("Decorator.JSplitPane.Bottom")) + " - " + text;
            } else if (backrefs.contains(this.sf_constraintComponent)) {
                String constraint;
                IJavaObjectInstance constraintString;
                EObject constraintComponent = ai.getFirstReferencedBy(this.sf_constraintComponent);
                if (BeanProxyUtilities.getBeanProxyHost((IJavaInstance)component).getErrorStatus() != 3 && (constraintString = (IJavaObjectInstance)constraintComponent.eGet((EStructuralFeature)this.sf_constraintConstraint)) != null && (constraint = BeanProxyUtilities.getBeanProxy((IJavaInstance)constraintString).toBeanString()) != null) {
                    if (constraint.equals("left")) {
                        text = String.valueOf(VisualMessages.getString("Decorator.JSplitPane.Left")) + " - " + text;
                    } else if (constraint.equals("right")) {
                        text = String.valueOf(VisualMessages.getString("Decorator.JSplitPane.Right")) + " - " + text;
                    } else if (constraint.equals("top")) {
                        text = String.valueOf(VisualMessages.getString("Decorator.JSplitPane.Top")) + " - " + text;
                    } else if (constraint.equals("bottom")) {
                        text = String.valueOf(VisualMessages.getString("Decorator.JSplitPane.Bottom")) + " - " + text;
                    }
                }
            }
        }
        return text;
    }

    public void addListener(ILabelProviderListener p1) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object p1, String p2) {
        return false;
    }

    public void removeListener(ILabelProviderListener p1) {
    }
}

