/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.IJavaCellEditor;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.java.visual.ILayoutPolicyFactory;
import org.eclipse.ve.internal.jfc.core.BeanAwtUtilities;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.jfc.core.LayoutManagerLabelProvider;
import org.eclipse.ve.internal.propertysheet.INeedData;
import org.eclipse.ve.internal.propertysheet.ISourced;
import org.eclipse.ve.internal.propertysheet.ObjectComboBoxCellEditor;

public class LayoutManagerCellEditor
extends ObjectComboBoxCellEditor
implements IJavaCellEditor,
INeedData,
ISourced {
    public static final String EDITDOMAINKEY_ITEMS_LIST = "org.eclipse.ve.internal.jfc.core.LayoutManagerCellEditor";
    public static final int CLASSNAMES_INDEX = 0;
    public static final int DISPLAYNAMES_INDEX = 1;
    protected EditDomain fEditDomain;
    protected IJavaObjectInstance container;

    public LayoutManagerCellEditor(Composite aComposite) {
        super(aComposite);
    }

    protected Object doGetObject(int index) {
        if (index == -1 || index == 0) {
            return null;
        }
        String layoutManagerClassName = LayoutManagerCellEditor.getLayoutManagerItems(this.fEditDomain)[0][index];
        ResourceSet rset = JavaEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain);
        JavaHelpers javaClass = JavaRefFactory.eINSTANCE.reflectType(layoutManagerClassName, rset);
        ILayoutPolicyFactory factory = BeanAwtUtilities.getLayoutPolicyFactoryFromLayoutManger((EClassifier)javaClass, this.fEditDomain);
        return factory.getLayoutManagerInstance(this.container, javaClass, rset);
    }

    protected int doGetIndex(Object anObject) {
        if (anObject == null) {
            return 0;
        }
        if (anObject instanceof IJavaObjectInstance) {
            String[] classNames = LayoutManagerCellEditor.getLayoutManagerItems(this.fEditDomain)[0];
            String className = LayoutManagerLabelProvider.getQualifiedName((IJavaObjectInstance)anObject);
            int i = 1;
            while (i < classNames.length) {
                if (className.equals(classNames[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public String getJavaInitializationString() {
        Object v = this.doGetValue();
        if (v == null) {
            return "null";
        }
        IJavaObjectInstance jv = (IJavaObjectInstance)v;
        return "new " + jv.getJavaType().getQualifiedName() + "()";
    }

    public static String getDisplayName(EditDomain editDomain, String className) {
        String dispName = null;
        String[][] layoutinfo = LayoutManagerCellEditor.getLayoutManagerItems(editDomain);
        int i = 0;
        while (i < layoutinfo[0].length) {
            if (layoutinfo[0][i].equals(className)) {
                dispName = layoutinfo[1][i];
                break;
            }
            ++i;
        }
        if (dispName == null) {
            return "";
        }
        return dispName;
    }

    public String isCorrectObject(Object anObject) {
        return null;
    }

    public void setData(Object data) {
        this.fEditDomain = (EditDomain)data;
        this.setItems(LayoutManagerCellEditor.getLayoutManagerItems(this.fEditDomain)[1]);
    }

    public static String[][] getLayoutManagerItems(EditDomain editDomain) {
        ResourceSet rset;
        JavaHelpers javaClass;
        if (editDomain == null) {
            return null;
        }
        String[][] layoutManagerLists = (String[][])editDomain.getData((Object)EDITDOMAINKEY_ITEMS_LIST);
        if (layoutManagerLists == null && (javaClass = JavaRefFactory.eINSTANCE.reflectType("java.awt.LayoutManager", rset = JavaEditDomainHelper.getResourceSet((EditDomain)editDomain))) != null) {
            ArrayList<String> classNames = new ArrayList<String>();
            ArrayList<String> displayNames = new ArrayList<String>();
            EList annotations = ((JavaClass)javaClass).getEAnnotations();
            int i = 0;
            while (i < annotations.size()) {
                if (((EAnnotation)annotations.get(i)).getSource().equals("org.eclipse.ve.LayoutInfo")) {
                    EMap details = ((EAnnotation)annotations.get(i)).getDetails();
                    String layoutClassName = (String)details.get((Object)"org.eclipse.ve.internal.jfc.core.layoutManagerClass");
                    String layoutDisplayName = (String)details.get((Object)"org.eclipse.ve.internal.jfc.core.layoutManagerDisplayName");
                    if (layoutClassName != null && layoutDisplayName != null) {
                        classNames.add(layoutClassName);
                        displayNames.add(layoutDisplayName);
                    }
                }
                ++i;
            }
            if (classNames.size() > 0) {
                layoutManagerLists = new String[2][];
                layoutManagerLists[0] = new String[classNames.size() + 1];
                layoutManagerLists[0][0] = "";
                layoutManagerLists[1] = new String[displayNames.size() + 1];
                layoutManagerLists[1][0] = "null";
                System.arraycopy(classNames.toArray(new String[classNames.size()]), 0, layoutManagerLists[0], 1, classNames.size());
                System.arraycopy(displayNames.toArray(new String[displayNames.size()]), 0, layoutManagerLists[1], 1, displayNames.size());
                editDomain.setData((Object)EDITDOMAINKEY_ITEMS_LIST, (Object)layoutManagerLists);
            }
        }
        return layoutManagerLists;
    }

    public void setSources(Object[] sources, IPropertySource[] propertySources, IPropertyDescriptor[] descriptors) {
        EReference sfConstraintComponent;
        this.container = sources[0] instanceof IJavaObjectInstance ? (IJavaObjectInstance)sources[0] : (sources[0] instanceof EObject ? ((sfConstraintComponent = JavaInstantiation.getReference((ResourceSet)JavaEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain), (URI)JFCConstants.SF_CONSTRAINT_COMPONENT)).getEContainingClass().isInstance(sources[0]) ? (IJavaObjectInstance)((EObject)sources[0]).eGet((EStructuralFeature)sfConstraintComponent) : null) : null);
    }
}

