/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.HoldProcessingCommand;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.java.visual.ILayoutPolicyFactory;
import org.eclipse.ve.internal.java.visual.ILayoutPolicyHelper;
import org.eclipse.ve.internal.java.visual.ILayoutSwitcher;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.jfc.core.BeanAwtUtilities;
import org.eclipse.ve.internal.jfc.core.JFCConstants;

public abstract class LayoutSwitcher
implements ILayoutSwitcher {
    protected VisualContainerPolicy policy;

    public LayoutSwitcher(VisualContainerPolicy policy) {
        this.policy = policy;
    }

    public Command getCommand(EStructuralFeature sf, IJavaObjectInstance newManager) {
        IJavaObjectInstance containerBean = this.getContainerBean();
        RuledCommandBuilder cb = new RuledCommandBuilder(this.policy.getEditDomain(), "change layout");
        List constraintComponents = (List)containerBean.eGet(JavaInstantiation.getSFeature((IJavaObjectInstance)containerBean, (URI)JFCConstants.SF_CONTAINER_COMPONENTS));
        ArrayList<Object> children = new ArrayList<Object>(constraintComponents.size());
        Iterator itr = constraintComponents.iterator();
        EStructuralFeature sfConstraintComponent = JavaInstantiation.getSFeature((IJavaObjectInstance)containerBean, (URI)JFCConstants.SF_CONSTRAINT_COMPONENT);
        while (itr.hasNext()) {
            children.add(((EObject)itr.next()).eGet(sfConstraintComponent));
        }
        if (!children.isEmpty()) {
            IBeanProxy containerProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)containerBean);
            ILayoutPolicyFactory lpFactory = BeanAwtUtilities.getLayoutPolicyFactory(containerProxy, this.policy.getEditDomain());
            ILayoutPolicyHelper lpHelper = lpFactory.getLayoutPolicyHelper(this.policy);
            cb.append(lpHelper.getOrphanConstraintsCommand(children));
        }
        cb.applyAttributeSetting((EObject)containerBean, sf, (Object)newManager);
        if (!children.isEmpty()) {
            cb.append(this.getChangeConstraintsCommand(children));
        }
        return new HoldProcessingCommand(cb.getCommand(), (IJavaInstance)containerBean);
    }

    public Command getCancelCommand(EStructuralFeature sf, IBeanProxy defaultManager) {
        IJavaObjectInstance containerBean = this.getContainerBean();
        if (!containerBean.eIsSet(sf)) {
            return null;
        }
        RuledCommandBuilder cb = new RuledCommandBuilder(this.policy.getEditDomain(), "cancel layout");
        List constraintComponents = (List)containerBean.eGet(JavaInstantiation.getSFeature((IJavaObjectInstance)containerBean, (URI)JFCConstants.SF_CONTAINER_COMPONENTS));
        ArrayList<Object> children = new ArrayList<Object>(constraintComponents.size());
        Iterator itr = constraintComponents.iterator();
        EStructuralFeature sfConstraintComponent = JavaInstantiation.getSFeature((IJavaObjectInstance)containerBean, (URI)JFCConstants.SF_CONSTRAINT_COMPONENT);
        while (itr.hasNext()) {
            children.add(((EObject)itr.next()).eGet(sfConstraintComponent));
        }
        if (!children.isEmpty()) {
            IBeanProxy containerProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)containerBean);
            ILayoutPolicyFactory lpFactory = BeanAwtUtilities.getLayoutPolicyFactory(containerProxy, this.policy.getEditDomain());
            ILayoutPolicyHelper lpHelper = lpFactory.getLayoutPolicyHelper(this.policy);
            cb.append(lpHelper.getOrphanConstraintsCommand(children));
        }
        cb.cancelAttributeSetting((EObject)containerBean, sf);
        if (!children.isEmpty()) {
            cb.append(this.getChangeConstraintsCommand(children));
        }
        return new HoldProcessingCommand(cb.getCommand(), (IJavaInstance)containerBean);
    }

    protected IJavaObjectInstance getContainerBean() {
        return (IJavaObjectInstance)this.policy.getContainer();
    }

    protected abstract Command getChangeConstraintsCommand(List var1);
}

