/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.jfc.core.ComponentTreeEditPart;

public class TreeDirectEditManager {
    public static final String VIEWER_DATA_KEY = "AWT_TreeDirectEditManager";
    private EditPartViewer viewer;
    private Tree parentTree;
    private TreeEditor editor;
    private Text textField = null;
    private String oldText;
    private ComponentTreeEditPart currentComponent = null;
    private EStructuralFeature currentProperty = null;
    boolean inKeyEvent = false;
    boolean inMouseEvent = false;
    private EditPartListener currentEditPartListener = null;

    public TreeDirectEditManager(EditPartViewer v) {
        this.viewer = v;
        if (this.viewer.getControl() instanceof Tree) {
            this.parentTree = (Tree)this.viewer.getControl();
            this.parentTree.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (TreeDirectEditManager.this.textField != null && !TreeDirectEditManager.this.textField.isDisposed()) {
                        TreeDirectEditManager.this.textField.dispose();
                    }
                }
            });
            this.currentEditPartListener = new EditPartListener.Stub(){

                public void partDeactivated(EditPart editPart) {
                    TreeDirectEditManager.this.hideDirectEdit();
                }
            };
        }
    }

    private Text getTextField() {
        if (this.textField == null) {
            this.textField = new Text((Composite)this.parentTree, 0);
            this.textField.setBackground(this.textField.getDisplay().getSystemColor(19));
            this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent f) {
                    if (!TreeDirectEditManager.this.inKeyEvent && TreeDirectEditManager.this.currentComponent != null) {
                        TreeDirectEditManager.this.saveChange();
                        TreeDirectEditManager.this.hideDirectEdit();
                    }
                }
            });
            this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent k) {
                    TreeDirectEditManager.this.inKeyEvent = true;
                    if (k.character == '\u001b') {
                        TreeDirectEditManager.this.hideDirectEdit();
                    } else if (k.character == '\r' || k.character == '\n') {
                        TreeDirectEditManager.this.saveChange();
                        TreeDirectEditManager.this.hideDirectEdit();
                    }
                    TreeDirectEditManager.this.inKeyEvent = false;
                }
            });
        }
        return this.textField;
    }

    private TreeEditor getEditor() {
        if (this.editor == null) {
            this.editor = new TreeEditor(this.parentTree);
            this.editor.horizontalAlignment = 16384;
            this.editor.grabHorizontal = true;
            this.editor.minimumWidth = 50;
        }
        return this.editor;
    }

    public void performDirectEdit(ComponentTreeEditPart component, EStructuralFeature property) {
        if (this.currentComponent != null || this.currentProperty != null) {
            return;
        }
        this.currentComponent = component;
        this.currentProperty = property;
        this.currentComponent.addEditPartListener(this.currentEditPartListener);
        this.showDirectEdit();
    }

    private void showDirectEdit() {
        this.oldText = this.getDirectEditText();
        this.getTextField().setText(this.oldText);
        this.getTextField().selectAll();
        this.getEditor().setEditor((Control)this.getTextField());
        this.getEditor().setItem((TreeItem)this.currentComponent.getWidget());
        this.getTextField().setVisible(true);
        this.getTextField().setFocus();
    }

    private void saveChange() {
        String newText = this.getTextField().getText();
        if (!newText.equals(this.oldText) && this.currentComponent != null && this.currentProperty != null) {
            EditDomain domain = EditDomain.getEditDomain((EditPart)this.currentComponent);
            RuledCommandBuilder cb = new RuledCommandBuilder(domain);
            IJavaObjectInstance component = (IJavaObjectInstance)this.currentComponent.getModel();
            IJavaObjectInstance stringObject = BeanUtilities.createString((ResourceSet)component.eResource().getResourceSet(), (String)newText);
            cb.applyAttributeSetting((EObject)component, this.currentProperty, (Object)stringObject);
            domain.getCommandStack().execute(cb.getCommand());
        }
    }

    private void hideDirectEdit() {
        this.getTextField().setVisible(false);
        this.getEditor().setEditor(null);
        if (this.currentEditPartListener != null && this.currentComponent != null) {
            this.currentComponent.removeEditPartListener(this.currentEditPartListener);
        }
        this.currentComponent = null;
        this.currentProperty = null;
    }

    private String getDirectEditText() {
        IJavaObjectInstance textObj;
        IJavaObjectInstance component;
        String text = "";
        if (this.currentComponent != null && this.currentProperty != null && (component = (IJavaObjectInstance)this.currentComponent.getModel()).eIsSet(this.currentProperty) && (textObj = (IJavaObjectInstance)component.eGet(this.currentProperty)) != null) {
            try {
                IBeanProxyHost host = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)component);
                IBeanProxy propProxy = host.getBeanPropertyProxyValue(this.currentProperty);
                text = ((IStringBeanProxy)propProxy).stringValue();
            }
            catch (Exception exception) {}
        }
        return text;
    }
}

