/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.Collections;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.jfc.core.ContainerPolicy;
import org.eclipse.ve.internal.jfc.core.UnknownLayoutPolicyHelper;

public class UnknownLayoutInputPolicy
extends LayoutEditPolicy {
    protected VisualContainerPolicy containerPolicy;
    protected UnknownLayoutPolicyHelper fLayoutPolicyHelper;

    public UnknownLayoutInputPolicy(VisualContainerPolicy aPolicy) {
        this.containerPolicy = aPolicy;
        this.fLayoutPolicyHelper = new UnknownLayoutPolicyHelper(aPolicy);
    }

    public void activate() {
        super.activate();
        this.containerPolicy.setContainer(this.getHost().getModel());
    }

    public void deactivate() {
        super.deactivate();
        this.containerPolicy.setContainer(null);
    }

    public EditPolicy createChildEditPolicy(EditPart aChild) {
        return new NonResizableEditPolicy();
    }

    protected Command getAddCommand(Request request) {
        ChangeBoundsRequest cbReq = (ChangeBoundsRequest)request;
        List children = ContainerPolicy.getChildren((GroupRequest)cbReq);
        List<Object> constraints = Collections.nCopies(children.size(), null);
        return this.fLayoutPolicyHelper.getAddChildrenCommand(children, constraints, null);
    }

    protected Command getCreateCommand(CreateRequest request) {
        return this.fLayoutPolicyHelper.getCreateChildCommand(request.getNewObject(), null, null);
    }

    protected Command getDeleteDependantCommand(Request request) {
        Command deleteContributionCmd = this.containerPolicy.getCommand(request);
        if (deleteContributionCmd == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return deleteContributionCmd;
    }

    protected Command getMoveChildrenCommand(Request request) {
        return null;
    }

    protected Command getOrphanChildrenCommand(Request request) {
        return this.fLayoutPolicyHelper.getOrphanChildrenCommand(ContainerPolicy.getChildren((GroupRequest)((GroupRequest)request)));
    }
}

