package com.ibm.calendar;

/**************************************************************************
 * File: Calendar.java
 * Version 2.0
 *
 *  Date               Author                  Changes
 *  Apr. 10,2000       Mohammed Odeh           Created	
 *  May  07,2001       Istvan Szamosi          Changed	
 * 
 * Copyright (c) 2000-2001, IBM Corporation
 * All Rights Reserved
 ***************************************************************************/

/**
 * Calendar bean is a base class of the package that is to provide the user with current 
 * month, year and day. You may choice a theme to your calendar or you can add plugins to 
 * it, and manipulate it, Calendar bean can give you the date to any day between 1900 and 2040.
 *
 * @see java.awt.Panel
 * @see java.awt.Color
 * @see java.awt.Graphics 
 * @see java.awt.Image
 * @see java.awt.event
 * @see java.util.Date
 * @see java.awt.Point
 */
import java.awt.Choice;
import java.awt.Color;
import java.awt.event.*;
import java.util.Date;
public class Calendar extends java.awt.Panel implements ActionListener, ComponentListener, ItemListener, MouseListener, MouseMotionListener, java.io.Serializable
{
	
	/**
	 * holds a number representing the day which must be drawn as the first day of week.
	 */
	private int firstDayOfWeek;

	/**
	 * used for placing the days in the correct place on the panel.
	 */
	private int weightX;

	/**
	 * used for placing the days in the correct place on the panel.
	 */
	private int weightY;
	
	/**
	 * holds number of days before the current month relative to 42.
	 */
	private int noOfDaysBefor;
	
	/**
	 * holds number of days after the current month relative to 42.
	 */
	private int noOfDaysAfter;
	
	/**
	 * holds number of days of the current month.
	 */
	private int currentMonthDaysNum;
	
	/**
	 * holds number of days of the previous month.
	 */
	private int previousMonthDaysNum;
	
	/**
	 * holds the name of the plugin from the popup Menu.
	 */
	private String pluginName;
	
	/**
	 * holds the plugin that is now activated.
	 */
	private Plugin activePlugin;
	
	/**
	 * used for date processing.
	 */
	private java.util.Calendar aCalendar;
	
	/**
	 * holds the date from calendar.
	 */
	private java.util.Date fieldSelectedDate = null;
	
	/**
	 * holds the initial date for calendar.
	 */
	private java.util.Date fieldInitialDate = new java.util.Date();
	
	/**
	 * holds all the plugins that was added to the calendar.
	 */
	private java.util.Vector plugins = new java.util.Vector();
	
	/**
	 * holds the new theme.
	 */
	private com.ibm.calendar.Theme fieldInputTheme = null;
	
	/**
	 * holds a description of this bean.
	 */
	private String fieldAboutThisBean = new String();
	
	/**
	 * holds a value of the selected date.
	 */
	private String fieldResultSelectedDateAsString = new String();
	
	private java.awt.Choice ivjMonthsList = null;
	private java.awt.Choice ivjYearsList = null;
	private java.awt.MenuItem ivjDayPlugin = null;
	private java.awt.MenuItem ivjNotePlugin = null;
	private java.awt.MenuItem ivjToDoPlugin = null;
	private java.awt.PopupMenu ivjPlugins = null;
	protected transient java.beans.VetoableChangeSupport vetoPropertyChange;
	protected transient java.beans.PropertyChangeSupport propertyChange;
	protected transient java.util.Vector aPluginInitializationErrorListener = null;
	private Plugin fieldInputPlugin = null;
	
	/**
	 * holds the number of first day of week set on the property sheet (not set:-1).
	 */
	private int fieldFirstDayOfWeek = -1;
	private DayCircle dayCircle;
	private java.util.Vector holidays = new java.util.Vector();
	private java.lang.String fieldHolidays = new String();
	protected transient java.util.Vector aDateSelectedEventListener = null;
	
	/**
	 * holds a number of selection type (0:every day, 1:workday, 2:weekend/holiday). 
	 */
	private int fieldSelectType = 0;
	
/**
 * Calendar constructor
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public Calendar()
{
	super();
	initialize();
	addMouseListener(this);
	aCalendar = java.util.Calendar.getInstance(); //initialize the aCalendar to the current date.

	dayCircle = new DayCircle(java.awt.Color.red);
	dayCircle.setBounds(0,0,23,23); // size of day rectangle (circle in it), location determined later
	this.add(dayCircle);
	
	this.add(getPlugins());
}

/**
 * Calendar constructor .
 * @param layout java.awt.LayoutManager
 */
public Calendar(java.awt.LayoutManager layout)
{
//	super(layout);
	initialize();
	addMouseListener(this);
	aCalendar = java.util.Calendar.getInstance(); //initialize the aCalendar to the current date.
}

/**
 * Method to handle events for the ActionListener interface.
 * @param e java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void actionPerformed(java.awt.event.ActionEvent e) {
	// user code begin {1}
	// user code end
	if (e.getSource() == getNotePlugin()) 
		connEtoC5(e);
	if (e.getSource() == getToDoPlugin()) 
		connEtoC7(e);
	if (e.getSource() == getDayPlugin()) 
		connEtoC8(e);
	// user code begin {2}
	// user code end
}

/**
 * activatePlugin method was created to pass all needed data to the selected
 * plugin ,also it activates the selected plugin and hide the calendar panel.
 */
private void activatePlugin()
{
	/**
	 * calculate current time and merge it with the selected date.
	 */
	Date CurrentTime = new Date();
	int aDay;
	int aMonth;
	int aYear;
	aDay = aCalendar.get(java.util.Calendar.DAY_OF_MONTH);
	aMonth = aCalendar.get(java.util.Calendar.MONTH);
	aYear = aCalendar.get(java.util.Calendar.YEAR);
	aCalendar.setTime(CurrentTime);
	aCalendar.set(aYear, aMonth, aDay);
	try
	{
		/**
		 * determines to use theme or to display the default plugin theme.
		 */
		if (fieldInputTheme == null)
		{
			activePlugin.setInfo(aCalendar, null, this.getLocation().x, this.getLocation().y);
		} else
		{
			activePlugin.setInfo(aCalendar, fieldInputTheme.getImage(pluginName), this.getLocation().x, this.getLocation().y);
		}
		activePlugin.initPlugin();
		this.setVisible(false);
	} catch (Exception e)
	{
		fireOnPluginInitializationError(new com.ibm.calendar.events.PluginInitializationError(this));
	}
}

/**
 * Adds a com.ibm.calendar.events.DateSelectedEventListener.
 */
public void addDateSelectedEventListener(com.ibm.calendar.events.DateSelectedEventListener newListener) {
	if (aDateSelectedEventListener == null) {
		aDateSelectedEventListener = new java.util.Vector();
	};
	aDateSelectedEventListener.addElement(newListener);
}
/* Commented out for version 2.0 by Lajos Kiskeri, 21/03/2001
public void addHoliday(java.util.Date d)
{holidays.addElement(d);}
*/

/**
 * Adds an PluginInitializationErrorListener to the listener list.
 * @param newListener  The PluginInitializationErrorListener to be added
 * @see   com.ibm.calendar.events.PluginInitializationErrorListener
 * @see   com.ibm.calendar.Calendar#removePluginInitializationErrorListener
 **/
public void addPluginInitializationErrorListener(com.ibm.calendar.events.PluginInitializationErrorListener newListener)
{
	if (aPluginInitializationErrorListener == null)
	{
		aPluginInitializationErrorListener = new java.util.Vector();
	};
	aPluginInitializationErrorListener.addElement(newListener);
}

/**
 * Adds an PropertyChangeListener to the listener list.
 * @param listener  The PropertyChangeListener to be added
 * @see   java.beans.PropertyChangeListener
 * @see   com.ibm.calendar.Calendar#removePropertyChangeListener
 **/
public synchronized void addPropertyChangeListener(java.beans.PropertyChangeListener listener)
{
	getPropertyChange().addPropertyChangeListener(listener);
}

/**
 * Adds an VetoableChangeListener to the listener list.
 * @param listener  The VetoableChangeListener to be added
 * @see   java.beans.VetoableChangeListener
 * @see   com.ibm.calendar.Calendar#removeVetoableChangeListener
 **/
public synchronized void addVetoableChangeListener(java.beans.VetoableChangeListener listener)
{
	getVetoPropertyChange().addVetoableChangeListener(listener);
}
private void calendar_ComponentEvents()
{

}
private void calendar_ComponentResized(java.awt.event.ComponentEvent componentEvent)
{
}

/**
 * Contains names of months
 */
public void choice1_ItemEvent()
{
	aCalendar.set(Integer.parseInt(ivjYearsList.getItem(ivjYearsList.getSelectedIndex())), ivjMonthsList.getSelectedIndex(), aCalendar.get(java.util.Calendar.DAY_OF_MONTH));
	fieldSelectedDate = null;
	repaint();
	return;
}

/**
 * Contains years from 1900 to 2040
 */
public void choice2_ItemEvent()
{
	aCalendar.set(Integer.parseInt(ivjYearsList.getItem(ivjYearsList.getSelectedIndex())), ivjMonthsList.getSelectedIndex(), aCalendar.get(java.util.Calendar.DAY_OF_MONTH));
	fieldSelectedDate = null;
	repaint();
	return;
}

/**
 * Method to handle events for the ComponentListener interface.
 * @param e java.awt.event.ComponentEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void componentHidden(java.awt.event.ComponentEvent e) {
	// user code begin {1}
	// user code end
	if (e.getSource() == this) 
		connEtoC4();
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the ComponentListener interface.
 * @param e java.awt.event.ComponentEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void componentMoved(java.awt.event.ComponentEvent e) {
	// user code begin {1}
	// user code end
	if (e.getSource() == this) 
		connEtoC4();
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the ComponentListener interface.
 * @param e java.awt.event.ComponentEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void componentResized(java.awt.event.ComponentEvent e) {
	// user code begin {1}
	// user code end
	if (e.getSource() == this) 
		connEtoC3(e);
	if (e.getSource() == this) 
		connEtoC4();
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the ComponentListener interface.
 * @param e java.awt.event.ComponentEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void componentShown(java.awt.event.ComponentEvent e) {
	// user code begin {1}
	// user code end
	if (e.getSource() == this) 
		connEtoC4();
	// user code begin {2}
	// user code end
}

/**
 * connEtoC1:  (Choice1.item. --> Calendar.choice1_ItemEvent()V)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC1()
{
	try
	{
		// user code begin {1}
		// user code end
		this.choice1_ItemEvent();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc)
	{
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * connEtoC2:  (Choice2.item. --> Calendar.choice2_ItemEvent()V)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC2()
{
	try
	{
		// user code begin {1}
		// user code end
		this.choice2_ItemEvent();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc)
	{
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * connEtoC3:  (Calendar.component.componentResized(java.awt.event.ComponentEvent) --> Calendar.calendar_ComponentResized(Ljava.awt.event.ComponentEvent;)V)
 * @param arg1 java.awt.event.ComponentEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC3(java.awt.event.ComponentEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.calendar_ComponentResized(arg1);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * connEtoC4:  (Calendar.component. --> Calendar.calendar_ComponentEvents()V)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC4()
{
	try
	{
		// user code begin {1}
		// user code end
		this.calendar_ComponentEvents();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc)
	{
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * connEtoC5:  (NotePlugin.action.actionPerformed(java.awt.event.ActionEvent) --> Calendar.notePlugin_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC5(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.notePlugin_ActionPerformed(arg1);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * connEtoC7:  (ToDoPlugin.action.actionPerformed(java.awt.event.ActionEvent) --> Calendar.toDoPlugin_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC7(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.toDoPlugin_ActionPerformed(arg1);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * connEtoC8:  (DayPlugin.action.actionPerformed(java.awt.event.ActionEvent) --> Calendar.dayPlugin_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC8(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.dayPlugin_ActionPerformed(arg1);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * The dayPlugin_ActionPerformed method activates the Day plugin
 * @param actionEvent java.awt.event.ActionEvent
 */
public void dayPlugin_ActionPerformed(java.awt.event.ActionEvent actionEvent)
{
	pluginName = "DayPlugin";
	String vpluginName;
	for (int i = 0; i < plugins.size(); i++)
	{
		vpluginName = ((Plugin)plugins.elementAt(i)).getClass().getName().substring(17);
		if (vpluginName.equalsIgnoreCase(pluginName))
		{
			activePlugin = (Plugin) plugins.elementAt(i);
			activatePlugin();
			break;
		}
	}
}

/**
 * drawCalendar method is created to draw the selected theme in the calendar 
 * or to draw the default calendar.
 * @param g java.awt.Graphics
 */
private void drawCalendar(java.awt.Graphics g)
{
			
	if (fieldInputTheme == null)
	{
		drawDefaultCalendar(g);
	} else
	{
		fieldFirstDayOfWeek = 1; //always Sunday because themes have a fixed header
		drawThemeCalendar(g);
	}
	/**
	 *call drawDaysNumber to draw days 
	 */
	drawDaysNumber(g);
	/**
	 *call selectDate to draw the circle around the selected date.
	 */
	selectDate(g);
}

/**
 * drawDaysNumber method draws the days numbers on the correct place on the calendar graph
 * @param g java.awt.Graphics
 */
private void drawDaysNumber(java.awt.Graphics g)
{
	// Local variables to draw the days form the last, current and next month.
	int k;
	int day = 0;
	int lastMonthDayShown = 1;
	int currentMonthDay = 1;
	int nextMonthDayShown = 1;
	int daysOfWeek = 6; // From 0 to 6
	int weeksOfMonth = 5;
	int dayButtonWidth = 24;
	int dayButtonHeight = 24;
	/**
	 * calculate the date and time (time is always the current system time).
	 */
	java.util.Calendar InitialCal = java.util.Calendar.getInstance();
	InitialCal.setTime(getInitialDate());
	Color c = Color.lightGray;
	/**
	 * display the correct month name in the specified list box.
	 */
	ivjMonthsList.select(aCalendar.get(java.util.Calendar.MONTH));
	/**
	 * display the correct year string in the specified list box.
	 */
	ivjYearsList.select(aCalendar.get(java.util.Calendar.YEAR) - 1900);

	lastMonthDayShown = previousMonthDaysNum - noOfDaysBefor + 1; 

	g.setFont(new java.awt.Font("dialog", 1, 12));
	for (int j = 0; j <= weeksOfMonth; j++)
	{
	   	for (int i = 0; i <= daysOfWeek; i++)
		{

			java.util.Calendar hCal = (java.util.Calendar) aCalendar.clone();
			hCal.set(java.util.Calendar.DAY_OF_MONTH, currentMonthDay);
			boolean todayIsHoliday = isHoliday(hCal);

			if (lastMonthDayShown <= previousMonthDaysNum)
			{
				/**
				 * draw the dayes related for the previous month.
				 */
				weightX = 15 - 3;

				g.setColor(Color.lightGray);
				g.drawString("" + lastMonthDayShown, weightX + (i * dayButtonWidth), 63 + (j * dayButtonHeight));
				lastMonthDayShown++;
			}
			else if (currentMonthDay <= currentMonthDaysNum)
			{
				/**
				 * draw the days related for the current month.
				 */

				/**
				 * calculate the correct place to draw the day digit. 
				 */
				if (currentMonthDay <= 9)
					weightX = 15;
				else
					weightX = 15 - 3;
				/**
				 * draw the days of the month according to its place, month days will have
				 * more than one color according to its place and if its as the system date.
				 */

				day = currentMonthDay + noOfDaysBefor;
				if ((day > noOfDaysBefor) && (day <= noOfDaysBefor + currentMonthDaysNum))
				{
					if (todayIsHoliday)
					{
						if ((aCalendar.get(java.util.Calendar.MONTH) == InitialCal.get(java.util.Calendar.MONTH)) && (aCalendar.get(java.util.Calendar.YEAR) == InitialCal.get(java.util.Calendar.YEAR)) && (currentMonthDay == InitialCal.get(java.util.Calendar.DAY_OF_MONTH)))
							g.setColor(Color.red.darker());
						else
							g.setColor(Color.red);
					}
					else
					{
						if (isWeekend((j * 7) + (i + 1)))
						{
							if ((aCalendar.get(java.util.Calendar.MONTH) == InitialCal.get(java.util.Calendar.MONTH)) && (aCalendar.get(java.util.Calendar.YEAR) == InitialCal.get(java.util.Calendar.YEAR)) && (currentMonthDay == InitialCal.get(java.util.Calendar.DAY_OF_MONTH)))
 								g.setColor(new Color(88,0,0));
// 								g.setColor(new Color(108,0,0));
							else
 								g.setColor(new Color(170,85,0));
						}
  						else // other days
						{
							if ((aCalendar.get(java.util.Calendar.MONTH) == InitialCal.get(java.util.Calendar.MONTH)) && (aCalendar.get(java.util.Calendar.YEAR) == InitialCal.get(java.util.Calendar.YEAR)) && (currentMonthDay == InitialCal.get(java.util.Calendar.DAY_OF_MONTH)))
								g.setColor(Color.blue);
							else
								g.setColor(Color.black);
						}
					}
					g.drawString("" + currentMonthDay, weightX + (i * dayButtonWidth), 63 + (j * dayButtonHeight));
					g.setColor(Color.black);
				}
				currentMonthDay++;
			}
			else if (nextMonthDayShown <= noOfDaysAfter)
			{
				/**
				 * draw the days digits after the current month
				 */
				if (nextMonthDayShown <= 9)
					weightX = 15;
				else
					weightX = 15 - 3;

				g.setColor(Color.lightGray);
				g.drawString("" + nextMonthDayShown, weightX + (i * dayButtonWidth), 63 + (j * dayButtonHeight));
				nextMonthDayShown++;
			}
		}
	}
	g.setFont(new java.awt.Font("dialog", 0, 12));
}

/**
 * drawDefaultCalendar method is created to draw the default calendar graph on the screen.
 * @param g java.awt.Graphics
 */
private void drawDefaultCalendar(java.awt.Graphics g)
{
	int i = 0;
	int j = 0;
	int k = 0;
	int day = 0;
	String [] daysOfWeek = {"Su","Mo","Tu","We","Th","Fr","Sa"}; 
	java.awt.Dimension dim = new java.awt.Dimension();

	/**
	 * place the list boxes in the correct place according 
	 * to the fact that the calendar is the default calendar.
	 */
	ivjMonthsList.setLocation(7, 0);
	ivjMonthsList.setSize(80, ivjMonthsList.getSize().height);
	ivjYearsList.setLocation(ivjMonthsList.getSize().width + 20, 0);
	ivjYearsList.setSize(78, ivjYearsList.getSize().height);

	/**
	 * draw the rectangles of the days names.
	 */
	for (i = 0; i < 7; i++)
	{
		g.setColor(Color.lightGray);
		g.fillRect(7 + 24 * i, 47 - 24 + (24 * j), 24, 24);
		g.setColor(Color.black);
	}
	/**
	 * draw and prepare the region of the days digits.
	 */

	for (j = 0; j < 6; j++)
	{
		for (i = 0; i < 7; i++)
		{
			day = ((j) * 7) + (i + 1);
			if ((day > this.noOfDaysBefor) && (day <= this.noOfDaysBefor + this.currentMonthDaysNum))
			{

				if (isWeekend(day))
				{
					g.setColor(new Color(255, 255, 145));
					g.fillRect(7 + 24 * i, 47 + 24 * j, 24, 24);
					g.setColor(Color.black);
				} else // other days
				{
					g.setColor(new Color(190, 255, 140));
					g.fillRect(7 + 24 * i, 47 + 24 * j, 24, 24);
					g.setColor(Color.black);
				}
			}
		}
	}
	/**
	 * draw the lines that separate every day region from the other one (vertical).
	 */
	for (i = 0; i < 8; i++)
	{
		g.drawLine(7 + i * 24, 47 - 24, 7 + i * 24, 47 + 24 * 6);
	}
	/**
	 * draw the lines that separate every day region from the other one (horizontal).
	 */
	for (i = 0; i < 8; i++)
	{
		g.drawLine(7, 47 - 24 + i * 24, 7 + 7 * 24, 47 - 24 + 24 * i);
	}
	/**
	 * draw the days string on the specified place.
	 */
	g.setFont(new java.awt.Font("dialog", 1, 14));

	j = firstDayOfWeek - 1;
	
	for (i = 0; i < 7; i++)
	{
		g.drawString(daysOfWeek[j], 10 + 24 * i, 40);
		if (++j == 7)
			j = 0;
	}

	g.setFont(new java.awt.Font("dialog", 0, 12));
}

/**
 * drawThemeCalendar was created to draw the theme of the calendar.
 * @param g java.awt.Graphics
 */
private void drawThemeCalendar(java.awt.Graphics g)
{
	 java.awt.Image img = fieldInputTheme.getImage("Calendar");
	 java.awt.MediaTracker mt = new      java.awt.MediaTracker( this );
	 mt.addImage( img, 0 );
	 try { mt.waitForAll(); }
	 catch ( InterruptedException ie ) {}

	g.drawImage(img, 0, 0, 182, 198, this);
	/**
	 * set the location where to display the list boxes on.
	 */
	ivjMonthsList.setLocation(7, 5);
	ivjMonthsList.setSize(80, ivjMonthsList.getSize().height);
	ivjYearsList.setLocation(ivjMonthsList.getSize().width + 20, 5);
	ivjYearsList.setSize(78, ivjYearsList.getSize().height);
}

/**
 * Method to support listener events.
 */
protected void fireOnDateSelectedEvent(com.ibm.calendar.events.DateSelectedEvent e) {
	//System.out.println ("DateSelected!");
	if (aDateSelectedEventListener == null) {
		return;
	};
	int currentSize = aDateSelectedEventListener.size();
	com.ibm.calendar.events.DateSelectedEventListener tempListener = null;
	for (int index = 0; index < currentSize; index++){
		tempListener = (com.ibm.calendar.events.DateSelectedEventListener)aDateSelectedEventListener.elementAt(index);
		if (tempListener != null) {
			tempListener.onDateSelectedEvent(e);
		};
	};
}

/**
 * Method to support listener events.
 * @param e com.ibm.calendar.events.PluginInitializationError 
 */
protected void fireOnPluginInitializationError(com.ibm.calendar.events.PluginInitializationError e)
{
	if (aPluginInitializationErrorListener == null)
	{
		return;
	};
	int currentSize = aPluginInitializationErrorListener.size();
	com.ibm.calendar.events.PluginInitializationErrorListener tempListener = null;
	for (int index = 0; index < currentSize; index++)
	{
		tempListener = (com.ibm.calendar.events.PluginInitializationErrorListener) aPluginInitializationErrorListener.elementAt(index);
		if (tempListener != null)
		{
			tempListener.onPluginInitializationError(e);
		};
	};
}

/**
 * The firePropertyChange method was generated to support the propertyChange field.
 * @param propertyName String
 * @param oldValue Object
 * @param newValue Object
 */
public void firePropertyChange(String propertyName, Object oldValue, Object newValue)
{
	getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
}

/**
 * The fireVetoableChange method was generated to support the vetoPropertyChange field.
 * @param propertyName String
 * @param oldValue Object
 * @param newValue Object
 */
public void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws java.beans.PropertyVetoException
{
	getVetoPropertyChange().fireVetoableChange(propertyName, oldValue, newValue);
}

/**
 * Gets the aboutThisBean property (java.lang.String) value.
 * @return The aboutThisBean property value.
 * @see #setAboutThisBean
 */
public String getAboutThisBean() {
	return getClass().getName() + "^Calendar^2.0^" + 
	"CalendarAbout.gif^" + 
	"CalendarFeatures.gif^" + 
	"CalendarWiring.gif^" + 
	"/calendar/docs/index.html";
}

/**
 * Returns the DayPlugin property value.
 * @return java.awt.MenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.MenuItem getDayPlugin() {
	if (ivjDayPlugin == null) {
		try {
			ivjDayPlugin = new java.awt.MenuItem();
			ivjDayPlugin.setEnabled(false);
			ivjDayPlugin.setLabel("DayPlugin");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjDayPlugin;
}

/**
 * Gets the firstDayOfWeek property (int) value.
 * @return The firstDayOfWeek property value.
 * @see #setFirstDayOfWeek
 */
public int getFirstDayOfWeek() {
	return fieldFirstDayOfWeek;
}

/**
 * Gets the holidays property (java.lang.String) value.
 * @return The holidays property value.
 * @see #setHolidays
 */
public java.lang.String getHolidays() {
	return fieldHolidays;
}
/* Commented out for version 2.0 by Lajos Kiskeri, 21/03/2001
public java.util.Date getHolidays() 
{ 

	if (holidays.size()>0) return (java.util.Date)holidays.elementAt(holidays.size()-1); // we always return the latest set holiday. If there is none, we just return a specific date that can be used by the date editor: 31/12/1799.
	else return new java.util.Date(-100,2,3,4,5,6); 
}
*/

/**
 * Gets the initialDate property (java.util.Date) value.
 * @return The initialDate property value.
 * @see #setInitialDate
 */
public java.util.Date getInitialDate()
{
	return fieldInitialDate;
}

/**
 * Gets the inputTheme property (java.awt.Image) value.
 * @return The inputTheme property value.
 * @see #setInputTheme
 */
public com.ibm.calendar.Theme getInputTheme()
{
	return fieldInputTheme;
}

/**
 * Returns the Choice1 property value.
 * @return java.awt.Choice
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Choice getMonthsList() {
	if (ivjMonthsList == null) {
		try {
			ivjMonthsList = new java.awt.Choice();
			ivjMonthsList.setName("MonthsList");
			ivjMonthsList.setBounds(7, 6, 56, 23);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjMonthsList;
}

/**
 * Returns the NotePlugin property value.
 * @return java.awt.MenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.MenuItem getNotePlugin() {
	if (ivjNotePlugin == null) {
		try {
			ivjNotePlugin = new java.awt.MenuItem();
			ivjNotePlugin.setEnabled(false);
			ivjNotePlugin.setLabel("NotePlugin");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjNotePlugin;
}

/**
 * Returns the Plugins property value.
 * @return java.awt.PopupMenu
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.PopupMenu getPlugins() {
	if (ivjPlugins == null) {
		try {
			ivjPlugins = new java.awt.PopupMenu();
			ivjPlugins.setLabel("Plugins");
			ivjPlugins.add(getNotePlugin());
			ivjPlugins.add(getToDoPlugin());
			ivjPlugins.add(getDayPlugin());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPlugins;
}

/**
 * Accessor for the propertyChange field.
 */
protected java.beans.PropertyChangeSupport getPropertyChange()
{
	if (propertyChange == null)
	{
		propertyChange = new java.beans.PropertyChangeSupport(this);
	};
	return propertyChange;
}

/**
 * Gets the resultSelectedDateAsString property (java.lang.String) value.
 * @return The resultSelectedDateAsString property value.
 */
public String getResultSelectedDateAsString()
{
	return fieldResultSelectedDateAsString;
}


/**
 * Gets the selectedDate property (java.util.Date) value.
 * @return The selectedDate property value.
 * @see #setSelectedDate
 */
public java.util.Date getSelectedDate()
{
	return fieldSelectedDate;
}

/**
 * Gets the selectType property (int) value.
 * @return The selectType property value.
 * @see #setSelectType
 */
public int getSelectType() {
	return fieldSelectType;
}

/**
 * Returns the ToDoPlugin property value.
 * @return java.awt.MenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.MenuItem getToDoPlugin() {
	if (ivjToDoPlugin == null) {
		try {
			ivjToDoPlugin = new java.awt.MenuItem();
			ivjToDoPlugin.setEnabled(false);
			ivjToDoPlugin.setLabel("ToDoPlugin");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjToDoPlugin;
}

/**
 * Accessor for the vetoPropertyChange field.
 */
protected java.beans.VetoableChangeSupport getVetoPropertyChange()
{
	if (vetoPropertyChange == null)
	{
		vetoPropertyChange = new java.beans.VetoableChangeSupport(this);
	};
	return vetoPropertyChange;
}

/**
 * Returns the Choice2 property value.
 * @return java.awt.Choice
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Choice getYearsList() {
	if (ivjYearsList == null) {
		try {
			ivjYearsList = new java.awt.Choice();
			ivjYearsList.setName("YearsList");
			ivjYearsList.setBounds(60, 6, 58, 23);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjYearsList;
}

/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(Throwable exception)
{
	System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	exception.printStackTrace(System.out);
}

/**
 * Initializes connections
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections() throws java.lang.Exception {
	// user code begin {1}
	// user code end
	getMonthsList().addItemListener(this);
	getYearsList().addItemListener(this);
	this.addComponentListener(this);
	getNotePlugin().addActionListener(this);
	getToDoPlugin().addActionListener(this);
	getDayPlugin().addActionListener(this);
}

/**
 * Sets all the variables needed to draw the calendar
 * and makes other important calculations.
 */
private void initDate()
{
	int aDay;
	int aMonth;
	int aYear;
	boolean leap;
	int MonthLeap[] = {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
	int MonthNotLeap[] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
	aDay = aCalendar.get(java.util.Calendar.DAY_OF_MONTH);
	aMonth = aCalendar.get(java.util.Calendar.MONTH);
	aYear = aCalendar.get(java.util.Calendar.YEAR);
	aCalendar.clear();
	aCalendar.set(aYear, aMonth, 1);
	noOfDaysBefor = (aCalendar.get(java.util.Calendar.DAY_OF_WEEK) - firstDayOfWeek + 7) % 7;
	/**
	 * determines if the year is leap or not.
	 */
	if (aYear % 4 == 0 && aYear % 100 != 0)
	{
		leap = true;
	} else
		if (aYear % 400 == 0)
		{
			leap = true;
		} else
			leap = false;
	/*
	 * handel leap year and calculate needed information
	 */
	if (!leap)
	{
		currentMonthDaysNum = MonthNotLeap[aMonth];
		if (aMonth - 1 < 0)
			previousMonthDaysNum = 31;
		else
			previousMonthDaysNum = MonthNotLeap[aMonth - 1];
	} else
	{
		currentMonthDaysNum = MonthLeap[aMonth];
		if (aMonth - 1 < 0)
			previousMonthDaysNum = 31;
		else
			previousMonthDaysNum = MonthLeap[aMonth - 1];
}
noOfDaysAfter = 42 - (noOfDaysBefor + currentMonthDaysNum);

/*
 * returns the date before the calculation
 */
aCalendar.set(aYear, aMonth, aDay);
if (aCalendar.get(java.util.Calendar.DAY_OF_MONTH) < 10)
{
	fieldResultSelectedDateAsString = "0" + aCalendar.get(java.util.Calendar.DAY_OF_MONTH);
} else
{
	fieldResultSelectedDateAsString = "" + aCalendar.get(java.util.Calendar.DAY_OF_MONTH);
}
if (aCalendar.get(java.util.Calendar.MONTH) < 10)
{
	fieldResultSelectedDateAsString = fieldResultSelectedDateAsString + "0" + "" + (aCalendar.get(java.util.Calendar.MONTH) + 1)  ;
} else
{
	fieldResultSelectedDateAsString = fieldResultSelectedDateAsString + "" + (aCalendar.get(java.util.Calendar.MONTH) + 1);
}
fieldResultSelectedDateAsString = fieldResultSelectedDateAsString + "" + aCalendar.get(java.util.Calendar.YEAR);
firePropertyChange("resultSelectedDateAsString", "", fieldResultSelectedDateAsString);
}

/**
 * Initializes the class.
 *	
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize()
{
	try
	{
		// user code begin {1}
		// user code end
		setName("Calendar");
		setLayout(null);
		setSize(182, 198);
		add(getMonthsList(), getMonthsList().getName());
		add(getYearsList(), getYearsList().getName());
		initConnections();
		initLists();
	} catch (java.lang.Throwable ivjExc)
	{
		handleException(ivjExc);
	}
	// user code begin {2}
	// user code end
}

/**
 * Initializes the the list boxes.
 */
private void initLists()
{

	ivjMonthsList.add("Jan");
	ivjMonthsList.add("Feb");
	ivjMonthsList.add("Mar");
	ivjMonthsList.add("Apr");
	ivjMonthsList.add("May");
	ivjMonthsList.add("Jun");
	ivjMonthsList.add("Jul");
	ivjMonthsList.add("Aug");
	ivjMonthsList.add("Sep");
	ivjMonthsList.add("Oct");
	ivjMonthsList.add("Nov");
	ivjMonthsList.add("Dec");
	for (int i = 1900; i < 2041; i++)
		ivjYearsList.insert("" + i, i - 1900);
}

/**
 * Checkes whether the Calendar parameter holds a holiday or not.
 * Creation date: (25/04/01 11:28:43)
 * @return boolean
 * @param cal java.util.Calendar
 */
boolean isHoliday(java.util.Calendar cal) {
	for (int i=0; i < holidays.size(); i++) {
	  if (((com.ibm.calendar.Holiday) holidays.elementAt(i)).equals(cal))
		return true;
	}
	return false;
}

/**
 * Checkes whether the day parameter is saturday/sunday or not.
 * @return boolean
 * @param day int
 */
public boolean isWeekend(int day) {

	int k;

	if ((k = day % 7) == 0)
		k = 7; 
	if ((k + firstDayOfWeek == 8) // saturday 				   
	   || ((firstDayOfWeek == java.util.Calendar.SUNDAY) && (k == 1)) // sunday
	   || ((firstDayOfWeek != java.util.Calendar.SUNDAY) && (k + firstDayOfWeek == 9))) // sunday
		return true;
	else
		return false;
}

/**
 * Method to handle events for the ItemListener interface.
 * @param e java.awt.event.ItemEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void itemStateChanged(java.awt.event.ItemEvent e) {
	// user code begin {1}

// next row added by Werner Zsolt, 12/06/2000. Under Win2000, it was very hard to 
// change the state of the month Choice. java.awt.event.ItemEvent.getItem() worked well,
// but the choice itself didn't want to repaint itself with the new value. 
// Choice.getSelectedItem()  didn't work, either - it just returned the previously chosen 
// item. We force the Choice to display the new item chosen by the user.
		((Choice)e.getSource()).select(e.getItem().toString());

	// user code end

	if (e.getSource() == getMonthsList()) 
		connEtoC1();
	if (e.getSource() == getYearsList()) 
		connEtoC2();
	// user code begin {2}
	// user code end
}

/**
 * Method to handle mouseClicked Event, included double click
 * if it is over the days region.
 * @param e java.awt.event.MouseEvent
 */
public void mouseClicked(java.awt.event.MouseEvent e)
{
	int year = Integer.parseInt(ivjYearsList.getItem(ivjYearsList.getSelectedIndex()));
	int month = ivjMonthsList.getSelectedIndex();
	int tyear;
	int tmonth;
	int day;
	int x = e.getX();
	int y = e.getY();
	int col;
	int row;
	int cdate;
	int cd;
	
	// selectFlag=0/1/2 -> all days/only weekdays/only weekend days can be selected
	int selectFlag = getSelectType();
	//System.out.println ("Click " + e.getX() + " " + e.getY() + "  " + e.getClickCount());
	if (e.getClickCount() == 2) {
  	  /**
	  * determines if the click is over the days region.
	  */
		if (x > 7 && x < (24 * 7) + 7 && y > 47 && y < 47 + (24 * 6))
	 	{ 
			y -= 47;
			x -= 7;
			col = x / 24;
			row = y / 24;
			cdate = ((row * 7) + (col + 1));

			// calculate new date for hcal
			java.util.Calendar hCal = (java.util.Calendar) aCalendar.clone();
			cd = cdate;
			tyear = year;
			tmonth = month;
			if (cd > noOfDaysBefor && cd <= (noOfDaysBefor + currentMonthDaysNum))
			{
				cd -= noOfDaysBefor;
				day = cd;
				hCal.set(tyear, tmonth, day);
			} else
			{
				if (cd <= noOfDaysBefor)
				{
					day = (previousMonthDaysNum - noOfDaysBefor) + cd;
					if (tmonth == 0)
					{
						tmonth = 11;
						tyear = tyear - 1;
					} else
						tmonth -= 1;
					if (tyear >= 1900)
						hCal.set(tyear, tmonth, day);
				} else
				{
					if (cd > (noOfDaysBefor + currentMonthDaysNum))
					{
						day = cd - (currentMonthDaysNum + noOfDaysBefor);
						if (tmonth == 11)
						{
							tmonth = 0;
							tyear = tyear + 1;
						} else
							tmonth += 1;
						if (tyear <= 2040)
							hCal.set(tyear, tmonth, day);
					}
				}
			}
			
			if ((selectFlag == 0) || (selectFlag == 1 && !isWeekend(cdate) && !isHoliday(hCal)) || (selectFlag == 2 && (isWeekend(cdate) || isHoliday(hCal))))
				fireOnDateSelectedEvent(new com.ibm.calendar.events.DateSelectedEvent(this));
		}
	}
}

/**
 * Informs all active ImageAreas of a mouse drag.
 * Only those areas that were inside the original mouseDown()
 * are informed of the mouseUp.
 */
public void mouseDragged(MouseEvent e)
{
	mouseMoved(e);
	e.consume();
}

/**
 * mouseEntered Event
 * @param e java.awt.event.MouseEvent
 */
public void mouseEntered(java.awt.event.MouseEvent e) {
}

/**
 * mouseExited Event
 * @param e java.awt.event.MouseEvent
 */
public void mouseExited(java.awt.event.MouseEvent e)
{
}

/**
 * mouseMoved Event
 * @param e java.awt.event.MouseEvent
 */
public void mouseMoved(MouseEvent e)
{
}

/**
  * Inform all active ImageAreas of a mouse press.
  * Using this method to calculate the selected date and to display the plugin list
  * and to call the select date function to select the correct date, in this method
  * repaint is used to redraw the calendar if needed and calculate the needed data
  * to the calendar.
  */
public void mousePressed(MouseEvent e)
{
	int year = Integer.parseInt(ivjYearsList.getItem(ivjYearsList.getSelectedIndex()));
	int month = ivjMonthsList.getSelectedIndex();
	int tyear;
	int tmonth;
	int day;
	int x = e.getX();
	int y = e.getY();
	int col;
	int row;
	int cdate;
	int cd;
	
	// selectFlag=0/1/2 -> all days/only weekdays/only weekend days can be selected
	int selectFlag = getSelectType();
	
	/**
	 * determine if the mouse is right clicked or left clicked.
	 */
	if (e.isMetaDown())
	{
		if (x > 7 && x < (24 * 7) + 7 && y > 47 && y < 47 + (24 * 6))
		{
			ivjPlugins.show(e.getComponent(), e.getX(), e.getY());
		}
	} else
	{
		/**
		 * determins if the click is over the days region.
		 */
		if (x > 7 && x < (24 * 7) + 7 && y > 47 && y < 47 + (24 * 6))
		{
			y -= 47;
			x -= 7;
			col = x / 24;
			row = y / 24;
			cdate = ((row * 7) + (col + 1));

			// calculate new date for hcal
			java.util.Calendar hCal = (java.util.Calendar) aCalendar.clone();
			cd = cdate;
			tyear = year;
			tmonth = month;
			if (cd > noOfDaysBefor && cd <= (noOfDaysBefor + currentMonthDaysNum))
			{
				cd -= noOfDaysBefor;
				day = cd;
				hCal.set(tyear, tmonth, day);
			} else
			{
				if (cd <= noOfDaysBefor)
				{
					day = (previousMonthDaysNum - noOfDaysBefor) + cd;
					if (tmonth == 0)
					{
						tmonth = 11;
						tyear = tyear - 1;
					} else
						tmonth -= 1;
					if (tyear >= 1900)
						hCal.set(tyear, tmonth, day);
				} else
				{
					if (cd > (noOfDaysBefor + currentMonthDaysNum))
					{
						day = cd - (currentMonthDaysNum + noOfDaysBefor);
						if (tmonth == 11)
						{
							tmonth = 0;
							tyear = tyear + 1;
						} else
							tmonth += 1;
						if (tyear <= 2040)
							hCal.set(tyear, tmonth, day);
					}
				}
			}
			

			if ((selectFlag == 0) || (selectFlag == 1 && !isWeekend(cdate) && !isHoliday(hCal)) || (selectFlag == 2 && (isWeekend(cdate) || isHoliday(hCal))))
			{
				if (cdate > noOfDaysBefor && cdate <= (noOfDaysBefor + currentMonthDaysNum))
				{
					cdate -= noOfDaysBefor;
					day = cdate;
					aCalendar.set(year, month, day);
					dayCircle.setVisible(false); // hide the circle of previous selected day
					//selectDate(getGraphics());
				} else
				{
					if (cdate <= noOfDaysBefor)
					{
						day = (previousMonthDaysNum - noOfDaysBefor) + cdate;
						if (month == 0)
						{
							month = 11;
							year = year - 1;
						} else
						{
							month -= 1;
						}
						if (year >= 1900)
						{
							aCalendar.set(year, month, day);
							repaint();
						}
					} else
					{
						if (cdate > (noOfDaysBefor + currentMonthDaysNum))
						{
							day = cdate - (currentMonthDaysNum + noOfDaysBefor);
							if (month == 11)
							{
								month = 0;
								year = year + 1;
							} else
							{
								month += 1;
							}
							if (year <= 2040)
							{
								aCalendar.set(year, month, day);
								repaint();
							}
						}
					}
				}
				setSelectedDate(aCalendar.getTime());
				selectDate(getGraphics());
			}
		}
	}
	e.consume();
}

/**
 * Method to handle mouseReleased Event
 * @param e java.awt.event.MouseEvent
 */
public void mouseReleased(java.awt.event.MouseEvent e) {
}

/**
 * The notePlugin_ActionPerformed method activates the Note plugin
 * @param actionEvent java.awt.event.ActionEvent
 */
public void notePlugin_ActionPerformed(java.awt.event.ActionEvent actionEvent)
{
	pluginName = "NotePlugin";
	String vpluginName;
	for (int i = 0; i < plugins.size(); i++)
	{
		vpluginName = ((Plugin)plugins.elementAt(i)).getClass().getName().substring(17);
		if (vpluginName.equalsIgnoreCase(pluginName))
		{
			activePlugin = (Plugin) plugins.elementAt(i);
			activatePlugin();
			break;
		}
	}
}

/**
 * Draws the calendar and initializes firstDayOfWeek
 * and the date variables whenever it's needed.
 * @param g java.awt.Graphics
 */
public void paint(java.awt.Graphics g)
{
	/**
	 * sets firstDayOfWeek from property sheet or from system 
	 * added by Istvan Szamosi 04/18/2001
	 */
	java.util.Calendar aCalendar = java.util.Calendar.getInstance();

	if ((firstDayOfWeek = getFirstDayOfWeek()) == -1) 		
		firstDayOfWeek = aCalendar.getFirstDayOfWeek();

	initDate();
	drawCalendar(g);
	paintComponents(g);
	
}

/**
 * Removes a com.ibm.calendar.events.DateSelectedEventListener.
 */
public void removeDateSelectedEventListener(com.ibm.calendar.events.DateSelectedEventListener newListener) {
	if (aDateSelectedEventListener != null) {
		aDateSelectedEventListener.removeElement(newListener);
	};
}

/**
 * Removes an PluginInitializationErrorListener to the listener list.
 * @param newListener  The PluginInitializationErrorListener to be removed
 * @see   com.ibm.calendar.events.PluginInitializationErrorListener
 * @see   com.ibm.calendar.Calendar#addPluginInitializationErrorListener
 **/
public void removePluginInitializationErrorListener(com.ibm.calendar.events.PluginInitializationErrorListener newListener)
{
	if (aPluginInitializationErrorListener != null)
	{
		aPluginInitializationErrorListener.removeElement(newListener);
	};
}

/**
 * Removes an PropertyChangeListener to the listener list.
 * @param listener  The PropertyChangeListener to be removed
 * @see   java.beans.PropertyChangeListener
 * @see   com.ibm.calendar.Calendar#addPropertyChangeListener
 **/
public synchronized void removePropertyChangeListener(java.beans.PropertyChangeListener listener)
{
	getPropertyChange().removePropertyChangeListener(listener);
}

/**
 * Removes an VetoableChangeListener to the listener list.
 * @param listener  The VetoableChangeListener to be removed
 * @see   java.beans.VetoableChangeListener
 * @see   com.ibm.calendar.Calendar#addVetoableChangeListener
 **/
public synchronized void removeVetoableChangeListener(java.beans.VetoableChangeListener listener)
{
	getVetoPropertyChange().removeVetoableChangeListener(listener);
}

/**
 * selectDate is used to draw the circle around the selected date.
 * @param g java.awt.Graphics
 */
private void selectDate(java.awt.Graphics g)
{
	int i;
	int j;
	int k;
	int index;
	int daysOfWeek = 6; // From 0 to 6
	int weeksOfMonth = 5;
	int dayButtonWidth = 24;
	int dayButtonHeight = 24;

	if (getSelectedDate() == null) {
		dayCircle.setVisible(false);
		return;
	}
	
	index = noOfDaysBefor + aCalendar.get(java.util.Calendar.DAY_OF_MONTH);
	if (index % 7 == 0)
	{
		j = (index / 7) - 1;
		i = 6;
	} else
	{
		j = index / 7;
		i = (index % 7) - 1;
	}
// sets the location of the day rectangle
	dayCircle.setLocation(7 + (i * dayButtonWidth) + 1, 47 + (j * dayButtonHeight) + 1);
// show the circle around the actually selected day
	dayCircle.setVisible(true);
		
	if (aCalendar.get(java.util.Calendar.DAY_OF_MONTH) < 10)
{
	fieldResultSelectedDateAsString = "0" + aCalendar.get(java.util.Calendar.DAY_OF_MONTH);
} else
{
	fieldResultSelectedDateAsString = "" + aCalendar.get(java.util.Calendar.DAY_OF_MONTH);
}
if (aCalendar.get(java.util.Calendar.MONTH) < 10)
{
	fieldResultSelectedDateAsString = fieldResultSelectedDateAsString + "0" + "" + (aCalendar.get(java.util.Calendar.MONTH) + 1) ;
} else
{
	fieldResultSelectedDateAsString = fieldResultSelectedDateAsString + "" + (aCalendar.get(java.util.Calendar.MONTH) + 1) ;
}
fieldResultSelectedDateAsString = fieldResultSelectedDateAsString + "" + aCalendar.get(java.util.Calendar.YEAR);
firePropertyChange("resultSelectedDateAsString", "", fieldResultSelectedDateAsString);

}

/**
 * Sets the aboutThisBean property (java.lang.String) value.
 * @param aboutThisBean The new value for the property.
 * @see #getAboutThisBean
 */
public void setAboutThisBean(String aboutThisBean)
{
	fieldAboutThisBean = aboutThisBean;
}

/**
 * Sets the firstDayOfWeek property (int) value.
 * @param firstDayOfWeek The new value for the property.
 * @see #getFirstDayOfWeek
 */
public void setFirstDayOfWeek(int firstDayOfWeek) {
	int oldValue = fieldFirstDayOfWeek;
	fieldFirstDayOfWeek = firstDayOfWeek;
	firePropertyChange("firstDayOfWeek", new Integer(oldValue), new Integer(firstDayOfWeek));
}

/**
 * Takes holiday dates from the parameter string and sets them as holidays in this 
 * CalendarBean.
 * The holiday string consists of dates in format "yyyy/M/d/F" (year/month/day/week_in_month) separated with comma ','. 
 * Field missing means that for this field any value is valid.
 * If the field "week_in_month" is not empty, the field "day" means "day_of_week". 
 * Positive value of "week_in_month" means a day of week from the month beginning.
 * Negative value of "week_in_month" means a day of week from the month end.
 *
 * <p>This allows to build universal repeatable dates.
 * <p>Valid combinations are listed below:
 * <ul>
 * <li>"year/month/day" (trailing empty fields may be missed) means a specific single date
 * <li>"year/month/day_of_week/week_in_month", e.g. "2001/12/1/1" means first Monday in December of year 2001.
 * <li>"/month/day", e.g. "/1/1" means January 1 of every year.
 * <li>"/month/day_of_week/week_in_month", e.g "/11/5/-1" means last Friday in December of every year.
 * </ul>
 * <p>Example of a holiday string (for Belarus): <code>"/1/1,/1/7,/3/8,2001/4/24,/5/1,/5/9,/7/3,/11/2,/11/7,/12/25"</code>
 * <p>Wrong holiday dates are ignored.
 * @param <code>h</code> string of holiday dates.
 * @see #getHolidays
 */
public void setHolidays(java.lang.String h) {
	String oldValue = fieldHolidays;
	fieldHolidays = h;
	holidays.removeAllElements();

	int i1=0, i2=0;
	   
	if (h != null) {
	  while (i2 < h.length()) {
		i1 = h.indexOf(',', i2);
		if (i1 < 0)
		  i1 = h.length();
		String hsub = h.substring(i2, i1);
		com.ibm.calendar.Holiday hd = new com.ibm.calendar.Holiday(hsub);
		holidays.addElement(hd);
		i2 = i1+1;
	  }
	}
	firePropertyChange("holidays", oldValue, h);
}

/**
 * Sets the initialDate property (java.util.Date) value.
 * @param initialDate The new value for the property.
 * @see #getInitialDate
 */
public void setInitialDate(java.util.Date initialDate)
{
	fieldInitialDate = initialDate;

/*
// added by Werner Zsolt, 16/12/2000. See PTR "setSelectedDate(Date)/Calendar.setInitialDate(Date) doesn't do anything"
		fieldSelectedDate = initialDate;
		aCalendar.set(getSelectedDate().getYear()+1900, getSelectedDate().getMonth(), getSelectedDate().getDate());
*/
// added by Istvan Szamosi, 23/04/2001. See PTR "Avoid using deprecated methods"
		// fieldSelectedDate = initialDate; 
		aCalendar.setTime(initialDate);
}

/**
 * Sets the inputPlugin property (com.ibm.calendar.Plugin) value.
 * @param inputPlugin The new value for the property.
 */
public void setInputPlugin(Plugin inputPlugin)
{
	String pluginName;
	Plugin oldAddPlugin = fieldInputPlugin;
	fieldInputPlugin = inputPlugin;
	if (!plugins.contains(fieldInputPlugin))
	{
		plugins.addElement(fieldInputPlugin);
		pluginName = fieldInputPlugin.getClass().getName().substring(17);
		pluginName = pluginName.substring(0, pluginName.length() - 6);
		if (pluginName.equalsIgnoreCase("Note"))
		{
			ivjNotePlugin.setEnabled(true);
		} else
			if (pluginName.equalsIgnoreCase("ToDo"))
			{
				ivjToDoPlugin.setEnabled(true);
			} else
				if (pluginName.equalsIgnoreCase("Day"))
				{
					ivjDayPlugin.setEnabled(true);
				}
		if (fieldInputPlugin != null)
			fieldInputPlugin.setInfo(aCalendar, null, 0, 0);
	} else
	{
		fieldInputPlugin = oldAddPlugin;
	}
}

/**
 * Sets the inputTheme property (java.awt.Image) value.
 * @param inputTheme The new value for the property.
 * @see #getInputTheme
 */
public void setInputTheme(com.ibm.calendar.Theme inputTheme)
{
	fieldInputTheme = inputTheme;
}

/**
 * Sets the selectedDate property (java.util.Date) value.
 * @param selectedDate The new value for the property.
 * @see #getSelectedDate
 */
public void setSelectedDate(java.util.Date selectedDate)
{
	java.util.Date oldValue = fieldSelectedDate;
	fieldSelectedDate = selectedDate;
/*
		// added by Werner Zsolt, 16/12/2000. See PTR "setSelectedDate(Date)/Calendar.setInitialDate(Date) doesn't do anything"
		aCalendar.set(getSelectedDate().getYear()+1900, getSelectedDate().getMonth(), getSelectedDate().getDate());	
*/
		// added by Istvan Szamosi, 23/04/2001. See PTR "setSelectedDate(Date)/Calendar.setInitialDate(Date) doesn't do anything"
		aCalendar.setTime(selectedDate);
		aCalendar.set(aCalendar.get(java.util.Calendar.YEAR), aCalendar.get(java.util.Calendar.MONTH), aCalendar.get(java.util.Calendar.DATE));

	firePropertyChange("selectedDate", oldValue, selectedDate);

}

/**
 * Sets the selectType property (int) value.
 * @param selectType The new value for the property.
 * @see #getSelectType
 */
public void setSelectType(int selectType) {
	int oldValue = fieldSelectType;
	fieldSelectType = selectType;
	firePropertyChange("selectType", new Integer(oldValue), new Integer(selectType));
}

/**
 * The toDoPlugin_ActionPerformed method activates the ToDo plugin
 * @param actionEvent java.awt.event.ActionEvent
 */
public void toDoPlugin_ActionPerformed(java.awt.event.ActionEvent actionEvent) {
	pluginName="ToDoPlugin";
	String vpluginName;
	for (int i = 0; i < plugins.size(); i++)
	{
		vpluginName = ((Plugin)plugins.elementAt(i)).getClass().getName().substring(17);
		if (vpluginName.equalsIgnoreCase(pluginName))
		{
			activePlugin = (Plugin) plugins.elementAt(i);
			activatePlugin();
			break;
		}
	}

}
}