package com.ibm.wtp.emf.workbench;
/*
 * Licensed Material - Property of IBM 
 * (C) Copyright IBM Corp. 2001, 2002 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 */

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

import com.ibm.wtp.emf.workbench.plugin.EMFWorkbenchPlugin;
import com.ibm.wtp.internal.emf.workbench.*;
import com.ibm.wtp.internal.emf.workbench.nls.EMFWorkbenchResourceHandler;


public class EMFWorkbenchContextBase {
	protected IProject project;
	protected ProjectResourceSet resourceSet;
  

	public EMFWorkbenchContextBase(IProject aProject) {
		if (aProject == null)
			throw new IllegalArgumentException(EMFWorkbenchResourceHandler.getString("EMFWorkbenchContextBase_ERROR_1")); //$NON-NLS-1$
		project = aProject;		
	}
	public void dispose() {
		if (resourceSet != null)
			resourceSet.release();
		resourceSet = null;
		project = null;
	}

	/*
	 * @see IProjectNature#getProject()
	 */
	public IProject getProject() {
		return project;
	}
	
	/**
	 * Return the ResourceSet.
	 */
	public ProjectResourceSet getResourceSet() {
		if (resourceSet == null) {
			resourceSet = createResourceSet();
			initializeResourceSet(resourceSet);
		}
		return resourceSet;
	}
	/**
	 * Used for optimization; answer whether a resourceSet has been
	 * created
	 */
	public boolean hasResourceSet() {
		return resourceSet != null;
	}	

	protected void initializeResourceSet(ProjectResourceSet aResourceSet) {
		createResourceSetSynchronizer(aResourceSet);
		aResourceSet.setURIConverter(createURIConverter(aResourceSet));
		aResourceSet.add(new WorkspaceResourceHandler());
		EMFWorkbenchPlugin.getDefault().addExtendedResourceHandlers(aResourceSet);
		
	}

	protected ProjectResourceSet createResourceSet() {
		if (project == null)
			throw new IllegalStateException(EMFWorkbenchResourceHandler.getString("EMFWorkbenchContextBase_ERROR_2")); //$NON-NLS-1$
		return new ProjectResourceSetImpl(project);
	}

	protected WorkbenchURIConverter createURIConverter(ProjectResourceSet aResourceSet) {
		return new WorkbenchURIConverterImpl(getProject(), aResourceSet.getSynchronizer());
	}
	
	protected ResourceSetWorkbenchSynchronizer createResourceSetSynchronizer(ProjectResourceSet aResourceSet) {
		return EMFWorkbenchContextFactory.INSTANCE.createSynchronizer(aResourceSet, getProject());
	}
	

	/**
	* Delete @aResource in the Workbench.
	*/
	public void deleteResource(Resource aResource) throws CoreException {
		if (aResource != null)
			deleteFile(aResource);
	}
	
	public void deleteFile(Resource resource) {
		throw new UnsupportedOperationException(EMFWorkbenchResourceHandler.getString("EMFWorkbenchContextBase_ERROR_0")); //$NON-NLS-1$
	}

	

	public Resource getResource(URI uri) {
		return this.resourceSet.getResource(uri, true);
	}

}
