package com.ibm.wtp.common.util;

import org.eclipse.core.runtime.*;
import java.util.*;

/**
 * The main plugin class to be used in the desktop.
 */
public class WTPCommonUtilPlugin extends Plugin {
	public static final String PLUGIN_ID = "com.ibm.wtp.common.util"; //$NON-NLS-1$
	public static final String UI_CONTEXT_EXTENSION_POINT = "uiContextSensitiveClass"; //$NON-NLS-1$
	public static final String UI_TESTER_EXTENSION_POINT = "uiTester"; //$NON-NLS-1$
	
	
	//The shared instance.
	private static WTPCommonUtilPlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;
	
	/**
	 * The constructor.
	 */
	public WTPCommonUtilPlugin() {
		super();
		plugin = this;
		// TODO (Rich and Ritchie discussed this). I think we decided that this isn't needed. It was created by
		// default when the plugin was created. There is no util properties, and nobody seems to be using 
		// the getResourceString and getResourceBundle methods. They should be removed.
		try {
			resourceBundle   = ResourceBundle.getBundle("util");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}

	/**
	 * Returns the shared instance.
	 */
	public static WTPCommonUtilPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = WTPCommonUtilPlugin.getDefault().getResourceBundle();
		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
}
