package com.ibm.wtp.logger.proxyrender;
/*
 * Licensed Material - Property of IBM (C) Copyright IBM Corp. 2001, 2002 - All Rights Reserved. US
 * Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP
 * Schedule Contract with IBM Corp.
 */

import java.util.logging.Level;

import com.ibm.wtp.common.logger.proxy.ILogRenderer;
import com.ibm.wtp.common.logger.proxy.Logger;

/**
 * Insert the type's description here. Creation date: (8/24/2001 10:49:01 AM) @author:
 * Administrator
 */
public class ConsoleLogRenderer extends AbstractWorkBenchRenderer {

	/**
	 * ConsoleLogRenderer constructor comment.
	 * 
	 * @param logger
	 *            com.ibm.etools.j2ee.logger.Logger
	 */
	public ConsoleLogRenderer(Logger logger) {
		super(logger);
	}
	/**
	 * 
	 * Creation date: (8/24/2001 10:49:01 AM)
	 * 
	 * @return java.lang.String
	 * @param param
	 *            org.eclipse.core.runtime.Status
	 */
	public String log(String msg) {

		System.out.println(msg);
		return ILogRenderer.CONSOLE_DESCRIPTION;

	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ibm.wtp.logger.proxyrender.AbstractWorkBenchRenderer#log(java.lang.String,
	 *      java.util.logging.Level, boolean)
	 */
	protected void log(String msg, Level l, boolean loggedToWorkbench) {
		if (!loggedToWorkbench || !consoleLogOn) {		
			if (l == Level.SEVERE)
				System.err.println(msg);
			else
				System.out.println(msg);
		}
	}

}
