/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.cdm.dept.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.ve.examples.cdm.dept.Company;
import org.eclipse.ve.examples.cdm.dept.Department;
import org.eclipse.ve.examples.cdm.dept.property.PropertySupport;
import org.eclipse.ve.examples.cdm.dept.ui.CompanyContainerPolicy;
import org.eclipse.ve.examples.cdm.dept.ui.DepartmentGraphicalEditPart;
import org.eclipse.ve.internal.cde.core.ContainerPolicy;
import org.eclipse.ve.internal.cde.core.ContentsGraphicalEditPart;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.VisualInfoXYLayoutEditPolicy;

public class CompanyContentsGraphicalEditPart
extends ContentsGraphicalEditPart {
    protected PropertyChangeListener companyListener;
    static /* synthetic */ Class class$0;

    public CompanyContentsGraphicalEditPart(Company company) {
        this.setModel(company);
    }

    protected List getModelChildren() {
        Company company = (Company)this.getModel();
        return company.getDepartments();
    }

    protected IFigure createFigure() {
        IFigure fig = super.createFigure();
        TitleBarBorder border = new TitleBarBorder();
        border.setBackgroundColor(ColorConstants.lightBlue);
        border.setPadding(new Insets(10, 10, 0, 0));
        fig.setBorder((Border)border);
        return fig;
    }

    public void activate() {
        super.activate();
        Company company = (Company)this.getModel();
        this.companyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("departments".equals(evt.getPropertyName())) {
                    CompanyContentsGraphicalEditPart.this.refreshChildren();
                } else if ("name".equals(evt.getPropertyName())) {
                    CompanyContentsGraphicalEditPart.this.refreshCompanyName((String)evt.getNewValue());
                }
            }
        };
        company.addPropertyChangeListener(this.companyListener);
    }

    public void deactivate() {
        super.deactivate();
        ((Company)this.getModel()).removePropertyChangeListener(this.companyListener);
    }

    protected void createEditPolicies() {
        VisualInfoXYLayoutEditPolicy ep = new VisualInfoXYLayoutEditPolicy((ContainerPolicy)new CompanyContainerPolicy(EditDomain.getEditDomain((EditPart)this)));
        ep.setZoomable(true);
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)ep);
    }

    protected void refreshChildren() {
        super.refreshChildren();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshCompanyName(((Company)this.getModel()).getName());
    }

    private void refreshCompanyName(String newName) {
        TitleBarBorder border = (TitleBarBorder)this.getFigure().getBorder();
        border.setLabel(newName);
        this.getFigure().repaint();
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return PropertySupport.getPropertySource(this.getModel());
        }
        return super.getAdapter(key);
    }

    protected EditPart createChild(Object child) {
        Department childModel = (Department)child;
        return new DepartmentGraphicalEditPart(childModel);
    }
}

