package org.eclipse.ve.examples.java.beaninfo;
/*******************************************************************************
 * Copyright (c)  2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

import java.awt.Color;
import java.awt.Component;

import javax.swing.*;


/**
 * This type was generated by a SmartGuide.
 */
public class ColorCellRenderer extends DefaultListCellRenderer {
	String colorNames[];
	Color colorValues[];
	SwatchIcon colorIcons[];
/**
 * ColorCellRenderer constructor comment.
 */
public ColorCellRenderer(String[] names, Color[] values) {
	super();

	colorNames = names;
	colorValues = values;
	colorIcons = new SwatchIcon[colorValues.length];
	for (int i=0; i<colorValues.length; i++) {
		colorIcons[i] = new SwatchIcon(colorValues[i]);
	}
}
public Component getListCellRendererComponent( JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {

	String text = colorNames[index];
	super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
	setIcon(colorIcons[index]);
	setIconTextGap(5);
	setVerticalTextPosition(SwingConstants.CENTER);
	return this;
	
}
}


