/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jem.internal.beaninfo.core.BeaninfoEntry;
import org.eclipse.jem.internal.beaninfo.core.SearchpathEntry;
import org.eclipse.jem.internal.beaninfo.ui.BPBeaninfoListElement;
import org.eclipse.jem.internal.beaninfo.ui.BPSearchListElement;
import org.eclipse.jem.internal.beaninfo.ui.BeanInfoUIMessages;
import org.eclipse.jem.internal.beaninfo.ui.PackageOnlyContentProvider;
import org.eclipse.jem.internal.beaninfo.ui.PackagesWorkbookPage;
import org.eclipse.jem.internal.beaninfo.ui.SearchPathListLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class BeaninfoEntrySearchpathDialog
extends Dialog {
    protected BPBeaninfoListElement infoElement;
    protected IJavaProject jProject;
    protected ListDialogField listField;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public BeaninfoEntrySearchpathDialog(Shell parentShell, BPBeaninfoListElement infoElement, IJavaProject jProject) {
        super(parentShell);
        this.infoElement = infoElement;
        this.jProject = jProject;
        DialogAdapter adapter = new DialogAdapter();
        String[] stringArray = new String[6];
        stringArray[0] = BeanInfoUIMessages.getString("BeaninfoPathsBlock_UI_.searchpath.up.button");
        stringArray[1] = BeanInfoUIMessages.getString("BeaninfoPathsBlock_UI_.searchpath.down.button");
        stringArray[3] = BeanInfoUIMessages.getString("SearchPathDialog.ChoosePackages");
        stringArray[5] = BeanInfoUIMessages.getString("SearchPathDialog.Remove");
        String[] buttonLabels = stringArray;
        this.listField = new ListDialogField((IListAdapter)adapter, buttonLabels, (ILabelProvider)new SearchPathListLabelProvider(jProject));
        this.listField.setLabelText(BeanInfoUIMessages.getString("SearchPathDialog.Desc.Label"));
        this.listField.setUpButtonIndex(0);
        this.listField.setDownButtonIndex(1);
        this.listField.setRemoveButtonIndex(5);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MessageFormat.format(BeanInfoUIMessages.getString("SearchPathDialog.ModifySearchPaths"), this.infoElement.getEntry().getPath().toString()));
    }

    protected Control createDialogArea(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.listField}, (boolean)true, (int)-1, (int)-1);
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.listField.setButtonsMinWidth(buttonBarWidth);
        this.updatePackagesList();
        return composite;
    }

    private void updatePackagesList() {
        if (this.infoElement.getEntry().getKind() == 100) {
            this.listField.setLabelText(BeanInfoUIMessages.getString("SearchPathDialog.NotEditable_INFO_"));
            this.listField.setEnabled(false);
            return;
        }
        this.listField.setElements(Arrays.asList(this.infoElement.getSearchpaths()));
    }

    protected void pageCustomButtonPressed(int index) {
        if (index != 3) {
            return;
        }
        List elementsToAdd = this.choosePackages();
        if (elementsToAdd != null && !elementsToAdd.isEmpty()) {
            this.listField.addElements(elementsToAdd);
            this.listField.postSetSelection((ISelection)new StructuredSelection(elementsToAdd));
        }
    }

    protected void okPressed() {
        if (this.listField.isEnabled()) {
            List paths = this.listField.getElements();
            this.infoElement.setSearchpaths(paths.toArray(new BPSearchListElement[paths.size()]));
        }
        super.okPressed();
    }

    private List choosePackages() {
        IPackageFragmentRoot[] roots = this.getBeaninfoRoots();
        ArrayList<String> newPackageNames = new ArrayList<String>();
        if (roots != null) {
            PackagesWorkbookPage.ChoosePackagesSelectionValidator validator = new PackagesWorkbookPage.ChoosePackagesSelectionValidator();
            Class[] classArray = new Class[2];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IPackageFragmentRoot");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.IPackageFragment");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            Class[] acceptedClasses = classArray;
            Object[] rejectedFragments = this.getFilteredExistingEntries(roots);
            TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedFragments){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (super.select(viewer, parentElement, element)) {
                        if (element instanceof IPackageFragment) {
                            IPackageFragment pkg = (IPackageFragment)element;
                            try {
                                return pkg.hasChildren();
                            }
                            catch (JavaModelException javaModelException) {
                                return false;
                            }
                        }
                        return true;
                    }
                    return false;
                }
            };
            PackageOnlyContentProvider provider = new PackageOnlyContentProvider();
            JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
            dialog.setTitle(BeanInfoUIMessages.getString("BeaninfoPathsBlock_UI_.addsearchpath.title"));
            dialog.setValidator((ISelectionStatusValidator)validator);
            dialog.setMessage(BeanInfoUIMessages.getString("BeaninfoPathsBlock_UI_.addsearchpath.description"));
            dialog.addFilter((ViewerFilter)filter);
            dialog.setInput(Arrays.asList(this.getBeaninfoRoots()));
            if (dialog.open() == 0) {
                Object[] elements = dialog.getResult();
                int i = 0;
                while (i < elements.length) {
                    newPackageNames.add(((IPackageFragment)elements[i]).getElementName());
                    ++i;
                }
            }
        } else {
            final List existingPackagenames = this.getFilteredExistingEntries();
            IInputValidator validator = new IInputValidator(){

                public String isValid(String newText) {
                    if (existingPackagenames.contains(newText)) {
                        return BeanInfoUIMessages.getString("SearchPathDialog.PackagePresent_INFO_");
                    }
                    IStatus status = JavaConventions.validatePackageName((String)newText);
                    return status.getSeverity() == 0 ? null : status.getMessage();
                }
            };
            InputDialog dialog = new InputDialog(this.getShell(), BeanInfoUIMessages.getString("SearchPathDialog.InputDialog.Title"), BeanInfoUIMessages.getString("SearchPathDialog.InputDialog.Message"), null, validator);
            if (dialog.open() == 0) {
                newPackageNames.add(dialog.getValue());
            }
        }
        if (newPackageNames.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<BPSearchListElement> newElements = new ArrayList<BPSearchListElement>(newPackageNames.size());
        int i = 0;
        while (i < newPackageNames.size()) {
            newElements.add(new BPSearchListElement(new SearchpathEntry((String)newPackageNames.get(i)), false, false, false));
            ++i;
        }
        return newElements;
    }

    protected IPackageFragmentRoot[] getBeaninfoRoots() {
        IPackageFragmentRoot[] roots = null;
        if (this.infoElement.getEntry().getKind() != 100) {
            IClasspathEntry resolved = JavaCore.getResolvedClasspathEntry((IClasspathEntry)((BeaninfoEntry)this.infoElement.getEntry()).getClasspathEntry());
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(resolved.getPath());
            if (res != null && res.exists()) {
                if (res instanceof IProject) {
                    IJavaProject jp = (IJavaProject)JavaCore.create((IResource)res);
                    try {
                        if (jp != null) {
                            roots = jp.getPackageFragmentRoots();
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                } else {
                    IProject containingProject = res.getProject();
                    IJavaProject jp = JavaCore.create((IProject)containingProject);
                    if (jp != null) {
                        try {
                            IPackageFragmentRoot root = jp.findPackageFragmentRoot(resolved.getPath());
                            if (root != null) {
                                roots = new IPackageFragmentRoot[]{root};
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                    }
                }
            }
        }
        return roots;
    }

    protected Object[] getFilteredExistingEntries(IPackageFragmentRoot[] roots) {
        List entries = this.listField.getElements();
        ArrayList fragments = new ArrayList(entries.size());
        Iterator itr = entries.iterator();
        while (itr.hasNext()) {
            BPSearchListElement elem = (BPSearchListElement)itr.next();
            fragments.addAll(this.getPackages(elem, roots));
        }
        return fragments.toArray();
    }

    protected List getFilteredExistingEntries() {
        List entries = this.listField.getElements();
        ArrayList<String> names = new ArrayList<String>(entries.size());
        Iterator itr = entries.iterator();
        while (itr.hasNext()) {
            BPSearchListElement elem = (BPSearchListElement)itr.next();
            names.add(((SearchpathEntry)elem.getEntry()).getPackage());
        }
        return names;
    }

    protected List getPackages(BPSearchListElement element, IPackageFragmentRoot[] roots) {
        String packageName = ((SearchpathEntry)element.getEntry()).getPackage();
        if (packageName == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            ArrayList<IJavaElement> packages = new ArrayList<IJavaElement>(10);
            int i = 0;
            while (i < roots.length) {
                IJavaElement[] pfs = roots[i].getChildren();
                int j = 0;
                while (j < pfs.length) {
                    if (pfs[j].getElementType() == 4 && pfs[j].getElementName().equals(packageName)) {
                        packages.add(pfs[j]);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            return packages;
        }
        catch (JavaModelException javaModelException) {
            return Collections.EMPTY_LIST;
        }
    }

    private class DialogAdapter
    implements IListAdapter {
        DialogAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            BeaninfoEntrySearchpathDialog.this.pageCustomButtonPressed(index);
        }

        public void selectionChanged(ListDialogField field) {
        }

        public void doubleClicked(ListDialogField field) {
        }
    }
}

