/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jem.internal.beaninfo.core.BeaninfoEntry;
import org.eclipse.jem.internal.beaninfo.ui.BIListElementSorter;
import org.eclipse.jem.internal.beaninfo.ui.BPBeaninfoListElement;
import org.eclipse.jem.internal.beaninfo.ui.BPListElement;
import org.eclipse.jem.internal.beaninfo.ui.BeanInfoUIMessages;
import org.eclipse.jem.internal.beaninfo.ui.BeaninfoEntrySearchpathDialog;
import org.eclipse.jem.internal.beaninfo.ui.BeaninfoPathsBlock;
import org.eclipse.jem.internal.beaninfo.ui.BuildSearchBasePage;
import org.eclipse.jem.internal.beaninfo.ui.SearchPathListLabelProvider;
import org.eclipse.jem.internal.beaninfo.ui.VariableSelectionBlock;
import org.eclipse.jem.internal.ui.core.JEMUIPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class BeaninfosWorkbookPage
extends BuildSearchBasePage {
    private BeaninfoPathsBlock biPathsBlock;
    private IJavaProject fCurrJProject;
    private ListDialogField fBeaninfosList;
    private IWorkspaceRoot fWorkspaceRoot;
    private IDialogSettings fDialogSettings;
    private Control fSWTControl;
    private IClasspathEntry[] resolvedList;
    private IClasspathEntry[] rawList;
    private SearchPathListLabelProvider labelProvider;
    private static final String DIALOGSTORE_LASTEXTJAR = "org.eclipse.jem.internal.beaninfo.ui.lastextjar";
    private static final String DIALOGSTORE_LASTVARIABLE = "org.eclipse.jem.internal.beaninfo.ui.lastvar";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public BeaninfosWorkbookPage(IWorkspaceRoot root, BeaninfoPathsBlock biPathsBlock, List interestedFieldsForEnableControl) {
        this.biPathsBlock = biPathsBlock;
        this.fWorkspaceRoot = root;
        this.fSWTControl = null;
        this.fDialogSettings = JEMUIPlugin.getPlugin().getDialogSettings();
        String[] stringArray = new String[9];
        stringArray[0] = BeanInfoUIMessages.getString("BeanInfosWorkbookPage.AddFolders");
        stringArray[1] = BeanInfoUIMessages.getString("BeanInfosWorkbookPage.AddJARs");
        stringArray[2] = BeanInfoUIMessages.getString("BeanInfosWorkbookPage.AddExternalJAR");
        stringArray[3] = BeanInfoUIMessages.getString("BeanInfosWorkbookPage.AddVariable");
        stringArray[4] = BeanInfoUIMessages.getString("BeanInfosWorkbookPage.AddProjects");
        stringArray[6] = BeanInfoUIMessages.getString("BeanInfosWorkbookPage.ModifyPaths");
        stringArray[8] = BeanInfoUIMessages.getString("BeanInfosWorkbookPage.Remove");
        String[] buttonLabels = stringArray;
        BeaninfosAdapter adapter = new BeaninfosAdapter();
        this.labelProvider = new SearchPathListLabelProvider();
        this.fBeaninfosList = new ListDialogField((IListAdapter)adapter, buttonLabels, (ILabelProvider)this.labelProvider);
        this.fBeaninfosList.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fBeaninfosList.setLabelText(BeanInfoUIMessages.getString("BeanInfosWorkbookPage.List.Text"));
        this.fBeaninfosList.setRemoveButtonIndex(8);
        this.fBeaninfosList.enableButton(6, false);
        this.fBeaninfosList.setViewerSorter((ViewerSorter)new BIListElementSorter());
        interestedFieldsForEnableControl.add(this.fBeaninfosList);
    }

    public void init(IJavaProject jproject) {
        this.fCurrJProject = jproject;
        this.labelProvider.setJavaProject(jproject);
        try {
            this.rawList = this.fCurrJProject.getRawClasspath();
            this.resolvedList = new IClasspathEntry[this.rawList.length];
            int i = 0;
            while (i < this.rawList.length) {
                this.resolvedList[i] = JavaCore.getResolvedClasspathEntry((IClasspathEntry)this.rawList[i]);
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            this.resolvedList = new IClasspathEntry[0];
            this.rawList = this.resolvedList;
        }
        this.updateBeaninfosList();
    }

    private void updateBeaninfosList() {
        List spelements = this.biPathsBlock.getSearchOrder().getElements();
        ArrayList<BPListElement> biElements = new ArrayList<BPListElement>(spelements.size());
        int i = 0;
        while (i < spelements.size()) {
            BPListElement spe = (BPListElement)spelements.get(i);
            if (spe instanceof BPBeaninfoListElement) {
                biElements.add(spe);
            }
            ++i;
        }
        this.fBeaninfosList.setElements(biElements);
    }

    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.fBeaninfosList}, (boolean)true, (int)-1, (int)-1);
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fBeaninfosList.setButtonsMinWidth(buttonBarWidth);
        this.fSWTControl = composite;
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return JEMUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private void beaninfosPageCustomButtonPressed(int index) {
        List beaninfoEntries = null;
        switch (index) {
            case 0: {
                beaninfoEntries = this.chooseClassContainers();
                break;
            }
            case 1: {
                beaninfoEntries = this.chooseJarFiles();
                break;
            }
            case 2: {
                beaninfoEntries = this.chooseExtJarFiles();
                break;
            }
            case 3: {
                beaninfoEntries = this.chooseVariableEntries();
                break;
            }
            case 4: {
                beaninfoEntries = this.chooseProjects();
                break;
            }
            case 6: {
                this.modifySearchPaths();
                return;
            }
        }
        if (beaninfoEntries != null) {
            this.fBeaninfosList.addElements(beaninfoEntries);
            this.fBeaninfosList.postSetSelection((ISelection)new StructuredSelection(beaninfoEntries));
        }
    }

    private void modifySearchPaths() {
        BPBeaninfoListElement elem = (BPBeaninfoListElement)this.fBeaninfosList.getSelectedElements().get(0);
        BeaninfoEntrySearchpathDialog dialog = new BeaninfoEntrySearchpathDialog(this.getShell(), elem, this.fCurrJProject);
        dialog.open();
    }

    private void beaninfosPageDialogFieldChanged() {
        if (this.fCurrJProject != null) {
            this.updateSearchpathList();
        }
    }

    private void updateSearchpathList() {
        List searchelements = this.biPathsBlock.getSearchOrder().getElements();
        List beaninfoelements = this.fBeaninfosList.getElements();
        boolean changeDone = false;
        ListIterator spitr = searchelements.listIterator(searchelements.size());
        while (spitr.hasPrevious()) {
            BPListElement element = (BPListElement)spitr.previous();
            if (!(element instanceof BPBeaninfoListElement) || beaninfoelements.remove(element)) continue;
            spitr.remove();
            changeDone = true;
        }
        searchelements.addAll(beaninfoelements);
        boolean bl = changeDone = changeDone || !beaninfoelements.isEmpty();
        if (changeDone) {
            this.biPathsBlock.setSearchOrderElements(searchelements);
        }
    }

    private List chooseClassContainers() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        Class[] classArray2 = new Class[2];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz2;
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[1] = clazz3;
        acceptedClasses = classArray2;
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, (Object[])this.getUsedContainers());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(BeanInfoUIMessages.getString("BeanInfosWorkbookPage.SelectionDialog.Classes.Title"));
        dialog.setMessage(BeanInfoUIMessages.getString("BeanInfosWorkbookPage.SelectionDialog.Classes.Prompt"));
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.fWorkspaceRoot);
        dialog.setInitialSelection((Object)this.fCurrJProject.getProject());
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            ArrayList<BPBeaninfoListElement> res = new ArrayList<BPBeaninfoListElement>(elements.length);
            int i = 0;
            while (i < elements.length) {
                BPBeaninfoListElement newGuy = this.newBPBeaninfoListElement((IResource)elements[i]);
                if (newGuy != null) {
                    res.add(newGuy);
                }
                ++i;
            }
            return res;
        }
        return null;
    }

    private List chooseJarFiles() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        ArchiveFileFilter filter = new ArchiveFileFilter(this.getUsedJARFiles(), true);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(BeanInfoUIMessages.getString("BeanInfosWorkbookPage.SelectionDialog.JARs.Title"));
        dialog.setMessage(BeanInfoUIMessages.getString("BeanInfosWorkbookPage.SelectionDialog.JARs.Message"));
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.fWorkspaceRoot);
        dialog.setInitialSelection((Object)this.fCurrJProject.getProject());
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            ArrayList<BPBeaninfoListElement> res = new ArrayList<BPBeaninfoListElement>(elements.length);
            int i = 0;
            while (i < elements.length) {
                BPBeaninfoListElement newGuy = this.newBPBeaninfoListElement((IResource)elements[i]);
                if (newGuy != null) {
                    res.add(newGuy);
                }
                ++i;
            }
            return res;
        }
        return null;
    }

    private IContainer[] getUsedContainers() {
        IResource resource;
        ArrayList<IResource> res = new ArrayList<IResource>();
        try {
            IPath outputLocation = this.fCurrJProject.getOutputLocation();
            if (outputLocation != null && (resource = this.fWorkspaceRoot.findMember(outputLocation)) instanceof IContainer) {
                res.add(resource);
            }
        }
        catch (JavaModelException e) {
            JEMUIPlugin.getPlugin().getLogger().log((Object)e.getStatus());
        }
        int i = 0;
        while (i < this.resolvedList.length) {
            if (this.resolvedList[i] != null && this.resolvedList[i].getEntryKind() == 3 && (resource = this.fWorkspaceRoot.findMember(this.resolvedList[i].getPath())) instanceof IContainer) {
                res.add(resource);
            }
            ++i;
        }
        List bilist = this.fBeaninfosList.getElements();
        int i2 = 0;
        while (i2 < bilist.size()) {
            BPListElement elem = (BPListElement)bilist.get(i2);
            if (elem.getEntry().getKind() == 3) {
                IResource resource2 = this.fWorkspaceRoot.findMember(elem.getEntry().getPath());
                res.add(resource2);
            }
            ++i2;
        }
        return res.toArray(new IContainer[res.size()]);
    }

    private IFile[] getUsedJARFiles() {
        ArrayList<IResource> res = new ArrayList<IResource>();
        int i = 0;
        while (i < this.resolvedList.length) {
            IResource resource;
            if (this.resolvedList[i] != null && this.resolvedList[i].getEntryKind() == 1 && (resource = this.fWorkspaceRoot.findMember(this.resolvedList[i].getPath())) instanceof IFile) {
                res.add(resource);
            }
            ++i;
        }
        List bilist = this.fBeaninfosList.getElements();
        int i2 = 0;
        while (i2 < bilist.size()) {
            IResource resource;
            BPListElement elem = (BPListElement)bilist.get(i2);
            if (elem.getEntry().getKind() == 1 && (resource = this.fWorkspaceRoot.findMember(elem.getEntry().getPath())) instanceof IFile) {
                res.add(resource);
            }
            ++i2;
        }
        return res.toArray(new IFile[res.size()]);
    }

    private BPBeaninfoListElement newBPBeaninfoListElement(IResource element) {
        if (element instanceof IContainer || element instanceof IFile) {
            IClasspathEntry cpe = JavaCore.newLibraryEntry((IPath)element.getFullPath(), null, null);
            BeaninfoEntry bie = new BeaninfoEntry(cpe, null, true);
            return new BPBeaninfoListElement(bie, null, false);
        }
        return null;
    }

    private List chooseExtJarFiles() {
        String lastUsedPath = this.fDialogSettings.get(DIALOGSTORE_LASTEXTJAR);
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        FileDialog dialog = new FileDialog(this.getShell(), 2);
        dialog.setText(BeanInfoUIMessages.getString("BeanInfosWorkbookPage.SelectionDialog.ExtJARs.Text"));
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        Path filterPath = new Path(dialog.getFilterPath());
        ArrayList<BPBeaninfoListElement> elems = new ArrayList<BPBeaninfoListElement>(nChosen);
        int i = 0;
        while (i < nChosen) {
            IPath path = filterPath.append(fileNames[i]).makeAbsolute();
            BPBeaninfoListElement newGuy = this.newBPBeaninfoListElement(path);
            if (newGuy != null) {
                elems.add(newGuy);
            }
            ++i;
        }
        this.fDialogSettings.put(DIALOGSTORE_LASTEXTJAR, filterPath.toOSString());
        return elems;
    }

    private BPBeaninfoListElement newBPBeaninfoListElement(IPath path) {
        int i = 0;
        while (i < this.resolvedList.length) {
            IClasspathEntry cpe = this.resolvedList[i];
            if (cpe != null && cpe.getEntryKind() == 1 && cpe.getPath().equals((Object)path)) {
                return null;
            }
            ++i;
        }
        List ours = this.fBeaninfosList.getElements();
        int i2 = 0;
        while (i2 < ours.size()) {
            BPBeaninfoListElement bpb = (BPBeaninfoListElement)ours.get(i2);
            if (bpb.getEntry().getKind() == 1 && bpb.getEntry().getPath().equals((Object)path)) {
                return null;
            }
            ++i2;
        }
        IClasspathEntry cpe = JavaCore.newLibraryEntry((IPath)path, null, null);
        BeaninfoEntry bie = new BeaninfoEntry(cpe, null, true);
        return new BPBeaninfoListElement(bie, null, false);
    }

    private List chooseProjects() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.jdt.core.IJavaProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        ArrayList<IJavaElement> allProjects = null;
        try {
            allProjects = new ArrayList<IJavaElement>(Arrays.asList(this.fCurrJProject.getJavaModel().getChildren()));
        }
        catch (JavaModelException javaModelException) {
            allProjects = Collections.EMPTY_LIST;
        }
        allProjects.removeAll(this.getUsedProjects());
        JavaElementLabelProvider lp = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)lp);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(BeanInfoUIMessages.getString("BeanInfosWorkbookPage.SelectionDialog.Projects.Title"));
        dialog.setMessage(BeanInfoUIMessages.getString("BeanInfosWorkbookPage.SelectionDialog.Projects.Prompt"));
        dialog.setElements(allProjects.toArray());
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            ArrayList<BPBeaninfoListElement> res = new ArrayList<BPBeaninfoListElement>(elements.length);
            int i = 0;
            while (i < elements.length) {
                try {
                    IClasspathEntry cpe = JavaCore.newProjectEntry((IPath)((IJavaProject)elements[i]).getCorrespondingResource().getFullPath());
                    BeaninfoEntry bie = new BeaninfoEntry(cpe, null, true);
                    res.add(new BPBeaninfoListElement(bie, null, false));
                }
                catch (JavaModelException javaModelException) {}
                ++i;
            }
            return res;
        }
        return null;
    }

    private List getUsedProjects() {
        ArrayList<IJavaProject> res = new ArrayList<IJavaProject>();
        res.add(this.fCurrJProject);
        IJavaModel jmodel = this.fCurrJProject.getJavaModel();
        int i = 0;
        while (i < this.resolvedList.length) {
            if (this.resolvedList[i] != null && this.resolvedList[i].getEntryKind() == 2) {
                res.add(jmodel.getJavaProject(this.resolvedList[i].getPath().segment(0)));
            }
            ++i;
        }
        List bilist = this.fBeaninfosList.getElements();
        int i2 = 0;
        while (i2 < bilist.size()) {
            BPListElement elem = (BPListElement)bilist.get(i2);
            if (elem.getEntry().getKind() == 2) {
                res.add(jmodel.getJavaProject(elem.getEntry().getPath().segment(0)));
            }
            ++i2;
        }
        return res;
    }

    private List chooseVariableEntries() {
        ArrayList<IPath> existingPaths = new ArrayList<IPath>();
        int i = 0;
        while (i < this.rawList.length) {
            if (this.rawList[i].getEntryKind() == 4) {
                existingPaths.add(this.rawList[i].getPath());
            }
            ++i;
        }
        List ours = this.fBeaninfosList.getElements();
        int i2 = 0;
        while (i2 < ours.size()) {
            BPBeaninfoListElement bpb = (BPBeaninfoListElement)ours.get(i2);
            if (bpb.getEntry().getKind() == 4) {
                existingPaths.add(bpb.getEntry().getPath());
            }
            ++i2;
        }
        VariableSelectionDialog dialog = new VariableSelectionDialog(this.getShell(), existingPaths);
        if (dialog.open() == 0) {
            IPath path = dialog.getVariable();
            IClasspathEntry cpe = JavaCore.newVariableEntry((IPath)path, null, null);
            IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)path);
            boolean isMissing = resolvedPath == null || !resolvedPath.toFile().isFile();
            return Collections.singletonList(new BPBeaninfoListElement(new BeaninfoEntry(cpe, null, true), null, isMissing));
        }
        return null;
    }

    public List getSelection() {
        return this.fBeaninfosList.getSelectedElements();
    }

    public void setSelection(List selElements) {
        this.fBeaninfosList.selectElements((ISelection)new StructuredSelection(selElements));
    }

    private class BeaninfosAdapter
    implements IDialogFieldListener,
    IListAdapter {
        BeaninfosAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            BeaninfosWorkbookPage.this.beaninfosPageCustomButtonPressed(index);
        }

        public void selectionChanged(ListDialogField field) {
            ListDialogField list;
            int selCnt = (list = field).getSelectedElements().size();
            list.enableButton(6, selCnt == 1);
        }

        public void dialogFieldChanged(DialogField field) {
            BeaninfosWorkbookPage.this.beaninfosPageDialogFieldChanged();
        }

        public void doubleClicked(ListDialogField field) {
        }
    }

    private class VariableSelectionDialog
    extends StatusDialog
    implements IStatusChangeListener {
        private VariableSelectionBlock fVariableSelectionBlock;

        public VariableSelectionDialog(Shell parent, List existingPaths) {
            super(parent);
            this.setTitle(NewWizardMessages.getString((String)"LibrariesWorkbookPage.VariableSelectionDialog.title"));
            String initVar = BeaninfosWorkbookPage.this.fDialogSettings.get(BeaninfosWorkbookPage.DIALOGSTORE_LASTVARIABLE);
            this.fVariableSelectionBlock = new VariableSelectionBlock(this, existingPaths, null, initVar, false);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Label message = new Label(composite, 64);
            message.setText(NewWizardMessages.getString((String)"LibrariesWorkbookPage.VariableSelectionDialog.message"));
            message.setLayoutData((Object)new GridData());
            Control inner = this.fVariableSelectionBlock.createControl(composite);
            inner.setLayoutData((Object)new GridData(1808));
            return composite;
        }

        protected void okPressed() {
            BeaninfosWorkbookPage.this.fDialogSettings.put(BeaninfosWorkbookPage.DIALOGSTORE_LASTVARIABLE, this.getVariable().segment(0));
            super.okPressed();
        }

        public void statusChanged(IStatus status) {
            this.updateStatus(status);
        }

        public IPath getVariable() {
            return this.fVariableSelectionBlock.getVariablePath();
        }
    }
}

