/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt.targetvm;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.ICallback;
import org.eclipse.jem.internal.proxy.common.ICallbackHandler;
import org.eclipse.jem.internal.proxy.common.ICallbackRunnable;
import org.eclipse.jem.internal.proxy.common.IVMServer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ve.internal.swt.targetvm.Environment;
import org.eclipse.ve.internal.swt.targetvm.IImageCapture;

public abstract class ControlManager
implements ICallback,
ControlListener {
    public static final int CO_RESIZED = 1;
    public static final int CO_MOVED = 2;
    public static final int CO_REFRESHED = 3;
    public static final int IMAGE_INITIAL_LENGTH = 4;
    public static final int IMAGE_FINISHED = 5;
    public static final int IMAGE_COLOR_MASKS = 6;
    protected Control fControl;
    protected IVMServer fServer;
    protected int fCallbackID;

    public void initializeCallback(IVMServer vmServer, int callbackID) {
        this.fServer = vmServer;
        this.fCallbackID = callbackID;
    }

    protected boolean isValidControl(Control control) {
        return control != null && !control.isDisposed();
    }

    public void setControl(final Control aControl) {
        final boolean[] queue = new boolean[1];
        Environment.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (ControlManager.this.isValidControl(ControlManager.this.fControl)) {
                    ControlManager.this.fControl.removeControlListener((ControlListener)ControlManager.this);
                }
                ControlManager.this.fControl = aControl;
                if (ControlManager.this.isValidControl(ControlManager.this.fControl)) {
                    ControlManager.this.fControl.addControlListener((ControlListener)ControlManager.this);
                    queue[0] = true;
                }
            }
        });
        if (queue[0]) {
            this.queueRefresh();
        }
    }

    private void queueRefresh() {
        Environment.getDisplay().syncExec(new Runnable(){

            public void run() {
            }
        });
        if (this.fServer != null) {
            try {
                this.fServer.doCallback(new ICallbackRunnable(){

                    public Object run(ICallbackHandler handler) throws CommandException {
                        return handler.callbackWithParms(ControlManager.this.fCallbackID, 3, null);
                    }
                });
            }
            catch (CommandException commandException) {}
        }
    }

    public void controlMoved(ControlEvent e) {
        final Point overallLocation = this.getLocation();
        if (this.fServer != null) {
            try {
                this.fServer.doCallback(new ICallbackRunnable(){

                    public Object run(ICallbackHandler handler) throws CommandException {
                        return handler.callbackWithParms(ControlManager.this.fCallbackID, 2, new Object[]{new Integer(overallLocation.x), new Integer(overallLocation.y)});
                    }
                });
            }
            catch (CommandException commandException) {}
        }
    }

    public void controlResized(final ControlEvent e) {
        if (this.fServer != null) {
            try {
                this.fServer.doCallback(new ICallbackRunnable(){

                    public Object run(ICallbackHandler handler) throws CommandException {
                        Control c = (Control)e.widget;
                        return handler.callbackWithParms(ControlManager.this.fCallbackID, 1, new Object[]{new Integer(c.getBounds().width), new Integer(c.getBounds().height)});
                    }
                });
            }
            catch (CommandException commandException) {}
        }
    }

    public Rectangle getBounds() {
        final Rectangle[] bounds = new Rectangle[1];
        if (this.isValidControl(this.fControl)) {
            Environment.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (ControlManager.this.isValidControl(ControlManager.this.fControl)) {
                        bounds[0] = ControlManager.this.fControl.getBounds();
                        if (ControlManager.this.fControl.getParent() != null) {
                            Point parentClientOrigin = ControlManager.this.getClientOrigin((Control)ControlManager.this.fControl.getParent());
                            bounds[0].x += parentClientOrigin.x;
                            bounds[0].y += parentClientOrigin.y;
                        }
                    }
                }
            });
        }
        return bounds[0];
    }

    public Rectangle getClientBox() {
        final Rectangle[] clientBox = new Rectangle[1];
        if (this.isValidControl(this.fControl)) {
            Environment.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (ControlManager.this.isValidControl(ControlManager.this.fControl)) {
                        clientBox[0] = ((Composite)ControlManager.this.fControl).getClientArea();
                        Point clientOrigin = ControlManager.this.getClientOrigin(ControlManager.this.fControl);
                        clientBox[0].x = clientOrigin.x;
                        clientBox[0].y = clientOrigin.y;
                    }
                }
            });
        }
        return clientBox[0];
    }

    private Point getClientOrigin(Control aControl) {
        Point displayClientOrigin = aControl.toDisplay(0, 0);
        Point locationRelativeToDisplay = aControl.getParent() == null ? aControl.getLocation() : aControl.getParent().toDisplay(aControl.getLocation());
        return new Point(displayClientOrigin.x - locationRelativeToDisplay.x, displayClientOrigin.y - locationRelativeToDisplay.y);
    }

    public Point getLocation() {
        return this.getOverallLocation();
    }

    private Point getOverallLocation() {
        final Point[] location = new Point[1];
        if (this.isValidControl(this.fControl)) {
            Environment.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (ControlManager.this.isValidControl(ControlManager.this.fControl)) {
                        if (ControlManager.this.fControl.getParent() == null) {
                            location[0] = ControlManager.this.fControl.getLocation();
                        } else {
                            Composite parentControl = ControlManager.this.fControl.getParent();
                            Point parentClientOrigin = ControlManager.this.getClientOrigin((Control)parentControl);
                            Point controlLocation = ControlManager.this.fControl.getLocation();
                            location[0] = new Point(parentClientOrigin.x + controlLocation.x, parentClientOrigin.y + controlLocation.y);
                        }
                    }
                }
            });
        }
        return location[0];
    }

    public abstract IImageCapture getImageCapturer();

    public void captureImage() {
        if (this.isValidControl(this.fControl)) {
            Environment.getDisplay().syncExec(new Runnable(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    FilterOutputStream os;
                    block11: {
                        if (!ControlManager.this.isValidControl(ControlManager.this.fControl)) return;
                        os = null;
                        Image image = null;
                        try {
                            try {
                                DataOutputStream outputStream = new DataOutputStream(ControlManager.this.fServer.requestStream(ControlManager.this.fCallbackID, 0));
                                IImageCapture grabber = ControlManager.this.getImageCapturer();
                                image = grabber.getImage(ControlManager.this.fControl, true);
                                ImageData imageData = image.getImageData();
                                image.dispose();
                                image = null;
                                byte[] data = imageData.data;
                                ControlManager.this.fServer.doCallback(new ICallbackRunnable(this, data, imageData){
                                    final /* synthetic */ 9 this$1;
                                    private final /* synthetic */ byte[] val$data;
                                    private final /* synthetic */ ImageData val$imageData;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$data = byArray;
                                        this.val$imageData = imageData;
                                    }

                                    public Object run(ICallbackHandler handler) throws CommandException {
                                        return handler.callbackWithParms(9.access$0(this.this$1).fCallbackID, 4, new Object[]{new Integer(this.val$data.length), new Integer(this.val$imageData.width), new Integer(this.val$imageData.height)});
                                    }
                                });
                                ControlManager.this.fServer.doCallback(new ICallbackRunnable(this, imageData){
                                    final /* synthetic */ 9 this$1;
                                    private final /* synthetic */ ImageData val$imageData;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$imageData = imageData;
                                    }

                                    public Object run(ICallbackHandler handler) throws CommandException {
                                        return handler.callbackWithParms(9.access$0(this.this$1).fCallbackID, 6, new Object[]{new Integer(this.val$imageData.depth), new Integer(this.val$imageData.palette.redMask), new Integer(this.val$imageData.palette.greenMask), new Integer(this.val$imageData.palette.blueMask)});
                                    }
                                });
                                int i = 0;
                                while (true) {
                                    if (i >= data.length) {
                                        outputStream.close();
                                        os = null;
                                        ControlManager.this.fServer.doCallback(new ICallbackRunnable(this){
                                            final /* synthetic */ 9 this$1;
                                            {
                                                this.this$1 = var1_1;
                                            }

                                            public Object run(ICallbackHandler handler) throws CommandException {
                                                return handler.callbackWithParms(9.access$0(this.this$1).fCallbackID, 5, null);
                                            }
                                        });
                                    }
                                    outputStream.write(data[i]);
                                    ++i;
                                }
                            }
                            catch (Exception exc) {
                                exc.printStackTrace();
                            }
                        }
                        catch (Throwable throwable) {
                            Object var8_10 = null;
                            if (image != null) {
                                image.dispose();
                            }
                            if (os == null) throw throwable;
                            try {
                                os.close();
                                throw throwable;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            throw throwable;
                        }
                        {
                            Object var8_11 = null;
                            if (image == null) break block11;
                        }
                        image.dispose();
                    }
                    if (os == null) return;
                    try {}
                    catch (IOException e) {
                        e.printStackTrace();
                        return;
                    }
                    os.close();
                }

                static /* synthetic */ ControlManager access$0(9 var0) {
                    return var0.ControlManager.this;
                }
            });
        }
    }

    public abstract void addShellListener(Shell var1);
}

