/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.Spinner;
import org.eclipse.ve.internal.swt.PropertyEditor;

public class ColorPropertyEditor
implements PropertyEditor {
    private static final String BUNDLE_NAME = "org.eclipse.ve.internal.swt.colorpropertyeditor";
    private static ResourceBundle messages = ResourceBundle.getBundle("org.eclipse.ve.internal.swt.colorpropertyeditor");
    private List fPropertyChangeListeners;
    private IJavaObjectInstance fExistingValue;
    private static final String COLOR_PREFIX = "org.eclipse.swt.SWT.COLOR_";
    private static final String[] basicColorNames = new String[]{messages.getString("black"), messages.getString("blue"), messages.getString("cyan"), messages.getString("gray"), messages.getString("green"), messages.getString("magenta"), messages.getString("red"), messages.getString("white"), messages.getString("yellow"), messages.getString("darkBlue"), messages.getString("darkCyan"), messages.getString("darkGray"), messages.getString("darkGreen"), messages.getString("darkMagenta"), messages.getString("darkRed"), messages.getString("darkYellow")};
    private static final String[] basicColorConstants = new String[]{"BLACK", "BLUE", "CYAN", "GRAY", "GREEN", "MAGENTA", "RED", "WHITE", "YELLOW", "DARK_BLUE", "DARK_CYAN", "DARK_GRAY", "DARK_GREEN", "DARK_MAGENTA", "DARK_RED", "DARK_YELLOW"};
    private static final int[] basicColorConstantValues = new int[]{2, 9, 13, 15, 5, 11, 3, 1, 7, 10, 14, 16, 6, 12, 4, 8};
    private static Color[] basicColorValues = new Color[basicColorConstantValues.length];
    private Image[] basicColorImages = new Image[basicColorValues.length];
    private static final String[] systemColorNames = new String[]{messages.getString("infoBackground"), messages.getString("infoForeground"), messages.getString("listBackground"), messages.getString("listForeground"), messages.getString("listSeletion"), messages.getString("listSelectionText"), messages.getString("titleBackground"), messages.getString("titleBackgroundGradient"), messages.getString("titleForeground"), messages.getString("titleInactiveBackground"), messages.getString("titleInactiveBackgroundGradient"), messages.getString("titleInactiveForeground"), messages.getString("widgetBackground"), messages.getString("widgetBorder"), messages.getString("widgetDarkShadow"), messages.getString("widgetForeground"), messages.getString("widgetHighlightShadow"), messages.getString("widgetLightShadow"), messages.getString("widgetNormalShadow")};
    private static final String[] systemColorConstants = new String[]{"INFO_BACKGROUND", "INFO_FOREGROUND", "LIST_BACKGROUND", "LIST_FOREGROUND", "LIST_SELECTION", "LIST_SELECTION_TEXT", "TITLE_BACKGROUND", "TITLE_BACKGROUND_GRADIENT", "TITLE_FOREGROUND", "TITLE_INACTIVE_BACKGROUND", "TITLE_INACTIVE_BACKGROUND_GRADIENT", "TITLE_INACTIVE_FOREGROUND", "WIDGET_BACKGROUND", "WIDGET_BORDER", "WIDGET_DARK_SHADOW", "WIDGET_FOREGROUND", "WIDGET_HIGHLIGHT_SHADOW", "WIDGET_LIGHT_SHADOW", "WIDGET_NORMAL_SHADOW"};
    private static final int[] systemColorConstantValues = new int[]{29, 28, 25, 24, 26, 27, 31, 32, 30, 34, 35, 33, 22, 23, 17, 21, 20, 19, 18};
    private static Color[] systemColorValues = new Color[systemColorConstantValues.length];
    private Image[] systemColorImages = new Image[systemColorValues.length];
    private Color black;
    private Composite control = null;
    private PreviewPanel preview = null;
    private Table basicTable;
    private Table systemTable;
    private Spinner redSpinner;
    private Spinner greenSpinner;
    private Spinner blueSpinner;
    private Scale redScale;
    private Scale greenScale;
    private Scale blueScale;
    private Color color = null;
    private boolean isNamed = false;
    private boolean isBasic = false;
    private boolean isSystem = false;
    private boolean changeInProcess = false;
    private static final int NAMED_SWATCH_SIZE = 10;
    private static final int NAMED_LIST_HEIGHT = 175;
    private static final int NAMED_LIST_WIDTH = 150;

    public ColorPropertyEditor() {
    }

    public ColorPropertyEditor(Color initialColor) {
        this.setColor(initialColor);
    }

    public Control createControl(Composite parent, int style) {
        return this.createControl(parent, style, true);
    }

    public Control createControl(Composite parent, int style, boolean showPreview) {
        if (this.control == null || this.control.isDisposed()) {
            this.control = new Composite(parent, style);
            this.createColorFromProxy((Control)this.control);
            this.black = this.control.getDisplay().getSystemColor(2);
            if (this.color == null) {
                this.setColor(this.control.getDisplay().getSystemColor(6), true);
                this.isBasic = true;
            }
            GridLayout grid = new GridLayout();
            grid.numColumns = 1;
            grid.verticalSpacing = 5;
            this.control.setLayout((Layout)grid);
            TabFolder tabPane = new TabFolder(this.control, 0);
            GridData tabGD = new GridData();
            tabGD.verticalAlignment = 4;
            tabGD.horizontalAlignment = 4;
            tabGD.grabExcessHorizontalSpace = true;
            tabGD.grabExcessVerticalSpace = true;
            tabPane.setLayoutData((Object)tabGD);
            TabItem namedPage = new TabItem(tabPane, 0);
            namedPage.setText(messages.getString("namedTabTitle"));
            Control namedPageContents = this.makeNamedPage((Composite)tabPane, 0);
            namedPage.setControl(namedPageContents);
            TabItem rgbPage = new TabItem(tabPane, 0);
            rgbPage.setText(messages.getString("rgbTabTitle"));
            Control rgbPageContents = this.makeRGBPage((Composite)tabPane, 0);
            rgbPage.setControl(rgbPageContents);
            if (!this.isNamed) {
                tabPane.setSelection(1);
            }
            if (showPreview) {
                this.preview = new PreviewPanel();
                Control pControl = this.preview.createControl(this.control, 0, this.getColor());
                GridData previewGD = new GridData();
                previewGD.verticalAlignment = 2;
                previewGD.horizontalAlignment = 4;
                previewGD.grabExcessHorizontalSpace = true;
                previewGD.grabExcessVerticalSpace = false;
                pControl.setLayoutData((Object)previewGD);
            }
            this.control.pack();
        }
        return this.control;
    }

    private Control makeNamedPage(Composite parent, int style) {
        Composite page = new Composite(parent, style);
        int selection = -1;
        this.initializeColorImages((Device)page.getDisplay());
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        rowLayout.pack = true;
        rowLayout.justify = true;
        page.setLayout((Layout)rowLayout);
        Group basicGroup = new Group(page, 0);
        basicGroup.setText(messages.getString("basicColorsGroupTitle"));
        basicGroup.setLayout((Layout)new RowLayout());
        this.basicTable = new Table((Composite)basicGroup, 68356);
        this.basicTable.setHeaderVisible(false);
        this.basicTable.setLinesVisible(false);
        int i = 0;
        while (i < basicColorNames.length) {
            TableItem ti = new TableItem(this.basicTable, 0);
            ti.setText(basicColorNames[i]);
            ti.setData((Object)new Integer(i));
            ti.setImage(this.makeSwatchIcon((Device)ti.getDisplay(), basicColorValues[i]));
            if (this.color.equals((Object)basicColorValues[i])) {
                selection = i;
            }
            ++i;
        }
        if (selection != -1) {
            this.basicTable.setSelection(selection);
        }
        RowData bRD = new RowData();
        bRD.width = 150;
        bRD.height = 175;
        this.basicTable.setLayoutData((Object)bRD);
        this.basicTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.changeSelection((Table)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.changeSelection((Table)e.widget);
            }

            private void changeSelection(Table t) {
                int value;
                TableItem[] items = t.getSelection();
                if (items.length > 0 && (value = ((Integer)items[0].getData()).intValue()) < basicColorValues.length) {
                    ColorPropertyEditor.this.changeInProcess = true;
                    ColorPropertyEditor.this.setColor(basicColorValues[value], true);
                    ColorPropertyEditor.this.systemTable.deselectAll();
                    ColorPropertyEditor.this.updateSpinnersFromColor();
                    ColorPropertyEditor.this.isBasic = true;
                    ColorPropertyEditor.this.changeInProcess = false;
                }
            }
        });
        Group systemGroup = new Group(page, 0);
        systemGroup.setText(messages.getString("SystemColorsGroupTitle"));
        systemGroup.setLayout((Layout)new RowLayout());
        this.systemTable = new Table((Composite)systemGroup, 68356);
        this.systemTable.setHeaderVisible(false);
        this.systemTable.setLinesVisible(false);
        int i2 = 0;
        while (i2 < systemColorNames.length) {
            TableItem ti = new TableItem(this.systemTable, 0);
            ti.setText(systemColorNames[i2]);
            ti.setData((Object)new Integer(i2));
            ti.setImage(this.makeSwatchIcon((Device)ti.getDisplay(), systemColorValues[i2]));
            ++i2;
        }
        RowData sRD = new RowData();
        sRD.width = 150;
        sRD.height = 175;
        this.systemTable.setLayoutData((Object)sRD);
        this.systemTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.changeSelection((Table)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.changeSelection((Table)e.widget);
            }

            private void changeSelection(Table t) {
                int value;
                TableItem[] items = t.getSelection();
                if (items.length > 0 && (value = ((Integer)items[0].getData()).intValue()) < systemColorValues.length) {
                    ColorPropertyEditor.this.changeInProcess = true;
                    ColorPropertyEditor.this.setColor(systemColorValues[value], true);
                    ColorPropertyEditor.this.basicTable.deselectAll();
                    ColorPropertyEditor.this.updateSpinnersFromColor();
                    ColorPropertyEditor.this.isSystem = true;
                    ColorPropertyEditor.this.changeInProcess = false;
                }
            }
        });
        page.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Image img;
                int i = 0;
                while (i < ColorPropertyEditor.this.basicColorImages.length) {
                    img = ColorPropertyEditor.this.basicColorImages[i];
                    if (img != null && !img.isDisposed()) {
                        img.dispose();
                        img = null;
                    }
                    ++i;
                }
                i = 0;
                while (i < ColorPropertyEditor.this.systemColorImages.length) {
                    img = ColorPropertyEditor.this.systemColorImages[i];
                    if (img != null && !img.isDisposed()) {
                        img.dispose();
                        img = null;
                    }
                    ++i;
                }
            }
        });
        return page;
    }

    private void initializeColorConstants(Device d) {
        if (basicColorValues[0] == null || basicColorValues[0].isDisposed()) {
            int i = 0;
            while (i < basicColorConstantValues.length) {
                ColorPropertyEditor.basicColorValues[i] = d.getSystemColor(basicColorConstantValues[i]);
                ++i;
            }
            i = 0;
            while (i < systemColorConstantValues.length) {
                ColorPropertyEditor.systemColorValues[i] = d.getSystemColor(systemColorConstantValues[i]);
                ++i;
            }
        }
    }

    private void initializeColorImages(Device d) {
        this.initializeColorConstants(d);
        int i = 0;
        while (i < this.basicColorImages.length) {
            this.basicColorImages[i] = this.makeSwatchIcon(d, basicColorValues[i]);
            ++i;
        }
        i = 0;
        while (i < this.systemColorImages.length) {
            this.systemColorImages[i] = this.makeSwatchIcon(d, systemColorValues[i]);
            ++i;
        }
    }

    private Image makeSwatchIcon(Device d, Color c) {
        Rectangle swatchBounds = new Rectangle(0, 0, 10, 10);
        Image img = new Image(d, swatchBounds);
        GC draw = new GC((Drawable)img);
        draw.setBackground(c);
        draw.fillRectangle(swatchBounds);
        draw.setForeground(this.black);
        draw.drawRectangle(swatchBounds);
        draw.dispose();
        return img;
    }

    private Control makeRGBPage(Composite parent, int style) {
        Composite page = new Composite(parent, style);
        GridLayout grid = new GridLayout();
        grid.numColumns = 1;
        grid.verticalSpacing = 5;
        grid.marginHeight = 5;
        grid.marginWidth = 5;
        page.setLayout((Layout)grid);
        Composite rgbPanel = new Composite(page, 0);
        GridData GD1 = new GridData();
        GD1.grabExcessHorizontalSpace = true;
        GD1.grabExcessVerticalSpace = true;
        GD1.horizontalAlignment = 2;
        GD1.verticalAlignment = 2;
        rgbPanel.setLayoutData((Object)GD1);
        GridLayout grid2 = new GridLayout();
        grid2.numColumns = 3;
        grid2.verticalSpacing = 5;
        grid2.horizontalSpacing = 10;
        grid2.marginHeight = 5;
        grid2.marginWidth = 5;
        rgbPanel.setLayout((Layout)grid2);
        Label redL = new Label(rgbPanel, 0);
        redL.setText(messages.getString("redSliderLabel"));
        this.redScale = new Scale(rgbPanel, 0);
        this.redScale.setMinimum(0);
        this.redScale.setMaximum(255);
        this.redScale.setPageIncrement(51);
        this.redScale.setSelection(this.color.getRed());
        this.redSpinner = new Spinner(rgbPanel, 0, this.color.getRed());
        this.redSpinner.setMinimum(0);
        this.redSpinner.setMaximum(255);
        Label greenL = new Label(rgbPanel, 0);
        greenL.setText(messages.getString("greenSliderLabel"));
        this.greenScale = new Scale(rgbPanel, 0);
        this.greenScale.setMinimum(0);
        this.greenScale.setMaximum(255);
        this.greenScale.setPageIncrement(51);
        this.greenScale.setSelection(this.color.getGreen());
        this.greenSpinner = new Spinner(rgbPanel, 0, this.color.getGreen());
        this.greenSpinner.setMinimum(0);
        this.greenSpinner.setMaximum(255);
        Label blueL = new Label(rgbPanel, 0);
        blueL.setText(messages.getString("blueSliderLabel"));
        this.blueScale = new Scale(rgbPanel, 0);
        this.blueScale.setMinimum(0);
        this.blueScale.setMaximum(255);
        this.blueScale.setPageIncrement(51);
        this.blueScale.setSelection(this.color.getBlue());
        this.blueSpinner = new Spinner(rgbPanel, 0, this.color.getBlue());
        this.blueSpinner.setMinimum(0);
        this.blueSpinner.setMaximum(255);
        Listener modifyListener = new Listener(){

            public void handleEvent(Event e) {
                Spinner s = (Spinner)e.widget;
                if (s == ColorPropertyEditor.this.redSpinner) {
                    ColorPropertyEditor.this.redScale.setSelection(ColorPropertyEditor.this.redSpinner.getValue());
                } else if (s == ColorPropertyEditor.this.greenSpinner) {
                    ColorPropertyEditor.this.greenScale.setSelection(ColorPropertyEditor.this.greenSpinner.getValue());
                } else if (s == ColorPropertyEditor.this.blueSpinner) {
                    ColorPropertyEditor.this.blueScale.setSelection(ColorPropertyEditor.this.blueSpinner.getValue());
                }
                s.setEnabled(true);
                if (!ColorPropertyEditor.this.changeInProcess) {
                    ColorPropertyEditor.this.updateColorFromSpinners();
                    ColorPropertyEditor.this.basicTable.deselectAll();
                    ColorPropertyEditor.this.systemTable.deselectAll();
                }
            }
        };
        this.redSpinner.addModifyListener(modifyListener);
        this.greenSpinner.addModifyListener(modifyListener);
        this.blueSpinner.addModifyListener(modifyListener);
        SelectionAdapter scaleListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == ColorPropertyEditor.this.redScale) {
                    ColorPropertyEditor.this.redSpinner.setValue(ColorPropertyEditor.this.redScale.getSelection());
                    ColorPropertyEditor.this.redSpinner.setEnabled(true);
                } else if (e.widget == ColorPropertyEditor.this.greenScale) {
                    ColorPropertyEditor.this.greenSpinner.setValue(ColorPropertyEditor.this.greenScale.getSelection());
                    ColorPropertyEditor.this.greenSpinner.setEnabled(true);
                } else if (e.widget == ColorPropertyEditor.this.blueScale) {
                    ColorPropertyEditor.this.blueSpinner.setValue(ColorPropertyEditor.this.blueScale.getSelection());
                    ColorPropertyEditor.this.blueSpinner.setEnabled(true);
                }
            }
        };
        this.redScale.addSelectionListener((SelectionListener)scaleListener);
        this.blueScale.addSelectionListener((SelectionListener)scaleListener);
        this.greenScale.addSelectionListener((SelectionListener)scaleListener);
        Button externalChooser = new Button(page, 8);
        externalChooser.setText(messages.getString("advancedButton"));
        externalChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = e.widget.getDisplay().getActiveShell();
                ColorDialog c = new ColorDialog(shell, 65536);
                RGB result = c.open();
                if (result != null) {
                    ColorPropertyEditor.this.redSpinner.setValue(result.red);
                    ColorPropertyEditor.this.greenSpinner.setValue(result.green);
                    ColorPropertyEditor.this.blueSpinner.setValue(result.blue);
                }
            }
        });
        GridData GD2 = new GridData();
        GD2.grabExcessHorizontalSpace = true;
        GD2.grabExcessVerticalSpace = true;
        GD2.horizontalAlignment = 3;
        GD2.verticalAlignment = 3;
        externalChooser.setLayoutData((Object)GD2);
        page.pack();
        return page;
    }

    private void updateColorFromSpinners() {
        Color c = new Color((Device)this.control.getDisplay(), this.redSpinner.getValue(), this.greenSpinner.getValue(), this.blueSpinner.getValue());
        this.setColor(c, false);
    }

    private void updateSpinnersFromColor() {
        Color c = this.getColor();
        this.redSpinner.setValue(c.getRed());
        this.greenSpinner.setValue(c.getGreen());
        this.blueSpinner.setValue(c.getBlue());
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.setColor(c, false);
    }

    private void setColor(Color c, boolean named) {
        if (this.color != null && !this.color.isDisposed() && !this.isNamed) {
            Color color = this.color;
            synchronized (color) {
                this.color.dispose();
            }
        }
        this.color = c;
        this.isNamed = named;
        this.isBasic = false;
        this.isSystem = false;
        if (this.preview != null) {
            this.preview.paint();
        }
        if (this.fPropertyChangeListeners != null) {
            Iterator iter = this.fPropertyChangeListeners.iterator();
            while (iter.hasNext()) {
                ((PropertyChangeListener)iter.next()).propertyChange(new PropertyChangeEvent(this, "value", c, null));
            }
        }
    }

    public void setValue(Object value) {
        if (value instanceof Color) {
            this.setColor((Color)value);
        }
    }

    public Object getValue() {
        return this.getColor();
    }

    public String getJavaInitializationString() {
        String result = "null";
        Color color = this.color;
        synchronized (color) {
            if (this.color != null) {
                if (!this.isNamed) {
                    result = "new org.eclipse.swt.graphics.Color(org.eclipse.swt.widgets.Display.getDefault(), " + this.color.getRed() + ", " + this.color.getGreen() + ", " + this.color.getBlue() + ")";
                } else {
                    this.initializeColorConstants((Device)this.control.getDisplay());
                    if (this.isBasic) {
                        int i = 0;
                        while (i < basicColorValues.length) {
                            if (this.color.getRGB().equals((Object)basicColorValues[i].getRGB())) {
                                result = "org.eclipse.swt.widgets.Display.getDefault().getSystemColor(org.eclipse.swt.SWT.COLOR_" + basicColorConstants[i] + ")";
                                break;
                            }
                            ++i;
                        }
                    } else if (this.isSystem) {
                        int i = 0;
                        while (i < systemColorValues.length) {
                            if (this.color.getRGB().equals((Object)systemColorValues[i].getRGB())) {
                                result = "org.eclipse.swt.widgets.Display.getDefault().getSystemColor(org.eclipse.swt.SWT.COLOR_" + systemColorConstants[i] + ")";
                                break;
                            }
                            ++i;
                        }
                    }
                }
            }
        }
        return result;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.fPropertyChangeListeners == null) {
            this.fPropertyChangeListeners = new ArrayList(1);
        }
        this.fPropertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.fPropertyChangeListeners != null) {
            this.fPropertyChangeListeners.remove(listener);
        }
    }

    public String getText() {
        if (this.color != null) {
            return this.color.toString();
        }
        if (this.fExistingValue != null) {
            return BeanProxyUtilities.getBeanProxy((IJavaInstance)this.fExistingValue).toBeanString();
        }
        return "";
    }

    public void setJavaObjectInstanceValue(IJavaObjectInstance value) {
        this.fExistingValue = value;
        this.color = null;
    }

    public void createColorFromProxy(Control control) {
        if (this.fExistingValue == null || this.color != null) {
            return;
        }
        try {
            IBeanProxy colorProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)this.fExistingValue);
            IBeanTypeProxy colorType = colorProxy.getTypeProxy();
            IMethodProxy getBlue = colorType.getMethodProxy("getBlue");
            IMethodProxy getGreen = colorType.getMethodProxy("getGreen");
            IMethodProxy getRed = colorType.getMethodProxy("getRed");
            int blue = ((IIntegerBeanProxy)getBlue.invoke(colorProxy)).intValue();
            int green = ((IIntegerBeanProxy)getGreen.invoke(colorProxy)).intValue();
            int red = ((IIntegerBeanProxy)getRed.invoke(colorProxy)).intValue();
            this.color = new Color((Device)control.getDisplay(), red, green, blue);
        }
        catch (ThrowableProxy throwableProxy) {}
    }

    private class PreviewPanel {
        private Group control;
        private Canvas canvas;
        private Color initial;
        private Color black;
        private Color white;
        private static final int spacing = 5;
        private static final int bigRect = 25;
        private static final int medRect = 15;
        private static final int smRect = 5;
        private static final int swatchWidth = 50;
        private static final int swatchHeight = 25;
        private final String previewText = ColorPropertyEditor.access$0().getString("previewText");

        PreviewPanel() {
        }

        public Control createControl(Composite parent, int style, Color initialColor) {
            if (this.control == null) {
                this.control = new Group(parent, style);
                this.control.setText(messages.getString("previewGroupTitle"));
                RowLayout rowLayout = new RowLayout();
                rowLayout.wrap = false;
                rowLayout.pack = true;
                rowLayout.justify = true;
                this.control.setLayout((Layout)rowLayout);
                this.canvas = new Canvas((Composite)this.control, 0);
                this.black = this.canvas.getDisplay().getSystemColor(2);
                this.white = this.canvas.getDisplay().getSystemColor(1);
                this.canvas.setLayoutData((Object)new RowData(this.computeDrawingSize()));
                this.control.pack();
                this.canvas.addPaintListener(new PaintListener(this){
                    final /* synthetic */ PreviewPanel this$1;
                    {
                        this.this$1 = previewPanel;
                    }

                    public void paintControl(PaintEvent e) {
                        this.this$1.paint();
                    }
                });
                this.initial = new Color((Device)this.control.getDisplay(), initialColor.getRGB());
                this.control.addDisposeListener(new DisposeListener(this){
                    final /* synthetic */ PreviewPanel this$1;
                    {
                        this.this$1 = previewPanel;
                    }

                    public void widgetDisposed(DisposeEvent e) {
                        if (PreviewPanel.access$0(this.this$1) != null && !PreviewPanel.access$0(this.this$1).isDisposed()) {
                            PreviewPanel.access$0(this.this$1).dispose();
                            PreviewPanel.access$1(this.this$1, null);
                        }
                    }
                });
                this.paint();
            }
            return this.control;
        }

        private Point computeDrawingSize() {
            GC surface = new GC((Drawable)this.canvas);
            Point previewSize = surface.stringExtent(this.previewText);
            surface.dispose();
            int width = 150 + previewSize.x + 5;
            int textHeight = (previewSize.y + 5) * 3 + 10;
            int shapesHeight = 55;
            int height = textHeight > shapesHeight ? textHeight : shapesHeight;
            return new Point(width, height);
        }

        public void paint() {
            Color current;
            int x = 0;
            int y = 0;
            Color color = current = ColorPropertyEditor.this.getColor();
            synchronized (color) {
                if (current == null || current.isDisposed()) {
                    return;
                }
                GC surface = new GC((Drawable)this.canvas);
                surface.setBackground(this.white);
                surface.fillRectangle(x, y, 25, 25);
                surface.setBackground(current);
                surface.fillRectangle(x + 5, y + 5, 15, 15);
                surface.setBackground(this.white);
                surface.fillRectangle(x + 10, y + 10, 5, 5);
                x = x + 25 + 5;
                surface.setBackground(this.black);
                surface.fillRectangle(x, y, 25, 25);
                surface.setBackground(current);
                surface.fillRectangle(x + 5, y + 5, 15, 15);
                surface.setBackground(this.white);
                surface.fillRectangle(x + 10, y + 10, 5, 5);
                x = x + 25 + 5;
                surface.setBackground(this.white);
                surface.fillRectangle(x, y, 25, 25);
                surface.setBackground(current);
                surface.fillRectangle(x + 5, y + 5, 15, 15);
                surface.setBackground(this.black);
                surface.fillRectangle(x + 10, y + 10, 5, 5);
                x = 0;
                y = y + 25 + 5;
                surface.setBackground(current);
                surface.fillRectangle(x, y, 25, 25);
                x = x + 25 + 5;
                surface.setBackground(this.white);
                surface.fillRectangle(x, y, 25, 25);
                surface.setBackground(current);
                surface.fillRectangle(x + 5, y + 5, 15, 15);
                x = x + 25 + 5;
                surface.setBackground(this.black);
                surface.fillRectangle(x, y, 25, 25);
                surface.setBackground(current);
                surface.fillRectangle(x + 5, y + 5, 15, 15);
                x = x + 25 + 5;
                y = 0;
                Point textSize = surface.stringExtent(this.previewText);
                surface.setForeground(current);
                surface.drawText(this.previewText, x + 3, y + 3, true);
                y = y + textSize.y + 10;
                surface.setBackground(current);
                surface.fillRectangle(x, y, textSize.x + 5, textSize.y + 5);
                surface.setForeground(this.black);
                surface.drawText(this.previewText, x + 3, y + 3, true);
                y = y + textSize.y + 10;
                surface.setBackground(this.white);
                surface.fillRectangle(x, y, textSize.x + 5, textSize.y + 5);
                surface.setForeground(current);
                surface.drawText(this.previewText, x + 3, y + 3, true);
                x = x + textSize.x + 5 + 5;
                y = 0;
                surface.setBackground(this.initial);
                surface.fillRectangle(x, y, 50, 25);
                surface.setBackground(current);
                surface.fillRectangle(x, y += 25, 50, 25);
                surface.dispose();
            }
        }

        static /* synthetic */ Color access$0(PreviewPanel previewPanel) {
            return previewPanel.initial;
        }

        static /* synthetic */ void access$1(PreviewPanel previewPanel, Color color) {
            previewPanel.initial = color;
        }
    }
}

