/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.swt.ControlGraphicalEditPart;

public class ControlDirectEditManager
extends DirectEditManager {
    private Font scaledFont;
    private EStructuralFeature sfProperty;

    public ControlDirectEditManager(ControlGraphicalEditPart source, Class editorType, CellEditorLocator locator, EStructuralFeature property) {
        super((GraphicalEditPart)source, editorType, locator);
        this.sfProperty = property;
    }

    protected void bringDown() {
        Font disposeFont = this.scaledFont;
        this.scaledFont = null;
        super.bringDown();
        if (disposeFont != null) {
            disposeFont.dispose();
        }
    }

    protected void initCellEditor() {
        IJavaObjectInstance textObj;
        String initialText = "";
        IJavaObjectInstance component = (IJavaObjectInstance)this.getEditPart().getModel();
        if (component.eIsSet(this.sfProperty) && (textObj = (IJavaObjectInstance)component.eGet(this.sfProperty)) != null) {
            try {
                IBeanProxyHost host = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)component);
                IBeanProxy propProxy = host.getBeanPropertyProxyValue(this.sfProperty);
                initialText = ((IStringBeanProxy)propProxy).stringValue();
            }
            catch (Exception exception) {}
        }
        this.getCellEditor().setValue((Object)initialText);
        Text text = (Text)this.getCellEditor().getControl();
        IFigure figure = this.getEditPart().getFigure();
        this.scaledFont = figure.getFont();
        FontData data = this.scaledFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, data.getHeight());
        this.getEditPart().getFigure().translateToAbsolute((Translatable)fontSize);
        data.setHeight(fontSize.height);
        this.scaledFont = new Font(null, data);
        text.setFont(this.scaledFont);
        text.selectAll();
    }
}

