/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.swt.FontJavaClassLabelProvider;
import org.eclipse.ve.internal.swt.PropertyEditor;

public class FontPropertyEditor
implements PropertyEditor {
    private static final String BUNDLE_NAME = "org.eclipse.ve.internal.swt.fontpropertyeditor";
    private static ResourceBundle messages = ResourceBundle.getBundle("org.eclipse.ve.internal.swt.fontpropertyeditor");
    private IJavaObjectInstance fExistingValue;
    private List fPropertyChangeListeners;
    protected static final String[] styleNames = new String[]{messages.getString("normalStyle"), messages.getString("boldStyle"), messages.getString("italicStyle"), messages.getString("boldItalicStyle")};
    protected static final int[] styleValues;
    protected static final int[] sizeValues;
    protected static Set fontNames;
    protected static Set lowerCaseFontNames;
    protected Composite control;
    private Text nameField;
    private Text styleField;
    private Text sizeField;
    private org.eclipse.swt.widgets.List namesList;
    private org.eclipse.swt.widgets.List stylesList;
    private org.eclipse.swt.widgets.List sizesList;
    private Text previewText;
    private boolean isUpdating = false;
    protected Font value;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        styleValues = nArray;
        sizeValues = new int[]{8, 10, 12, 14, 18, 24, 36, 48, 72};
    }

    public Control createControl(Composite parent, int style) {
        if (this.control == null || this.control.isDisposed()) {
            this.control = new Composite(parent, style);
            GridLayout grid = new GridLayout();
            grid.numColumns = 3;
            grid.marginHeight = 5;
            grid.marginWidth = 5;
            grid.horizontalSpacing = 5;
            grid.verticalSpacing = 5;
            this.control.setLayout((Layout)grid);
            Label nameLabel = new Label(this.control, 0);
            nameLabel.setText(messages.getString("nameLabel"));
            Label styleLabel = new Label(this.control, 0);
            styleLabel.setText(messages.getString("styleLabel"));
            Label sizeLabel = new Label(this.control, 0);
            sizeLabel.setText(messages.getString("sizeLabel"));
            this.nameField = new Text(this.control, 2052);
            GridData gd01 = new GridData();
            gd01.horizontalAlignment = 4;
            gd01.grabExcessHorizontalSpace = true;
            this.nameField.setLayoutData((Object)gd01);
            this.styleField = new Text(this.control, 2060);
            GridData gd11 = new GridData();
            gd11.horizontalAlignment = 4;
            this.styleField.setLayoutData((Object)gd11);
            this.sizeField = new Text(this.control, 2052);
            GridData gd21 = new GridData();
            gd21.horizontalAlignment = 4;
            this.sizeField.setLayoutData((Object)gd21);
            this.namesList = new org.eclipse.swt.widgets.List(this.control, 2820);
            GridData gd02 = new GridData();
            gd02.horizontalAlignment = 4;
            gd02.verticalAlignment = 4;
            gd02.grabExcessHorizontalSpace = true;
            gd02.grabExcessVerticalSpace = true;
            gd02.heightHint = 100;
            gd02.widthHint = 200;
            this.namesList.setLayoutData((Object)gd02);
            this.stylesList = new org.eclipse.swt.widgets.List(this.control, 2820);
            GridData gd12 = new GridData();
            gd12.horizontalAlignment = 4;
            gd12.verticalAlignment = 4;
            gd12.grabExcessVerticalSpace = true;
            this.stylesList.setLayoutData((Object)gd12);
            this.sizesList = new org.eclipse.swt.widgets.List(this.control, 2820);
            GridData gd22 = new GridData();
            gd22.horizontalAlignment = 4;
            gd22.verticalAlignment = 4;
            gd22.grabExcessVerticalSpace = true;
            gd22.heightHint = 100;
            gd22.widthHint = 40;
            this.sizesList.setLayoutData((Object)gd22);
            this.previewText = new Text(this.control, 2882);
            this.previewText.setText(messages.getString("previewText"));
            GridData gd03 = new GridData();
            gd03.horizontalSpan = 3;
            gd03.horizontalAlignment = 4;
            gd03.verticalAlignment = 4;
            gd03.grabExcessHorizontalSpace = true;
            gd03.grabExcessVerticalSpace = true;
            gd03.heightHint = 50;
            gd03.widthHint = 500;
            this.previewText.setLayoutData((Object)gd03);
            this.initializeLists();
            this.namesList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!FontPropertyEditor.this.isUpdating) {
                        String newSelection = FontPropertyEditor.this.namesList.getSelection()[0];
                        FontPropertyEditor.this.isUpdating = true;
                        FontPropertyEditor.this.nameField.setText(newSelection);
                        FontPropertyEditor.this.isUpdating = false;
                    }
                    FontPropertyEditor.this.updateFont();
                }
            });
            this.nameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!FontPropertyEditor.this.isUpdating) {
                        int newIndex = FontPropertyEditor.this.searchFontNames(FontPropertyEditor.this.nameField.getText());
                        if (FontPropertyEditor.this.namesList.getSelectionIndex() != newIndex) {
                            FontPropertyEditor.this.isUpdating = true;
                            FontPropertyEditor.this.namesList.setSelection(newIndex);
                            FontPropertyEditor.this.isUpdating = false;
                            FontPropertyEditor.this.updateFont();
                        }
                    }
                }
            });
            this.nameField.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    FontPropertyEditor.this.nameField.selectAll();
                }
            });
            this.stylesList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String newSelection = FontPropertyEditor.this.stylesList.getSelection()[0];
                    FontPropertyEditor.this.styleField.setText(newSelection);
                    FontPropertyEditor.this.updateFont();
                }
            });
            this.sizesList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String newSelection = FontPropertyEditor.this.sizesList.getSelection()[0];
                    FontPropertyEditor.this.sizeField.setText(newSelection);
                    FontPropertyEditor.this.updateFont();
                }
            });
            this.sizeField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String newText = FontPropertyEditor.this.sizeField.getText();
                    int newSize = 1;
                    if (newText.length() > 0) {
                        try {
                            newSize = Integer.parseInt(newText);
                            if (newSize < 1) {
                                throw new NumberFormatException();
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            FontPropertyEditor.this.sizeField.setText(String.valueOf(FontPropertyEditor.this.value.getFontData()[0].getHeight()));
                            return;
                        }
                    }
                    FontPropertyEditor.this.updateFont();
                    FontPropertyEditor.this.sizesList.deselectAll();
                    int i = 0;
                    while (i < sizeValues.length) {
                        if (newSize == sizeValues[i]) {
                            FontPropertyEditor.this.sizesList.setSelection(i);
                            break;
                        }
                        ++i;
                    }
                }
            });
            this.sizeField.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    FontPropertyEditor.this.sizeField.selectAll();
                }
            });
            this.createFontFromProxy((Control)this.control);
            this.updateSelections();
            this.nameField.selectAll();
        }
        return this.control;
    }

    private void initializeLists() {
        this.namesList.removeAll();
        Iterator iter = this.getFontNames().iterator();
        while (iter.hasNext()) {
            this.namesList.add((String)iter.next());
        }
        this.stylesList.setItems(styleNames);
        this.sizesList.removeAll();
        int i = 0;
        while (i < sizeValues.length) {
            this.sizesList.add(String.valueOf(sizeValues[i]));
            ++i;
        }
    }

    protected Set getFontNames() {
        if (fontNames == null) {
            fontNames = new TreeSet(new StringIgnoreCaseComparator());
            FontData[] fd = this.control.getDisplay().getFontList(null, true);
            int i = 0;
            while (i < fd.length) {
                fontNames.add(fd[i].getName());
                ++i;
            }
        }
        return fontNames;
    }

    protected Set getLowerCaseFontNames() {
        if (lowerCaseFontNames == null) {
            lowerCaseFontNames = new TreeSet();
            Iterator iter = this.getFontNames().iterator();
            while (iter.hasNext()) {
                lowerCaseFontNames.add(((String)iter.next()).toLowerCase());
            }
        }
        return lowerCaseFontNames;
    }

    private int searchFontNames(String search) {
        int index = 0;
        if (search.length() > 0) {
            search = search.toLowerCase();
            Set lcfn = this.getLowerCaseFontNames();
            Iterator iter = lcfn.iterator();
            while (iter.hasNext()) {
                if (((String)iter.next()).compareTo(search) >= 0) break;
                ++index;
            }
            if (index >= lcfn.size()) {
                index = lcfn.size();
            }
        }
        return index;
    }

    private void updateFont() {
        Font f;
        if (this.namesList.getSelectionCount() == 0 || this.stylesList.getSelectionCount() == 0) {
            return;
        }
        int newSize = 1;
        if (this.sizeField.getText().length() > 0) {
            newSize = Integer.parseInt(this.sizeField.getText());
        } else if (this.sizesList.getItemCount() > 0) {
            this.sizesList.setSelection(0);
            String smallestSize = this.sizesList.getItem(0);
            newSize = Integer.parseInt(smallestSize);
            this.sizeField.setText(smallestSize);
        }
        try {
            f = new Font((Device)this.control.getDisplay(), this.namesList.getSelection()[0], newSize, styleValues[this.stylesList.getSelectionIndex()]);
        }
        catch (SWTError sWTError) {
            return;
        }
        this.previewText.setFont(f);
        if (this.value != null && !this.value.isDisposed()) {
            this.value.dispose();
        }
        this.setValue(f);
    }

    private void updateSelections() {
        if (this.value == null) {
            return;
        }
        this.isUpdating = true;
        FontData fd = this.value.getFontData()[0];
        this.namesList.setSelection(new String[]{fd.getName()});
        this.nameField.setText(fd.getName());
        int i = 0;
        while (i < styleValues.length) {
            if (fd.getStyle() == styleValues[i]) {
                this.stylesList.setSelection(i);
                this.styleField.setText(styleNames[i]);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < sizeValues.length) {
            if (fd.getHeight() == sizeValues[i]) {
                this.sizesList.setSelection(i);
                break;
            }
            ++i;
        }
        this.sizeField.setText(String.valueOf(fd.getHeight()));
        this.previewText.setFont(this.value);
        this.isUpdating = false;
    }

    public void setValue(Object v) {
        if (v != null && v instanceof Font) {
            this.value = (Font)v;
        }
        if (this.fPropertyChangeListeners != null) {
            Iterator iter = this.fPropertyChangeListeners.iterator();
            while (iter.hasNext()) {
                ((PropertyChangeListener)iter.next()).propertyChange(new PropertyChangeEvent(this, "value", v, null));
            }
        }
    }

    public Object getValue() {
        return this.value;
    }

    public String getJavaInitializationString() {
        String style;
        String SWT_PREFIX = "org.eclipse.swt.SWT";
        if (this.value == null) {
            return "null";
        }
        FontData fd = this.value.getFontData()[0];
        switch (fd.getStyle()) {
            case 0: {
                style = String.valueOf(SWT_PREFIX) + ".NORMAL";
                break;
            }
            case 1: {
                style = String.valueOf(SWT_PREFIX) + ".BOLD";
                break;
            }
            case 2: {
                style = String.valueOf(SWT_PREFIX) + ".ITALIC";
                break;
            }
            case 3: {
                style = String.valueOf(SWT_PREFIX) + ".BOLD | " + SWT_PREFIX + ".ITALIC";
                break;
            }
            default: {
                style = String.valueOf(SWT_PREFIX) + ".NORMAL";
            }
        }
        return "new org.eclipse.swt.graphics.Font(org.eclipse.swt.widgets.Display.getDefault(), \"" + fd.getName() + "\", " + String.valueOf(fd.getHeight()) + ", " + style + ")";
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.fPropertyChangeListeners == null) {
            this.fPropertyChangeListeners = new ArrayList(1);
        }
        this.fPropertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.fPropertyChangeListeners != null) {
            this.fPropertyChangeListeners.remove(listener);
        }
    }

    public String getText() {
        if (this.fExistingValue != null) {
            return FontJavaClassLabelProvider.getText((IJavaInstance)this.fExistingValue);
        }
        return "";
    }

    public void setJavaObjectInstanceValue(IJavaObjectInstance value) {
        this.fExistingValue = value;
        this.value = null;
    }

    private void createFontFromProxy(Control control) {
        if (this.fExistingValue == null && this.value != null) {
            return;
        }
        try {
            IBeanProxy fontProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)this.fExistingValue);
            IBeanTypeProxy fontType = fontProxy.getTypeProxy();
            IMethodProxy getFontData = fontType.getMethodProxy("getFontData");
            IArrayBeanProxy fontDataArrayProxy = (IArrayBeanProxy)getFontData.invoke(fontProxy);
            int len = fontDataArrayProxy.getLength();
            FontData[] fontData = new FontData[len];
            int i = 0;
            while (i < len) {
                IBeanProxy fontDataProxy = fontDataArrayProxy.get(i);
                IBeanTypeProxy fontDataType = fontDataProxy.getTypeProxy();
                IMethodProxy getHeight = fontDataType.getMethodProxy("getHeight");
                IMethodProxy getStyle = fontDataType.getMethodProxy("getStyle");
                IMethodProxy getName = fontDataType.getMethodProxy("getName");
                int height = ((IIntegerBeanProxy)getHeight.invoke(fontDataProxy)).intValue();
                int style = ((IIntegerBeanProxy)getStyle.invoke(fontDataProxy)).intValue();
                String name = ((IStringBeanProxy)getName.invoke(fontDataProxy)).stringValue();
                fontData[i] = new FontData(name, height, style);
                ++i;
            }
            this.value = new Font((Device)control.getDisplay(), fontData);
        }
        catch (ThrowableProxy throwableProxy) {}
    }

    public class StringIgnoreCaseComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return ((String)o1).compareToIgnoreCase((String)o2);
            }
            return -1;
        }

        public boolean equals(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return ((String)o1).equalsIgnoreCase((String)o2);
            }
            return false;
        }
    }
}

