/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ve.internal.cde.commands.NoOpCommand;
import org.eclipse.ve.internal.cde.core.AnnotationLinkagePolicy;
import org.eclipse.ve.internal.cde.core.CustomizeLayoutWindowAction;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.GridController;
import org.eclipse.ve.internal.cde.core.IGridListener;
import org.eclipse.ve.internal.cde.core.IImageListener;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.swt.ControlProxyAdapter;
import org.eclipse.ve.internal.swt.DefaultLayoutEditPolicy;
import org.eclipse.ve.internal.swt.GridLayoutFeedbackFigure;
import org.eclipse.ve.internal.swt.GridLayoutGridFigure;
import org.eclipse.ve.internal.swt.GridLayoutPolicyHelper;
import org.eclipse.ve.internal.swt.GridSpanHandle;
import org.eclipse.ve.internal.swt.NonResizableSpannableEditPolicy;

public class GridLayoutEditPolicy
extends DefaultLayoutEditPolicy
implements IGridListener,
IActionFilter {
    public static final String LAYOUT_ID = "org.eclipse.swt.layout.GridLayout";
    public static final String REQ_GRIDLAYOUT_SPAN = "GridLayout span cells";
    private final int DEFAULT_EDGE = 5;
    private final int HEIGHT_PADDING = 4;
    boolean fShowGrid = false;
    GridLayoutPolicyHelper helper = new GridLayoutPolicyHelper();
    int[][] layoutDimensions = null;
    private GridLayoutGridFigure fGridLayoutGridFigure;
    private GridLayoutFeedbackFigure fGridLayoutCellFigure;
    private GridController gridController;
    private GridImageListener fGridImageListener;
    protected FigureListener hostFigureListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            GridLayoutEditPolicy.this.refreshGridFigure();
            GridLayoutEditPolicy.this.helper.refresh();
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected IImageListener getGridImageListener() {
        if (this.fGridImageListener == null) {
            this.fGridImageListener = new GridImageListener();
        }
        return this.fGridImageListener;
    }

    public GridLayoutEditPolicy(VisualContainerPolicy containerPolicy) {
        super(containerPolicy);
        this.helper.setContainerPolicy(containerPolicy);
    }

    public void activate() {
        this.gridController = new GridController();
        if (this.gridController != null) {
            this.gridController.addGridListener((IGridListener)this);
            GridController.registerEditPart((EditPart)this.getHost(), (GridController)this.gridController);
            ControlProxyAdapter beanProxy = (ControlProxyAdapter)BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaObjectInstance)this.getHost().getModel()));
            if (beanProxy != null) {
                beanProxy.addImageListener(this.getGridImageListener());
            }
            this.getHostFigure().addFigureListener(this.hostFigureListener);
            this.initializeGrid();
        }
        super.activate();
        EditPartViewer editPartViewer = this.getHost().getViewer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ve.internal.swt.GridLayoutLayoutPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CustomizeLayoutWindowAction.addLayoutCustomizationPage((EditPartViewer)editPartViewer, (Class)clazz);
        EditPartViewer editPartViewer2 = this.getHost().getViewer();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ve.internal.swt.GridLayoutComponentPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CustomizeLayoutWindowAction.addComponentCustomizationPage((EditPartViewer)editPartViewer2, (Class)clazz2);
    }

    protected void initializeGrid() {
        AnnotationLinkagePolicy policy;
        Annotation ann;
        EditDomain domain = EditDomain.getEditDomain((EditPart)this.getHost());
        HashSet gridStateData = (HashSet)domain.getData((Object)"org.eclipse.ve.internal.cde.core.gridstatekey");
        if (gridStateData != null && (ann = (policy = domain.getAnnotationLinkagePolicy()).getAnnotation(this.getHost().getModel())) != null) {
            String name = (String)ann.getKeyedValues().get((Object)"org.eclipse.ve.internal.cde.core.nameincomposition");
            if (name == null) {
                name = "THIS_PART";
            }
            if (gridStateData.contains(name) && this.gridController != null) {
                this.gridController.setGridShowing(true);
            }
        }
    }

    public void deactivate() {
        ControlProxyAdapter beanProxy;
        this.containerPolicy.setContainer(null);
        GridController gridController = GridController.getGridController((EditPart)this.getHost());
        this.eraseGridFigure();
        if (gridController != null) {
            gridController.removeGridListener((IGridListener)this);
            GridController.unregisterEditPart((EditPart)this.getHost());
        }
        if ((beanProxy = (ControlProxyAdapter)BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaObjectInstance)this.getHost().getModel()))) != null) {
            beanProxy.removeImageListener(this.getGridImageListener());
        }
        this.getHostFigure().removeFigureListener(this.hostFigureListener);
        super.deactivate();
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new NonResizableSpannableEditPolicy(this);
    }

    public Command getCommand(Request request) {
        if (REQ_GRIDLAYOUT_SPAN.equals(request.getType())) {
            return this.getSpanChildrenCommand((Request)((ChangeBoundsRequest)request));
        }
        return super.getCommand(request);
    }

    protected Command getSpanChildrenCommand(Request generic) {
        ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
        List editParts = request.getEditParts();
        if (editParts.isEmpty() || editParts.size() > 1) {
            return UnexecutableCommand.INSTANCE;
        }
        Point spanToPosition = this.getLocationFromRequest((Request)request).getCopy();
        this.getHostFigure().translateToRelative((Translatable)spanToPosition);
        Point spanToCellLocation = this.getGridLayoutGridFigure().getCellLocation(spanToPosition.x, spanToPosition.y);
        Dimension dim = request.getSizeDelta();
        int handleSizeOffset = GridSpanHandle.HANDLE_SIZE / 2;
        Point startPosition = new Point(spanToPosition.x - dim.width - handleSizeOffset, spanToPosition.y - dim.height - handleSizeOffset);
        GraphicalEditPart ep = (GraphicalEditPart)editParts.get(0);
        Point childPosition = ep.getFigure().getBounds().getLocation();
        Point childCellLocation = this.getGridLayoutGridFigure().getCellLocation(childPosition.x, childPosition.y);
        Point startCellLocation = this.getGridLayoutGridFigure().getCellLocation(startPosition.x, startPosition.y);
        if (spanToCellLocation.x >= childCellLocation.x && spanToCellLocation.y >= childCellLocation.y && (spanToCellLocation.x != startCellLocation.x || spanToCellLocation.y != startCellLocation.y)) {
            return this.helper.getSpanChildrenCommand((EditPart)editParts.get(0), childCellLocation, spanToCellLocation, request.getResizeDirection());
        }
        return NoOpCommand.INSTANCE;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.startsWith("showgrid") && value.equals("false") && !this.fShowGrid) {
            return true;
        }
        if (name.startsWith("showgrid") && value.equals("true") && this.fShowGrid) {
            return true;
        }
        if (name.startsWith("customizelayout") && value.equals("true")) {
            return true;
        }
        return name.startsWith("LAYOUTPOLICY") && value.equals(LAYOUT_ID);
    }

    protected GridLayoutGridFigure getGridLayoutGridFigure() {
        if (this.fGridLayoutGridFigure == null) {
            IFigure f = ((GraphicalEditPart)this.getHost()).getFigure();
            int[][] layoutDimensions = null;
            int[][] expandableDimensions = null;
            Rectangle layoutSpacing = null;
            Rectangle clientArea = null;
            boolean columnsEqualWidth = false;
            if (this.helper.getContainer() == null || this.getHost().getChildren().size() == 0) {
                layoutDimensions = new int[2][0];
                layoutDimensions[0] = new int[0];
                layoutDimensions[1] = new int[0];
                expandableDimensions = new int[2][0];
                expandableDimensions[0] = new int[0];
                expandableDimensions[1] = new int[0];
            } else {
                layoutDimensions = this.helper.getContainerLayoutDimensions();
                expandableDimensions = this.helper.getContainerExpandableDimensions();
                layoutSpacing = this.helper.getContainerLayoutSpacing();
                columnsEqualWidth = this.helper.isContainerColumnsEqualWidth();
            }
            clientArea = this.helper.getContainerClientArea();
            this.fGridLayoutGridFigure = new GridLayoutGridFigure(f.getBounds().getCopy(), layoutDimensions, expandableDimensions, columnsEqualWidth, layoutSpacing, clientArea);
        }
        return this.fGridLayoutGridFigure;
    }

    protected void eraseGridFigure() {
        if (this.fGridLayoutGridFigure != null) {
            this.removeFeedback((IFigure)this.fGridLayoutGridFigure);
            this.fGridLayoutGridFigure = null;
        }
        this.fShowGrid = false;
    }

    public void eraseTargetFeedback(Request request) {
        if (!this.fShowGrid && this.fGridLayoutGridFigure != null && this.fGridLayoutGridFigure.getParent() != null) {
            this.removeFeedback((IFigure)this.fGridLayoutGridFigure);
            this.fGridLayoutGridFigure = null;
        }
        if (this.fGridLayoutCellFigure != null) {
            this.removeFeedback((IFigure)this.fGridLayoutCellFigure);
            this.fGridLayoutCellFigure = null;
        }
        super.eraseTargetFeedback(request);
    }

    protected void showGridFigure() {
        if (!this.fShowGrid) {
            this.fShowGrid = true;
            this.addFeedback((IFigure)this.getGridLayoutGridFigure());
        }
        this.fShowGrid = true;
    }

    public void showSpanTargetFeedback(ChangeBoundsRequest request) {
        if (!this.fShowGrid) {
            this.addFeedback((IFigure)this.getGridLayoutGridFigure());
        }
        Point spanToPosition = request.getLocation().getCopy();
        this.getHostFigure().translateToRelative((Translatable)spanToPosition);
        GraphicalEditPart ep = (GraphicalEditPart)request.getEditParts().get(0);
        Point childPosition = ep.getFigure().getBounds().getLocation();
        Rectangle startCellBounds = this.getGridLayoutGridFigure().getCellBounds(childPosition.x, childPosition.y);
        Rectangle endCellBounds = this.getGridLayoutGridFigure().getCellBounds(spanToPosition.x, spanToPosition.y);
        Rectangle spanrect = new Rectangle(startCellBounds.x, startCellBounds.y, endCellBounds.x + endCellBounds.width - startCellBounds.x, endCellBounds.y + endCellBounds.height - startCellBounds.y);
        if (this.fGridLayoutCellFigure == null) {
            this.fGridLayoutCellFigure = new GridLayoutFeedbackFigure();
        }
        this.fGridLayoutCellFigure.setBounds(spanrect);
        this.addFeedback((IFigure)this.fGridLayoutCellFigure);
    }

    protected void refreshGridFigure() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (GridLayoutEditPolicy.this.fShowGrid) {
                    GridLayoutEditPolicy.this.eraseGridFigure();
                    GridLayoutEditPolicy.this.showGridFigure();
                } else {
                    GridLayoutEditPolicy.this.fGridLayoutGridFigure = null;
                }
            }
        });
    }

    public void gridVisibilityChanged(boolean showGrid) {
        if (showGrid) {
            this.showGridFigure();
        } else {
            this.eraseGridFigure();
        }
    }

    public void gridHeightChanged(int gridHeight, int oldGridHeight) {
    }

    public void gridWidthChanged(int gridWidth, int oldGridWidth) {
    }

    public void gridMarginChanged(int gridMargin, int oldGridMargin) {
    }

    private Rectangle getAbsoluteBounds(GraphicalEditPart ep) {
        Rectangle bounds = ep.getFigure().getBounds().getCopy();
        ep.getFigure().translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    private Point getLocationFromRequest(Request request) {
        return ((DropRequest)request).getLocation();
    }

    protected int getFeedbackIndexFor(Request request) {
        List children = this.getHost().getChildren();
        if (children.isEmpty()) {
            return -1;
        }
        Point p = this.getLocationFromRequest(request);
        Point cell = this.getGridLayoutGridFigure().getCellLocation(p);
        int index = this.helper.getChildIndexAtCell(cell);
        if (index != -1) {
            Rectangle r = this.getAbsoluteBounds((GraphicalEditPart)children.get(index));
            if (p.x > r.x + r.width / 2 && ++index >= children.size()) {
                index = -1;
            }
        }
        return index;
    }

    protected void showLayoutTargetFeedback(Request request) {
        EditPart editPart;
        if (this.getHost().getChildren().size() == 0) {
            return;
        }
        if (!this.fShowGrid) {
            this.addFeedback((IFigure)this.getGridLayoutGridFigure());
        }
        Polyline fb = this.getLineFeedback();
        boolean before = true;
        int epIndex = this.getFeedbackIndexFor(request);
        Rectangle r = null;
        if (epIndex == -1) {
            before = false;
            epIndex = this.getHost().getChildren().size() - 1;
            editPart = (EditPart)this.getHost().getChildren().get(epIndex);
            r = this.getAbsoluteBounds((GraphicalEditPart)editPart);
        } else {
            editPart = (EditPart)this.getHost().getChildren().get(epIndex);
            r = this.getAbsoluteBounds((GraphicalEditPart)editPart);
            before = true;
        }
        int x = Integer.MIN_VALUE;
        Rectangle parentBox = this.getAbsoluteBounds((GraphicalEditPart)this.getHost());
        if (before) {
            if (epIndex == 0) {
                x = parentBox.x + (r.x - parentBox.x) / 2;
                if (x < 5) {
                    x = 5;
                }
            } else if (this.helper.isOnSameRow(epIndex - 1, epIndex)) {
                Rectangle otherFigure = this.getAbsoluteBounds((GraphicalEditPart)this.getHost().getChildren().get(epIndex - 1));
                Rectangle otherGrid = this.getGridLayoutGridFigure().getGridBroundsForCellBounds(this.helper.getChildrenDimensions()[epIndex - 1]);
                x = otherGrid.right() + (r.x - otherGrid.right()) / 2;
                if (otherFigure.height < r.height) {
                    r = otherFigure;
                }
            } else if (this.helper.isCellEmptyBefore(epIndex)) {
                r = this.getAbsoluteBounds((GraphicalEditPart)this.getHost().getChildren().get(epIndex - 1));
                x = parentBox.right() - (parentBox.right() - r.right()) / 2;
                if (x > 5) {
                    x = r.right() + 5;
                }
            } else {
                x = parentBox.x + (r.x - parentBox.x) / 2;
                if (x < 5) {
                    x = r.x - 5;
                }
            }
        } else {
            x = parentBox.right() - (parentBox.right() - r.right()) / 2;
            if (x > 5) {
                x = r.right() + 5;
            }
        }
        Point p1 = new Point(x, r.y - 4);
        fb.translateToRelative((Translatable)p1);
        Point p2 = new Point(x, r.y + r.height + 4);
        fb.translateToRelative((Translatable)p2);
        fb.setPoint(p1, 0);
        fb.setPoint(p2, 1);
    }

    private class GridImageListener
    implements IImageListener {
        GridImageListener() {
        }

        public void imageChanged(ImageData data) {
            GridLayoutEditPolicy.this.refreshGridFigure();
            GridLayoutEditPolicy.this.helper.refresh();
        }
    }
}

