/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.commands.Command;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.BeanPropertyDescriptorAdapter;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.HoldProcessingCommand;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.java.visual.ILayoutPolicyFactory;
import org.eclipse.ve.internal.java.visual.ILayoutSwitcher;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.propertysheet.command.ICommandPropertyDescriptor;
import org.eclipse.ve.internal.swt.BeanSWTUtilities;
import org.eclipse.ve.internal.swt.CompositeContainerPolicy;
import org.eclipse.ve.internal.swt.LayoutCellEditor;
import org.eclipse.ve.internal.swt.LayoutLabelProvider;

public class LayoutPropertyDescriptor
extends BeanPropertyDescriptorAdapter
implements ICommandPropertyDescriptor {
    public ILabelProvider getLabelProvider() {
        return new LayoutLabelProvider();
    }

    public CellEditor createPropertyEditor(Composite parent) {
        return new LayoutCellEditor(parent);
    }

    public Command setValue(IPropertySource source, Object setValue) {
        IJavaObjectInstance container = (IJavaObjectInstance)source.getEditableValue();
        IBeanProxyHost containerProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)container);
        IPropertySource oldLayoutPS = (IPropertySource)source.getPropertyValue((Object)this.getTarget());
        IJavaObjectInstance oldLayout = oldLayoutPS != null ? (IJavaObjectInstance)oldLayoutPS.getEditableValue() : null;
        EditDomain domain = containerProxyHost.getBeanProxyDomain().getEditDomain();
        if (oldLayout != setValue) {
            ILayoutPolicyFactory layoutFactory;
            EClass layoutManagerClass = null;
            if (setValue != null) {
                layoutManagerClass = ((IJavaObjectInstance)setValue).eClass();
            }
            if ((layoutFactory = BeanSWTUtilities.getLayoutPolicyFactoryFromLayout(layoutManagerClass, domain)) != null) {
                CompositeContainerPolicy cp = new CompositeContainerPolicy(domain);
                cp.setContainer(container);
                ILayoutSwitcher switcher = layoutFactory.getLayoutSwitcher((VisualContainerPolicy)cp);
                if (switcher != null) {
                    return switcher.getCommand((EStructuralFeature)this.getTarget(), (IJavaObjectInstance)setValue);
                }
            }
        }
        RuledCommandBuilder cbld = new RuledCommandBuilder(domain);
        cbld.applyAttributeSetting((EObject)container, (EStructuralFeature)this.getTarget(), setValue);
        return new HoldProcessingCommand(cbld.getCommand(), (IJavaInstance)container);
    }

    public Command resetValue(IPropertySource source) {
        ILayoutPolicyFactory layoutFactory;
        if (!source.isPropertySet((Object)this.getTarget())) {
            return null;
        }
        IJavaObjectInstance container = (IJavaObjectInstance)source.getEditableValue();
        IBeanProxyHost containerProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)container);
        EditDomain domain = containerProxyHost.getBeanProxyDomain().getEditDomain();
        IBeanProxy defaultLayoutManager = (IBeanProxy)containerProxyHost.getOriginalSettingsTable().get(this.getTarget());
        JavaHelpers layoutManagerClass = null;
        if (defaultLayoutManager != null) {
            layoutManagerClass = BeanProxyUtilities.getJavaType((IBeanProxy)defaultLayoutManager, (ResourceSet)container.eResource().getResourceSet());
        }
        if ((layoutFactory = BeanSWTUtilities.getLayoutPolicyFactoryFromLayout(layoutManagerClass, domain)) != null) {
            CompositeContainerPolicy cp = new CompositeContainerPolicy(domain);
            cp.setContainer(container);
            ILayoutSwitcher switcher = layoutFactory.getLayoutSwitcher((VisualContainerPolicy)cp);
            if (switcher != null) {
                return switcher.getCancelCommand((EStructuralFeature)this.getTarget(), defaultLayoutManager);
            }
        }
        RuledCommandBuilder cbld = new RuledCommandBuilder(domain);
        cbld.cancelAttributeSetting((EObject)container, (EStructuralFeature)this.getTarget());
        return new HoldProcessingCommand(cbld.getCommand(), (IJavaInstance)container);
    }
}

