/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.awt.IPointBeanProxy;
import org.eclipse.jem.internal.proxy.awt.IRectangleBeanProxy;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.ve.internal.cde.core.ContainerPolicy;
import org.eclipse.ve.internal.cde.core.XYLayoutEditPolicy;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.swt.BeanSWTUtilities;
import org.eclipse.ve.internal.swt.NullLayoutPolicyHelper;
import org.eclipse.ve.internal.swt.SWTConstants;

public class NullLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected ContainerPolicy containerPolicy;
    protected NullLayoutPolicyHelper helper;
    protected Rectangle clientBox;
    private IBeanTypeProxy environmentBeanTypeProxy;
    private IMethodProxy getFieldMethodProxy;

    public NullLayoutEditPolicy(VisualContainerPolicy containerPolicy, Rectangle aClientBox) {
        this.containerPolicy = containerPolicy;
        this.helper = new NullLayoutPolicyHelper(containerPolicy);
        this.clientBox = aClientBox;
    }

    public void activate() {
        super.activate();
        this.containerPolicy.setContainer(this.getHost().getModel());
    }

    public void deactivate() {
        super.deactivate();
        this.containerPolicy.setContainer(null);
    }

    protected Command createAddCommand(EditPart childEditPart, Object constraint) {
        Object child = childEditPart.getModel();
        NullLayoutPolicyHelper.NullConstraint nullconst = new NullLayoutPolicyHelper.NullConstraint((Rectangle)constraint, true, true);
        return this.helper.getAddChildrenCommand(Collections.singletonList(child), Collections.singletonList(nullconst), null);
    }

    protected Command getCreateCommand(CreateRequest aRequest) {
        Object child = aRequest.getNewObject();
        Object parent = this.getHost().getModel();
        Object constraint = this.translateToModelConstraint(this.getConstraintFor(aRequest));
        NullLayoutPolicyHelper.NullConstraint nullconst = new NullLayoutPolicyHelper.NullConstraint((Rectangle)constraint, true, true);
        return this.helper.getCreateChildCommand(child, parent, nullconst, null);
    }

    protected Command getDeleteDependantCommand(Request aRequest) {
        Command deleteContributionCmd = this.containerPolicy.getCommand(aRequest);
        if (deleteContributionCmd == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return deleteContributionCmd;
    }

    protected Command getOrphanChildrenCommand(Request aRequest) {
        return this.helper.getOrphanChildrenCommand(ContainerPolicy.getChildren((GroupRequest)((GroupRequest)aRequest)));
    }

    protected Command createChangeConstraintCommand(EditPart childEditPart, Object constraint, boolean moved, boolean resize) {
        return this.createChangeConstraintCommand(childEditPart.getModel(), constraint, moved, resize);
    }

    protected Object getChildConstraint(EditPart child) {
        IJavaObjectInstance size;
        IJavaObjectInstance childObject = (IJavaObjectInstance)child.getModel();
        IJavaObjectInstance constraint = (IJavaObjectInstance)childObject.eGet(JavaInstantiation.getSFeature((IJavaObjectInstance)childObject, (URI)SWTConstants.SF_CONTROL_BOUNDS));
        if (constraint != null) {
            IBeanProxy rect = BeanProxyUtilities.getBeanProxy((IJavaInstance)constraint);
            return new Rectangle(this.getX(rect), this.getY(rect), this.getWidth(rect), this.getHeight(rect));
        }
        Rectangle rect = new Rectangle();
        IJavaObjectInstance loc = (IJavaObjectInstance)childObject.eGet(JavaInstantiation.getSFeature((IJavaObjectInstance)childObject, (URI)SWTConstants.SF_CONTROL_LOCATION));
        if (loc != null) {
            IBeanProxy point = BeanProxyUtilities.getBeanProxy((IJavaInstance)loc);
            rect.setLocation(this.getX(point), this.getY(point));
        }
        if ((size = (IJavaObjectInstance)childObject.eGet(JavaInstantiation.getSFeature((IJavaObjectInstance)childObject, (URI)SWTConstants.SF_CONTROL_SIZE))) != null) {
            IBeanProxy sz = BeanProxyUtilities.getBeanProxy((IJavaInstance)size);
            rect.setSize(this.getX(sz), this.getY(sz));
        }
        return rect;
    }

    protected Command createChangeConstraintCommand(Object child, Object constraint, boolean moved, boolean resize) {
        NullLayoutPolicyHelper.NullConstraint nullConstraint = new NullLayoutPolicyHelper.NullConstraint((Rectangle)constraint, moved, resize);
        return this.helper.getChangeConstraintCommand(Collections.singletonList(child), Collections.singletonList(nullConstraint));
    }

    protected Object translateToModelConstraint(Object aFigureConstraint) {
        Rectangle figureConstraint = (Rectangle)aFigureConstraint;
        Rectangle result = new Rectangle(figureConstraint.x - this.clientBox.x, figureConstraint.y - this.clientBox.y, figureConstraint.width, figureConstraint.height);
        return result;
    }

    protected Object modelToFigureConstraint(Object modelConstraint) {
        IBeanProxy proxy;
        if (modelConstraint instanceof IJavaInstance && (proxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaInstance)modelConstraint))) instanceof IRectangleBeanProxy) {
            IRectangleBeanProxy rect = (IRectangleBeanProxy)modelConstraint;
            return new Rectangle(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        }
        return null;
    }

    protected void setConstraintToFigure(EditPart child, Rectangle figureConstraint) {
    }

    protected boolean isChildResizeable(EditPart aChild) {
        return true;
    }

    private int getX(IBeanProxy anSWTRectangleBeanProxy) {
        IFieldProxy xFieldProxy = anSWTRectangleBeanProxy.getTypeProxy().getFieldProxy("x");
        try {
            IIntegerBeanProxy xProxy = (IIntegerBeanProxy)this.getGetFieldMethodProxy(anSWTRectangleBeanProxy.getProxyFactoryRegistry()).invoke((IBeanProxy)xFieldProxy, anSWTRectangleBeanProxy);
            return xProxy.intValue();
        }
        catch (ThrowableProxy exc) {
            exc.printProxyStackTrace();
            return 0;
        }
    }

    private int getY(IBeanProxy anSWTRectangleBeanProxy) {
        IFieldProxy xFieldProxy = anSWTRectangleBeanProxy.getTypeProxy().getFieldProxy("y");
        try {
            IIntegerBeanProxy xProxy = (IIntegerBeanProxy)this.getGetFieldMethodProxy(anSWTRectangleBeanProxy.getProxyFactoryRegistry()).invoke((IBeanProxy)xFieldProxy, anSWTRectangleBeanProxy);
            return xProxy.intValue();
        }
        catch (ThrowableProxy exc) {
            exc.printProxyStackTrace();
            return 0;
        }
    }

    private int getWidth(IBeanProxy anSWTRectangleBeanProxy) {
        IFieldProxy xFieldProxy = anSWTRectangleBeanProxy.getTypeProxy().getFieldProxy("width");
        try {
            IIntegerBeanProxy xProxy = (IIntegerBeanProxy)this.getGetFieldMethodProxy(anSWTRectangleBeanProxy.getProxyFactoryRegistry()).invoke((IBeanProxy)xFieldProxy, anSWTRectangleBeanProxy);
            return xProxy.intValue();
        }
        catch (ThrowableProxy exc) {
            exc.printProxyStackTrace();
            return 0;
        }
    }

    private int getHeight(IBeanProxy anSWTRectangleBeanProxy) {
        IFieldProxy xFieldProxy = anSWTRectangleBeanProxy.getTypeProxy().getFieldProxy("height");
        try {
            IIntegerBeanProxy xProxy = (IIntegerBeanProxy)this.getGetFieldMethodProxy(anSWTRectangleBeanProxy.getProxyFactoryRegistry()).invoke((IBeanProxy)xFieldProxy, anSWTRectangleBeanProxy);
            return xProxy.intValue();
        }
        catch (ThrowableProxy exc) {
            exc.printProxyStackTrace();
            return 0;
        }
    }

    protected final IBeanTypeProxy getEnvironmentBeanTypeProxy(ProxyFactoryRegistry aProxyFactoryRegistry) {
        if (this.environmentBeanTypeProxy == null) {
            this.environmentBeanTypeProxy = aProxyFactoryRegistry.getBeanTypeProxyFactory().getBeanTypeProxy("org.eclipse.ve.internal.swt.targetvm.Environment");
        }
        return this.environmentBeanTypeProxy;
    }

    protected final IMethodProxy getGetFieldMethodProxy(ProxyFactoryRegistry aProxyFactoryRegistry) {
        if (this.getFieldMethodProxy == null) {
            this.getFieldMethodProxy = this.getEnvironmentBeanTypeProxy(aProxyFactoryRegistry).getMethodProxy("java.lang.reflect.field", "java.lang.Object");
        }
        return this.getFieldMethodProxy;
    }

    public static boolean adjustForPreferredSizeAndPosition(IBeanProxy childProxy, IJavaObjectInstance parentComposite, Rectangle bounds, int marginWidth, int marginHeight, IBeanProxy defaultX, IBeanProxy defaultY) {
        boolean changedit = false;
        if (bounds.width == -1 || bounds.height == -1) {
            changedit = true;
            IPointBeanProxy preferredSize = BeanSWTUtilities.invoke_computeSize(childProxy, defaultX, defaultY);
            if (bounds.width == -1) {
                bounds.width = Math.max(preferredSize.getX(), marginWidth);
            }
            if (bounds.height == -1) {
                bounds.height = Math.max(preferredSize.getY(), marginHeight);
            }
        }
        if (bounds.x == Integer.MIN_VALUE && bounds.y == Integer.MIN_VALUE) {
            changedit = true;
            Point position = NullLayoutEditPolicy.findNextAvailablePosition(bounds, parentComposite, marginWidth, marginHeight);
            bounds.x = position.x;
            bounds.y = position.y;
        }
        return changedit;
    }

    protected static Point findNextAvailablePosition(Rectangle bounds, IJavaObjectInstance parentComposite, int marginWidth, int marginHeight) {
        int requestedWidth = bounds.width + 2 * marginWidth;
        int requestedHeight = bounds.height + 2 * marginHeight;
        IBeanProxy compositeBeanProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)parentComposite);
        IRectangleBeanProxy boundingRect = BeanSWTUtilities.invoke_getBounds(compositeBeanProxy);
        IArrayBeanProxy children = BeanSWTUtilities.invoke_getChildren(compositeBeanProxy);
        ArrayList<Rectangle> rects = new ArrayList<Rectangle>(children.getLength());
        int i = 0;
        while (i < children.getLength()) {
            try {
                IRectangleBeanProxy cBounds = BeanSWTUtilities.invoke_getBounds(children.get(i));
                if (cBounds.getWidth() != -1 && cBounds.getHeight() != -1) {
                    Rectangle lBounds = new Rectangle(cBounds.getX(), cBounds.getY(), cBounds.getWidth(), cBounds.getHeight());
                    rects.add(lBounds);
                }
            }
            catch (ThrowableProxy exc) {
                exc.printProxyStackTrace();
            }
            ++i;
        }
        if (requestedWidth < boundingRect.getWidth()) {
            Rectangle tryRect;
            int highestBottom = 0;
            block3: while (true) {
                boolean intersects;
                int x = 0;
                int y = highestBottom;
                highestBottom = Integer.MAX_VALUE;
                do {
                    if (x + requestedWidth >= boundingRect.getWidth()) continue block3;
                    intersects = false;
                    tryRect = new Rectangle(x, y, requestedWidth, requestedHeight);
                    int i2 = 0;
                    while (i2 < rects.size()) {
                        Rectangle rect = (Rectangle)rects.get(i2);
                        if (rect.intersects(tryRect)) {
                            intersects = true;
                            x = Math.max(x, rect.x + rect.width);
                            highestBottom = Math.min(highestBottom, rect.y + rect.height);
                        }
                        ++i2;
                    }
                } while (intersects);
                break;
            }
            Point position = new Point(tryRect.x + marginWidth, tryRect.y + marginHeight);
            return position;
        }
        int y = 0;
        block6: while (true) {
            boolean intersects = false;
            Rectangle tryRect = new Rectangle(0, y, requestedWidth, requestedHeight);
            int i3 = 0;
            while (true) {
                if (i3 >= rects.size()) continue block6;
                Rectangle rect = (Rectangle)rects.get(i3);
                if (rect.intersects(tryRect)) {
                    intersects = true;
                    y = Math.max(y, rect.y + rect.height);
                }
                if (!intersects) {
                    Point position = new Point(tryRect.x + marginWidth, tryRect.y + marginHeight);
                    return position;
                }
                ++i3;
            }
            break;
        }
    }
}

