/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.jem.internal.instantiation.base.IJavaDataTypeInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.JavaBeanCustomizeLayoutPage;
import org.eclipse.ve.internal.java.core.Spinner;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.propertysheet.common.commands.AbstractCommand;
import org.eclipse.ve.internal.swt.SWTConstants;
import org.eclipse.ve.internal.swt.SWTMessages;

public class RowLayoutLayoutPage
extends JavaBeanCustomizeLayoutPage {
    EditPart fEditPart = null;
    Button typeHorizontalRadio;
    Button typeVerticalRadio;
    Button fillCheck;
    Button justifyCheck;
    Button packCheck;
    Button wrapCheck;
    Spinner spacingSpinner;
    Spinner heightSpinner;
    Spinner widthSpinner;
    Spinner topSpinner;
    Spinner bottomSpinner;
    Spinner leftSpinner;
    Spinner rightSpinner;
    ResourceSet rset;
    protected EReference sfCompositeLayout;
    EStructuralFeature sfFill;
    EStructuralFeature sfJustify;
    EStructuralFeature sfPack;
    EStructuralFeature sfSpacing;
    EStructuralFeature sfType;
    EStructuralFeature sfWrap;
    EStructuralFeature sfMarginHeight;
    EStructuralFeature sfMarginWidth;
    EStructuralFeature sfMarginBottom;
    EStructuralFeature sfMarginLeft;
    EStructuralFeature sfMarginRight;
    EStructuralFeature sfMarginTop;
    boolean initialized = false;
    private static final String[] orientationInitStrings = new String[]{"org.eclipse.swt.SWT.HORIZONTAL", "org.eclipse.swt.SWT.VERTICAL"};
    private static final int HORIZONTAL = 0;
    private static final int VERTICAL = 1;
    protected SelectionListener radioSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            RowLayoutLayoutPage.this.radioModified((Button)e.widget);
        }
    };
    protected Listener spinnerModify = new Listener(){

        public void handleEvent(Event event) {
            RowLayoutLayoutPage.this.spinnerModified((Spinner)event.widget);
        }
    };
    protected SelectionListener checkSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            RowLayoutLayoutPage.this.checkModified((Button)e.widget);
        }
    };
    private Map sfMap = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    protected void handleSelectionProviderInitialization(ISelectionProvider selectionProvider) {
    }

    public Control getControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout grid = new GridLayout();
        grid.numColumns = 2;
        c.setLayout((Layout)grid);
        Group orientationGroup = new Group(c, 0);
        orientationGroup.setText(SWTMessages.getString("RowLayoutLayoutPage.orientationGroupTitle"));
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalAlignment = 4;
        orientationGroup.setLayoutData((Object)gd);
        grid = new GridLayout();
        orientationGroup.setLayout((Layout)grid);
        this.typeHorizontalRadio = this.makeRadio((Composite)orientationGroup, SWTMessages.getString("RowLayoutLayoutPage.horizontalLabel"));
        this.typeVerticalRadio = this.makeRadio((Composite)orientationGroup, SWTMessages.getString("RowLayoutLayoutPage.verticalLabel"));
        Group spacingGroup = new Group(c, 0);
        spacingGroup.setText(SWTMessages.getString("RowLayoutLayoutPage.spacingGroupTitle"));
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 1;
        gd.verticalSpan = 2;
        spacingGroup.setLayoutData((Object)gd);
        grid = new GridLayout();
        grid.numColumns = 5;
        spacingGroup.setLayout((Layout)grid);
        this.spacingSpinner = this.makeSpinner((Composite)spacingGroup, SWTMessages.getString("RowLayoutLayoutPage.spacingLabel"));
        Label seperator = new Label((Composite)spacingGroup, 514);
        gd = new GridData();
        gd.verticalSpan = 4;
        gd.verticalAlignment = 4;
        seperator.setLayoutData((Object)gd);
        this.bottomSpinner = this.makeSpinner((Composite)spacingGroup, SWTMessages.getString("RowLayoutLayoutPage.bottomLabel"));
        this.heightSpinner = this.makeSpinner((Composite)spacingGroup, SWTMessages.getString("RowLayoutLayoutPage.heightLabel"));
        this.leftSpinner = this.makeSpinner((Composite)spacingGroup, SWTMessages.getString("RowLayoutLayoutPage.leftLabel"));
        this.widthSpinner = this.makeSpinner((Composite)spacingGroup, SWTMessages.getString("RowLayoutLayoutPage.widthLabel"));
        this.rightSpinner = this.makeSpinner((Composite)spacingGroup, SWTMessages.getString("RowLayoutLayoutPage.rightLabel"));
        Label blank = new Label((Composite)spacingGroup, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        blank.setLayoutData((Object)gd);
        this.topSpinner = this.makeSpinner((Composite)spacingGroup, SWTMessages.getString("RowLayoutLayoutPage.topLabel"));
        spacingGroup.setTabList(new Control[]{this.spacingSpinner, this.heightSpinner, this.widthSpinner, this.bottomSpinner, this.leftSpinner, this.rightSpinner, this.topSpinner});
        Group configGroup = new Group(c, 0);
        configGroup.setText(SWTMessages.getString("RowLayoutLayoutPage.configGroupTitle"));
        gd = new GridData();
        gd.verticalAlignment = 4;
        configGroup.setLayoutData((Object)gd);
        grid = new GridLayout();
        grid.numColumns = 2;
        configGroup.setLayout((Layout)grid);
        this.fillCheck = this.makeCheck((Composite)configGroup, SWTMessages.getString("RowLayoutLayoutPage.fillLabel"));
        this.justifyCheck = this.makeCheck((Composite)configGroup, SWTMessages.getString("RowLayoutLayoutPage.justifyLabel"));
        this.packCheck = this.makeCheck((Composite)configGroup, SWTMessages.getString("RowLayoutLayoutPage.packLabel"));
        this.wrapCheck = this.makeCheck((Composite)configGroup, SWTMessages.getString("RowLayoutLayoutPage.wrapLabel"));
        c.setTabList(new Control[]{orientationGroup, configGroup, spacingGroup});
        if (this.fEditPart != null) {
            this.initialized = false;
            this.initializeValues();
        }
        return c;
    }

    private Button makeRadio(Composite parent, String label) {
        Button b = new Button(parent, 16);
        b.setText(label);
        b.addSelectionListener(this.radioSelection);
        return b;
    }

    private Spinner makeSpinner(Composite parent, String labelText) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        Spinner spin = new Spinner(parent, 0, 0);
        spin.addModifyListener(this.spinnerModify);
        return spin;
    }

    private Button makeCheck(Composite parent, String label) {
        Button b = new Button(parent, 32);
        b.setText(label);
        b.addSelectionListener(this.checkSelection);
        return b;
    }

    protected boolean handleSelectionChanged(ISelection oldSelection) {
        ISelection newSelection = this.getSelection();
        if (newSelection != null && newSelection instanceof IStructuredSelection && !((IStructuredSelection)newSelection).isEmpty()) {
            EditPart firstParent;
            List editparts = ((IStructuredSelection)newSelection).toList();
            boolean enableAll = true;
            if (editparts.size() == 1 && editparts.get(0) instanceof EditPart && this.isValidTarget(firstParent = (EditPart)editparts.get(0))) {
                this.fEditPart = firstParent;
                this.initialized = false;
                this.initializeValues();
                return true;
            }
            if (editparts.get(0) instanceof EditPart && ((EditPart)editparts.get(0)).getParent() != null && this.isValidTarget(firstParent = ((EditPart)editparts.get(0)).getParent())) {
                EditPart ep = (EditPart)editparts.get(0);
                int i = 1;
                while (i < editparts.size()) {
                    if (editparts.get(i) instanceof EditPart) {
                        ep = (EditPart)editparts.get(i);
                        if (ep.getParent() == null || ep.getParent() != firstParent) {
                            enableAll = false;
                            break;
                        }
                    } else {
                        enableAll = false;
                        break;
                    }
                    ++i;
                }
                if (enableAll) {
                    this.fEditPart = firstParent;
                    this.initialized = false;
                    this.initializeValues();
                    return true;
                }
            }
        }
        this.fEditPart = null;
        return false;
    }

    public boolean isValidTarget(EditPart target) {
        IActionFilter af;
        Class<?> clazz;
        if (target instanceof TreeEditPart) {
            EditPart ep;
            EditPartViewer viewer;
            EditDomain ed = EditDomain.getEditDomain((EditPart)target);
            IEditorPart iEditorPart = ed.getEditorPart();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.gef.EditPartViewer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((viewer = (EditPartViewer)iEditorPart.getAdapter((Class)clazz2)) != null && (ep = (EditPart)viewer.getEditPartRegistry().get(target.getModel())) != null) {
                target = ep;
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.IActionFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (af = (IActionFilter)target.getAdapter((Class)clazz)) != null && af.testAttribute((Object)target, "EDITPOLICY#LAYOUTPOLICY", "org.eclipse.swt.layout.RowLayout");
    }

    protected boolean selectionIsContainer(ISelection oldSelection) {
        EditPart firstParent;
        List editparts;
        ISelection newSelection = this.getSelection();
        return newSelection != null && newSelection instanceof IStructuredSelection && !((IStructuredSelection)newSelection).isEmpty() && (editparts = ((IStructuredSelection)newSelection).toList()).size() == 1 && editparts.get(0) instanceof EditPart && this.isValidTarget(firstParent = (EditPart)editparts.get(0));
    }

    protected void handleEditorPartChanged(IEditorPart oldEditorPart) {
        this.resetVariables();
    }

    private void initializeValues() {
        if (!this.initialized) {
            this.getResourceSet(this.fEditPart);
            if (this.typeHorizontalRadio == null) {
                return;
            }
            int orientationValue = this.getIntValue(this.fEditPart, this.sfType);
            if (orientationValue == 256) {
                this.typeHorizontalRadio.setSelection(true);
            } else if (orientationValue == 512) {
                this.typeVerticalRadio.setSelection(true);
            }
            this.spacingSpinner.setValue(this.getIntValue(this.fEditPart, this.sfSpacing));
            this.spacingSpinner.setEnabled(true);
            this.heightSpinner.setValue(this.getIntValue(this.fEditPart, this.sfMarginHeight));
            this.heightSpinner.setEnabled(true);
            this.widthSpinner.setValue(this.getIntValue(this.fEditPart, this.sfMarginWidth));
            this.widthSpinner.setEnabled(true);
            this.topSpinner.setValue(this.getIntValue(this.fEditPart, this.sfMarginTop));
            this.topSpinner.setEnabled(true);
            this.bottomSpinner.setValue(this.getIntValue(this.fEditPart, this.sfMarginBottom));
            this.bottomSpinner.setEnabled(true);
            this.leftSpinner.setValue(this.getIntValue(this.fEditPart, this.sfMarginLeft));
            this.leftSpinner.setEnabled(true);
            this.rightSpinner.setValue(this.getIntValue(this.fEditPart, this.sfMarginRight));
            this.rightSpinner.setEnabled(true);
            this.fillCheck.setSelection(this.getBooleanValue(this.fEditPart, this.sfFill));
            this.justifyCheck.setSelection(this.getBooleanValue(this.fEditPart, this.sfJustify));
            this.packCheck.setSelection(this.getBooleanValue(this.fEditPart, this.sfPack));
            this.wrapCheck.setSelection(this.getBooleanValue(this.fEditPart, this.sfWrap));
            this.initialized = true;
        }
    }

    private EStructuralFeature getSFForWidget(Widget w) {
        if (this.sfMap == null) {
            this.sfMap = new HashMap();
            this.sfMap.put(this.fillCheck, this.sfFill);
            this.sfMap.put(this.justifyCheck, this.sfJustify);
            this.sfMap.put(this.packCheck, this.sfPack);
            this.sfMap.put(this.wrapCheck, this.sfWrap);
            this.sfMap.put(this.spacingSpinner, this.sfSpacing);
            this.sfMap.put(this.heightSpinner, this.sfMarginHeight);
            this.sfMap.put(this.widthSpinner, this.sfMarginWidth);
            this.sfMap.put(this.topSpinner, this.sfMarginTop);
            this.sfMap.put(this.bottomSpinner, this.sfMarginBottom);
            this.sfMap.put(this.leftSpinner, this.sfMarginLeft);
            this.sfMap.put(this.rightSpinner, this.sfMarginRight);
        }
        return (EStructuralFeature)this.sfMap.get(w);
    }

    private void radioModified(Button b) {
        if (this.initialized) {
            this.execute(this.createOrientationCommand(this.fEditPart, b == this.typeHorizontalRadio ? 0 : 1));
        }
    }

    private void checkModified(Button b) {
        if (this.initialized) {
            this.execute(this.createBooleanCommand(this.fEditPart, this.getSFForWidget((Widget)b), b.getSelection()));
        }
    }

    private void spinnerModified(Spinner s) {
        if (this.initialized) {
            this.execute(this.createSpinnerCommand(this.fEditPart, this.getSFForWidget((Widget)s), s));
        }
    }

    protected Command createOrientationCommand(EditPart editpart, int orientation) {
        CommandBuilder cb = new CommandBuilder();
        EObject control = (EObject)editpart.getModel();
        if (control != null) {
            IJavaInstance layout = (IJavaInstance)control.eGet((EStructuralFeature)this.sfCompositeLayout);
            if (layout == null) {
                return UnexecutableCommand.INSTANCE;
            }
            RuledCommandBuilder componentCB = new RuledCommandBuilder(EditDomain.getEditDomain((EditPart)editpart), null, false);
            String init = orientationInitStrings[orientation];
            IJavaInstance intObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)init);
            componentCB.applyAttributeSetting((EObject)layout, this.sfType, (Object)intObject);
            componentCB.applyAttributeSetting(control, (EStructuralFeature)this.sfCompositeLayout, (Object)layout);
            cb.append(componentCB.getCommand());
            return cb.getCommand();
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command createSpinnerCommand(EditPart editpart, EStructuralFeature sf, Spinner spinner) {
        CommandBuilder cb = new CommandBuilder();
        EObject control = (EObject)editpart.getModel();
        if (control != null) {
            IJavaInstance layout = (IJavaInstance)control.eGet((EStructuralFeature)this.sfCompositeLayout);
            if (layout == null) {
                return UnexecutableCommand.INSTANCE;
            }
            RuledCommandBuilder componentCB = new RuledCommandBuilder(EditDomain.getEditDomain((EditPart)editpart), null, false);
            String init = String.valueOf(spinner.getValue());
            IJavaInstance intObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)init);
            componentCB.applyAttributeSetting((EObject)layout, sf, (Object)intObject);
            componentCB.applyAttributeSetting(control, (EStructuralFeature)this.sfCompositeLayout, (Object)layout);
            cb.append(componentCB.getCommand());
            cb.append((Command)new EnableSpinnerCommand(spinner));
            return cb.getCommand();
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected int getIntValue(EditPart ep, EStructuralFeature sf) {
        if (this.getResourceSet(ep) != null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((IPropertySource)ep.getAdapter((Class)clazz) instanceof IPropertySource) {
                Object intPV;
                IPropertySource ps;
                IPropertySource gridLayout;
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((gridLayout = (IPropertySource)(ps = (IPropertySource)ep.getAdapter((Class)clazz2)).getPropertyValue((Object)this.sfCompositeLayout)) != null && (intPV = gridLayout.getPropertyValue((Object)sf)) != null && intPV instanceof IJavaDataTypeInstance) {
                    IIntegerBeanProxy intProxy = (IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaDataTypeInstance)intPV), (ResourceSet)this.rset);
                    return intProxy.intValue();
                }
            }
        }
        return 0;
    }

    protected Command createBooleanCommand(EditPart editpart, EStructuralFeature sf, boolean value) {
        CommandBuilder cb = new CommandBuilder();
        EObject control = (EObject)editpart.getModel();
        if (control != null) {
            IJavaInstance layout = (IJavaInstance)control.eGet((EStructuralFeature)this.sfCompositeLayout);
            if (layout == null) {
                return UnexecutableCommand.INSTANCE;
            }
            RuledCommandBuilder componentCB = new RuledCommandBuilder(EditDomain.getEditDomain((EditPart)editpart), null, false);
            String init = String.valueOf(value);
            IJavaInstance booleanObject = BeanUtilities.createJavaObject((String)"boolean", (ResourceSet)this.rset, (String)init);
            componentCB.applyAttributeSetting((EObject)layout, sf, (Object)booleanObject);
            componentCB.applyAttributeSetting(control, (EStructuralFeature)this.sfCompositeLayout, (Object)layout);
            cb.append(componentCB.getCommand());
            return cb.getCommand();
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean getBooleanValue(EditPart ep, EStructuralFeature sf) {
        if (this.getResourceSet(ep) != null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((IPropertySource)ep.getAdapter((Class)clazz) instanceof IPropertySource) {
                Object booleanPV;
                IPropertySource ps;
                IPropertySource gridLayout;
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((gridLayout = (IPropertySource)(ps = (IPropertySource)ep.getAdapter((Class)clazz2)).getPropertyValue((Object)this.sfCompositeLayout)) != null && (booleanPV = gridLayout.getPropertyValue((Object)sf)) != null && booleanPV instanceof IJavaDataTypeInstance) {
                    IBooleanBeanProxy booleanProxy = (IBooleanBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaDataTypeInstance)booleanPV), (ResourceSet)this.rset);
                    return booleanProxy.booleanValue();
                }
            }
        }
        return false;
    }

    protected void execute(Command command) {
        CommandStack cmdStack;
        if (command == null || !command.canExecute()) {
            return;
        }
        IEditorPart iEditorPart = this.getEditorPart();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.gef.commands.CommandStack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((cmdStack = (CommandStack)iEditorPart.getAdapter((Class)clazz)) != null) {
            cmdStack.execute(command);
        }
    }

    private void resetVariables() {
        this.rset = null;
        this.sfCompositeLayout = null;
        this.sfFill = null;
        this.sfJustify = null;
        this.sfPack = null;
        this.sfSpacing = null;
        this.sfType = null;
        this.sfWrap = null;
        this.sfMarginHeight = null;
        this.sfMarginWidth = null;
        this.sfMarginBottom = null;
        this.sfMarginLeft = null;
        this.sfMarginRight = null;
        this.sfMarginTop = null;
        this.initialized = false;
    }

    protected ResourceSet getResourceSet(EditPart editpart) {
        if (this.rset == null) {
            this.rset = EMFEditDomainHelper.getResourceSet((EditDomain)EditDomain.getEditDomain((EditPart)editpart));
            this.sfCompositeLayout = JavaInstantiation.getReference((ResourceSet)this.rset, (URI)SWTConstants.SF_COMPOSITE_LAYOUT);
            this.sfFill = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_ROW_LAYOUT_FILL);
            this.sfJustify = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_ROW_LAYOUT_JUSTIFY);
            this.sfPack = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_ROW_LAYOUT_PACK);
            this.sfSpacing = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_ROW_LAYOUT_SPACING);
            this.sfType = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_ROW_LAYOUT_TYPE);
            this.sfWrap = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_ROW_LAYOUT_WRAP);
            this.sfMarginHeight = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_ROW_LAYOUT_MARGIN_HEIGHT);
            this.sfMarginWidth = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_ROW_LAYOUT_MARGIN_WIDTH);
            this.sfMarginBottom = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_ROW_LAYOUT_MARGIN_BOTTOM);
            this.sfMarginLeft = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_ROW_LAYOUT_MARGIN_LEFT);
            this.sfMarginRight = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_ROW_LAYOUT_MARGIN_RIGHT);
            this.sfMarginTop = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_ROW_LAYOUT_MARGIN_TOP);
        }
        return this.rset;
    }

    protected class EnableSpinnerCommand
    extends AbstractCommand {
        protected Spinner spinner;

        public EnableSpinnerCommand(Spinner spinner) {
            this.spinner = spinner;
        }

        public void execute() {
            if (this.spinner != null) {
                this.spinner.setEnabled(true);
            }
        }

        public boolean canExecute() {
            return true;
        }
    }
}

