/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jem.internal.proxy.core.ConfigurationContributorAdapter;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionController;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionInfo;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.remote.swt.SWTREMProxyRegistration;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.ve.internal.swt.SWTMessages;
import org.eclipse.ve.internal.swt.SwtPlugin;
import org.osgi.framework.Bundle;

public class SWTConfigurationContributor
extends ConfigurationContributorAdapter {
    public static final String SWT_BUILD_PATH_MARKER = "org.eclipse.ve.swt.buildpath";
    protected IJavaProject javaProject;

    public void initialize(IConfigurationContributionInfo info) {
        super.initialize(info);
        this.javaProject = info.getJavaProject();
    }

    public void contributeClasspaths(final IConfigurationContributionController controller) throws CoreException {
        controller.contributeClasspath(SwtPlugin.getDefault().getBundle(), "jbcfswtvm.jar", 0, false);
        if (!ProxyPlugin.isPDEProject((IJavaProject)this.javaProject)) {
            controller.contributeClasspath(Platform.getBundle((String)"org.eclipse.swt"), "$os$", 4, false);
        } else {
            URL ide = Platform.find((Bundle)Platform.getBundle((String)"org.eclipse.swt"), (IPath)new Path("$os$"));
            Path idePath = new Path(ide.getFile());
            IPath relPath = idePath.removeFirstSegments(idePath.segmentCount() - 3);
            PluginModelManager pm = PDECore.getDefault().getModelManager();
            IFragmentModel[] frags = pm.getFragments();
            URL os = null;
            int i = 0;
            while (i < frags.length) {
                if (frags[i].getBundleDescription().getHost().getName().equals("org.eclipse.swt") && !frags[i].getBundleDescription().getSymbolicName().startsWith("org.eclipse.swt.nl") && (os = this.getResourceURL(frags[i], relPath.toString())) != null) break;
                ++i;
            }
            final URL osURL = os;
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    if (osURL != null) {
                        controller.contributeClasspath(osURL, 4);
                        SWTConfigurationContributor.this.removeMarker("Could not resolve the SWT dll on the PDE target");
                    } else {
                        SWTConfigurationContributor.this.createMarker("Could not resolve the SWT dll on the PDE target");
                    }
                }
            }, null, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        if ("gtk".equals(Platform.getWS())) {
            controller.contributeClasspath(Platform.getBundle((String)"org.eclipse.ve.swt"), "$os$", 4, false);
        }
    }

    public void contributeToConfiguration(ILaunchConfigurationWorkingCopy config) throws CoreException {
    }

    protected IMarker[] getMarker(String msg) {
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        try {
            IMarker[] markers = this.javaProject.getProject().findMarkers(SWT_BUILD_PATH_MARKER, false, 0);
            int i = 0;
            while (i < markers.length) {
                if (markers[i].getAttribute("message").equals(msg)) {
                    result.add(markers[i]);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            SwtPlugin.getDefault().getLogger().log((Throwable)e, Level.WARNING);
        }
        return result.toArray(new IMarker[result.size()]);
    }

    protected void removeMarker(String msg) {
        try {
            IMarker[] marks = this.getMarker(msg);
            int i = 0;
            while (i < marks.length) {
                marks[i].delete();
                ++i;
            }
        }
        catch (CoreException e) {
            SwtPlugin.getDefault().getLogger().log((Throwable)e, Level.WARNING);
        }
    }

    protected void createMarker(String msg) {
        try {
            if (this.getMarker(msg).length == 0) {
                IMarker marker = this.javaProject.getProject().createMarker(SWT_BUILD_PATH_MARKER);
                marker.setAttribute("severity", 2);
                marker.setAttribute("message", (Object)msg);
            }
        }
        catch (CoreException e) {
            SwtPlugin.getDefault().getLogger().log((Throwable)e, Level.WARNING);
        }
    }

    public void contributeToRegistry(ProxyFactoryRegistry registry) {
        SWTREMProxyRegistration.initialize(registry);
        if (this.javaProject != null) {
            StringTokenizer versTokens;
            boolean versOk = true;
            IBeanProxy version = registry.getMethodProxyFactory().getInvokable("java.lang.System", "getProperty", new String[]{"java.lang.String"}).invokeCatchThrowableExceptions(null, (IBeanProxy)registry.getBeanProxyFactory().createBeanProxyWith("java.version"));
            if (version instanceof IStringBeanProxy && (versTokens = new StringTokenizer(((IStringBeanProxy)version).stringValue(), "._")).hasMoreTokens()) {
                try {
                    Integer v = Integer.valueOf(versTokens.nextToken());
                    if (v == 1 && versTokens.hasMoreTokens()) {
                        Integer r = Integer.valueOf(versTokens.nextToken());
                        if (r < 4) {
                            versOk = false;
                        } else if (r == 4) {
                            if (versTokens.hasMoreTokens()) {
                                Integer m = Integer.valueOf(versTokens.nextToken());
                                if (m < 2) {
                                    versOk = false;
                                }
                            } else {
                                versOk = false;
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            final boolean fversok = versOk;
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        if (fversok) {
                            SWTConfigurationContributor.this.removeMarker(SWTMessages.getString("Marker.BuildPathNot142"));
                        } else {
                            SWTConfigurationContributor.this.createMarker(SWTMessages.getString("Marker.BuildPathNot142"));
                        }
                    }
                }, null, 1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                SwtPlugin.getDefault().getLogger().log((Throwable)e, Level.WARNING);
            }
        }
    }

    private URL getResourceURL(IFragmentModel frag, String relativePath) {
        String location = frag.getInstallLocation();
        if (location == null) {
            return null;
        }
        File file = new File(location);
        URL url = null;
        try {
            if (file.isFile() && file.getName().endsWith(".jar")) {
                ZipFile zip = new ZipFile(file);
                if (zip.getEntry(relativePath) != null) {
                    url = new URL("jar:file:" + file.getAbsolutePath() + "!/" + relativePath);
                }
            } else if (new File(file, relativePath).exists()) {
                url = new URL("file:" + file.getAbsolutePath() + '/' + relativePath);
            }
        }
        catch (IOException iOException) {}
        return url;
    }
}

