/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionController;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionInfo;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributor;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.swt.SWTConfigurationContributor;
import org.eclipse.ve.internal.swt.SWTMessages;

public class SWTContainer
implements IClasspathContainer,
IConfigurationContributor {
    private IClasspathEntry[] fClasspathEntries;
    private IPath containerPath;
    private static final String[][] swtLibraries = new String[][]{{"org.eclipse.swt", "$ws$/swt.jar"}};
    private static final String[][] swtGTKLibraries = new String[][]{{"org.eclipse.swt.gtk", "$ws$/swt-pi.jar"}, {"org.eclipse.swt.gtk", "$ws$/swt-mozilla.jar"}};
    private static final String[][] jfaceLibraries = new String[][]{{"org.eclipse.jface", "jface.jar"}, {"org.eclipse.jface.text", "jfacetext.jar"}, {"org.eclipse.core.runtime", "runtime.jar"}, {"org.eclipse.core.runtime.compatibility", "compatibility.jar"}, {"org.eclipse.osgi", "osgi.jar"}};
    private SWTConfigurationContributor configContribute = new SWTConfigurationContributor();

    public SWTContainer(IPath containerPath) {
        this.containerPath = containerPath;
        try {
            int j;
            Path srcPath;
            URL[] locSrc;
            Path path;
            boolean isJFace = this.isJFace(containerPath);
            boolean isGTK = this.isGTK();
            int classpathlength = swtLibraries.length;
            if (isJFace) {
                classpathlength += jfaceLibraries.length;
            }
            if (isGTK) {
                classpathlength += swtGTKLibraries.length;
            }
            this.fClasspathEntries = new IClasspathEntry[classpathlength];
            int ci = 0;
            int i = 0;
            while (i < swtLibraries.length) {
                path = new Path(swtLibraries[i][1]);
                locSrc = ProxyPlugin.getPlugin().findPluginJarAndAttachedSource(Platform.getBundle((String)swtLibraries[i][0]), (IPath)path);
                if (locSrc[0] != null) {
                    path = new Path(Platform.resolve((URL)locSrc[0]).getFile());
                    srcPath = null;
                    if (locSrc[1] != null) {
                        srcPath = new Path(Platform.resolve((URL)locSrc[1]).getFile());
                    }
                    this.fClasspathEntries[ci++] = JavaCore.newLibraryEntry((IPath)path, srcPath, null);
                }
                ++i;
            }
            if (isJFace) {
                j = 0;
                while (j < jfaceLibraries.length) {
                    path = new Path(jfaceLibraries[j][1]);
                    locSrc = ProxyPlugin.getPlugin().findPluginJarAndAttachedSource(Platform.getBundle((String)jfaceLibraries[j][0]), (IPath)path);
                    if (locSrc[0] != null) {
                        path = new Path(Platform.resolve((URL)locSrc[0]).getFile());
                        srcPath = null;
                        if (locSrc[1] != null) {
                            srcPath = new Path(Platform.resolve((URL)locSrc[1]).getFile());
                        }
                        this.fClasspathEntries[ci++] = JavaCore.newLibraryEntry((IPath)path, (IPath)srcPath, null);
                    }
                    ++j;
                }
            }
            if (isGTK) {
                j = 0;
                while (j < swtGTKLibraries.length) {
                    path = new Path(swtGTKLibraries[j][1]);
                    locSrc = ProxyPlugin.getPlugin().findPluginJarAndAttachedSource(Platform.getBundle((String)swtGTKLibraries[j][0]), (IPath)path);
                    if (locSrc[0] != null) {
                        path = new Path(Platform.resolve((URL)locSrc[0]).getFile());
                        srcPath = null;
                        if (locSrc[1] != null) {
                            srcPath = new Path(Platform.resolve((URL)locSrc[1]).getFile());
                        }
                        this.fClasspathEntries[ci++] = JavaCore.newLibraryEntry((IPath)path, (IPath)srcPath, null);
                    }
                    ++j;
                }
            }
        }
        catch (IOException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.INFO);
        }
    }

    private boolean isGTK() {
        return "gtk".equals(Platform.getWS());
    }

    private boolean isJFace(IPath containerPath) {
        return "JFACE".equals(containerPath.segment(1));
    }

    public IClasspathEntry[] getClasspathEntries() {
        return this.fClasspathEntries;
    }

    public String getDescription() {
        return SWTMessages.getString("SWTContainer.Description");
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.containerPath;
    }

    public void initialize(IConfigurationContributionInfo info) {
        this.configContribute.initialize(info);
    }

    public void contributeClasspaths(IConfigurationContributionController controller) throws CoreException {
        this.configContribute.contributeClasspaths(controller);
    }

    public void contributeToConfiguration(ILaunchConfigurationWorkingCopy config) throws CoreException {
        this.configContribute.contributeToConfiguration(config);
    }

    public void contributeToRegistry(ProxyFactoryRegistry registry) {
        this.configContribute.contributeToRegistry(registry);
    }
}

