/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.List;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.IImageListener;
import org.eclipse.ve.internal.cde.emf.EditPartAdapterRunnable;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.swt.CompositeGraphicalEditPart;
import org.eclipse.ve.internal.swt.DefaultLayoutEditPolicy;
import org.eclipse.ve.internal.swt.SWTConstants;
import org.eclipse.ve.internal.swt.TableColumnGraphicalEditPart;
import org.eclipse.ve.internal.swt.TableColumnProxyAdapter;
import org.eclipse.ve.internal.swt.TableContainerPolicy;
import org.eclipse.ve.internal.swt.TableProxyAdapter;

public class TableGraphicalEditPart
extends CompositeGraphicalEditPart {
    private TableProxyAdapter tableProxyAdapter;
    private EStructuralFeature sfColumns;
    private TableImageListener fImageListener;
    protected FigureListener hostFigureListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            TableGraphicalEditPart.this.refreshColumns();
        }
    };
    private Adapter tableAdapter = new EditPartAdapterRunnable(){

        public void run() {
            if (TableGraphicalEditPart.this.isActive()) {
                TableGraphicalEditPart.this.refreshChildren();
                TableGraphicalEditPart.this.refreshColumns();
            }
        }

        public void notifyChanged(Notification notification) {
            if (notification.getFeature() == TableGraphicalEditPart.this.sfColumns) {
                this.queueExec((EditPart)TableGraphicalEditPart.this);
            }
        }
    };
    private Runnable fRefreshColumnsRunnable = new Runnable(){

        public void run() {
            int columnWidth = 0;
            int columnHeight = TableGraphicalEditPart.this.getHeaderHeight();
            Rectangle parentRect = TableGraphicalEditPart.this.getBounds();
            Point nextColumnLocation = new Point(parentRect.x, parentRect.y);
            List children = TableGraphicalEditPart.this.getChildren();
            int i = 0;
            while (i < children.size()) {
                TableColumnGraphicalEditPart columnEP = (TableColumnGraphicalEditPart)((Object)children.get(i));
                TableColumnProxyAdapter proxyAdapter = columnEP.getControlProxy();
                if (proxyAdapter != null && proxyAdapter.isBeanProxyInstantiated()) {
                    columnWidth = columnEP.getControlProxy().getWidth().intValue();
                    columnEP.setBounds(new Rectangle(nextColumnLocation.x, nextColumnLocation.y, columnWidth, columnHeight));
                    columnEP.refresh();
                    nextColumnLocation.x += columnWidth;
                }
                ++i;
            }
        }
    };

    public TableGraphicalEditPart(Object aModel) {
        super(aModel);
    }

    protected VisualContainerPolicy getContainerPolicy() {
        return new TableContainerPolicy(EditDomain.getEditDomain((EditPart)this));
    }

    protected Rectangle getBounds() {
        return this.getFigure().getBounds().getCopy();
    }

    protected TableImageListener getTableImageListener() {
        if (this.fImageListener == null) {
            this.fImageListener = new TableImageListener();
        }
        return this.fImageListener;
    }

    public void activate() {
        super.activate();
        ((EObject)this.getModel()).eAdapters().add((Object)this.tableAdapter);
        this.getFigure().addFigureListener(this.hostFigureListener);
        this.getVisualComponent().addImageListener((IImageListener)this.getTableImageListener());
    }

    public void deactivate() {
        super.deactivate();
        ((EObject)this.getModel()).eAdapters().remove((Object)this.tableAdapter);
        this.getFigure().removeFigureListener(this.hostFigureListener);
        this.getVisualComponent().removeImageListener((IImageListener)this.getTableImageListener());
        this.tableProxyAdapter = null;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
    }

    protected void createLayoutEditPolicy() {
        EditDomain domain = EditDomain.getEditDomain((EditPart)this);
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new DefaultLayoutEditPolicy(new TableContainerPolicy(domain)));
    }

    protected List getModelChildren() {
        return (List)this.getBean().eGet(this.sfColumns);
    }

    protected EditPart createChild(Object child) {
        TableColumnGraphicalEditPart result = new TableColumnGraphicalEditPart();
        result.setModel(child);
        return result;
    }

    protected int getHeaderHeight() {
        IIntegerBeanProxy intBeanProxy = this.getTableProxyAdapter().getHeaderHeight();
        if (intBeanProxy != null) {
            return intBeanProxy.intValue();
        }
        return 0;
    }

    protected TableProxyAdapter getTableProxyAdapter() {
        if (this.tableProxyAdapter == null) {
            IBeanProxyHost tableProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaObjectInstance)this.getModel()));
            this.tableProxyAdapter = (TableProxyAdapter)tableProxyHost;
        }
        return this.tableProxyAdapter;
    }

    private void refreshColumns() {
        if (this.getChildren().size() == 0) {
            return;
        }
        CDEUtilities.displayExec((EditPart)this, (Runnable)this.fRefreshColumnsRunnable);
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.sfColumns = JavaInstantiation.getSFeature((ResourceSet)((EObject)model).eClass().eResource().getResourceSet(), (URI)SWTConstants.SF_TABLE_COLUMNS);
    }

    protected class TableImageListener
    implements IImageListener {
        protected TableImageListener() {
        }

        public void imageChanged(ImageData imageData) {
            TableGraphicalEditPart.this.refreshColumns();
        }
    }
}

