/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.internal.beaninfo.BeanDecorator;
import org.eclipse.jem.internal.beaninfo.FeatureAttributeValue;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.internal.instantiation.InstantiationFactory;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.PTClassInstanceCreation;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.PTFieldAccess;
import org.eclipse.jem.internal.instantiation.PTInfixExpression;
import org.eclipse.jem.internal.instantiation.PTInfixOperator;
import org.eclipse.jem.internal.instantiation.PTName;
import org.eclipse.jem.internal.instantiation.ParseTreeAllocation;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ve.internal.java.core.BasicAllocationProcesser;
import org.eclipse.ve.internal.java.core.BeanPropertySourceAdapter;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.EnumeratedIntValueCellEditor;
import org.eclipse.ve.internal.java.core.EnumeratedIntValueLabelProvider;
import org.eclipse.ve.internal.java.core.IAllocationProcesser;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;
import org.eclipse.ve.internal.jcm.JCMPackage;
import org.eclipse.ve.internal.propertysheet.EToolsPropertyDescriptor;
import org.eclipse.ve.internal.swt.SWTMessages;
import org.eclipse.ve.internal.swt.SwtPlugin;
import org.eclipse.ve.internal.swt.WidgetProxyAdapter;

public class WidgetPropertySourceAdapter
extends BeanPropertySourceAdapter {
    private static String[] EXPERT_FILTER_FLAGS = new String[]{"org.eclipse.ui.views.properties.expert"};
    private static final Object SWEET_STYLE_ID = "org.eclipse.ve.sweet.stylebits";
    protected static final String SWT_TYPE_ID = "org.eclipse.swt.SWT";
    protected static final String STYLE_NONE = "NONE";
    protected static final int STYLE_NOT_SET = -1;
    private static final String STYLE_NOT_SET_INITSTRING = String.valueOf(-1);
    private WidgetProxyAdapter widgetProxyAdapter;
    private int explicitStyle = -1;

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] propertyDescriptors = super.getPropertyDescriptors();
        ArrayList<IPropertyDescriptor> descriptorsList = new ArrayList<IPropertyDescriptor>(propertyDescriptors.length + 5);
        int i = 0;
        while (i < propertyDescriptors.length) {
            descriptorsList.add(propertyDescriptors[i]);
            ++i;
        }
        if (((EObject)this.getTarget()).eContainmentFeature() != JCMPackage.eINSTANCE.getBeanSubclassComposition_ThisPart()) {
            this.mergeStyleBits(descriptorsList, ((EObject)this.getTarget()).eClass());
        }
        return descriptorsList.toArray(new IPropertyDescriptor[descriptorsList.size()]);
    }

    protected void mergeStyleBits(List propertyDescriptors, EClass eClass) {
        BeanDecorator beanDecor = Utilities.getBeanDecorator((EModelElement)eClass);
        Map styleDetails = WidgetPropertySourceAdapter.getStyleDetails(beanDecor);
        while (styleDetails == null || styleDetails.size() == 0) {
            if ((eClass = ((JavaClass)eClass).getSupertype()) == null) {
                return;
            }
            beanDecor = Utilities.getBeanDecorator((EModelElement)eClass);
            styleDetails = WidgetPropertySourceAdapter.getStyleDetails(beanDecor);
        }
        Iterator sweetProperties = styleDetails.keySet().iterator();
        while (sweetProperties.hasNext()) {
            String propertyName = (String)sweetProperties.next();
            SweetStyleBits styleBits = (SweetStyleBits)styleDetails.get(propertyName);
            String[] names = styleBits.fNames;
            String[] initStrings = styleBits.fInitStrings;
            Integer[] values = styleBits.fValues;
            if (names.length == 1) {
                names = new String[]{names[0], SWTMessages.getString("WidgetPropertySourceAdapter.NotSet")};
                initStrings = new String[]{initStrings[0], STYLE_NOT_SET_INITSTRING};
                values = new Integer[]{values[0], new Integer(-1)};
            }
            StyleBitPropertyDescriptor property = new StyleBitPropertyDescriptor(propertyName, styleBits.fDisplayName, styleBits.fIsExpert, names, initStrings, values);
            propertyDescriptors.add(property);
        }
    }

    public static Map getStyleDetails(BeanDecorator beanDecorator) {
        FeatureAttributeValue value = (FeatureAttributeValue)beanDecorator.getAttributes().get(SWEET_STYLE_ID);
        if (value != null && value.isSetValueJava()) {
            return (Map)value.getValueJava();
        }
        if (value != null && value.isSetValueProxy()) {
            IArrayBeanProxy outerArray = (IArrayBeanProxy)value.getValueProxy();
            HashMap<String, SweetStyleBits> styleDetails = new HashMap<String, SweetStyleBits>();
            int i = 0;
            while (i < outerArray.getLength()) {
                try {
                    IArrayBeanProxy innerArray = (IArrayBeanProxy)outerArray.get(i);
                    String propertyName = ((IStringBeanProxy)innerArray.get(0)).stringValue();
                    String displayName = ((IStringBeanProxy)innerArray.get(1)).stringValue();
                    boolean expert = ((IBooleanBeanProxy)innerArray.get(2)).booleanValue();
                    IArrayBeanProxy triplicateArray = (IArrayBeanProxy)innerArray.get(3);
                    int numberOfValues = triplicateArray.getLength() / 3;
                    String[] names = new String[numberOfValues];
                    String[] initStrings = new String[numberOfValues];
                    Integer[] values = new Integer[numberOfValues];
                    int j = 0;
                    while (j < triplicateArray.getLength()) {
                        int index = j / 3;
                        names[index] = ((IStringBeanProxy)triplicateArray.get(j)).stringValue();
                        initStrings[index] = ((IStringBeanProxy)triplicateArray.get(j + 1)).stringValue();
                        values[index] = new Integer(((IIntegerBeanProxy)triplicateArray.get(j + 2)).intValue());
                        j += 3;
                    }
                    styleDetails.put(propertyName, new SweetStyleBits(propertyName, displayName, expert, names, initStrings, values));
                }
                catch (ThrowableProxy exc) {
                    SwtPlugin.getDefault().getLogger().log((Throwable)exc, Level.WARNING);
                }
                ++i;
            }
            value.setValueJava(styleDetails);
            return styleDetails;
        }
        return null;
    }

    private WidgetProxyAdapter getWidgetProxyAdapter() {
        if (this.widgetProxyAdapter == null) {
            this.widgetProxyAdapter = (WidgetProxyAdapter)BeanProxyUtilities.getBeanProxyHost((IJavaInstance)this.getBean());
        }
        return this.widgetProxyAdapter;
    }

    public Object getPropertyValue(Object descriptorID) {
        if (descriptorID instanceof EStructuralFeature) {
            return super.getPropertyValue(descriptorID);
        }
        if (descriptorID instanceof StyleBitPropertyID) {
            int currentStyleValue = this.getWidgetProxyAdapter().getStyle();
            Integer[] availableValues = ((StyleBitPropertyID)descriptorID).bitValues;
            int i = 0;
            while (i < availableValues.length) {
                if ((availableValues[i] & currentStyleValue) == availableValues[i]) {
                    return availableValues[i];
                }
                ++i;
            }
            return new Integer(-1);
        }
        return "???";
    }

    public boolean isPropertySet(Object descriptorID) {
        if (descriptorID instanceof EStructuralFeature) {
            return super.isPropertySet(descriptorID);
        }
        if (descriptorID instanceof StyleBitPropertyID) {
            int currentValue = (Integer)this.getPropertyValue(descriptorID);
            if (currentValue == -1) {
                return false;
            }
            return (currentValue & this.getExplicitStyle()) != 0;
        }
        return false;
    }

    protected int getExplicitStyle() {
        if (this.explicitStyle == -1) {
            PTExpression styleExpression;
            IBeanProxy styleBeanProxy = null;
            if (this.getBean().getAllocation() instanceof ParseTreeAllocation && (styleExpression = this.getStyleExpression(((ParseTreeAllocation)this.getBean().getAllocation()).getExpression())) != null) {
                try {
                    styleBeanProxy = BasicAllocationProcesser.instantiateWithExpression((PTExpression)styleExpression, (IBeanProxyDomain)this.getWidgetProxyAdapter().getBeanProxyDomain());
                    if (styleBeanProxy != null && !(styleBeanProxy instanceof IIntegerBeanProxy)) {
                        styleBeanProxy.getProxyFactoryRegistry().releaseProxy(styleBeanProxy);
                        styleBeanProxy = null;
                    }
                }
                catch (IAllocationProcesser.AllocationException e) {
                    SwtPlugin.getDefault().getLogger().log(e.getCause(), Level.INFO);
                }
            }
            this.explicitStyle = styleBeanProxy != null ? ((IIntegerBeanProxy)styleBeanProxy).intValue() : 0;
        }
        return this.explicitStyle;
    }

    protected PTExpression getStyleExpression(PTExpression allocationExp) {
        PTClassInstanceCreation classInstanceCreation;
        if (allocationExp instanceof PTClassInstanceCreation && (classInstanceCreation = (PTClassInstanceCreation)allocationExp).getArguments().size() == 2) {
            return (PTExpression)classInstanceCreation.getArguments().get(1);
        }
        return null;
    }

    public void resetPropertyValue(Object descriptorID) {
        if (!(descriptorID instanceof StyleBitPropertyID)) {
            super.resetPropertyValue(descriptorID);
        } else {
            this.setPropertyValue(descriptorID, null);
        }
    }

    protected boolean updateStyleBit(PTExpression current, StyleBitPropertyID id, int style) {
        PTInfixExpression infix;
        if (current instanceof PTFieldAccess) {
            PTFieldAccess field = (PTFieldAccess)current;
            if (this.isSameStyleFamily(field, id)) {
                this.updateField(field, id.getInitString(style));
                return true;
            }
            return false;
        }
        if (current instanceof PTInfixExpression && (infix = (PTInfixExpression)current).getOperator() == PTInfixOperator.OR_LITERAL) {
            if (this.updateStyleBit(infix.getLeftOperand(), id, style) || this.updateStyleBit(infix.getRightOperand(), id, style)) {
                return true;
            }
            if (!infix.getExtendedOperands().isEmpty()) {
                EList ext = infix.getExtendedOperands();
                int i = 0;
                while (i < ext.size()) {
                    if (this.updateStyleBit((PTExpression)ext.get(i), id, style)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    protected PTFieldAccess updateField(PTFieldAccess current, String[] updateTo) {
        if (current == null) {
            current = InstantiationFactory.eINSTANCE.createPTFieldAccess();
        }
        if (current.getReceiver() == null || !(current.getReceiver() instanceof PTName) || !((PTName)current.getReceiver()).getName().equals(updateTo[0])) {
            current.setReceiver((PTExpression)InstantiationFactory.eINSTANCE.createPTName(updateTo[0]));
        }
        current.setField(updateTo[1]);
        return current;
    }

    protected PTExpression addStyleBit(PTExpression current, StyleBitPropertyID id, int style) {
        if (this.updateStyleBit(current, id, style)) {
            return current;
        }
        PTFieldAccess field = this.updateField(null, id.getInitString(style));
        if (current == null) {
            return field;
        }
        if (current instanceof PTFieldAccess) {
            return InstantiationFactory.eINSTANCE.createPTInfixExpression(current, PTInfixOperator.OR_LITERAL, (PTExpression)field, null);
        }
        if (current instanceof PTInfixExpression) {
            if (((PTInfixExpression)current).getOperator() == PTInfixOperator.OR_LITERAL) {
                ((PTInfixExpression)current).getExtendedOperands().add((Object)field);
                return current;
            }
            return InstantiationFactory.eINSTANCE.createPTInfixExpression(current, PTInfixOperator.OR_LITERAL, (PTExpression)field, null);
        }
        return current;
    }

    protected PTExpression removeStyleBit(PTExpression styleExpression, StyleBitPropertyID id, int style) {
        if (styleExpression instanceof PTFieldAccess) {
            if (this.isSameStyleFamily((PTFieldAccess)styleExpression, id)) {
                return null;
            }
            return styleExpression;
        }
        if (styleExpression instanceof PTInfixExpression && ((PTInfixExpression)styleExpression).getOperator() == PTInfixOperator.OR_LITERAL) {
            int i;
            EList ext;
            PTInfixExpression infixExpression = (PTInfixExpression)styleExpression;
            if (infixExpression.getLeftOperand() instanceof PTFieldAccess && this.isSameStyleFamily((PTFieldAccess)infixExpression.getLeftOperand(), id)) {
                if (infixExpression.getExtendedOperands().isEmpty()) {
                    return infixExpression.getRightOperand();
                }
                infixExpression.setLeftOperand(infixExpression.getRightOperand());
                infixExpression.setRightOperand((PTExpression)infixExpression.getExtendedOperands().remove(0));
                return infixExpression;
            }
            if (infixExpression.getRightOperand() instanceof PTFieldAccess && this.isSameStyleFamily((PTFieldAccess)infixExpression.getRightOperand(), id)) {
                if (infixExpression.getExtendedOperands().isEmpty()) {
                    return infixExpression.getLeftOperand();
                }
                infixExpression.setRightOperand((PTExpression)infixExpression.getExtendedOperands().remove(0));
                return infixExpression;
            }
            if (!infixExpression.getExtendedOperands().isEmpty()) {
                ext = infixExpression.getExtendedOperands();
                i = 0;
                while (i < ext.size()) {
                    if (ext.get(i) instanceof PTFieldAccess && this.isSameStyleFamily((PTFieldAccess)ext.get(i), id)) {
                        ext.remove(i);
                        return infixExpression;
                    }
                    ++i;
                }
            }
            infixExpression.setLeftOperand(this.removeStyleBit(infixExpression.getLeftOperand(), id, style));
            infixExpression.setRightOperand(this.removeStyleBit(infixExpression.getRightOperand(), id, style));
            if (!infixExpression.getExtendedOperands().isEmpty()) {
                ext = infixExpression.getExtendedOperands();
                i = 0;
                while (i < ext.size()) {
                    ext.set(i, this.removeStyleBit((PTExpression)ext.get(i), id, style));
                    ++i;
                }
            }
            return infixExpression;
        }
        return styleExpression;
    }

    public void setPropertyValue(Object feature, Object val) {
        if (feature instanceof EStructuralFeature) {
            super.setPropertyValue(feature, val);
        } else if (feature instanceof StyleBitPropertyID) {
            PTExpression newAllocation;
            int intValue;
            StyleBitPropertyID propertyID = (StyleBitPropertyID)feature;
            int n = intValue = val != null ? ((IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaInstance)val))).intValue() : -1;
            if ((Integer)this.getPropertyValue(feature) == intValue) {
                return;
            }
            JavaAllocation alloc = this.getBean().getAllocation();
            if (alloc instanceof ParseTreeAllocation && (newAllocation = this.getChangedAllocation(((ParseTreeAllocation)alloc).getExpression(), propertyID, intValue)) != null) {
                ParseTreeAllocation newParseTreeAlloc = InstantiationFactory.eINSTANCE.createParseTreeAllocation();
                newParseTreeAlloc.setExpression(newAllocation);
                this.getBean().setAllocation((JavaAllocation)newParseTreeAlloc);
            }
        }
    }

    protected PTExpression getChangedAllocation(PTExpression allocationExpression, StyleBitPropertyID propertyID, int styleBit) {
        PTClassInstanceCreation classInstanceCreation;
        if (allocationExpression instanceof PTClassInstanceCreation && (classInstanceCreation = (PTClassInstanceCreation)allocationExpression).getArguments().size() >= 2) {
            PTExpression currentArg = (PTExpression)classInstanceCreation.getArguments().set(1, (Object)InstantiationFactory.eINSTANCE.createPTNullLiteral());
            PTExpression newArg = this.getChangedStyleExpression(currentArg, propertyID, styleBit);
            if (newArg == null) {
                PTName name = InstantiationFactory.eINSTANCE.createPTName(SWT_TYPE_ID);
                newArg = InstantiationFactory.eINSTANCE.createPTFieldAccess((PTExpression)name, STYLE_NONE);
            }
            classInstanceCreation.getArguments().set(1, (Object)newArg);
            return classInstanceCreation;
        }
        return null;
    }

    protected PTExpression getChangedStyleExpression(PTExpression styleExpression, StyleBitPropertyID propertyID, int style) {
        return style != -1 ? this.addStyleBit(styleExpression, propertyID, style) : this.removeStyleBit(styleExpression, propertyID, style);
    }

    private boolean isSameStyleFamily(PTFieldAccess existingField, StyleBitPropertyID propertyID) {
        if (existingField.getReceiver() instanceof PTName && SWT_TYPE_ID.equals(((PTName)existingField.getReceiver()).getName()) && STYLE_NONE.equals(existingField.getField())) {
            return true;
        }
        return propertyID.includeInitString(existingField);
    }

    protected boolean isSameStyleFamilySet(PTExpression expression, StyleBitPropertyID propertyID) {
        if (expression instanceof PTFieldAccess) {
            return this.isSameStyleFamily((PTFieldAccess)expression, propertyID);
        }
        if (expression instanceof PTInfixExpression && ((PTInfixExpression)expression).getOperator() == PTInfixOperator.OR_LITERAL) {
            PTInfixExpression infix = (PTInfixExpression)expression;
            if (this.isSameStyleFamily((PTFieldAccess)infix.getLeftOperand(), propertyID) || this.isSameStyleFamily((PTFieldAccess)infix.getRightOperand(), propertyID)) {
                return true;
            }
            if (!infix.getExtendedOperands().isEmpty()) {
                EList ext = infix.getExtendedOperands();
                int i = 0;
                while (i < ext.size()) {
                    if (this.isSameStyleFamily((PTFieldAccess)ext.get(i), propertyID)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    protected StyleBitPropertyID findFamily(String familyName) {
        IPropertyDescriptor[] properties = this.getPropertyDescriptors();
        int i = 0;
        while (i < properties.length) {
            StyleBitPropertyID id;
            if (properties[i].getId() instanceof StyleBitPropertyID && (id = (StyleBitPropertyID)properties[i].getId()).getFamilyName().equals(familyName)) {
                return id;
            }
            ++i;
        }
        return null;
    }

    public void notifyChanged(Notification msg) {
        if (msg.getFeature() == JavaInstantiation.getAllocationFeature((IJavaInstance)this.getBean())) {
            this.explicitStyle = -1;
        }
        super.notifyChanged(msg);
    }

    static class StyleBitPropertyID {
        String propertyName;
        public Integer[] bitValues;
        private String[] fInitStrings;
        private String[][] packagedInitStrings;
        private static final String[] UNKNOWN = new String[]{"???", "???"};

        StyleBitPropertyID(String aPropertyName, Integer[] values, String[] initStrings) {
            this.propertyName = aPropertyName;
            this.bitValues = values;
            this.fInitStrings = initStrings;
        }

        public String getFamilyName() {
            return this.propertyName;
        }

        public boolean includeInitString(PTFieldAccess existingField) {
            if (!(existingField.getReceiver() instanceof PTName)) {
                return false;
            }
            return this.getStyle(((PTName)existingField.getReceiver()).getName(), existingField.getField()) != -1;
        }

        public String[] getInitString(int val) {
            this.initializepackagedInitStrings();
            int i = 0;
            while (i < this.bitValues.length) {
                if (this.bitValues[i] == val) {
                    return this.packagedInitStrings[i];
                }
                ++i;
            }
            return UNKNOWN;
        }

        public int getStyle(String className, String fieldName) {
            this.initializepackagedInitStrings();
            int i = 0;
            while (i < this.packagedInitStrings.length) {
                if (this.packagedInitStrings[i][1].equals(fieldName) && this.packagedInitStrings[i][0].equals(className)) {
                    return this.bitValues[i];
                }
                ++i;
            }
            return -1;
        }

        private void initializepackagedInitStrings() {
            if (this.packagedInitStrings == null) {
                this.packagedInitStrings = new String[this.fInitStrings.length][2];
                int i = 0;
                while (i < this.fInitStrings.length) {
                    int lastDot = this.fInitStrings[i].lastIndexOf(46);
                    if (lastDot != -1) {
                        this.packagedInitStrings[i][0] = this.fInitStrings[i].substring(0, lastDot);
                        this.packagedInitStrings[i][1] = this.fInitStrings[i].substring(lastDot + 1);
                    } else {
                        this.packagedInitStrings[i][0] = "";
                        this.packagedInitStrings[i][1] = this.fInitStrings[i];
                    }
                    ++i;
                }
            }
        }
    }

    public static class StyleBitPropertyDescriptor
    extends EToolsPropertyDescriptor {
        String fPropertyName;
        String fDisplayName;
        String[] fNames;
        String[] fInitStrings;
        Integer[] fValues;
        boolean fIsExpert;
        private ILabelProvider labelProvider;

        public StyleBitPropertyDescriptor(String propertyName, String displayName, boolean isExpert, String[] names, String[] initStrings, Integer[] values) {
            super((Object)new StyleBitPropertyID(propertyName, values, initStrings), propertyName);
            this.fPropertyName = propertyName;
            this.fNames = names;
            this.fDisplayName = displayName;
            this.fIsExpert = isExpert;
            this.fInitStrings = initStrings;
            this.fValues = values;
        }

        public CellEditor createPropertyEditor(Composite parent) {
            return new EnumeratedIntValueCellEditor(parent, this.fNames, this.fValues, this.fInitStrings);
        }

        public ILabelProvider getLabelProvider() {
            if (this.labelProvider == null) {
                return new EnumeratedIntValueLabelProvider(this.fNames, this.fValues);
            }
            return this.labelProvider;
        }

        public String[] getFilterFlags() {
            return this.fIsExpert ? EXPERT_FILTER_FLAGS : null;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }
    }

    public static class SweetStyleBits {
        public String fPropertyName;
        public String fDisplayName;
        public boolean fIsExpert;
        public String[] fNames;
        public String[] fInitStrings;
        public Integer[] fValues;

        public SweetStyleBits(String propertyName, String displayName, boolean isExpert, String[] names, String[] initStrings, Integer[] values) {
            this.fPropertyName = propertyName;
            this.fDisplayName = displayName;
            this.fIsExpert = isExpert;
            this.fNames = names;
            this.fInitStrings = initStrings;
            this.fValues = values;
        }
    }
}

