/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ve.internal.cde.core.AlignmentCommandRequest;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class AlignmentAction
extends SelectionAction {
    private static final String[] resPrefix = new String[]{"AlignmentAction.left.", "AlignmentAction.center.", "AlignmentAction.right.", "AlignmentAction.top.", "AlignmentAction.middle.", "AlignmentAction.bottom.", "AlignmentAction.width.", "AlignmentAction.height."};
    protected int fAlignType;

    public AlignmentAction(int alignType) {
        super(null);
        this.fAlignType = alignType < 0 || alignType >= resPrefix.length ? 0 : alignType;
        String sAlignType = resPrefix[this.fAlignType];
        this.setText(CDEMessages.getString(String.valueOf(sAlignType) + "label"));
        this.setToolTipText(CDEMessages.getString(String.valueOf(sAlignType) + "tooltip"));
        String graphicName = CDEMessages.getString(String.valueOf(sAlignType) + "image");
        this.setImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/elcl16/" + graphicName));
        this.setHoverImageDescriptor(this.getImageDescriptor());
        this.setDisabledImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/dlcl16/" + graphicName));
        this.setEnabled(false);
        this.setId(AlignmentAction.getActionId(this.fAlignType));
    }

    public static String getActionId(int alignType) {
        return alignType >= 0 && alignType < resPrefix.length ? resPrefix[alignType] : resPrefix[0];
    }

    protected Command createAlignmentCommand(List objects) {
        if (objects.size() < 2) {
            return UnexecutableCommand.INSTANCE;
        }
        Iterator itr = objects.iterator();
        while (itr.hasNext()) {
            if (itr.next() instanceof EditPart) continue;
            return UnexecutableCommand.INSTANCE;
        }
        AlignmentCommandRequest alignReq = new AlignmentCommandRequest(this.fAlignType);
        ArrayList<EditPart> selectedParts = new ArrayList<EditPart>(objects.size() - 1);
        int i = 0;
        while (i < objects.size()) {
            EditPart editpart = (EditPart)objects.get(i);
            if (editpart.getSelected() == 2) {
                alignReq.setAnchorObject(editpart);
            } else {
                selectedParts.add(editpart);
            }
            ++i;
        }
        CompoundCommand compoundCmd = new CompoundCommand();
        int i2 = 0;
        while (i2 < selectedParts.size()) {
            EditPart editpart = (EditPart)selectedParts.get(i2);
            Command cmd = editpart.getCommand((Request)alignReq);
            if (cmd == null) {
                return UnexecutableCommand.INSTANCE;
            }
            compoundCmd.append(cmd);
            ++i2;
        }
        return compoundCmd;
    }

    public void run() {
        this.execute(this.createAlignmentCommand(this.getSelectedObjects()));
    }

    protected boolean calculateEnabled() {
        Command cmd = this.createAlignmentCommand(this.getSelectedObjects());
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    public void setWorkbenchPart(IWorkbenchPart part) {
        super.setWorkbenchPart(part);
    }
}

