/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import org.eclipse.draw2d.Cursors;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Sash;

public class CustomSashForm
extends SashForm {
    public static final String copyright = "(c) Copyright IBM Corporation 2002.";
    public static final int NO_MAX_LEFT = 1;
    public static final int NO_MAX_UP = 1;
    public static final int NO_MAX_RIGHT = 2;
    public static final int NO_MAX_DOWN = 2;
    private static final int NO_WEIGHT = -1;
    private static final int NO_ARROW = -1;
    protected SashInfo currentSashInfo = null;
    protected boolean inMouseClick = false;
    protected boolean[] sashBorders;
    protected boolean noMaxUp;
    protected boolean noMaxDown;
    protected static final int UP_ARROW = 0;
    protected static final int UP_MAX_ARROW = 1;
    protected static final int DOWN_ARROW = 2;
    protected static final int DOWN_MAX_ARROW = 3;
    protected static final int MAX_ARROWS = 4;
    protected static final int ARROW_TYPE_INDEX = 0;
    protected static final int ARROW_DRAWN_INDEX = 1;
    protected static final int X_INDEX = 2;
    protected static final int Y_INDEX = 3;
    protected static final int WIDTH_INDEX = 4;
    protected static final int HEIGHT_INDEX = 5;
    protected static final int ARROW_SIZE = 8;
    protected static final int ARROW_HEIGHT = 8;
    protected static final int ARROW_MARGIN = 3;
    protected Color arrowColor;
    protected Color borderColor;

    public CustomSashForm(Composite parent, int style) {
        this(parent, style, 0);
    }

    public CustomSashForm(Composite parent, int style, int customStyle) {
        super(parent, style);
        this.noMaxUp = (customStyle & 1) != 0;
        boolean bl = this.noMaxDown = (customStyle & 2) != 0;
        if (this.noMaxUp & this.noMaxDown) {
            return;
        }
        this.SASH_WIDTH = 3 + this.getOrientation() == 512 ? 8 : 8;
        this.arrowColor = new Color((Device)parent.getDisplay(), 99, 101, 156);
        this.borderColor = new Color((Device)parent.getDisplay(), 132, 130, 132);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CustomSashForm.this.arrowColor.dispose();
                CustomSashForm.this.borderColor.dispose();
                CustomSashForm.this.borderColor = null;
                CustomSashForm.this.arrowColor = null;
            }
        });
    }

    public void maxUp() {
        if (this.noMaxUp) {
            return;
        }
        if (this.currentSashInfo == null) {
            this.currentSashInfo = new SashInfo(null);
        }
        this.upMaxClicked(this.currentSashInfo);
    }

    public void maxLeft() {
        this.maxUp();
    }

    public void maxDown() {
        if (this.noMaxDown) {
            return;
        }
        if (this.currentSashInfo == null) {
            this.currentSashInfo = new SashInfo(null);
        }
        this.downMaxClicked(this.currentSashInfo);
    }

    public void maxRight() {
        this.maxDown();
    }

    public void setSashBorders(boolean[] sashBorders) {
        int[] weights = this.getWeights();
        if (weights.length != 2 || sashBorders != null && sashBorders.length != 2) {
            SWT.error((int)5);
        }
        this.sashBorders = sashBorders;
    }

    public void layout(boolean changed) {
        super.layout(changed);
        if (this.noMaxUp && this.noMaxDown) {
            return;
        }
        if (this.getMaximizedControl() != null) {
            return;
        }
        Control[] children = this.getChildren();
        Sash newSash = null;
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Sash) {
                if (newSash == null) {
                    newSash = (Sash)children[i];
                } else {
                    if (this.currentSashInfo != null) {
                        this.currentSashInfo.enabled = false;
                    }
                    return;
                }
            }
            ++i;
        }
        if (newSash == null) {
            return;
        }
        if (this.currentSashInfo == null || this.currentSashInfo.sash == null) {
            if (this.currentSashInfo == null) {
                this.currentSashInfo = new SashInfo(newSash);
            } else {
                this.currentSashInfo.sash = newSash;
            }
            newSash.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    GC gc = e.gc;
                    Color oldFg = gc.getForeground();
                    Color oldBg = gc.getBackground();
                    CustomSashForm.this.drawArrow(gc, CustomSashForm.this.currentSashInfo.sashLocs[0], CustomSashForm.this.currentSashInfo.cursorOver == 0);
                    if (CustomSashForm.this.currentSashInfo.sashLocs.length > 1) {
                        CustomSashForm.this.drawArrow(gc, CustomSashForm.this.currentSashInfo.sashLocs[1], CustomSashForm.this.currentSashInfo.cursorOver == 1);
                    }
                    if (CustomSashForm.this.currentSashInfo.sashBorderLeft) {
                        CustomSashForm.this.drawSashBorder(gc, CustomSashForm.this.currentSashInfo.sash, true);
                    }
                    if (CustomSashForm.this.currentSashInfo.sashBorderRight) {
                        CustomSashForm.this.drawSashBorder(gc, CustomSashForm.this.currentSashInfo.sash, false);
                    }
                    gc.setForeground(oldFg);
                    gc.setBackground(oldBg);
                }
            });
            newSash.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                    CustomSashForm.this.recomputeSashInfo();
                }

                public void controlResized(ControlEvent e) {
                    CustomSashForm.this.recomputeSashInfo();
                }
            });
            newSash.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    CustomSashForm.this.currentSashInfo = null;
                }
            });
            newSash.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    int x = e.x;
                    int y = e.y;
                    int i = 0;
                    while (i < CustomSashForm.this.currentSashInfo.sashLocs.length) {
                        int sizeIndex;
                        int[] locs = CustomSashForm.this.currentSashInfo.sashLocs[i];
                        boolean vertical = CustomSashForm.this.getOrientation() == 512;
                        int loc = vertical ? x : y;
                        int locIndex = vertical ? 2 : 3;
                        int n = sizeIndex = vertical ? 4 : 5;
                        if (locs[locIndex] <= loc && loc <= locs[locIndex] + locs[sizeIndex]) {
                            if (CustomSashForm.this.currentSashInfo.cursorOver == -1) {
                                CustomSashForm.this.currentSashInfo.sash.setCursor(Cursors.ARROW);
                            }
                            if (CustomSashForm.this.currentSashInfo.cursorOver != i) {
                                CustomSashForm.this.currentSashInfo.cursorOver = i;
                                CustomSashForm.this.currentSashInfo.sash.redraw();
                            }
                            return;
                        }
                        ++i;
                    }
                    if (CustomSashForm.this.currentSashInfo.cursorOver != -1) {
                        CustomSashForm.this.currentSashInfo.sash.setCursor(null);
                        CustomSashForm.this.currentSashInfo.cursorOver = -1;
                        CustomSashForm.this.currentSashInfo.sash.redraw();
                    }
                }
            });
            newSash.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent e) {
                    if (CustomSashForm.this.currentSashInfo.cursorOver != -1) {
                        CustomSashForm.this.currentSashInfo.sash.setCursor(null);
                        CustomSashForm.this.currentSashInfo.cursorOver = -1;
                        CustomSashForm.this.currentSashInfo.sash.redraw();
                    }
                }
            });
            newSash.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    CustomSashForm.this.inMouseClick = true;
                    int x = e.x;
                    int y = e.y;
                    int i = 0;
                    while (i < CustomSashForm.this.currentSashInfo.sashLocs.length) {
                        int sizeIndex;
                        int[] locs = CustomSashForm.this.currentSashInfo.sashLocs[i];
                        boolean vertical = CustomSashForm.this.getOrientation() == 512;
                        int loc = vertical ? x : y;
                        int locIndex = vertical ? 2 : 3;
                        int n = sizeIndex = vertical ? 4 : 5;
                        if (locs[locIndex] <= loc && loc <= locs[locIndex] + locs[sizeIndex]) {
                            CustomSashForm.this.currentSashInfo.sash.redraw();
                            break;
                        }
                        ++i;
                    }
                }

                public void mouseUp(MouseEvent e) {
                    CustomSashForm.this.inMouseClick = false;
                    int x = e.x;
                    int y = e.y;
                    int i = 0;
                    while (i < CustomSashForm.this.currentSashInfo.sashLocs.length) {
                        int sizeIndex;
                        int[] locs = CustomSashForm.this.currentSashInfo.sashLocs[i];
                        boolean vertical = CustomSashForm.this.getOrientation() == 512;
                        int loc = vertical ? x : y;
                        int locIndex = vertical ? 2 : 3;
                        int n = sizeIndex = vertical ? 4 : 5;
                        if (locs[locIndex] <= loc && loc <= locs[locIndex] + locs[sizeIndex]) {
                            switch (locs[0]) {
                                case 0: {
                                    CustomSashForm.this.upClicked(CustomSashForm.this.currentSashInfo);
                                    break;
                                }
                                case 1: {
                                    CustomSashForm.this.upMaxClicked(CustomSashForm.this.currentSashInfo);
                                    break;
                                }
                                case 2: {
                                    CustomSashForm.this.downClicked(CustomSashForm.this.currentSashInfo);
                                    break;
                                }
                                case 3: {
                                    CustomSashForm.this.downMaxClicked(CustomSashForm.this.currentSashInfo);
                                }
                            }
                            break;
                        }
                        ++i;
                    }
                    CustomSashForm.this.currentSashInfo.sash.redraw();
                }
            });
            this.recomputeSashInfo();
        }
    }

    protected void recomputeSashInfo() {
        if (this.inMouseClick && this.currentSashInfo.cursorOver != -1) {
            return;
        }
        int[] addArrows = null;
        int[] drawArrows = null;
        int[] weights = this.getWeights();
        if (this.noMaxUp) {
            addArrows = new int[1];
            drawArrows = new int[1];
            if (weights[1] == 0) {
                addArrows[0] = 0;
                drawArrows[0] = 0;
                this.currentSashInfo.sashBorderLeft = this.sashBorders != null ? this.sashBorders[0] : false;
                this.currentSashInfo.sashBorderRight = false;
            } else {
                addArrows[0] = 3;
                drawArrows[0] = 2;
                this.currentSashInfo.weight = -1;
                this.currentSashInfo.sashBorderLeft = this.sashBorders != null ? this.sashBorders[0] : false;
                this.currentSashInfo.sashBorderRight = this.sashBorders != null ? this.sashBorders[1] : false;
            }
        } else if (this.noMaxDown) {
            addArrows = new int[1];
            drawArrows = new int[1];
            if (weights[0] == 0) {
                addArrows[0] = 2;
                drawArrows[0] = 2;
                this.currentSashInfo.sashBorderLeft = false;
                this.currentSashInfo.sashBorderRight = this.sashBorders != null ? this.sashBorders[1] : false;
            } else {
                addArrows[0] = 1;
                drawArrows[0] = 0;
                this.currentSashInfo.weight = -1;
                this.currentSashInfo.sashBorderLeft = this.sashBorders != null ? this.sashBorders[0] : false;
                this.currentSashInfo.sashBorderRight = this.sashBorders != null ? this.sashBorders[1] : false;
            }
        } else {
            addArrows = new int[2];
            drawArrows = new int[2];
            if (weights[0] == 0) {
                addArrows[0] = 3;
                drawArrows[0] = 3;
                addArrows[1] = 2;
                drawArrows[1] = 2;
                this.currentSashInfo.sashBorderLeft = false;
                this.currentSashInfo.sashBorderRight = this.sashBorders != null ? this.sashBorders[1] : false;
            } else if (weights[1] == 0) {
                addArrows[0] = 0;
                drawArrows[0] = 0;
                addArrows[1] = 1;
                drawArrows[1] = 1;
                this.currentSashInfo.sashBorderLeft = this.sashBorders != null ? this.sashBorders[0] : false;
                this.currentSashInfo.sashBorderRight = false;
            } else {
                addArrows[0] = 1;
                drawArrows[0] = 0;
                addArrows[1] = 3;
                drawArrows[1] = 2;
                this.currentSashInfo.weight = -1;
                this.currentSashInfo.sashBorderLeft = this.sashBorders != null ? this.sashBorders[0] : false;
                this.currentSashInfo.sashBorderRight = this.sashBorders != null ? this.sashBorders[1] : false;
            }
        }
        this.getNewSashArray(this.currentSashInfo, addArrows, drawArrows);
        this.currentSashInfo.sash.redraw();
    }

    protected void upClicked(SashInfo sashinfo) {
        int[] weights = this.getWeights();
        weights[0] = 1000 - sashinfo.weight;
        weights[1] = sashinfo.weight;
        sashinfo.weight = -1;
        this.setWeights(weights);
    }

    protected void upMaxClicked(SashInfo sashinfo) {
        int[] weights = this.getWeights();
        if (this.currentSashInfo.weight == -1) {
            this.currentSashInfo.weight = weights[1];
        }
        weights[1] = 1000;
        weights[0] = 0;
        Control[] children = this.getChildren();
        boolean upperFocus = this.isFocusAncestorA(children[0]);
        this.setWeights(weights);
        if (upperFocus) {
            children[1].setFocus();
        }
    }

    protected void downClicked(SashInfo sashinfo) {
        int[] weights = this.getWeights();
        weights[0] = 1000 - sashinfo.weight;
        weights[1] = sashinfo.weight;
        sashinfo.weight = -1;
        this.setWeights(weights);
    }

    protected void downMaxClicked(SashInfo sashinfo) {
        int[] weights = this.getWeights();
        if (this.currentSashInfo.weight == -1) {
            this.currentSashInfo.weight = weights[1];
        }
        weights[0] = 1000;
        weights[1] = 0;
        Control[] children = this.getChildren();
        boolean lowerFocus = this.isFocusAncestorA(children[1]);
        this.setWeights(weights);
        if (lowerFocus) {
            children[0].setFocus();
        }
    }

    protected boolean isFocusAncestorA(Control control) {
        Display display = this.getDisplay();
        Control focusControl = display.getFocusControl();
        while (focusControl != null && focusControl != control) {
            focusControl = focusControl.getParent();
        }
        return control == focusControl;
    }

    protected void getNewSashArray(SashInfo sashInfo, int[] addArrowTypes, int[] drawArrowTypes) {
        int[][] thisSash = sashInfo.sashLocs;
        if (thisSash == null) {
            thisSash = sashInfo.sashLocs = new int[addArrowTypes.length][];
        }
        int aSize = 8;
        int tSize = aSize + 6;
        int neededSize = tSize * addArrowTypes.length;
        boolean vertical = this.getOrientation() == 512;
        Point s = sashInfo.sash.getSize();
        int start = 0;
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        if (vertical) {
            x = start = (s.x - neededSize) / 2;
            y = (s.y - 8) / 2;
            width = tSize;
            height = aSize;
        } else {
            y = start = (s.y - neededSize) / 2;
            x = (s.x - 8) / 2;
            width = aSize;
            height = tSize;
        }
        int j = 0;
        while (j < addArrowTypes.length) {
            if (thisSash[j] == null) {
                thisSash[j] = new int[]{addArrowTypes[j], drawArrowTypes[j], x, y, width, height};
            } else {
                thisSash[j][0] = addArrowTypes[j];
                thisSash[j][1] = drawArrowTypes[j];
                thisSash[j][2] = x;
                thisSash[j][3] = y;
                thisSash[j][4] = width;
                thisSash[j][5] = height;
            }
            if (vertical) {
                x += tSize;
            } else {
                y += tSize;
            }
            ++j;
        }
    }

    protected void drawSashBorder(GC gc, Sash sash, boolean leftBorder) {
        gc.setForeground(this.borderColor);
        if (this.getOrientation() == 512) {
            Point s = sash.getSize();
            if (leftBorder) {
                gc.drawLine(0, 0, s.x - 1, 0);
            } else {
                gc.drawLine(0, s.y - 1, s.x - 1, s.y - 1);
            }
        } else {
            Point s = sash.getSize();
            if (leftBorder) {
                gc.drawLine(0, 0, 0, s.y - 1);
            } else {
                gc.drawLine(s.x - 1, 0, s.x - 1, s.y - 1);
            }
        }
    }

    protected void drawArrow(GC gc, int[] sashLoc, boolean selected) {
        int indent = 0;
        if (selected) {
            if (!this.inMouseClick) {
                Color highlightShadow = this.getDisplay().getSystemColor(20);
                Color normalShadow = this.getDisplay().getSystemColor(18);
                gc.setForeground(highlightShadow);
                gc.drawLine(sashLoc[2], sashLoc[3] + sashLoc[5], sashLoc[2], sashLoc[3]);
                gc.drawLine(sashLoc[2], sashLoc[3], sashLoc[2] + sashLoc[4], sashLoc[3]);
                gc.setForeground(normalShadow);
                gc.drawLine(sashLoc[2], sashLoc[3] + sashLoc[5], sashLoc[2] + sashLoc[4], sashLoc[3] + sashLoc[5]);
                gc.drawLine(sashLoc[2] + sashLoc[4], sashLoc[3] + sashLoc[5], sashLoc[2] + sashLoc[4], sashLoc[3]);
            } else {
                indent = 1;
                Color highlightShadow = this.getDisplay().getSystemColor(20);
                Color normalShadow = this.getDisplay().getSystemColor(18);
                gc.setForeground(normalShadow);
                gc.drawLine(sashLoc[2], sashLoc[3] + sashLoc[5], sashLoc[2], sashLoc[3]);
                gc.drawLine(sashLoc[2], sashLoc[3], sashLoc[2] + sashLoc[4], sashLoc[3]);
                gc.setForeground(highlightShadow);
                gc.drawLine(sashLoc[2], sashLoc[3] + sashLoc[5], sashLoc[2] + sashLoc[4], sashLoc[3] + sashLoc[5]);
                gc.drawLine(sashLoc[2] + sashLoc[4], sashLoc[3] + sashLoc[5], sashLoc[2] + sashLoc[4], sashLoc[3]);
            }
        }
        if (this.getOrientation() == 512) {
            switch (sashLoc[1]) {
                case 0: {
                    this.drawUpArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                    break;
                }
                case 2: {
                    this.drawDownArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                    break;
                }
                case 1: {
                    this.drawUpMaxArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                    break;
                }
                case 3: {
                    this.drawDownMaxArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                }
            }
        } else {
            switch (sashLoc[1]) {
                case 0: {
                    this.drawLeftArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                    break;
                }
                case 2: {
                    this.drawRightArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                    break;
                }
                case 1: {
                    this.drawLeftMaxArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                    break;
                }
                case 3: {
                    this.drawRightMaxArrow(gc, sashLoc[2] + indent, sashLoc[3] + indent);
                }
            }
        }
    }

    protected void drawUpArrow(GC gc, int x, int y) {
        gc.setForeground(this.arrowColor);
        gc.drawLine((x += 3) + 4, y + 2, x + 7, y + 5);
        gc.drawLine(x + 3, y + 2, x + 3, y + 2);
        gc.drawLine(x + 2, y + 3, x + 4, y + 3);
        gc.drawLine(x + 1, y + 4, x + 5, y + 4);
        gc.drawLine(x, y + 5, x + 6, y + 5);
    }

    protected void drawUpMaxArrow(GC gc, int x, int y) {
        gc.setForeground(this.arrowColor);
        gc.drawLine(x += 3, y, x + 7, y);
        gc.drawLine(x, y + 1, x + 7, y + 1);
        gc.drawLine(x + 4, y + 2, x + 7, y + 5);
        gc.drawLine(x + 3, y + 2, x + 3, y + 2);
        gc.drawLine(x + 2, y + 3, x + 4, y + 3);
        gc.drawLine(x + 1, y + 4, x + 5, y + 4);
        gc.drawLine(x, y + 5, x + 6, y + 5);
    }

    protected void drawDownArrow(GC gc, int x, int y) {
        gc.setForeground(this.arrowColor);
        gc.drawLine(x += 3, y + 2, x + 3, y + 5);
        gc.drawLine(x + 4, y + 5, x + 4, y + 5);
        gc.drawLine(x + 3, y + 4, x + 5, y + 4);
        gc.drawLine(x + 1, y + 3, x + 6, y + 3);
        gc.drawLine(x + 1, y + 2, x + 7, y + 2);
    }

    protected void drawDownMaxArrow(GC gc, int x, int y) {
        gc.setForeground(this.arrowColor);
        gc.drawLine(x += 3, y + 6, x + 7, y + 6);
        gc.drawLine(x, y + 7, x + 7, y + 7);
        gc.drawLine(x, y + 2, x + 3, y + 5);
        gc.drawLine(x + 4, y + 5, x + 4, y + 5);
        gc.drawLine(x + 3, y + 4, x + 5, y + 4);
        gc.drawLine(x + 1, y + 3, x + 6, y + 3);
        gc.drawLine(x + 1, y + 2, x + 7, y + 2);
    }

    protected void drawLeftArrow(GC gc, int x, int y) {
        gc.setForeground(this.arrowColor);
        gc.drawLine(x + 2, (y += 3) + 4, x + 5, y + 7);
        gc.drawLine(x + 2, y + 3, x + 2, y + 3);
        gc.drawLine(x + 3, y + 2, x + 3, y + 4);
        gc.drawLine(x + 4, y + 1, x + 4, y + 5);
        gc.drawLine(x + 5, y, x + 5, y + 6);
    }

    protected void drawLeftMaxArrow(GC gc, int x, int y) {
        gc.setForeground(this.arrowColor);
        gc.drawLine(x, y += 3, x, y + 7);
        gc.drawLine(x + 1, y, x + 1, y + 7);
        gc.drawLine(x + 2, y + 4, x + 5, y + 7);
        gc.drawLine(x + 2, y + 3, x + 2, y + 3);
        gc.drawLine(x + 3, y + 2, x + 3, y + 4);
        gc.drawLine(x + 4, y + 1, x + 4, y + 5);
        gc.drawLine(x + 5, y, x + 5, y + 6);
    }

    protected void drawRightArrow(GC gc, int x, int y) {
        gc.setForeground(this.arrowColor);
        gc.drawLine(x + 2, y += 3, x + 5, y + 3);
        gc.drawLine(x + 5, y + 4, x + 5, y + 4);
        gc.drawLine(x + 4, y + 3, x + 4, y + 5);
        gc.drawLine(x + 3, y + 1, x + 3, y + 6);
        gc.drawLine(x + 2, y + 1, x + 2, y + 7);
    }

    protected void drawRightMaxArrow(GC gc, int x, int y) {
        gc.setForeground(this.arrowColor);
        gc.drawLine(x + 6, y += 3, x + 6, y + 7);
        gc.drawLine(x + 7, y, x + 7, y + 7);
        gc.drawLine(x + 2, y, x + 5, y + 3);
        gc.drawLine(x + 5, y + 4, x + 5, y + 4);
        gc.drawLine(x + 4, y + 3, x + 4, y + 5);
        gc.drawLine(x + 3, y + 1, x + 3, y + 6);
        gc.drawLine(x + 2, y + 1, x + 2, y + 7);
    }

    private static class SashInfo {
        public Sash sash;
        public boolean enabled;
        public int weight = -1;
        public int cursorOver = -1;
        public boolean sashBorderLeft;
        public boolean sashBorderRight;
        public int[][] sashLocs;

        public SashInfo(Sash sash) {
            this.sash = sash;
        }
    }
}

