/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.CustomizeLayoutPage;
import org.eclipse.ve.internal.cde.core.CustomizeLayoutWindowAction;
import org.eclipse.ve.internal.cde.core.EditDomain;

public class CustomizeLayoutWindow
extends Window {
    protected List layoutClasses = new ArrayList(2);
    protected List layoutPages = new ArrayList(2);
    protected List layoutControls = new ArrayList(2);
    protected List componentClasses = new ArrayList(2);
    protected List componentPages = new ArrayList(2);
    protected List componentControls = new ArrayList(2);
    protected TabFolder tabFolder;
    protected Composite layoutPage;
    protected StackLayout layoutPageLayout;
    protected Composite componentPage;
    protected StackLayout componentPageLayout;
    protected Composite noLayoutPage;
    protected Composite noComponentPage;
    private Point location;
    protected CustomizeLayoutWindowAction windowAction;
    protected Shell parentShell;
    protected CustomizeLayoutPage selectedPage = null;
    protected ISelection selection = StructuredSelection.EMPTY;
    protected IEditorPart editorPart;
    static /* synthetic */ Class class$0;

    public CustomizeLayoutWindow(Shell parentShell, CustomizeLayoutWindowAction windowAction) {
        super(parentShell);
        this.setShellStyle(2160);
        this.windowAction = windowAction;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.setTitle(null);
    }

    protected void setTitle(String description) {
        Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        if (description == null) {
            shell.setText(CDEMessages.getString("CustomizeLayoutWindow.title"));
        } else {
            shell.setText(String.valueOf(CDEMessages.getString("CustomizeLayoutWindow.title")) + " - " + description);
        }
    }

    protected Point getInitialSize() {
        Point initSize = this.getShell().computeSize(-1, -1, true);
        if (initSize.x < 100) {
            initSize.x = 100;
        }
        if (initSize.x < 90) {
            initSize.y = 90;
        }
        return initSize;
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.getLocation() == null) {
            return super.getInitialLocation(initialSize);
        }
        Rectangle displayBounds = this.getShell().getDisplay().getClientArea();
        Point loc = this.getLocation();
        if (loc.x + initialSize.x > displayBounds.x + displayBounds.width) {
            loc.x = displayBounds.x + displayBounds.width - initialSize.x;
        }
        if (loc.y + initialSize.y > displayBounds.y + displayBounds.height) {
            loc.y = displayBounds.y + displayBounds.height - initialSize.y;
        }
        this.setLocation(loc);
        return loc;
    }

    protected Control createContents(Composite parent) {
        Class pageClass;
        CustomizeLayoutPage page;
        this.tabFolder = new TabFolder(parent, 0);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem layoutTab = new TabItem(this.tabFolder, 0);
        layoutTab.setText(CDEMessages.getString("CustomizeLayoutWindow.layoutTabTitle"));
        layoutTab.setToolTipText(CDEMessages.getString("CustomizeLayoutWindow.layoutTabToolTip"));
        this.layoutPage = new Composite((Composite)this.tabFolder, 0);
        this.layoutPageLayout = new StackLayout();
        this.layoutPage.setLayout((Layout)this.layoutPageLayout);
        layoutTab.setControl((Control)this.layoutPage);
        TabItem componentTab = new TabItem(this.tabFolder, 0);
        componentTab.setText(CDEMessages.getString("CustomizeLayoutWindow.componentTabTitle"));
        componentTab.setToolTipText(CDEMessages.getString("CustomizeLayoutWindow.componentTabToolTip"));
        this.componentPage = new Composite((Composite)this.tabFolder, 0);
        this.componentPageLayout = new StackLayout();
        this.componentPage.setLayout((Layout)this.componentPageLayout);
        componentTab.setControl((Control)this.componentPage);
        this.noLayoutPage = new Composite(this.layoutPage, 0);
        this.noLayoutPage.setLayout((Layout)new GridLayout());
        Label noLayoutLabel = new Label(this.noLayoutPage, 64);
        noLayoutLabel.setText(CDEMessages.getString("CustomizeLayoutWindow.noLayoutText"));
        GridData gd = new GridData();
        gd.widthHint = 200;
        noLayoutLabel.setLayoutData((Object)gd);
        this.layoutPageLayout.topControl = this.noLayoutPage;
        this.layoutPage.layout();
        this.noComponentPage = new Composite(this.componentPage, 0);
        this.noComponentPage.setLayout((Layout)new GridLayout());
        Label noComponentLabel = new Label(this.noComponentPage, 64);
        noComponentLabel.setText(CDEMessages.getString("CustomizeLayoutWindow.noComponentText"));
        gd = new GridData();
        gd.widthHint = 200;
        noComponentLabel.setLayoutData((Object)gd);
        this.componentPageLayout.topControl = this.noComponentPage;
        this.componentPage.layout();
        int i = 0;
        while (i < this.layoutPages.size()) {
            page = (CustomizeLayoutPage)this.layoutPages.get(i);
            if (page == null) {
                try {
                    pageClass = (Class)this.layoutClasses.get(i);
                    page = this.createPage(pageClass);
                    this.layoutPages.set(i, page);
                }
                catch (CoreException e) {
                    CDEPlugin.getPlugin().getLog().log(e.getStatus());
                    this.layoutPages.remove(i);
                    this.layoutClasses.remove(i);
                    --i;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.componentPages.size()) {
            page = (CustomizeLayoutPage)this.componentPages.get(i);
            if (page == null) {
                try {
                    pageClass = (Class)this.componentClasses.get(i);
                    page = this.createPage(pageClass);
                    this.componentPages.set(i, page);
                }
                catch (CoreException e) {
                    CDEPlugin.getPlugin().getLog().log(e.getStatus());
                    this.layoutPages.remove(i);
                    this.layoutClasses.remove(i);
                    --i;
                }
            }
            ++i;
        }
        this.tabFolder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CustomizeLayoutWindow.this.tabFolder = null;
            }
        });
        return this.tabFolder;
    }

    protected Control createPageControl(Composite parent, CustomizeLayoutPage page) {
        Control control = null;
        if (parent != null && !parent.isDisposed()) {
            control = page.getControl(parent);
            Point size = this.getInitialSize();
            Point location = this.getInitialLocation(size);
            this.getShell().setBounds(location.x, location.y, size.x, size.y);
        }
        return control;
    }

    protected CustomizeLayoutPage createPage(Class pageClass) throws CoreException {
        try {
            CustomizeLayoutPage page = (CustomizeLayoutPage)pageClass.newInstance();
            page.setSelectionProvider(this.windowAction.getSelectionProvider());
            page.setEditorPart(this.editorPart);
            page.update(this.selection);
            return page;
        }
        catch (InstantiationException e) {
            throw new CoreException((IStatus)new Status(2, CDEPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
        }
        catch (IllegalAccessException e) {
            throw new CoreException((IStatus)new Status(2, CDEPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
        }
    }

    public void hide() {
        Shell shell = this.getShell();
        if (shell != null) {
            shell.setVisible(false);
        }
    }

    public boolean isHidden() {
        Shell shell = this.getShell();
        return shell != null ? !shell.isVisible() : true;
    }

    protected void addCustomizationPages(Class layoutPageClass, Class componentPageClass) {
        this.addLayoutCustomizationPage(layoutPageClass);
        this.addComponentCustomizationPage(componentPageClass);
    }

    protected void addLayoutCustomizationPage(Class layoutPageClass) {
        if (layoutPageClass != null && !this.layoutClasses.contains(layoutPageClass)) {
            this.layoutClasses.add(layoutPageClass);
            if (this.layoutPage != null) {
                int i = this.layoutPages.size();
                try {
                    CustomizeLayoutPage page = this.createPage(layoutPageClass);
                    this.layoutPages.add(i, page);
                    this.layoutControls.add(i, null);
                }
                catch (CoreException e) {
                    CDEPlugin.getPlugin().getLog().log(e.getStatus());
                    this.layoutPages.remove(i);
                    this.layoutClasses.remove(i);
                }
            }
        }
    }

    protected void addComponentCustomizationPage(Class componentPageClass) {
        if (componentPageClass != null && !this.componentClasses.contains(componentPageClass)) {
            this.componentClasses.add(componentPageClass);
            if (this.componentPage != null) {
                int i = this.componentPages.size();
                try {
                    CustomizeLayoutPage page = this.createPage(componentPageClass);
                    this.componentPages.add(i, page);
                    this.componentControls.add(i, null);
                }
                catch (CoreException e) {
                    CDEPlugin.getPlugin().getLog().log(e.getStatus());
                    this.componentPages.remove(i);
                    this.componentClasses.remove(i);
                }
            }
        }
    }

    public void update(ISelection selection) {
        Control control;
        CustomizeLayoutPage page;
        this.selection = selection;
        boolean found = false;
        boolean isLayout = false;
        CustomizeLayoutPage lPage = null;
        CustomizeLayoutPage cPage = null;
        int i = 0;
        while (i < this.layoutPages.size()) {
            page = (CustomizeLayoutPage)this.layoutPages.get(i);
            if (page != null) {
                found = page.update(selection);
            }
            if (found) {
                control = (Control)this.layoutControls.get(i);
                if (control == null) {
                    control = this.createPageControl(this.layoutPage, page);
                    this.layoutControls.set(i, control);
                }
                this.layoutPageLayout.topControl = control;
                this.layoutPage.layout();
                lPage = page;
                if (page.selectionIsContainer(selection)) {
                    isLayout = true;
                    break;
                }
            }
            ++i;
        }
        if (!found) {
            lPage = null;
            this.layoutPageLayout.topControl = this.noLayoutPage;
            this.layoutPage.layout();
        }
        found = false;
        i = 0;
        while (i < this.componentPages.size()) {
            page = (CustomizeLayoutPage)this.componentPages.get(i);
            if (page != null) {
                found = page.update(selection);
            }
            if (found) {
                control = (Control)this.componentControls.get(i);
                if (control == null) {
                    control = this.createPageControl(this.componentPage, page);
                    this.componentControls.set(i, control);
                }
                this.componentPageLayout.topControl = control;
                this.componentPage.layout();
                cPage = page;
                break;
            }
            ++i;
        }
        if (!found) {
            cPage = null;
            this.componentPageLayout.topControl = this.noComponentPage;
            this.componentPage.layout();
        }
        if (isLayout || !found) {
            if (this.tabFolder.getSelectionIndex() != 0) {
                this.tabFolder.setSelection(0);
            }
            if (lPage != null) {
                this.setTitle(lPage.getLabelForSelection(selection));
            }
        } else {
            if (this.tabFolder.getSelectionIndex() != 1) {
                this.tabFolder.setSelection(1);
            }
            if (cPage != null) {
                this.setTitle(cPage.getLabelForSelection(selection));
            }
        }
        if (lPage == null && lPage == null) {
            this.setTitle(null);
        }
    }

    public void setEditorPart(IEditorPart editorPart) {
        this.editorPart = editorPart;
        if (editorPart != null) {
            EditDomain dom;
            CustomizeLayoutWindowAction.CustomizeLayoutPageController pages;
            org.eclipse.gef.EditDomain odom;
            EditPartViewer primaryViewer;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gef.EditPartViewer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((primaryViewer = (EditPartViewer)editorPart.getAdapter((Class)clazz)) != null && (odom = primaryViewer.getEditDomain()) instanceof EditDomain && (pages = (CustomizeLayoutWindowAction.CustomizeLayoutPageController)(dom = (EditDomain)odom).getViewerData(primaryViewer, "customizeLayoutPage_Key")) != null) {
                pages.setCustomizeLayoutWindowAction(this.windowAction);
                List layoutClasses = pages.getLayoutClasses();
                int i = 0;
                while (i < layoutClasses.size()) {
                    this.addCustomizationPages((Class)layoutClasses.get(i), null);
                    ++i;
                }
                List componentClasses = pages.getComponentClasses();
                int i2 = 0;
                while (i2 < componentClasses.size()) {
                    this.addCustomizationPages(null, (Class)componentClasses.get(i2));
                    ++i2;
                }
            }
        }
        int i = 0;
        while (i < this.componentPages.size()) {
            CustomizeLayoutPage page = (CustomizeLayoutPage)this.componentPages.get(i);
            if (page != null) {
                page.setEditorPart(editorPart);
            }
            ++i;
        }
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    public Point getLocation() {
        return this.location;
    }
}

