/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.DistributeCommandRequest;
import org.eclipse.ve.internal.cde.core.DistributeController;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class DistributeAction
extends SelectionAction {
    protected int fDistributeType;
    protected boolean fDistributeInSurface;
    private static final String[] resPrefix = new String[]{"DistributeAction.horizontal.", "DistributeAction.vertical."};

    public DistributeAction(int distributeType) {
        super(null);
        this.fDistributeType = distributeType < 0 || distributeType >= resPrefix.length ? 0 : distributeType;
        String sDistributeType = resPrefix[this.fDistributeType];
        this.setText(CDEMessages.getString(String.valueOf(sDistributeType) + "label"));
        this.setToolTipText(CDEMessages.getString(String.valueOf(sDistributeType) + "tooltip"));
        String graphicName = CDEMessages.getString(String.valueOf(sDistributeType) + "image");
        this.setImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/elcl16/" + graphicName));
        this.setHoverImageDescriptor(this.getImageDescriptor());
        this.setDisabledImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/dlcl16/" + graphicName));
        this.setEnabled(true);
        this.setId(DistributeAction.getActionId(this.fDistributeType));
    }

    public static String getActionId(int distributeType) {
        return distributeType >= 0 && distributeType <= resPrefix.length ? resPrefix[distributeType] : resPrefix[0];
    }

    protected Command createDistributeCommand(List objects) {
        if (objects.size() < 2) {
            return UnexecutableCommand.INSTANCE;
        }
        Iterator itr = objects.iterator();
        while (itr.hasNext()) {
            if (itr.next() instanceof GraphicalEditPart) continue;
            return UnexecutableCommand.INSTANCE;
        }
        Rectangle boundingBox = this.getBoundingBox(objects);
        if (boundingBox == null) {
            return UnexecutableCommand.INSTANCE;
        }
        DistributeCommandRequest distReq = new DistributeCommandRequest();
        Command cmd = null;
        switch (this.fDistributeType) {
            case 0: {
                cmd = this.distributeHorizontally(objects, boundingBox, distReq);
                break;
            }
            case 1: {
                cmd = this.distributeVertically(objects, boundingBox, distReq);
            }
        }
        return cmd;
    }

    protected Rectangle getBoundingBox(List selObjs) {
        Rectangle boundingBox = null;
        DistributeController dc = DistributeController.getDistributeController((EditPart)selObjs.get(0));
        if (dc == null) {
            return null;
        }
        if (dc.isBoxActive()) {
            boundingBox = dc.getBoundaryBox();
        }
        if (boundingBox == null) {
            Iterator itr = selObjs.iterator();
            EditPart contentsEditPart = ((EditPart)itr.next()).getParent();
            while (itr.hasNext()) {
                EditPart ep = (EditPart)itr.next();
                if (ep.getParent() == contentsEditPart) continue;
                return null;
            }
            boundingBox = new Rectangle(((GraphicalEditPart)contentsEditPart).getFigure().getClientArea());
            this.fDistributeInSurface = true;
        } else {
            this.fDistributeInSurface = false;
        }
        return boundingBox;
    }

    protected Command distributeHorizontally(List inSelObjs, Rectangle boundingBox, DistributeCommandRequest distReq) {
        ArrayList selObjs = new ArrayList(inSelObjs);
        Collections.sort(selObjs, new Comparator(){

            public int compare(Object o1, Object o2) {
                Rectangle r = ((GraphicalEditPart)o1).getFigure().getBounds();
                int x1 = r.x + r.width;
                r = ((GraphicalEditPart)o2).getFigure().getBounds();
                int x2 = r.x + r.width;
                return x1 - x2;
            }
        });
        int summWidths = 0;
        CompoundCommand compoundCmd = new CompoundCommand();
        int i = 0;
        while (i < selObjs.size()) {
            Rectangle bounds = ((GraphicalEditPart)selObjs.get(i)).getFigure().getBounds();
            summWidths += bounds.width;
            ++i;
        }
        int gap = 0;
        int nextXPos = 0;
        if (this.fDistributeInSurface) {
            gap = (boundingBox.width - summWidths) / (selObjs.size() + 1);
            nextXPos = boundingBox.x + gap;
        } else {
            gap = (boundingBox.width - summWidths) / (selObjs.size() - 1);
            nextXPos = boundingBox.x;
        }
        int i2 = 0;
        while (i2 < selObjs.size()) {
            GraphicalEditPart currObj = (GraphicalEditPart)selObjs.get(i2);
            Rectangle currRect = currObj.getFigure().getBounds();
            if (nextXPos != currRect.x) {
                Rectangle newRect = new Rectangle(nextXPos, currRect.y, currRect.width, currRect.height);
                distReq.setBounds(newRect);
                Command cmd = currObj.getCommand((Request)distReq);
                if (cmd == null) {
                    return UnexecutableCommand.INSTANCE;
                }
                compoundCmd.append(cmd);
            }
            nextXPos = nextXPos + gap + currRect.width;
            ++i2;
        }
        return compoundCmd;
    }

    protected Command distributeVertically(List inSelObjs, Rectangle boundingBox, DistributeCommandRequest distReq) {
        ArrayList selObjs = new ArrayList(inSelObjs);
        Collections.sort(selObjs, new Comparator(){

            public int compare(Object o1, Object o2) {
                Rectangle r = ((GraphicalEditPart)o1).getFigure().getBounds();
                int y1 = r.y + r.height;
                r = ((GraphicalEditPart)o2).getFigure().getBounds();
                int y2 = r.y + r.height;
                return y1 - y2;
            }
        });
        int summHeights = 0;
        CompoundCommand compoundCmd = new CompoundCommand();
        int i = 0;
        while (i < selObjs.size()) {
            Rectangle bounds = ((GraphicalEditPart)selObjs.get(i)).getFigure().getBounds();
            summHeights += bounds.height;
            ++i;
        }
        int gap = 0;
        int nextYPos = 0;
        if (this.fDistributeInSurface) {
            gap = (boundingBox.height - summHeights) / (selObjs.size() + 1);
            nextYPos = boundingBox.y + gap;
        } else {
            gap = (boundingBox.height - summHeights) / (selObjs.size() - 1);
            nextYPos = boundingBox.y;
        }
        int i2 = 0;
        while (i2 < selObjs.size()) {
            GraphicalEditPart currObj = (GraphicalEditPart)selObjs.get(i2);
            Rectangle currRect = currObj.getFigure().getBounds();
            if (nextYPos != currRect.y) {
                Rectangle newRect = new Rectangle(currRect.x, nextYPos, currRect.width, currRect.height);
                distReq.setBounds(newRect);
                Command cmd = currObj.getCommand((Request)distReq);
                if (cmd == null) {
                    return UnexecutableCommand.INSTANCE;
                }
                compoundCmd.append(cmd);
            }
            nextYPos = nextYPos + gap + currRect.height;
            ++i2;
        }
        return compoundCmd;
    }

    protected boolean calculateEnabled() {
        Command cmd = this.createDistributeCommand(this.getSelectedObjects());
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    public void run() {
        this.execute(this.createDistributeCommand(this.getSelectedObjects()));
    }

    public void setWorkbenchPart(IWorkbenchPart part) {
        super.setWorkbenchPart(part);
    }
}

