/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ve.internal.cde.commands.NoOpCommand;
import org.eclipse.ve.internal.cde.core.AlignmentChildCommandRequest;
import org.eclipse.ve.internal.cde.core.AlignmentCommandRequest;
import org.eclipse.ve.internal.cde.core.AnnotationLinkagePolicy;
import org.eclipse.ve.internal.cde.core.CustomizeLayoutWindowAction;
import org.eclipse.ve.internal.cde.core.DistributeChildCommandRequest;
import org.eclipse.ve.internal.cde.core.DistributeCommandRequest;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.GridController;
import org.eclipse.ve.internal.cde.core.GridFigure;
import org.eclipse.ve.internal.cde.core.IGridListener;
import org.eclipse.ve.internal.cde.core.IZoomListener;
import org.eclipse.ve.internal.cde.core.PrimaryDragRoleEditPolicy;
import org.eclipse.ve.internal.cde.core.XYLayoutGridConstrainer;
import org.eclipse.ve.internal.cde.core.ZoomController;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public abstract class XYLayoutEditPolicy
extends org.eclipse.gef.editpolicies.XYLayoutEditPolicy
implements IZoomListener,
IGridListener,
IActionFilter {
    public static final String LAYOUT_ID = "org.eclipse.ve.internal.cde.core.XYLayout";
    private ZoomController zoomController;
    private GridController gridController;
    private GridFigure gridFigure;
    private IFigure targetFeedback;
    protected XYLayoutGridConstrainer layoutConstrainer;
    ArrayList feedbackList;
    protected boolean allowZooming = false;
    protected boolean allowGridding = true;
    static /* synthetic */ Class class$0;

    protected EditPartListener createListener() {
        return new EditPartListener.Stub(){

            public void childAdded(EditPart child, int index) {
                XYLayoutEditPolicy.this.decorateChild(child);
                if (XYLayoutEditPolicy.this.gridController != null && XYLayoutEditPolicy.this.gridFigure != null && XYLayoutEditPolicy.this.gridController.isGridShowing()) {
                    XYLayoutEditPolicy.this.getHostFigure().remove((IFigure)XYLayoutEditPolicy.this.gridFigure);
                    XYLayoutEditPolicy.this.getHostFigure().add((IFigure)XYLayoutEditPolicy.this.gridFigure, 0);
                }
            }
        };
    }

    public void setGriddable(boolean allowGridding) {
        this.allowGridding = allowGridding;
    }

    protected abstract Object modelToFigureConstraint(Object var1);

    public void setZoomable(boolean allowZooming) {
        this.allowZooming = allowZooming;
    }

    public void activate() {
        super.activate();
        if (this.allowZooming) {
            this.zoomController = ZoomController.getZoomController(this.getHost());
            if (this.zoomController != null) {
                this.zoomController.addZoomListener(this);
                this.zoomChanged(this.zoomController.getZoomValue(), 0);
            }
        }
        if (this.allowGridding) {
            this.gridController = new GridController();
            if (this.gridController != null) {
                this.gridFigure = this.createGridFigure();
                this.gridFigure.setVisible(this.gridController.isGridShowing());
                IFigure fig = ((GraphicalEditPart)this.getHost()).getContentPane();
                fig.add((IFigure)this.gridFigure, 0);
                this.gridController.addGridListener(this);
                GridController.registerEditPart(this.getHost(), this.gridController);
                this.initializeGrid();
            }
        }
        EditPartViewer editPartViewer = this.getHost().getViewer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.core.AlignmentXYComponentPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CustomizeLayoutWindowAction.addComponentCustomizationPage(editPartViewer, clazz);
    }

    protected void initializeGrid() {
        AnnotationLinkagePolicy policy;
        Annotation ann;
        EditDomain domain = EditDomain.getEditDomain(this.getHost());
        HashSet gridStateData = (HashSet)domain.getData("org.eclipse.ve.internal.cde.core.gridstatekey");
        if (gridStateData != null && (ann = (policy = domain.getAnnotationLinkagePolicy()).getAnnotation(this.getHost().getModel())) != null) {
            String name = (String)ann.getKeyedValues().get((Object)"org.eclipse.ve.internal.cde.core.nameincomposition");
            if (name == null) {
                name = "THIS_PART";
            }
            if (gridStateData.contains(name) && this.gridController != null) {
                this.gridController.setGridShowing(true);
            }
        }
    }

    public void deactivate() {
        if (this.zoomController != null) {
            this.zoomController.removeZoomListener(this);
            this.zoomController = null;
        }
        if (this.gridController != null) {
            this.gridController.removeGridListener(this);
            GridController.unregisterEditPart(this.getHost());
            this.gridController = null;
            IFigure fig = ((GraphicalEditPart)this.getHost()).getContentPane();
            fig.remove((IFigure)this.gridFigure);
            this.gridFigure = null;
        }
        this.undecorateChildren();
        super.deactivate();
    }

    public void zoomChanged(int newValue, int oldValue) {
        Iterator iter = this.getHost().getChildren().iterator();
        while (iter.hasNext()) {
            EditPart child = (EditPart)iter.next();
            Object modelConstraint = this.getChildConstraint(child);
            Rectangle figureConstraint = (Rectangle)this.modelToFigureConstraint(modelConstraint);
            this.setConstraintToFigure(child, figureConstraint);
        }
        if (this.gridController != null) {
            this.gridFigure.repaint();
        }
    }

    public void gridWidthChanged(int newWidth, int oldWidth) {
        if (this.gridController.isGridShowing()) {
            this.gridFigure.repaint();
        }
    }

    public void gridHeightChanged(int newHeight, int oldHeight) {
        if (this.gridController.isGridShowing()) {
            this.gridFigure.repaint();
        }
    }

    public void gridMarginChanged(int newMargin, int oldMargin) {
        if (this.gridController.isGridShowing()) {
            this.gridFigure.repaint();
        }
    }

    public void gridVisibilityChanged(boolean showGrid) {
        this.gridFigure.setVisible(showGrid);
        this.getHostFigure().remove((IFigure)this.gridFigure);
        this.getHostFigure().add((IFigure)this.gridFigure, 0);
        this.layoutConstrainer = showGrid ? this.createGridConstrainer() : null;
    }

    public Command getCommand(Request request) {
        if ("distribute child".equals(request.getType())) {
            return this.getDistributeChildCommand(request);
        }
        if ("cde align child".equals(request.getType())) {
            return this.getAlignmentChildCommand(request);
        }
        return super.getCommand(request);
    }

    protected abstract boolean isChildResizeable(EditPart var1);

    protected abstract Object getChildConstraint(EditPart var1);

    protected abstract void setConstraintToFigure(EditPart var1, Rectangle var2);

    protected Command createChangeConstraintCommand(EditPart childEditPart, Object constraint) {
        return this.createChangeConstraintCommand(childEditPart, constraint, false, true);
    }

    protected abstract Command createChangeConstraintCommand(EditPart var1, Object var2, boolean var3, boolean var4);

    protected Command getResizeChildrenCommand(ChangeBoundsRequest req) {
        CompoundCommand changeConstraintCmd = new CompoundCommand();
        List children = req.getEditParts();
        boolean move = req.getMoveDelta().x != 0 || req.getMoveDelta().y != 0;
        boolean resize = req.getSizeDelta().width != 0 || req.getSizeDelta().height != 0;
        int i = 0;
        while (i < children.size()) {
            GraphicalEditPart child = (GraphicalEditPart)children.get(i);
            Rectangle constraint = (Rectangle)this.getConstraintFor(req, child);
            if (!resize || constraint.width >= 0 && constraint.height >= 0) {
                Command c = this.createChangeConstraintCommand((EditPart)child, this.translateToModelConstraint(constraint), move, resize);
                changeConstraintCmd.append(c);
            }
            ++i;
        }
        return changeConstraintCmd.isEmpty() ? null : changeConstraintCmd.unwrap();
    }

    protected EditPolicy createChildEditPolicy(EditPart aPart) {
        ResizableEditPolicy dragRolePolicy = this.isChildResizeable(aPart) ? new ResizableEditPolicy() : new NonResizableEditPolicy();
        return new PrimaryDragRoleEditPolicy(this.gridController, (EditPolicy)dragRolePolicy, true);
    }

    protected Command getAlignmentChildCommand(Request request) {
        AlignmentCommandRequest alignReq = ((AlignmentChildCommandRequest)request).getAlignmentRequest();
        Point clientAreaOffset = this.getHostFigure().getClientArea().getLocation().negate();
        Rectangle anchorRect = new Rectangle(((GraphicalEditPart)alignReq.getAnchorObject()).getFigure().getBounds());
        anchorRect.translate(clientAreaOffset);
        anchorRect = (Rectangle)this.getConstraintFor(anchorRect);
        EditPart child = ((AlignmentChildCommandRequest)request).getChildEditPart();
        Rectangle currRect = new Rectangle(((GraphicalEditPart)child).getFigure().getBounds());
        currRect.translate(clientAreaOffset);
        currRect = (Rectangle)this.getConstraintFor(currRect);
        Rectangle newRect = this.getNewPosition(alignReq.getAlignType(), anchorRect, currRect);
        if (this.isAlignmentResize(alignReq.getAlignType()) && !this.isChildResizeable(child)) {
            return UnexecutableCommand.INSTANCE;
        }
        Command cmd = this.createChangeConstraintCommand(child, this.translateToModelConstraint(newRect), this.isAlignmentMove(alignReq.getAlignType()), this.isAlignmentResize(alignReq.getAlignType()));
        return cmd != null ? cmd : NoOpCommand.INSTANCE;
    }

    protected boolean isAlignmentResize(int alignType) {
        return alignType == 6 || alignType == 7;
    }

    protected boolean isAlignmentMove(int alignType) {
        return !this.isAlignmentResize(alignType);
    }

    protected Rectangle getNewPosition(int alignType, Rectangle anchorRect, Rectangle currRect) {
        switch (alignType) {
            case 0: {
                return new Rectangle(anchorRect.x, currRect.y, currRect.width, currRect.height);
            }
            case 1: {
                int delta = anchorRect.x + anchorRect.width / 2 - (currRect.x + currRect.width / 2);
                return new Rectangle(currRect.x + delta, currRect.y, currRect.width, currRect.height);
            }
            case 2: {
                int delta = anchorRect.x + anchorRect.width - (currRect.x + currRect.width);
                return new Rectangle(currRect.x + delta, currRect.y, currRect.width, currRect.height);
            }
            case 3: {
                return new Rectangle(currRect.x, anchorRect.y, currRect.width, currRect.height);
            }
            case 4: {
                int delta = anchorRect.y + anchorRect.height / 2 - (currRect.y + currRect.height / 2);
                return new Rectangle(currRect.x, currRect.y + delta, currRect.width, currRect.height);
            }
            case 5: {
                int delta = anchorRect.y + anchorRect.height - (currRect.y + currRect.height);
                return new Rectangle(currRect.x, currRect.y + delta, currRect.width, currRect.height);
            }
            case 6: {
                return new Rectangle(currRect.x, currRect.y, anchorRect.width, currRect.height);
            }
            case 7: {
                return new Rectangle(currRect.x, currRect.y, currRect.width, anchorRect.height);
            }
        }
        return new Rectangle(anchorRect.x, currRect.y, currRect.width, currRect.height);
    }

    protected Command getDistributeChildCommand(Request request) {
        DistributeCommandRequest distReq = ((DistributeChildCommandRequest)request).getDistributeRequest();
        EditPart child = ((DistributeChildCommandRequest)request).getChildEditPart();
        Rectangle newRect = distReq.getBounds();
        newRect.translate(this.getHostFigure().getClientArea().getLocation().negate());
        Rectangle relativeRect = (Rectangle)this.getConstraintFor(newRect);
        newRect.x = relativeRect.x;
        newRect.y = relativeRect.y;
        Command cmd = this.createChangeConstraintCommand(child, this.translateToModelConstraint(newRect), true, false);
        return cmd != null ? cmd : NoOpCommand.INSTANCE;
    }

    public Object getConstraintFor(Point p) {
        Rectangle rect = (Rectangle)super.getConstraintFor(p);
        if (this.zoomController != null) {
            rect.setLocation(this.zoomController.unzoomCoordinate(rect.x), this.zoomController.unzoomCoordinate(rect.y));
        }
        if (this.layoutConstrainer != null) {
            rect = this.layoutConstrainer.adjustConstraintFor(rect);
        }
        return rect;
    }

    public Object getConstraintFor(Rectangle r) {
        Rectangle rect = (Rectangle)super.getConstraintFor(r);
        if (this.zoomController != null) {
            rect.setLocation(this.zoomController.unzoomCoordinate(rect.x), this.zoomController.unzoomCoordinate(rect.y));
        }
        if (this.layoutConstrainer != null) {
            rect = this.layoutConstrainer.adjustConstraintFor(rect);
        }
        return rect;
    }

    protected IFigure createDragTargetFeedbackFigure(Rectangle rect) {
        RectangleFigure r = new RectangleFigure();
        FigureUtilities.makeGhostShape((Shape)r);
        r.setLineStyle(4);
        r.setForegroundColor(ColorConstants.white);
        r.setBounds(rect);
        return r;
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        super.eraseLayoutTargetFeedback(request);
        if (this.feedbackList != null) {
            int i = 0;
            while (i < this.feedbackList.size()) {
                this.removeFeedback((IFigure)this.feedbackList.get(i));
                ++i;
            }
            this.feedbackList = null;
        }
        if (this.targetFeedback != null) {
            this.removeFeedback(this.targetFeedback);
            this.targetFeedback = null;
        }
    }

    protected IFigure getRectangleFeedback(Request request) {
        if ("add children".equals(request.getType()) || "move".equals(request.getType()) || "resize".equals(request.getType())) {
            this.getRectangleFeedback((ChangeBoundsRequest)request);
        }
        if (this.targetFeedback == null) {
            RectangleFigure rf = new RectangleFigure();
            this.targetFeedback = rf;
            rf.setFill(false);
            Rectangle rect = new Rectangle(this.getHostFigure().getBounds());
            rf.setBounds(rect.shrink(5, 5));
            this.addFeedback(this.targetFeedback);
        }
        return this.targetFeedback;
    }

    protected void getRectangleFeedback(ChangeBoundsRequest request) {
        if (this.layoutConstrainer != null) {
            List children = request.getEditParts();
            Point inset = this.getHostFigure().getClientArea().getLocation();
            if (this.feedbackList == null) {
                this.feedbackList = new ArrayList(children.size());
            }
            int i = 0;
            while (i < children.size()) {
                GraphicalEditPart child = (GraphicalEditPart)children.get(i);
                Rectangle rect = (Rectangle)this.getConstraintFor(request, child);
                if (this.zoomController != null) {
                    rect.setLocation(this.zoomController.zoomCoordinate(rect.x), this.zoomController.zoomCoordinate(rect.y));
                }
                Rectangle childRect = child.getFigure().getBounds();
                rect.width = childRect.width;
                rect.height = childRect.height;
                rect.translate(inset);
                if (i > this.feedbackList.size() - 1) {
                    IFigure targetFigure = this.createDragTargetFeedbackFigure(rect);
                    this.addFeedback(targetFigure);
                    this.feedbackList.add(targetFigure);
                } else {
                    ((IFigure)this.feedbackList.get(i)).setBounds(rect);
                }
                ++i;
            }
        }
    }

    protected Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        Rectangle rect = (Rectangle)super.getConstraintFor(request, child);
        if (this.layoutConstrainer != null) {
            rect = this.layoutConstrainer.adjustConstraintFor(rect);
        }
        return rect;
    }

    protected ZoomController getZoomController() {
        return this.zoomController;
    }

    protected GridController getGridController() {
        return this.gridController;
    }

    protected GridFigure getGridFigure() {
        return this.gridFigure;
    }

    protected GridFigure createGridFigure() {
        return new GridFigure(this.gridController, this.zoomController);
    }

    protected XYLayoutGridConstrainer createGridConstrainer() {
        return new XYLayoutGridConstrainer(this.gridFigure);
    }

    protected void showLayoutTargetFeedback(Request request) {
        this.getRectangleFeedback(request);
    }

    protected void showSizeOnDropFeedback(CreateRequest request) {
        super.showSizeOnDropFeedback(request);
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.startsWith("showgrid") && value.equals("false") && !this.gridController.isGridShowing()) {
            return true;
        }
        if (name.startsWith("showgrid") && value.equals("true") && this.gridController.isGridShowing()) {
            return true;
        }
        return name.startsWith("LAYOUTPOLICY") && value.equals(LAYOUT_ID);
    }

    protected void undecorateChildren() {
        Iterator children = this.getHost().getChildren().iterator();
        while (children.hasNext()) {
            this.undecorateChild((EditPart)children.next());
        }
    }

    protected void undecorateChild(EditPart child) {
        child.removeEditPolicy((Object)"PrimaryDrag Policy");
    }

    protected void decorateChild(EditPart child) {
        super.decorateChild(child);
    }
}

