/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.emf;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.ve.internal.cde.core.AnnotationPolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.cdm.CDMPackage;

public class DefaultLabelProviderNotifier {
    protected EObject model;
    protected ILabelProvider labelProvider;
    protected IDefaultLabelProviderListener listener;
    protected AnnotationPolicy.AnnotationListener annotationListener;
    protected ILabelProviderListener labelProviderListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            DefaultLabelProviderNotifier.this.listener.refreshLabel(DefaultLabelProviderNotifier.this.labelProvider);
        }
    };
    protected Adapter modelListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (DefaultLabelProviderNotifier.this.labelProvider == null) {
                return;
            }
            switch (msg.getEventType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    Object sf = msg.getFeature();
                    if (!(sf instanceof EStructuralFeature) || !DefaultLabelProviderNotifier.this.labelProvider.isLabelProperty((Object)DefaultLabelProviderNotifier.this.model, ((EStructuralFeature)sf).getName())) break;
                    DefaultLabelProviderNotifier.this.listener.refreshLabel(DefaultLabelProviderNotifier.this.labelProvider);
                    break;
                }
            }
        }
    };
    protected EditDomain domain;

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(ILabelProvider provider) {
        if (this.model != null) {
            if (this.labelProvider != null) {
                this.labelProvider.removeListener(this.labelProviderListener);
            }
            this.labelProvider = provider;
            if (this.labelProvider != null) {
                this.labelProvider.addListener(this.labelProviderListener);
                if (this.annotationListener == null) {
                    this.model.eAdapters().add((Object)this.modelListener);
                    this.annotationListener = new AnnotationPolicy.AnnotationListener(this.model, this.domain){

                        public void notifyAnnotation(int eventType, Annotation oldAnnotation, Annotation newAnnotation) {
                            if (DefaultLabelProviderNotifier.this.labelProvider == null) {
                                return;
                            }
                            DefaultLabelProviderNotifier.this.listener.refreshLabel(DefaultLabelProviderNotifier.this.labelProvider);
                        }

                        public void notifyAnnotationChanges(Notification msg) {
                            if (DefaultLabelProviderNotifier.this.labelProvider == null) {
                                return;
                            }
                            Object sf = msg.getFeature();
                            if (sf instanceof EStructuralFeature) {
                                boolean refresh = false;
                                refresh = sf == CDMPackage.eINSTANCE.getKeyedValueHolder_KeyedValues() ? DefaultLabelProviderNotifier.this.labelProvider.isLabelProperty(msg.getNotifier(), (String)((BasicEMap.Entry)(msg.getEventType() == 1 ? msg.getNewValue() : msg.getOldValue())).getKey()) : DefaultLabelProviderNotifier.this.labelProvider.isLabelProperty(this.model, ((EStructuralFeature)sf).getName());
                                if (refresh) {
                                    DefaultLabelProviderNotifier.this.listener.refreshLabel(DefaultLabelProviderNotifier.this.labelProvider);
                                }
                            }
                        }
                    };
                }
            }
        }
    }

    public void setModel(EObject model, EditDomain domain, IDefaultLabelProviderListener listener, ILabelProvider provider) {
        if (this.model != null) {
            if (this.labelProvider != null) {
                this.labelProvider.removeListener(this.labelProviderListener);
            }
            this.labelProvider = null;
            if (this.annotationListener != null) {
                this.annotationListener.removeListening();
            }
            this.model.eAdapters().remove((Object)this.modelListener);
            this.annotationListener = null;
            this.model = null;
            this.domain = null;
        }
        if (model != null) {
            this.model = model;
            this.domain = domain;
            this.listener = listener;
            if (provider != null) {
                this.setLabelProvider(provider);
            }
        }
    }

    public interface IDefaultLabelProviderListener {
        public void refreshLabel(ILabelProvider var1);
    }
}

