/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.utility.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.utility.URLResourceBundle;
import org.eclipse.ve.internal.cde.utility.UtilityPackage;
import org.eclipse.ve.internal.cde.utility.impl.ResourceBundleImpl;
import org.osgi.framework.Bundle;

public class URLResourceBundleImpl
extends ResourceBundleImpl
implements URLResourceBundle {
    protected static final String BUNDLE_NAME_EDEFAULT = null;
    private ResourceBundle fBundle = null;
    private boolean fLoaded = false;
    protected String bundleName = BUNDLE_NAME_EDEFAULT;
    protected EList bundleURLs = null;
    static /* synthetic */ Class class$0;

    protected URLResourceBundleImpl() {
    }

    protected EClass eStaticClass() {
        return UtilityPackage.eINSTANCE.getURLResourceBundle();
    }

    public ResourceBundle getBundle() {
        if (!this.fLoaded) {
            this.fLoaded = true;
            if (this.getBundleName() != null && this.bundleURLs != null && this.bundleURLs.size() > 0) {
                ArrayList<URL> urls = new ArrayList<URL>(this.bundleURLs.size() * 2);
                Iterator itr = this.bundleURLs.iterator();
                while (itr.hasNext()) {
                    try {
                        Bundle[] fragments;
                        String urlString = (String)itr.next();
                        urls.add(new URL(urlString));
                        if (!urlString.startsWith("platform:/plugin/")) continue;
                        int begPluginName = "platform:/plugin/".length();
                        int endPluginName = urlString.indexOf(47, begPluginName);
                        String pluginName = urlString.substring(begPluginName, endPluginName);
                        String rest = urlString.substring(endPluginName);
                        Bundle bundle = Platform.getBundle((String)pluginName);
                        if (bundle == null || (fragments = Platform.getFragments((Bundle)bundle)) == null) continue;
                        int j = 0;
                        while (j < fragments.length) {
                            try {
                                URL u = fragments[j].getEntry(rest);
                                if (u != null) {
                                    urls.add(u);
                                }
                            }
                            catch (Exception exception) {}
                            ++j;
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        return null;
                    }
                }
                URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
                try {
                    this.fBundle = ResourceBundle.getBundle(this.getBundleName(), Locale.getDefault(), cl);
                }
                catch (MissingResourceException e) {
                    CDEPlugin.getPlugin().getLog().log((IStatus)new Status(2, CDEPlugin.getPlugin().getPluginID(), 0, "", (Throwable)e));
                }
            }
        }
        return this.fBundle;
    }

    public void setBundleName(String value) {
        this.fLoaded = false;
        this.fBundle = null;
        this.setBundleNameGen(value);
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public EList getBundleURLs() {
        if (this.bundleURLs == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.bundleURLs = new EDataTypeUniqueEList((Class)clazz, (InternalEObject)this, 1);
        }
        return this.bundleURLs;
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getBundleName();
            }
            case 1: {
                return this.getBundleURLs();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return BUNDLE_NAME_EDEFAULT == null ? this.bundleName != null : !BUNDLE_NAME_EDEFAULT.equals(this.bundleName);
            }
            case 1: {
                return this.bundleURLs != null && !this.bundleURLs.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setBundleName((String)newValue);
                return;
            }
            case 1: {
                this.getBundleURLs().clear();
                this.getBundleURLs().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setBundleName(BUNDLE_NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.getBundleURLs().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (bundleName: ");
        result.append(this.bundleName);
        result.append(", bundleURLs: ");
        result.append(this.bundleURLs);
        result.append(')');
        return result.toString();
    }

    public void setBundleNameGen(String newBundleName) {
        String oldBundleName = this.bundleName;
        this.bundleName = newBundleName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldBundleName, (Object)this.bundleName));
        }
    }
}

