/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.beaninfo;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import org.eclipse.ve.internal.jfc.beaninfo.AbstractBorderPropertyPage;
import org.eclipse.ve.internal.jfc.beaninfo.VisualBeanInfoMessages;

public class EtchedBorderPropertyPage
extends AbstractBorderPropertyPage
implements ItemListener {
    private boolean built = false;
    private JRadioButton raisedButton = null;
    private JRadioButton loweredButton = null;
    private ButtonGroup buttonGroup = null;
    private int etchedType = 0;

    public EtchedBorderPropertyPage() {
        this.initialize();
    }

    public String getDisplayName() {
        if (this.getEtchedType() == 1) {
            return VisualBeanInfoMessages.getString("EtchedBorder.DisplayName.Lowered");
        }
        return VisualBeanInfoMessages.getString("EtchedBorder.DisplayName.Raised");
    }

    public String getName() {
        return "EtchedBorderPropertyPage";
    }

    public int getEtchedType() {
        return this.etchedType;
    }

    public JRadioButton getRaisedButton() {
        if (this.raisedButton == null) {
            try {
                this.raisedButton = new JRadioButton(VisualBeanInfoMessages.getString("EtchedBorder.radio.Raised.Text"));
                this.raisedButton.setBackground(SystemColor.control);
                this.raisedButton.setName("Raised Etched");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this.raisedButton;
    }

    public JRadioButton getLoweredButton() {
        if (this.loweredButton == null) {
            try {
                this.loweredButton = new JRadioButton(VisualBeanInfoMessages.getString("EtchedBorder.radio.Lowered.Text"));
                this.loweredButton.setBackground(SystemColor.control);
                this.loweredButton.setName("Lowered Etched");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this.loweredButton;
    }

    public ButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            try {
                this.buttonGroup = new ButtonGroup();
                this.buttonGroup.add(this.getRaisedButton());
                this.buttonGroup.add(this.getLoweredButton());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this.buttonGroup;
    }

    public void initialize() {
        this.setName("EtchedBorderPropertyPage");
    }

    public void buildPropertyPage() {
        if (!this.built) {
            this.setBackground(SystemColor.control);
            this.setLayout(new GridLayout(8, 1, 0, 0));
            this.getButtonGroup();
            this.add((Component)this.getRaisedButton(), this.getRaisedButton().getName());
            this.add((Component)this.getLoweredButton(), this.getLoweredButton().getName());
            this.getRaisedButton().addItemListener(this);
            this.getLoweredButton().addItemListener(this);
            if (this.getEtchedType() == 0) {
                this.getRaisedButton().setSelected(true);
            } else if (this.getEtchedType() == 1) {
                this.getLoweredButton().setSelected(true);
            }
            this.built = true;
        }
    }

    public Border getBorderValue() {
        Border aBorder = BorderFactory.createEtchedBorder(this.getEtchedType());
        return aBorder;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.getRaisedButton()) {
            this.etchedType = 0;
        } else if (e.getSource() == this.getLoweredButton()) {
            this.etchedType = 1;
        }
        this.firePropertyChange("borderValueChanged", null, this.getBorderValue());
    }

    public boolean okToSetBorder(Border aBorder) {
        if (aBorder instanceof EtchedBorder) {
            this.etchedType = ((EtchedBorder)aBorder).getEtchType();
            return true;
        }
        return false;
    }

    public String getJavaInitializationString() {
        if (this.getEtchedType() == 1) {
            return "javax.swing.BorderFactory.createEtchedBorder(javax.swing.border.EtchedBorder.LOWERED)";
        }
        return "javax.swing.BorderFactory.createEtchedBorder(javax.swing.border.EtchedBorder.RAISED)";
    }
}

