/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.beaninfo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.ve.internal.jfc.beaninfo.ColorCellRenderer;
import org.eclipse.ve.internal.jfc.beaninfo.VisualBeanInfoMessages;

public class NamedColorChooserPanel
extends AbstractColorChooserPanel {
    private static ResourceBundle resabtedit = ResourceBundle.getBundle("org.eclipse.ve.internal.jfc.beaninfo.vceedit");
    public static final Color[] basicColorValues = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    public static final String[] basicColorNames = new String[]{resabtedit.getString("black"), resabtedit.getString("blue"), resabtedit.getString("cyan"), resabtedit.getString("darkGray"), resabtedit.getString("gray"), resabtedit.getString("green"), resabtedit.getString("lightGray"), resabtedit.getString("magenta"), resabtedit.getString("orange"), resabtedit.getString("pink"), resabtedit.getString("red"), resabtedit.getString("white"), resabtedit.getString("yellow")};
    public static final String basicColorConstantPrefix = "java.awt.Color.";
    public static final String[] basicColorConstants = new String[]{"black", "blue", "cyan", "darkGray", "gray", "green", "lightGray", "magenta", "orange", "pink", "red", "white", "yellow"};
    public static final SystemColor[] systemColorValues = new SystemColor[]{SystemColor.activeCaption, SystemColor.activeCaptionBorder, SystemColor.activeCaptionText, SystemColor.control, SystemColor.controlDkShadow, SystemColor.controlHighlight, SystemColor.controlLtHighlight, SystemColor.controlShadow, SystemColor.controlText, SystemColor.desktop, SystemColor.inactiveCaption, SystemColor.inactiveCaptionBorder, SystemColor.inactiveCaptionText, SystemColor.info, SystemColor.infoText, SystemColor.menu, SystemColor.menuText, SystemColor.scrollbar, SystemColor.text, SystemColor.textHighlight, SystemColor.textHighlightText, SystemColor.textInactiveText, SystemColor.textText, SystemColor.window, SystemColor.windowBorder, SystemColor.windowText};
    public static final String[] systemColorNames = new String[]{resabtedit.getString("activeCaption"), resabtedit.getString("activeCaptionBorder"), resabtedit.getString("activeCaptionText"), resabtedit.getString("control"), resabtedit.getString("controlDkShadow"), resabtedit.getString("controlHighlight"), resabtedit.getString("controlLtHighlight"), resabtedit.getString("controlShadow"), resabtedit.getString("controlText"), resabtedit.getString("desktop"), resabtedit.getString("inactiveCaption"), resabtedit.getString("inactiveCaptionBord"), resabtedit.getString("inactiveCaptionText"), resabtedit.getString("info"), resabtedit.getString("infoText"), resabtedit.getString("menu"), resabtedit.getString("menuText"), resabtedit.getString("scrollbar"), resabtedit.getString("text"), resabtedit.getString("textHighlight"), resabtedit.getString("textHighlightText"), resabtedit.getString("textInactiveText"), resabtedit.getString("textText"), resabtedit.getString("window"), resabtedit.getString("windowBorder"), resabtedit.getString("windowText")};
    public static final String systemColorConstantPrefix = "java.awt.SystemColor.";
    public static final String[] systemColorConstants = new String[]{"activeCaption", "activeCaptionBorder", "activeCaptionText", "control", "controlDkShadow", "controlHighlight", "controlLtHighlight", "controlShadow", "controlText", "desktop", "inactiveCaption", "inactiveCaptionBorder", "inactiveCaptionText", "info", "infoText", "menu", "menuText", "scrollbar", "text", "textHighlight", "textHighlightText", "textInactiveText", "textText", "window", "windowBorder", "windowText"};
    private static List basicColors = Arrays.asList(basicColorValues);
    private JList basicColorsList = null;
    private static List systemColors = Arrays.asList(systemColorValues);
    private JList systemColorsList = null;
    private static final char UNKNOWN_CHAR = '?';
    private static final int UNKNOWN_INDEX = -2;
    private static char mnemonic = (char)63;
    private static int mnemonicIndex = -2;
    private ChangeListener colorListener = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            NamedColorChooserPanel.this.updateListSelection(NamedColorChooserPanel.this.getColorFromModel());
        }
    };

    public void installChooserPanel(JColorChooser cc) {
        cc.getSelectionModel().addChangeListener(this.colorListener);
        super.installChooserPanel(cc);
    }

    public void uninstallChooserPanel(JColorChooser cc) {
        cc.getSelectionModel().removeChangeListener(this.colorListener);
        super.uninstallChooserPanel(cc);
    }

    public void updateChooser() {
        this.updateListSelection(this.getColorFromModel());
    }

    public void updateListSelection(Color newColor) {
        Color oldColor;
        if (newColor == null) {
            return;
        }
        if (NamedColorChooserPanel.isBasicColor(newColor)) {
            oldColor = (Color)this.basicColorsList.getSelectedValue();
            if (oldColor == null || !oldColor.equals(newColor)) {
                this.basicColorsList.setSelectedValue(newColor, true);
            }
        } else {
            this.basicColorsList.clearSelection();
        }
        if (NamedColorChooserPanel.isSystemColor(newColor)) {
            oldColor = (SystemColor)this.basicColorsList.getSelectedValue();
            if (oldColor == null || !oldColor.equals(newColor)) {
                this.systemColorsList.setSelectedValue(newColor, true);
                this.basicColorsList.clearSelection();
            }
        } else {
            this.systemColorsList.clearSelection();
        }
    }

    protected void buildChooser() {
        this.basicColorsList = new JList<Color>(basicColorValues);
        this.basicColorsList.setSelectionMode(0);
        this.basicColorsList.setCellRenderer(new ColorCellRenderer(basicColorNames, basicColorValues));
        this.basicColorsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                Color selected = (Color)NamedColorChooserPanel.this.basicColorsList.getSelectedValue();
                if (selected != null) {
                    NamedColorChooserPanel.this.getColorSelectionModel().setSelectedColor(selected);
                }
            }
        });
        this.systemColorsList = new JList<SystemColor>(systemColorValues);
        this.systemColorsList.setSelectionMode(0);
        this.systemColorsList.setCellRenderer(new ColorCellRenderer(systemColorNames, systemColorValues));
        this.systemColorsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SystemColor selected = (SystemColor)NamedColorChooserPanel.this.systemColorsList.getSelectedValue();
                if (selected != null) {
                    NamedColorChooserPanel.this.getColorSelectionModel().setSelectedColor(selected);
                }
            }
        });
        this.setLayout(new GridLayout(1, 2, 5, 5));
        JPanel basicPane = new JPanel();
        basicPane.setLayout(new BorderLayout(5, 5));
        basicPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), VisualBeanInfoMessages.getString("NamedColorChooserPanel.BasicTitle")));
        basicPane.add((Component)new JScrollPane(this.basicColorsList), "Center");
        this.add(basicPane);
        JPanel systemPane = new JPanel();
        systemPane.setLayout(new BorderLayout(5, 5));
        systemPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), VisualBeanInfoMessages.getString("NamedColorChooserPanel.SystemTitle")));
        systemPane.add((Component)new JScrollPane(this.systemColorsList), "Center");
        this.add(systemPane);
    }

    public boolean isBasicColorSelected() {
        return this.basicColorsList.getSelectedIndex() != -1;
    }

    public static boolean isBasicColor(Color c) {
        return basicColors.contains(c);
    }

    public boolean isSystemColorSelected() {
        return this.systemColorsList.getSelectedIndex() != -1;
    }

    public static boolean isSystemColor(Color c) {
        return c instanceof SystemColor;
    }

    public String getColorName() {
        Color c = this.getColorFromModel();
        return NamedColorChooserPanel.getColorName(c);
    }

    public static String getColorName(Color c) {
        if (NamedColorChooserPanel.isBasicColor(c)) {
            return basicColorNames[basicColors.indexOf(c)];
        }
        if (NamedColorChooserPanel.isSystemColor(c)) {
            return systemColorNames[systemColors.indexOf(c)];
        }
        return "";
    }

    public String getConstant() {
        Color c = this.getColorFromModel();
        return this.getConstant(c);
    }

    public String getConstant(Color c) {
        if (NamedColorChooserPanel.isBasicColor(c)) {
            return basicColorConstantPrefix + basicColorConstants[basicColors.indexOf(c)];
        }
        if (NamedColorChooserPanel.isSystemColor(c)) {
            return systemColorConstantPrefix + systemColorConstants[systemColors.indexOf(c)];
        }
        return "";
    }

    public String getDisplayName() {
        return VisualBeanInfoMessages.getString("NamedColorChooserPanel.PanelName");
    }

    public int getMnemonic() {
        if (mnemonic == '?') {
            mnemonic = Character.toUpperCase(VisualBeanInfoMessages.getString("NamedColorChooserPanel.PanelName.Mnemonic").charAt(0));
        }
        return mnemonic;
    }

    public int getDisplayedMnemonicIndex() {
        if (mnemonicIndex == -2) {
            mnemonicIndex = this.getDisplayName().indexOf(this.getMnemonic()) == -1 ? this.getDisplayName().indexOf(Character.toLowerCase((char)this.getMnemonic())) : this.getDisplayName().indexOf(this.getMnemonic());
        }
        return mnemonicIndex;
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }
}

