/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.remotevm;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.ICallback;
import org.eclipse.jem.internal.proxy.common.ICallbackHandler;
import org.eclipse.jem.internal.proxy.common.ICallbackRunnable;
import org.eclipse.jem.internal.proxy.common.IVMServer;
import org.eclipse.ve.internal.java.remotevm.BeanPropertyEditorFrame;
import org.eclipse.ve.internal.java.remotevm.BeanPropertyEditorJFrame;
import org.eclipse.ve.internal.java.remotevm.IBeanPropertyEditorDialog;
import org.eclipse.ve.internal.java.remotevm.IPropertyEditorDialogListener;
import org.eclipse.ve.internal.java.remotevm.WindowLauncher;
import org.eclipse.ve.internal.java.remotevm.WindowListener;

public class WindowLauncher
implements ICallback {
    protected IVMServer fServer;
    protected int fCallbackID;
    Component fComponent;
    IBeanPropertyEditorDialog fDialog;
    Window fWindow;
    List fWindowListeners = new ArrayList(1);
    int windowState = 1;

    public WindowLauncher(Component aComponent) {
        this.fComponent = aComponent;
        this.launchEditor();
        this.listenToComponent();
    }

    public void initializeCallback(IVMServer server, int callbackID) {
        this.fServer = server;
        this.fCallbackID = callbackID;
    }

    protected void callbackRevertValue() {
        this.windowState = 4;
    }

    protected void callbackSaveValue() {
        this.windowState = 3;
    }

    protected void callbackWindowClosed() {
        if (this.windowState == 1) {
            this.windowState = 2;
            this.fDialog.setPropertyEditor(null);
            this.fWindow = null;
            this.fDialog = null;
        }
    }

    public int getWindowState() {
        return this.windowState;
    }

    void launchEditor() {
        if (this.fComponent instanceof JComponent) {
            this.fDialog = new BeanPropertyEditorJFrame();
        } else if (this.fComponent instanceof Component) {
            this.fDialog = new BeanPropertyEditorFrame();
        }
        this.fDialog.setPropertyEditor(this.fComponent);
        this.fWindow = (Window)((Object)this.fDialog);
        this.fWindow.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.fWindow.setLocation((screenSize.width - this.fWindow.getWidth()) / 2, (screenSize.height - this.fWindow.getHeight()) / 2);
        this.fWindow.setVisible(true);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                WindowLauncher.this.toFront();
            }
        });
        this.windowState = 1;
    }

    void listenToComponent() {
        this.fWindow.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent event) {
                Iterator iter = WindowLauncher.this.fWindowListeners.iterator();
                while (iter.hasNext()) {
                    ((WindowListener)iter.next()).windowClosed();
                }
                WindowLauncher.this.callbackWindowClosed();
            }
        });
        this.fDialog.addListener(new IPropertyEditorDialogListener(){

            public void revertPropertyValue() {
                WindowLauncher.this.callbackRevertValue();
            }

            public void savePropertyValue() {
                WindowLauncher.this.callbackSaveValue();
            }
        });
        this.fComponent.addHierarchyListener(new HierarchyListener(){
            PropertyChangeListener pcl = new PropertyChangeListener(this){
                final /* synthetic */ 4 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void propertyChange(PropertyChangeEvent evt) {
                    try {
                        4.access$0(this.this$1).fServer.doCallback(new ICallbackRunnable(this, evt){
                            final /* synthetic */ 5 this$2;
                            private final /* synthetic */ PropertyChangeEvent val$evt;
                            {
                                this.this$2 = var1_1;
                                this.val$evt = propertyChangeEvent;
                            }

                            public Object run(ICallbackHandler handler) throws CommandException {
                                return handler.callbackWithParms(4.access$0(5.access$0(this.this$2)).fCallbackID, 7, new Object[]{this.val$evt.getPropertyName()});
                            }
                        });
                    }
                    catch (CommandException commandException) {}
                }

                static /* synthetic */ 4 access$0(5 var0) {
                    return var0.this$1;
                }
            };
            boolean hasParent;
            {
                boolean bl = this.hasParent = WindowLauncher.this.fComponent.getParent() != null;
                if (this.hasParent) {
                    WindowLauncher.this.fComponent.addPropertyChangeListener(this.pcl);
                }
            }

            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 2L) != 0L) {
                    boolean bl = this.hasParent = !this.hasParent;
                    if (this.hasParent) {
                        WindowLauncher.this.fComponent.addPropertyChangeListener(this.pcl);
                    } else {
                        WindowLauncher.this.fComponent.removePropertyChangeListener(this.pcl);
                    }
                }
            }

            static /* synthetic */ WindowLauncher access$0(4 var0) {
                return var0.WindowLauncher.this;
            }
        });
    }

    public void toFront() {
        this.fWindow.toFront();
        this.fWindow.requestFocus();
    }

    public void show() {
        this.fWindow.setVisible(true);
    }

    public void hide() {
        this.fWindow.setVisible(false);
    }

    public boolean isVisible() {
        return this.fWindow.isVisible();
    }

    public void addListener(WindowListener aListener) {
        this.fWindowListeners.add(aListener);
    }

    public void removeListener(WindowListener aListener) {
        this.fWindowListeners.remove(aListener);
    }
}

