/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.launcher.remotevm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ve.internal.java.vce.launcher.remotevm.ILauncher;
import org.eclipse.ve.internal.java.vce.launcher.remotevm.VCELauncherMessages;

public class SWTLauncher
implements ILauncher {
    protected ArrayList shellList = null;
    protected Constructor controlCtor = null;
    protected int controlCtorType = 0;
    private static final int NOCTOR = 0;
    private static final int DEFAULTCTOR = 1;
    private static final int DISPLAYCTOR = 2;
    private static final int PARENTCTOR = 3;
    private static final int PARENTSTYLECTOR = 4;
    protected Shell shell = null;
    protected Button okButton = null;
    protected Button codeButton = null;
    protected List selectionList = null;
    protected int selectedIndex = -1;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public boolean supportsLaunching(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.widgets.Control");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.isAssignableFrom(clazz)) {
            Constructor<?>[] ctors = clazz.getDeclaredConstructors();
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.eclipse.swt.widgets.Shell");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            boolean isShell = clazz3.isAssignableFrom(clazz);
            int i = 0;
            while (i < ctors.length) {
                Class<?>[] parms = ctors[i].getParameterTypes();
                if (parms.length == 0 && isShell) {
                    this.controlCtor = ctors[i];
                    this.controlCtorType = 1;
                    break;
                }
                if (parms.length == 1 && isShell) {
                    Class<?> clazz4 = class$2;
                    if (clazz4 == null) {
                        try {
                            clazz4 = Class.forName("org.eclipse.swt.widgets.Display");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz4.isAssignableFrom(parms[0])) {
                        this.controlCtor = ctors[i];
                        this.controlCtorType = 2;
                        break;
                    }
                }
                if (parms.length == 1) {
                    Class<?> clazz5 = class$3;
                    if (clazz5 == null) {
                        try {
                            clazz5 = Class.forName("org.eclipse.swt.widgets.Composite");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz5.isAssignableFrom(parms[0])) {
                        this.controlCtor = ctors[i];
                        this.controlCtorType = 3;
                        break;
                    }
                }
                if (parms.length == 2) {
                    Class<?> clazz6 = class$3;
                    if (clazz6 == null) {
                        try {
                            clazz6 = Class.forName("org.eclipse.swt.widgets.Composite");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz6.isAssignableFrom(parms[0]) && parms[1] == Integer.TYPE) {
                        this.controlCtor = ctors[i];
                        this.controlCtorType = 4;
                    }
                }
                ++i;
            }
            return this.controlCtorType != 0;
        }
        this.shellList = new ArrayList();
        Method createMethod = null;
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Class<?> clazz7 = class$1;
            if (clazz7 == null) {
                try {
                    clazz7 = Class.forName("org.eclipse.swt.widgets.Shell");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz7.isAssignableFrom(fields[i].getType())) {
                StringBuffer nameBuff = new StringBuffer(fields[i].getName());
                nameBuff.setCharAt(0, Character.toUpperCase(nameBuff.charAt(0)));
                nameBuff.insert(0, "create");
                String methodName = nameBuff.toString();
                try {
                    createMethod = clazz.getDeclaredMethod(methodName, null);
                    if (createMethod != null) {
                        ShellInfo info = new ShellInfo();
                        info.shellField = fields[i];
                        info.createMethod = createMethod;
                        info.methodName = methodName;
                        this.shellList.add(info);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    createMethod = null;
                }
            }
            ++i;
        }
        Collections.sort(this.shellList);
        return !this.shellList.isEmpty();
    }

    public void launch(Class clazz, String[] args) {
        Method mainMethod = null;
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$4;
            if (clazz2 == null) {
                try {
                    clazz2 = class$4 = Class.forName("[Ljava.lang.String;");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            mainMethod = clazz.getDeclaredMethod("main", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (mainMethod != null && Modifier.isStatic(mainMethod.getModifiers())) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Msg.BeanWithMain_INFO_"), clazz.getName()));
            try {
                mainMethod.invoke(null, new Object[]{args});
                System.exit(0);
            }
            catch (IllegalArgumentException e1) {
                System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.IllegalAccessException_ERROR_"), clazz.getName()));
                e1.printStackTrace();
                System.exit(0);
            }
            catch (IllegalAccessException e1) {
                System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.IllegalAccessException_ERROR_"), clazz.getName()));
                e1.printStackTrace();
                System.exit(0);
            }
            catch (InvocationTargetException e1) {
                System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InvocationException_ERROR_"), clazz.getName()));
                e1.printStackTrace();
                System.exit(0);
            }
        }
        if (this.controlCtorType != 0) {
            this.runControl(clazz);
            return;
        }
        if (this.shellList == null && !this.supportsLaunching(clazz)) {
            return;
        }
        if (!this.shellList.isEmpty()) {
            try {
                Constructor ctor = clazz.getDeclaredConstructor(null);
                ctor.setAccessible(true);
                Object bean = ctor.newInstance(null);
                if (this.shellList.size() == 1) {
                    this.runShell((ShellInfo)this.shellList.get(0), bean);
                    return;
                }
                ShellInfo info = this.chooseShell(this.shellList, bean);
                if (info != null) {
                    this.runShell(info, bean);
                }
            }
            catch (SecurityException e1) {
                System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InvocationException_ERROR_"), clazz.getName()));
                e1.printStackTrace();
                System.exit(0);
            }
            catch (IllegalArgumentException e1) {
                System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.IllegalAccessException_ERROR_"), clazz.getName()));
                e1.printStackTrace();
                System.exit(0);
            }
            catch (NoSuchMethodException e1) {
                System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InvocationException_ERROR_"), clazz.getName()));
                e1.printStackTrace();
                System.exit(0);
            }
            catch (InstantiationException e1) {
                System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InvocationException_ERROR_"), clazz.getName()));
                e1.printStackTrace();
                System.exit(0);
            }
            catch (IllegalAccessException e1) {
                System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.IllegalAccessException_ERROR_"), clazz.getName()));
                e1.printStackTrace();
                System.exit(0);
            }
            catch (InvocationTargetException e1) {
                System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InvocationException_ERROR_"), clazz.getName()));
                e1.printStackTrace();
                System.exit(0);
            }
        }
    }

    protected ShellInfo chooseShell(final ArrayList shells, final Object bean) {
        this.shell = new Shell(2144);
        this.shell.setText(VCELauncherMessages.getString("SWTLauncher.ChooseShell.Title"));
        this.shell.setSize(375, 275);
        this.shell.setLayout((Layout)new GridLayout(2, false));
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SWTLauncher.this.selectedIndex = -1;
            }
        });
        Label label1 = new Label((Composite)this.shell, 0);
        label1.setText(VCELauncherMessages.getString("SWTLauncher.ChooseShell.SelectMessage"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label1.setLayoutData((Object)gd);
        this.selectionList = new List((Composite)this.shell, 2048);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.selectionList.setLayoutData((Object)gd);
        this.selectionList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTLauncher.this.selectedIndex = SWTLauncher.this.selectionList.getSelectionIndex();
                SWTLauncher.this.okButton.setEnabled(SWTLauncher.this.selectedIndex != -1);
                SWTLauncher.this.codeButton.setEnabled(SWTLauncher.this.selectedIndex != -1);
            }
        });
        Iterator itr = shells.iterator();
        while (itr.hasNext()) {
            this.selectionList.add(itr.next().toString());
        }
        Label label2 = new Label((Composite)this.shell, 64);
        label2.setText(MessageFormat.format(VCELauncherMessages.getString("SWTLauncher.ChooseShell.AddMainMessage"), bean.getClass().getName()));
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.widthHint = 350;
        label2.setLayoutData((Object)gd);
        Label label3 = new Label((Composite)this.shell, 64);
        label3.setText(VCELauncherMessages.getString("SWTLauncher.ChooseShell.CodeExampleMessage"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        label3.setLayoutData((Object)gd);
        this.codeButton = new Button((Composite)this.shell, 8);
        this.codeButton.setText(VCELauncherMessages.getString("SWTLauncher.ChooseShell.CodeButton"));
        this.codeButton.setEnabled(false);
        this.codeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTLauncher.this.launchCodeDialog((ShellInfo)shells.get(SWTLauncher.this.selectedIndex), SWTLauncher.this.shell, bean);
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 1;
        this.codeButton.setLayoutData((Object)gd);
        Composite buttonComposite = new Composite((Composite)this.shell, 0);
        gd = new GridData();
        gd.horizontalAlignment = 3;
        gd.grabExcessHorizontalSpace = true;
        buttonComposite.setLayoutData((Object)gd);
        RowLayout row = new RowLayout();
        row.pack = false;
        buttonComposite.setLayout((Layout)row);
        this.okButton = new Button(buttonComposite, 8);
        this.okButton.setText(VCELauncherMessages.getString("SWTLauncher.ChooseShell.OKButton"));
        this.okButton.setEnabled(false);
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTLauncher.this.shell.dispose();
            }
        });
        Button cancelButton = new Button(buttonComposite, 8);
        cancelButton.setText(VCELauncherMessages.getString("SWTLauncher.ChooseShell.CancelButton"));
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTLauncher.this.selectedIndex = -1;
                SWTLauncher.this.shell.dispose();
            }
        });
        this.shell.setLocation((Display.getDefault().getBounds().width - this.shell.getSize().x) / 2, (Display.getDefault().getBounds().height - this.shell.getSize().y) / 2);
        this.shell.pack();
        this.runEventLoop(this.shell);
        if (this.selectedIndex != -1 && this.selectedIndex < shells.size()) {
            return (ShellInfo)shells.get(this.selectedIndex);
        }
        return null;
    }

    protected void launchCodeDialog(ShellInfo info, Shell parent, Object bean) {
        Shell codeShell = new Shell(parent, 67680);
        codeShell.setText(VCELauncherMessages.getString("SWTLauncher.ExampleCode.Title"));
        codeShell.setLayout((Layout)new GridLayout());
        Label label1 = new Label((Composite)codeShell, 64);
        label1.setText(MessageFormat.format(VCELauncherMessages.getString("SWTLauncher.ExampleCode.Desc"), info.toString()));
        Text codeText = new Text((Composite)codeShell, 2818);
        codeText.setLayoutData((Object)new GridData(1808));
        String codeBegin = "public static void main(String[] args) {\n\torg.eclipse.swt.widgets.Display display = org.eclipse.swt.widgets.Display.getDefault();\n";
        String codeContents = "\t{0} test = new {0}();\n\ttest.{1}();\n\ttest.{2}.open();\n";
        String codeEnd = "\twhile (!test.sShell1.isDisposed()) {\n\t\tif (!display.readAndDispatch()) display.sleep ();\n\t}\n\tdisplay.dispose();\n}";
        String beanClassName = this.getSimpleName(bean.getClass().getName());
        codeText.setText(String.valueOf(codeBegin) + MessageFormat.format(codeContents, beanClassName, info.createMethod.getName(), info.shellField.getName()) + codeEnd);
        codeText.setSelection(0, codeText.getText().length());
        Button okButton = new Button((Composite)codeShell, 8);
        okButton.setText(VCELauncherMessages.getString("SWTLauncher.ChooseShell.OKButton"));
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((Button)e.widget).getShell().close();
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 2;
        okButton.setLayoutData((Object)gd);
        codeShell.pack();
        codeShell.open();
    }

    protected String getSimpleName(String className) {
        int index = className.lastIndexOf(".");
        if (index != -1) {
            return className.substring(index + 1);
        }
        return className;
    }

    protected void runControl(Class clazz) {
        this.controlCtor.setAccessible(true);
        try {
            switch (this.controlCtorType) {
                case 1: {
                    System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Msg.BeanWithNullConstructor_INFO"), clazz.getName()));
                    Shell shell = (Shell)this.controlCtor.newInstance(null);
                    this.runEventLoop(shell);
                    break;
                }
                case 2: {
                    System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Msg.BeanWithShellMethod_INFO_"), clazz.getName(), this.controlCtor.toString()));
                    Display display = Display.getDefault();
                    Shell shell = (Shell)this.controlCtor.newInstance(display);
                    this.runEventLoop(shell);
                    break;
                }
                case 3: {
                    System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Msg.BeanWithShellMethod_INFO_"), clazz.getName(), this.controlCtor.toString()));
                    Shell parentShell = this.createParentShell(clazz);
                    this.controlCtor.newInstance(parentShell);
                    this.runEventLoop(parentShell);
                    break;
                }
                case 4: {
                    System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Msg.BeanWithShellMethod_INFO_"), clazz.getName(), this.controlCtor.toString()));
                    Shell parentShell = this.createParentShell(clazz);
                    this.controlCtor.newInstance(parentShell, new Integer(0));
                    this.runEventLoop(parentShell);
                }
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.IllegalAccessException_ERROR_"), clazz.getName()));
            e.printStackTrace();
            System.exit(0);
        }
        catch (InstantiationException e) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InvocationException_ERROR_"), clazz.getName()));
            e.printStackTrace();
            System.exit(0);
        }
        catch (IllegalAccessException e) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.IllegalAccessException_ERROR_"), clazz.getName()));
            e.printStackTrace();
            System.exit(0);
        }
        catch (InvocationTargetException e) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InvocationException_ERROR_"), clazz.getName()));
            e.printStackTrace();
            System.exit(0);
        }
    }

    protected Shell createParentShell(Class clazz) {
        Shell parentShell = new Shell(Display.getDefault());
        parentShell.setText(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.FrameTitle.LaunchComponent"), clazz.getName()));
        parentShell.setLayout((Layout)new FillLayout());
        return parentShell;
    }

    protected void runShell(ShellInfo info, Object bean) {
        info.shellField.setAccessible(true);
        info.createMethod.setAccessible(true);
        System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Msg.BeanWithShellMethod_INFO_"), bean.getClass().getName(), info.methodName));
        try {
            info.createMethod.invoke(bean, null);
            Shell beanShell = (Shell)info.shellField.get(bean);
            this.runEventLoop(beanShell);
        }
        catch (IllegalArgumentException e) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.IllegalAccessException_ERROR_"), bean.getClass().getName()));
            e.printStackTrace();
            System.exit(0);
        }
        catch (IllegalAccessException e) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.IllegalAccessException_ERROR_"), bean.getClass().getName()));
            e.printStackTrace();
            System.exit(0);
        }
        catch (InvocationTargetException e) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InvocationException_ERROR_"), bean.getClass().getName()));
            e.printStackTrace();
            System.exit(0);
        }
    }

    protected void runEventLoop(Shell beanShell) {
        Display display = beanShell.getDisplay();
        String pack = System.getProperty("pack");
        if (pack != null && pack.equals("true")) {
            beanShell.pack();
        }
        beanShell.open();
        while (!beanShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private class ShellInfo
    implements Comparable {
        public Field shellField = null;
        public Method createMethod = null;
        public String methodName = null;

        ShellInfo() {
        }

        public int compareTo(Object o) {
            if (o instanceof ShellInfo) {
                return this.toString().compareTo(o.toString());
            }
            return 0;
        }

        public String toString() {
            return this.shellField.getName();
        }
    }
}

