/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.editorpart;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.internal.adapters.jdom.JavaModelListener;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoNature;
import org.eclipse.jem.internal.proxy.core.ConfigurationContributorAdapter;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionController;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionInfo;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributor;
import org.eclipse.jem.internal.proxy.core.IInvokable;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyLaunchSupport;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ve.internal.java.codegen.editorpart.CodegenEditorPartMessages;
import org.eclipse.ve.internal.java.codegen.editorpart.JavaVisualEditorPart;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class JavaVisualEditorVMController {
    private static final long INACTIVE_PERIOD = 300000L;
    protected static int INACTIVE_COUNT;
    protected static Map PER_PROJECT;
    protected static final boolean IN_DEBUG_MODE;
    protected static ChangeListener JAVA_MODEL_LISTENER;
    protected static Job INACTIVE_JOB;

    static {
        IN_DEBUG_MODE = "true".equalsIgnoreCase(Platform.getDebugOption((String)(String.valueOf(ProxyPlugin.getPlugin().getBundle().getSymbolicName()) + "/remote/debug/debugvm")));
        if (!IN_DEBUG_MODE) {
            PER_PROJECT = new HashMap();
        }
    }

    static RegistryResult getRegistry(IFile file) throws CoreException {
        if (IN_DEBUG_MODE) {
            return JavaVisualEditorVMController.createRegistryForDebug(file);
        }
        PerProject perProjectEntry = null;
        IProject project = file.getProject();
        Map map = PER_PROJECT;
        synchronized (map) {
            if (PER_PROJECT.isEmpty()) {
                if (JAVA_MODEL_LISTENER == null) {
                    JavaVisualEditorVMController.addJavaModelListener();
                }
                if (INACTIVE_JOB == null) {
                    JavaVisualEditorVMController.addInactiveJob();
                }
                JavaVEPlugin.getPlugin().setJavaVMControllerDisposer(new Runnable(){

                    public void run() {
                        JavaVisualEditorVMController.dispose();
                    }
                });
            }
            if ((perProjectEntry = (PerProject)PER_PROJECT.get(project)) == null) {
                perProjectEntry = new PerProject(project);
                PER_PROJECT.put(project, perProjectEntry);
            }
        }
        return perProjectEntry.getSpare();
    }

    static void disposeEditor(IFile file) {
        if (IN_DEBUG_MODE) {
            return;
        }
        Map map = PER_PROJECT;
        synchronized (map) {
            IProject project = file.getProject();
            PerProject perProjectEntry = (PerProject)PER_PROJECT.get(project);
            if (perProjectEntry != null) {
                perProjectEntry.lastActivity = INACTIVE_COUNT;
            }
        }
    }

    public static void dispose() {
        JavaVisualEditorVMController.deactivate();
    }

    protected static void deactivate() {
        Map map = PER_PROJECT;
        synchronized (map) {
            if (INACTIVE_JOB != null) {
                Job inactive = INACTIVE_JOB;
                INACTIVE_JOB = null;
                inactive.cancel();
            }
            if (JAVA_MODEL_LISTENER != null) {
                JavaCore.removeElementChangedListener((IElementChangedListener)JAVA_MODEL_LISTENER);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)JAVA_MODEL_LISTENER);
                JAVA_MODEL_LISTENER = null;
            }
            if (!PER_PROJECT.isEmpty()) {
                Iterator iter = PER_PROJECT.values().iterator();
                while (iter.hasNext()) {
                    PerProject pp;
                    PerProject perProject = pp = (PerProject)iter.next();
                    synchronized (perProject) {
                        try {
                            RegistryResult spare = pp.getExistingSpare(true);
                            if (spare != null) {
                                spare.registry.terminateRegistry();
                            }
                        }
                        catch (RuntimeException runtimeException) {}
                    }
                }
                PER_PROJECT.clear();
            }
        }
        JavaVEPlugin.getPlugin().setJavaVMControllerDisposer(null);
    }

    protected static void addJavaModelListener() {
        JAVA_MODEL_LISTENER = new ChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)JAVA_MODEL_LISTENER, 6);
    }

    protected static void addInactiveJob() {
        INACTIVE_JOB = new Job("Visual Editor for Java Inactive VM check"){

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ++JavaVisualEditorVMController.INACTIVE_COUNT;
                    monitor.beginTask("", 300);
                    activeProjects = new HashSet<IProject>();
                    ww = PlatformUI.getWorkbench().getWorkbenchWindows();
                    subm = new SubProgressMonitor(monitor, 100);
                    subm.beginTask("", ww.length * 100);
                    i = 0;
                    while (i < ww.length) {
                        if (subm.isCanceled()) {
                            var14_15 = Status.CANCEL_STATUS;
                            var12_20 = null;
                            if (JavaVisualEditorVMController.INACTIVE_JOB == null) return var14_15;
                            this.schedule(300000L);
                            return var14_15;
                        }
                        wwpages = ww[i].getPages();
                        j = 0;
                        while (j < wwpages.length) {
                            ers = wwpages[j].getEditorReferences();
                            k = 0;
                            while (k < ers.length) {
                                ep = ers[k].getEditor(false);
                                if (ep instanceof JavaVisualEditorPart && !activeProjects.contains((jf = ((IFileEditorInput)ep.getEditorInput()).getFile()).getProject())) {
                                    activeProjects.add(jf.getProject());
                                }
                                ++k;
                            }
                            ++j;
                        }
                        subm.worked(100);
                        ++i;
                    }
                    if (subm.isCanceled()) {
                        var14_16 = Status.CANCEL_STATUS;
                        var12_21 = null;
                        if (JavaVisualEditorVMController.INACTIVE_JOB == null) return var14_16;
                        this.schedule(300000L);
                        return var14_16;
                    }
                    subm.done();
                    var5_6 = JavaVisualEditorVMController.PER_PROJECT;
                    synchronized (var5_6) {
                        if (!monitor.isCanceled()) ** break block22
                        var14_17 = Status.CANCEL_STATUS;
                    }
                    var12_22 = null;
                    if (JavaVisualEditorVMController.INACTIVE_JOB == null) return var14_17;
                    this.schedule(300000L);
                    return var14_17;
                    {
                        clearCount = JavaVisualEditorVMController.INACTIVE_COUNT - 2;
                        subm = new SubProgressMonitor(monitor, 100);
                        subm.beginTask("", JavaVisualEditorVMController.PER_PROJECT.size() * 100);
                        iter = JavaVisualEditorVMController.PER_PROJECT.values().iterator();
                        while (iter.hasNext()) {
                            if (subm.isCanceled()) break;
                            pp = (PerProject)iter.next();
                            if (!activeProjects.contains(pp.project)) {
                                removeIt = false;
                                var10_13 = pp;
                                synchronized (var10_13) {
                                    if (pp.createJob == null && pp.lastActivity <= (long)clearCount) {
                                        removeIt = true;
                                    } else {
                                        rr = pp.getExistingSpare(true);
                                        removeIt = pp.lastActivity <= (long)clearCount;
                                        if (removeIt && rr != null) {
                                            rr.registry.terminateRegistry();
                                        }
                                    }
                                    if (removeIt) {
                                        iter.remove();
                                    }
                                }
                            }
                            subm.worked(100);
                        }
                        subm.done();
                        if (!JavaVisualEditorVMController.PER_PROJECT.isEmpty()) ** break block23
                        JavaVisualEditorVMController.INACTIVE_JOB = null;
                        JavaVisualEditorVMController.deactivate();
                        monitor.worked(100);
                        var14_18 = Status.OK_STATUS;
                    }
                    var12_23 = null;
                    if (JavaVisualEditorVMController.INACTIVE_JOB == null) return var14_18;
                    this.schedule(300000L);
                    return var14_18;
                    {
                        monitor.worked(100);
                        monitor.done();
                    }
                    var14_19 = monitor.isCanceled() == false ? Status.OK_STATUS : Status.CANCEL_STATUS;
                    var12_24 = null;
                    if (JavaVisualEditorVMController.INACTIVE_JOB == null) return var14_19;
                }
                catch (Throwable var13_26) {
                    var12_25 = null;
                    if (JavaVisualEditorVMController.INACTIVE_JOB == null) throw var13_26;
                    this.schedule(300000L);
                    throw var13_26;
                }
                this.schedule(300000L);
                return var14_19;
            }
        };
        INACTIVE_JOB.setSystem(true);
        INACTIVE_JOB.schedule(300000L);
    }

    protected static RegistryResult createRegistryForDebug(IFile file) throws CoreException {
        CreateDebugRegistry job = new CreateDebugRegistry(CodegenEditorPartMessages.getString("JavaVisualEditorPart.CreateRemoteVMForJVE"), file);
        job.schedule();
        while (true) {
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        if (job.getResult().isOK()) {
            return job.result;
        }
        throw new CoreException(job.getResult());
    }

    public static class RegistryResult {
        public final ProxyFactoryRegistry registry;
        public final IConfigurationContributionInfo configInfo;

        public RegistryResult(ProxyFactoryRegistry registry, IConfigurationContributionInfo configInfo) {
            this.registry = registry;
            this.configInfo = configInfo;
        }
    }

    protected static abstract class CreateRegistry
    extends Job {
        protected String vmName;

        protected CreateRegistry(String name, String vmName) {
            super(name);
            this.vmName = vmName;
        }

        protected final IStatus run(IProgressMonitor monitor) {
            IConfigurationContributionInfo[] contributeInfo = new IConfigurationContributionInfo[1];
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ConfigurationContributorAdapter jcmCont = new ConfigurationContributorAdapter(this, contributeInfo){
                final /* synthetic */ CreateRegistry this$1;
                private final /* synthetic */ IConfigurationContributionInfo[] val$contributeInfo;
                {
                    this.this$1 = createRegistry;
                    this.val$contributeInfo = iConfigurationContributionInfoArray;
                }

                public void initialize(IConfigurationContributionInfo info) {
                    this.val$contributeInfo[0] = info;
                }

                public void contributeClasspaths(IConfigurationContributionController controller) throws CoreException {
                    controller.contributeClasspath(JavaVEPlugin.getPlugin().getBundle(), "vm/javaremotevm.jar", 0, true);
                }

                public void contributeToRegistry(ProxyFactoryRegistry registry) {
                    IBeanTypeProxy aSetupBeanTypeProxy = registry.getBeanTypeProxyFactory().getBeanTypeProxy("org.eclipse.ve.internal.java.remotevm.Setup");
                    IInvokable setupInvokable = aSetupBeanTypeProxy.getInvokable("setup");
                    setupInvokable.invokeCatchThrowableExceptions((IBeanProxy)aSetupBeanTypeProxy);
                }
            };
            try {
                IConfigurationContributor[] contribs = new IConfigurationContributor[]{BeaninfoNature.getRuntime((IProject)this.getProject()).getConfigurationContributor(), jcmCont};
                ProxyFactoryRegistry registry = ProxyLaunchSupport.startImplementation((IProject)this.getProject(), (String)this.vmName, (IConfigurationContributor[])contribs, (IProgressMonitor)monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                registry.getBeanTypeProxyFactory().setMaintainNotFoundTypes(true);
                this.processNewRegistry(registry, contributeInfo[0]);
            }
            catch (CoreException e) {
                return new Status(4, JavaVEPlugin.getPlugin().getBundle().getSymbolicName(), 16, e.getStatus().getMessage(), (Throwable)e);
            }
            return Status.OK_STATUS;
        }

        protected abstract void processNewRegistry(ProxyFactoryRegistry var1, IConfigurationContributionInfo var2);

        protected abstract IProject getProject();
    }

    protected static class PerProject {
        public long lastActivity;
        public CreateSpareRegistry createJob;
        public IProject project;
        public RegistryResult spare;
        private static final long START_JOB_DELAY = 10000L;

        public PerProject(IProject project) {
            this.project = project;
        }

        public synchronized RegistryResult getSpare() throws CoreException {
            RegistryResult result = null;
            while (true) {
                IStatus status;
                if (!(status = this.waitForJob()).isOK()) {
                    throw new CoreException(status);
                }
                if (this.createJob != null) {
                    CreateSpareRegistry createSpareRegistry = this.createJob;
                    synchronized (createSpareRegistry) {
                        if (this.spare != null) {
                            result = this.spare;
                            this.spare = null;
                            this.startJob(10000L);
                            break;
                        }
                    }
                }
                if (this.createJob != null && this.createJob.getState() != 0) continue;
                this.startJob(0L);
            }
            return result;
        }

        private synchronized IStatus waitForJob() {
            if (this.createJob == null) {
                return Status.OK_STATUS;
            }
            int state = this.createJob.getState();
            if ((state == 2 || state == 1) && this.createJob.sleep()) {
                this.createJob.wakeUp();
            }
            while (true) {
                try {
                    this.createJob.join();
                    IStatus status = this.createJob.getResult();
                    if (status == null) {
                        return Status.OK_STATUS;
                    }
                    if (!status.isOK()) {
                        CreateSpareRegistry createSpareRegistry = this.createJob;
                        synchronized (createSpareRegistry) {
                            this.createJob = null;
                            if (this.spare != null) {
                                this.spare.registry.terminateRegistry();
                                this.spare = null;
                            }
                        }
                    }
                    return status;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private synchronized void startJob(long delay) {
            if (this.createJob == null) {
                this.createJob = new CreateSpareRegistry(CodegenEditorPartMessages.getString("JavaVisualEditorPart.CreateRemoteVMForJVE"));
                this.createJob.setSystem(true);
            }
            this.createJob.schedule(delay);
        }

        synchronized void restartSpare() {
            if (this.createJob != null) {
                CreateSpareRegistry createSpareRegistry = this.createJob;
                synchronized (createSpareRegistry) {
                    if (this.spare != null) {
                        this.spare.registry.terminateRegistry();
                        this.spare = null;
                    }
                }
            }
            this.startJob(10000L);
        }

        public synchronized RegistryResult getExistingSpare(boolean cancel) {
            IStatus status;
            if (cancel && this.createJob != null) {
                this.createJob.cancel();
            }
            if (!(status = this.waitForJob()).isOK() && status.getSeverity() != 8) {
                return null;
            }
            if (this.createJob != null) {
                CreateSpareRegistry createSpareRegistry = this.createJob;
                synchronized (createSpareRegistry) {
                    if (this.spare != null) {
                        return this.spare;
                    }
                }
            }
            return null;
        }

        protected class CreateSpareRegistry
        extends CreateRegistry {
            public CreateSpareRegistry(String name) {
                super(name, "VM for " + PerProject.this.project.getName());
            }

            protected IProject getProject() {
                return PerProject.this.project;
            }

            protected void processNewRegistry(ProxyFactoryRegistry registry, IConfigurationContributionInfo info) {
                CreateSpareRegistry createSpareRegistry = this;
                synchronized (createSpareRegistry) {
                    PerProject.this.spare = new RegistryResult(registry, info);
                    PerProject.this.lastActivity = INACTIVE_COUNT;
                }
            }
        }
    }

    protected static class CreateDebugRegistry
    extends CreateRegistry {
        protected IProject project;
        public RegistryResult result;

        public CreateDebugRegistry(String name, IFile file) {
            super(name, "VM for " + file.getFullPath().lastSegment());
            this.project = file.getProject();
        }

        protected void processNewRegistry(ProxyFactoryRegistry registry, IConfigurationContributionInfo info) {
            this.result = new RegistryResult(registry, info);
        }

        protected IProject getProject() {
            return this.project;
        }
    }

    private static class ChangeListener
    extends JavaModelListener
    implements IResourceChangeListener {
        public ChangeListener() {
            super(1);
        }

        protected IJavaProject getJavaProject() {
            return null;
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IProject project = (IProject)e.getResource();
            this.processRemovedProject(project, true);
            this.processChangedReferencedProject(project);
        }

        protected void processJavaElementChanged(IJavaProject element, IJavaElementDelta delta) {
            switch (delta.getKind()) {
                case 2: {
                    this.processRemovedProject(element.getProject(), true);
                    this.processChangedReferencedProject(element.getProject());
                    break;
                }
                case 1: {
                    this.processChangedReferencedProject(element.getProject());
                    break;
                }
                case 4: {
                    if ((delta.getFlags() & 0x400) != 0) {
                        this.processRemovedProject(element.getProject(), false);
                        this.processChangedReferencedProject(element.getProject());
                        break;
                    }
                    if (!this.isClasspathResourceChange(delta)) break;
                    this.processChangedProject(element.getProject());
                    this.processChangedReferencedProject(element.getProject());
                }
            }
        }

        protected void processChangedReferencedProject(IProject project) {
            IPath projectPath = project.getFullPath();
            Map map = PER_PROJECT;
            synchronized (map) {
                if (!PER_PROJECT.isEmpty()) {
                    Iterator iter = PER_PROJECT.values().iterator();
                    while (iter.hasNext()) {
                        PerProject pp = (PerProject)iter.next();
                        if (pp.project.equals((Object)project)) continue;
                        PerProject perProject = pp;
                        synchronized (perProject) {
                            RegistryResult spare = pp.getExistingSpare(true);
                            if (spare == null || spare.configInfo != null && spare.configInfo.getProjectPaths().containsKey(projectPath)) {
                                pp.restartSpare();
                            }
                        }
                    }
                }
            }
        }

        protected void processChangedProject(IProject project) {
            Map map = PER_PROJECT;
            synchronized (map) {
                PerProject pp = (PerProject)PER_PROJECT.get(project);
                if (pp != null) {
                    PerProject perProject = pp;
                    synchronized (perProject) {
                        pp.getExistingSpare(true);
                        pp.restartSpare();
                    }
                }
            }
        }

        protected void processRemovedProject(IProject project, boolean wait) {
            Map map = PER_PROJECT;
            synchronized (map) {
                PerProject pp = (PerProject)PER_PROJECT.remove(project);
                if (pp != null) {
                    PerProject perProject = pp;
                    synchronized (perProject) {
                        RegistryResult spare = pp.getExistingSpare(true);
                        if (spare != null) {
                            spare.registry.terminateRegistry(wait);
                        }
                    }
                }
                if (PER_PROJECT.isEmpty()) {
                    JavaVisualEditorVMController.deactivate();
                }
            }
        }
    }
}

